/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.iiop.ColocatedInputStream;
import com.ibm.rmi.iiop.FragmentObserver;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.QueueingOutputStream;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.buffer.SimpleByteBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.portable.InputStream;

public class ColocatedOutputStream
extends CDROutputStream {
    private static final String CLASS = ColocatedOutputStream.class.getName();
    private static final long serialVersionUID = 1L;
    private QueueingOutputStream queueingStream = null;
    private final FragmentObserver observer;
    private final ClassLoader readerClassLoader;

    public ColocatedOutputStream(ORB oRB, FragmentObserver fragmentObserver, ClassLoader classLoader) {
        super((org.omg.CORBA.ORB)oRB, oRB.getCharEncoding(), oRB.getWCharEncoding());
        int n = oRB.getPartnerVersion();
        this.setGIOPVersions((byte)1, oRB.getMaxGIOPMinor(), PartnerVersionUtil.unpackMajor(n), PartnerVersionUtil.unpackMinor(n), oRB.getPartnerExtended(), (byte)2, true);
        this.observer = fragmentObserver;
        this.readerClassLoader = classLoader;
    }

    @Override
    public void close() {
        if (null != this.queueingStream) {
            if (0 < this.getSize()) {
                this.completeFragment(0);
            }
            this.queueingStream.close();
        }
        super.close();
    }

    @Override
    protected final void allocateBuffer() {
        this.byteBuf = new SimpleByteBuffer(CDRWriter.getDefaultBufferSize());
    }

    private synchronized void initQueueingStream() {
        this.queueingStream = new QueueingOutputStream();
    }

    @Override
    protected void sendFragment() {
        boolean bl;
        boolean bl2 = bl = null == this.queueingStream;
        if (bl) {
            this.initQueueingStream();
        }
        try {
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, CLASS, "sendFragment:90");
            }
            this.initialOffset += this.byteBuf.getWriteOffset();
            this.writeTo(this.queueingStream);
        }
        catch (IOException iOException) {
            Trc.ffdc(iOException, CLASS, "sendFragment:95");
        }
        if (bl && null != this.observer) {
            this.observer.firstFragmentSent();
        }
    }

    @Override
    public void write_value(Serializable serializable) {
        super.write_value(serializable);
    }

    synchronized QueueingOutputStream getQueueingStream() {
        return this.queueingStream;
    }

    ClassLoader getReaderClassLoader() {
        return this.readerClassLoader;
    }

    @Override
    public InputStream create_input_stream() {
        final ColocatedOutputStream colocatedOutputStream = this;
        if (null == this.getQueueingStream()) {
            CDRInputStream cDRInputStream = (CDRInputStream)super.create_input_stream();
            cDRInputStream.setClassLoader(this.getReaderClassLoader());
            return cDRInputStream;
        }
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ColocatedInputStream(colocatedOutputStream);
            }
        });
    }
}

