/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPConnectionInfo;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.DynamicStub;
import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.IOR;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.DisconnectedDelegate;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.CharToTcsConverter;
import com.ibm.rmi.iiop.ConnectionInfoImpl;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.WriteNoopTransformer;
import com.ibm.rmi.iiop.WriteValueTransformerStrategy;
import com.ibm.rmi.iiop.WriteZoneInfoTransformer;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ValueHandlerImpl;
import com.ibm.rmi.io.ValueHandlerPool;
import com.ibm.rmi.io.ValueUtility;
import com.ibm.rmi.util.IdentityHashtable;
import com.ibm.rmi.util.Interop;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA.portable.ValueOutputStream;

public abstract class CDRWriter
extends CDROutputStream
implements DataOutputStream,
ValueOutputStream,
PartnerVersion {
    private static final String CLASS = CDRWriter.class.getName();
    public static final TypeCodeImpl BOX_STRING_TC = new TypeCodeImpl(null, 30, RepositoryId.createForJavaType(String.class), "", TypeCodeImpl.get_primitive_tc(27));
    private static final TypeCodeImpl ABSTRACT_INTERFACE_TC = TypeCodeImpl.get_primitive_tc(32);
    public static final java.lang.Object PENDING_WRITE = new java.lang.Object();
    protected static final byte PAD_BYTE = -67;
    private static final int CFW_FRAG_SIZE_OFFSET = 16;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    public final Interop interop;
    protected final boolean littleEndian;
    protected final org.omg.CORBA.ORB orb;
    private final int requestedBufLen;
    protected int initialOffset;
    private int fragSize = -1;
    protected boolean startNewChunk;
    protected boolean writingChunkMarker;
    private boolean paddingPending = false;
    protected int tcsChar = -1;
    protected int tcsWChar = -1;
    protected CharToTcsConverter tcsCConverter = null;
    protected CharToTcsConverter tcsWConverter = null;
    private Hashtable codebaseCache = null;
    private IdentityHashtable valueCache = null;
    private Hashtable repositoryIdCache = null;
    protected int end_flag = 0;
    private HashMap serializedFieldsInfo = new HashMap();
    private boolean mustChunk = false;
    private boolean inBlock = false;
    private ValueHandlerImpl valueHandler = null;
    private int firstNullTc = -1;
    private int firstStringTc = -1;
    private byte GIOPMajor = 1;
    private byte GIOPMinor = (byte)2;
    private boolean preGIOP12_CDR = false;
    private boolean fragmentable = false;
    private int addIndirectionBytes = 0;
    private short partnerMajor = (short)-1;
    private short partnerMinor = (short)-1;
    private short partnerExtended = (short)-1;
    private byte streamFormatVersion = 1;
    private boolean checkedOptimisedTCVersion = false;
    private boolean optimisedTCVersion;
    private boolean checkedOldNullTC = false;
    private boolean oldNullTC;
    private int oldSUID = -1;
    private boolean prevMustChunk = false;
    private java.lang.Object currentObject = null;
    protected final boolean useCFW;
    private GIOPConnectionInfo connInfo = ConnectionInfoImpl.unconnected;
    private static final WriteValueTransformerStrategy writeValueTransformer;
    private int crossReferencePointer = -1;
    private boolean isCollocated;
    private static final int[] SWAPBYTE_SHIFTS;
    private static final int[][] NOSWAPBYTES_SHIFTS;
    private Hashtable typeMap = null;
    private static String _id;
    private static String[] _ids;
    protected boolean haveCheckedOldNestingDepths;
    protected boolean useOldNestingDepths;
    private static final long serialVersionUID = 0L;

    public CDRWriter(org.omg.CORBA.ORB oRB) {
        this(oRB, false);
    }

    public CDRWriter(org.omg.CORBA.ORB oRB, byte by, byte by2) {
        this(oRB, false);
        this.setGIOPVersion(by, by2, false);
    }

    public CDRWriter(org.omg.CORBA.ORB oRB, boolean bl) {
        this(oRB, bl, 0);
    }

    public CDRWriter(org.omg.CORBA.ORB oRB, boolean bl, int n) {
        this.orb = oRB;
        this.littleEndian = bl;
        this.requestedBufLen = n;
        this.initialOffset = 0;
        if (oRB instanceof com.ibm.rmi.ORB) {
            this.interop = ((com.ibm.rmi.ORB)oRB).getInterop(this);
            ValueHandlerImpl.THREAD_LOCAL_PV.set(this);
            this.useCFW = ((com.ibm.rmi.ORB)oRB).useChannelFramework();
        } else {
            this.interop = Interop.NO_IBM_ORB;
            this.useCFW = false;
        }
    }

    public CDRWriter(org.omg.CORBA.ORB oRB, int n, int n2) {
        this(oRB, false);
        this.setCodeSets(n, n2);
    }

    public CDRWriter() {
        this(org.omg.CORBA.ORB.init(), false, 0);
    }

    public CDRWriter(CDRWriter cDRWriter) {
        this(cDRWriter.orb, cDRWriter.littleEndian);
        this.typeMap = cDRWriter.getTypeMap();
        cDRWriter.alignAndReserve(4, 4);
        this.initialOffset = cDRWriter.get_offset(true) + 4;
        this.setGIOPVersion(cDRWriter.GIOPMajor, cDRWriter.GIOPMinor, false);
    }

    void setConnectionInfo(GIOPConnectionInfo gIOPConnectionInfo) {
        this.connInfo = gIOPConnectionInfo;
    }

    @Override
    public void setGIOPVersions(byte by, byte by2, short s, short s2, short s3, byte by3) {
        this.setGIOPVersions(by, by2, s, s2, s3, by3, false);
    }

    @Override
    public void setGIOPVersions(byte by, byte by2, short s, short s2, short s3, byte by3, boolean bl) {
        this.partnerMajor = s;
        this.partnerMinor = s2;
        this.partnerExtended = s3;
        this.setGIOPVersion(by, by2, bl);
        if (by3 > 0 && by3 <= 2) {
            this.setStreamFormatVersion(by3);
        }
    }

    public void setGIOPVersion(byte by, byte by2) {
        this.setGIOPVersion(by, by2, false);
    }

    @Override
    public void setGIOPVersion(byte by, byte by2, boolean bl) {
        if (by != 1 || by2 > 2) {
            BAD_PARAM bAD_PARAM = new BAD_PARAM("Invalid GIOP level: " + by + "." + by2);
            Trc.ffdc(bAD_PARAM, CLASS, "setGIOPVersion:413");
            throw bAD_PARAM;
        }
        this.GIOPMajor = by;
        this.GIOPMinor = by2;
        if (by == 1 && by2 <= 1) {
            this.preGIOP12_CDR = true;
            this.fragmentable = false;
            this.fragSize = 0;
        } else {
            this.preGIOP12_CDR = false;
            this.fragmentable = bl;
        }
        if (by == 1 && by2 <= 2) {
            short s;
            short s2 = this.getPartnerMajor();
            if (PartnerVersionUtil.useStreamFormat2(s2, s = this.getPartnerMinor())) {
                this.setStreamFormatVersion((byte)2);
            } else {
                this.setStreamFormatVersion((byte)1);
            }
        } else {
            this.setStreamFormatVersion((byte)2);
        }
    }

    @Override
    public byte getGIOPMajor() {
        return this.GIOPMajor;
    }

    @Override
    public byte getGIOPMinor() {
        return this.GIOPMinor;
    }

    protected final boolean isPreGiop12() {
        return this.preGIOP12_CDR;
    }

    public void setStreamFormatVersion(byte by) {
        this.streamFormatVersion = by;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "custom stream format=", Trc.str(this.streamFormatVersion), CLASS, "setStreamFormatVersion:467");
        }
    }

    @Override
    public short getPartnerMajor() {
        if (this.partnerMajor == -1) {
            this.partnerMajor = this.connInfo.getPartnerMajor();
        }
        return this.partnerMajor;
    }

    @Override
    public short getPartnerMinor() {
        if (this.partnerMinor == -1) {
            this.partnerMinor = this.connInfo.getPartnerMinor();
        }
        return this.partnerMinor;
    }

    @Override
    public short getPartnerExtended() {
        if (this.partnerExtended == -1) {
            this.partnerExtended = this.connInfo.getPartnerExtended();
        }
        return this.partnerExtended;
    }

    @Override
    public void setCodeSets(int n, int n2) {
        this.tcsChar = n;
        this.tcsWChar = n2;
        this.tcsCConverter = null;
        this.tcsWConverter = null;
    }

    public void setPartnerVersion(int n) {
        this.partnerMajor = PartnerVersionUtil.unpackMajor(n);
        this.partnerMinor = PartnerVersionUtil.unpackMinor(n);
    }

    public final byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    @Override
    public int getCharCodeSet() {
        return this.tcsChar;
    }

    @Override
    public int getWCharCodeSet() {
        return this.tcsWChar;
    }

    protected static int[] getByteShifts(int n, boolean bl) {
        return bl ? SWAPBYTE_SHIFTS : NOSWAPBYTES_SHIFTS[n / 4];
    }

    public void addTypePosition(TypeCodeImpl typeCodeImpl, int n) {
        if (this.typeMap == null) {
            this.typeMap = new Hashtable(16);
        }
        this.typeMap.put(typeCodeImpl, n);
    }

    public int getTypePosition(TypeCodeImpl typeCodeImpl) {
        if (this.typeMap == null) {
            return -1;
        }
        java.lang.Object v = this.typeMap.get((java.lang.Object)typeCodeImpl);
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    @Override
    public void enableLargeDataBufferPool() {
    }

    @Override
    public void disableLargeDataBufferPool() {
    }

    @Override
    public abstract void releaseBuffer();

    @Override
    public abstract byte[] toByteArray();

    private Hashtable getTypeMap() {
        if (this.typeMap == null) {
            this.typeMap = new Hashtable(16);
        }
        return this.typeMap;
    }

    void setPaddingPending() {
        this.paddingPending = true;
    }

    void clearPaddingPending() {
        this.paddingPending = false;
    }

    boolean isPaddingPending() {
        return this.paddingPending;
    }

    protected void checkPadding() {
        if (this.paddingPending) {
            this.paddingPending = false;
            this.align(8);
            this.recordBodyPosition();
        }
    }

    protected void recordBodyPosition() {
    }

    protected abstract void pad(int var1);

    protected abstract void align(int var1);

    protected abstract int alignAndReserve(int var1, int var2);

    protected final void completeFragment(int n) {
        if (this.inBlock && !this.startNewChunk && !this.writingChunkMarker) {
            this.end_block(n, true);
            this.sendFragment();
            this.startNewChunk = true;
        } else {
            this.sendFragment();
            if (this.writingChunkMarker) {
                this.align(4);
                this.rememberBlockSizePosition();
            }
        }
        this.clearEndFlagMarker();
    }

    protected abstract void rememberBlockSizePosition();

    protected abstract void forgetBlockSizePosition();

    protected abstract void writeBlockSizeHere(int var1);

    protected abstract void clearEndFlagMarker();

    protected abstract void allocateBuffer();

    protected void sendFragment() {
        throw new MARSHAL("OutputStream fragmentation error", 1229125818, CompletionStatus.COMPLETED_NO);
    }

    @Override
    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    @Override
    public final boolean littleEndian() {
        return this.littleEndian;
    }

    @Override
    public void write_longdouble(double d) {
        throw new NO_IMPLEMENT("Long Double Not Implemented (3)", 1229124492, CompletionStatus.COMPLETED_MAYBE);
    }

    protected final void checkChunkStart() {
        if (this.startNewChunk) {
            this.writingChunkMarker = true;
            this.startNewChunk = false;
            this.writeBlockSizeHere(0);
            this.writingChunkMarker = false;
            this.inBlock = true;
        }
    }

    @Override
    public abstract void write_octet(byte var1);

    protected static byte booleanToByte(boolean bl) {
        return (byte)(bl ? 1 : 0);
    }

    @Override
    public void write_boolean(boolean bl) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(1, 1);
        this.writeBoolean(bl);
    }

    public abstract java.lang.Object writePlaceHolderBoolean(boolean var1);

    public abstract void rewriteBoolean(boolean var1, java.lang.Object var2);

    public abstract java.lang.Object writePlaceHolderOctet(byte var1);

    public abstract void rewriteOctet(byte var1, java.lang.Object var2);

    public abstract java.lang.Object writePlaceHolderLong(int var1);

    public abstract void rewriteLong(int var1, java.lang.Object var2);

    protected abstract void writeBoolean(boolean var1);

    protected abstract void writeShort(int var1, boolean var2);

    protected abstract void writeLong(int var1, boolean var2);

    protected abstract void writeLongLong(long var1, boolean var3);

    @Override
    public void write_short(short s) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(2, 2);
        this.writeShort(s, this.littleEndian);
    }

    @Override
    public void write_ushort(short s) {
        this.write_short(s);
    }

    public abstract void write_long(int var1, boolean var2);

    @Override
    public void write_longlong(long l) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(8, 8);
        this.writeLongLong(l, this.littleEndian);
    }

    @Override
    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    @Override
    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    @Override
    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public abstract void write_octet_array(byte[] var1, int var2, int var3, boolean var4);

    public abstract void writeOctetArrayPiece(byte[] var1, int var2, int var3, boolean var4, int var5);

    @Override
    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    @Override
    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM("Null Param (5) - any", 1229124101, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value((OutputStream)this);
    }

    @Override
    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM("Null Param (6) - TypeCode", 1229124102, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this);
    }

    @Override
    public void writeAnyOpt(java.lang.Object object) {
        int n;
        boolean bl = this.isOptimisedTCVersion();
        if (object instanceof String) {
            this.writeStringAnyOpt((String)object, bl);
            return;
        }
        if (object == null) {
            this.writeNullAnyOpt(bl);
            return;
        }
        java.lang.Object object2 = Utility.autoConnect(object, this.orb, false);
        TypeCodeImpl typeCodeImpl = (TypeCodeImpl)ValueUtility.getTypeCode(this.orb, object2, (PartnerVersion)this);
        if (bl) {
            n = this.getTypePosition(typeCodeImpl);
            if (n != -1) {
                this.writeIndirection(n);
            } else {
                typeCodeImpl.write_value(this);
            }
        } else {
            typeCodeImpl.write_value(this);
        }
        n = typeCodeImpl.kind().value();
        if (n == 29) {
            this.write_value((Serializable)object2);
        } else if (n == 30) {
            this.write_value((Serializable)object2);
        } else if (n == 14) {
            this.write_Object((Object)object2);
        } else if (n == 32) {
            this.write_abstract_interface(object2);
        } else {
            throw new BAD_PARAM("Unexpected type for any", 1229125805, CompletionStatus.COMPLETED_NO);
        }
    }

    public final java.lang.Object fast_writeAnyOpt(java.lang.Object object) {
        int n;
        boolean bl = this.isOptimisedTCVersion();
        if (object == null) {
            this.writeNullAnyOpt(bl);
            return object;
        }
        if (this.isCollocated && this.crossReferencePointer != -1) {
            this.write_long(-16);
            this.write_long(this.crossReferencePointer);
            this.crossReferencePointer = -1;
            this.isCollocated = false;
            return object;
        }
        if (object instanceof String) {
            this.writeStringAnyOpt((String)object, bl);
            return object;
        }
        java.lang.Object object2 = Utility.autoConnect(object, this.orb, false);
        TypeCodeImpl typeCodeImpl = (TypeCodeImpl)ValueUtility.getTypeCode(this.orb, object2, (PartnerVersion)this);
        if (bl) {
            n = this.getTypePosition(typeCodeImpl);
            if (n != -1) {
                this.writeIndirection(n);
            } else {
                typeCodeImpl.write_value(this);
            }
        } else {
            typeCodeImpl.write_value(this);
        }
        n = typeCodeImpl.kind().value();
        if (n == 29) {
            return this.fastWriteVal((Serializable)object2);
        }
        if (n == 30) {
            return this.fastWriteVal((Serializable)object2);
        }
        if (n == 14) {
            this.write_Object((Object)object2);
            return object2;
        }
        if (n == 32) {
            return this.fast_write_abstract_interface(object2);
        }
        throw new BAD_PARAM("Unexpected type for any", 1229125811, CompletionStatus.COMPLETED_NO);
    }

    private final void writeStringAnyOpt(String string, boolean bl) {
        if (this.firstStringTc == -1 || !bl) {
            this.firstStringTc = BOX_STRING_TC.writeValueOpt(this);
        } else {
            this.writeIndirection(this.firstStringTc);
        }
        this.write_value((Serializable)((java.lang.Object)string));
    }

    private final void writeNullAnyOpt(boolean bl) {
        if (this.firstNullTc == -1 || !bl) {
            if (this.useOldNullTC()) {
                this.firstNullTc = TypeCodeImpl.get_primitive_tc(TCKind.tk_value).writeValueOpt(this);
                this.write_value(null);
            } else {
                this.firstNullTc = ABSTRACT_INTERFACE_TC.writeValueOpt(this);
                this.write_abstract_interface(null);
            }
        } else {
            this.writeIndirection(this.firstNullTc);
            this.write_abstract_interface(null);
        }
    }

    public final void writeIndirection(int n) {
        this.checkPadding();
        this.checkChunkStart();
        this.addIndirectionBytes = 4;
        this.alignAndReserve(4, 4);
        this.writeLong(-1, this.littleEndian);
        this.addIndirectionBytes = 0;
        this.alignAndReserve(4, 4);
        this.writeLong(n - this.get_offset(), this.littleEndian);
    }

    @Override
    public void write_Object(Object object) {
        if (object == null) {
            IOR.NULL.write(this);
            return;
        }
        if (object instanceof LocalObject) {
            throw new MARSHAL(object.getClass() + " is a LocalObject and " + "cannot be marshalled", 1330446340, CompletionStatus.COMPLETED_MAYBE);
        }
        if (object instanceof DynamicStub) {
            object = ((DynamicStub)object).getStub();
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        ClientSubcontract clientSubcontract = null;
        com.ibm.CORBA.iiop.IOR iOR = null;
        try {
            Delegate delegate = objectImpl._get_delegate();
            if (delegate instanceof ClientSubcontract) {
                clientSubcontract = (ClientSubcontract)delegate;
                iOR = clientSubcontract.marshal();
            } else if (Trc.enabled(2) && !(delegate instanceof DisconnectedDelegate)) {
                Trc.info(Trc.FINEST, "received non-IBM delegate of type", Trc.clz(delegate), CLASS, "write_Object:1082");
            }
        }
        catch (BAD_OPERATION bAD_OPERATION) {
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "write_Object:1088");
        }
        if (clientSubcontract == null) {
            if (object instanceof Stub) {
                try {
                    ((Stub)object).connect(this.orb);
                }
                catch (RemoteException remoteException) {
                    Trc.ffdc(remoteException, CLASS, "write_Object:1099");
                    MARSHAL mARSHAL = new MARSHAL(object.getClass() + " is a CORBA Stub, no IOR: servant was not " + "connected to ORB", 1229125797, CompletionStatus.COMPLETED_MAYBE);
                    mARSHAL.initCause((Throwable)remoteException);
                    throw mARSHAL;
                }
            } else {
                ((com.ibm.rmi.corba.ORB)this.orb).internalConnect(object);
            }
            clientSubcontract = (ClientSubcontract)objectImpl._get_delegate();
        }
        if (iOR == null) {
            iOR = clientSubcontract.isClientCallback() ? clientSubcontract.getCallbackIOR(this.connInfo.getLocalHost(), this.connInfo.getLocalPort()) : clientSubcontract.marshal();
        }
        iOR.write(this);
    }

    @Override
    public void write_abstract_interface(java.lang.Object object) {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "write_abstract_interface:1136");
        }
        if (this.fast_write_abstract_interface_as_Object(object)) {
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, object == null ? null : object.getClass().getName(), CLASS, "write_abstract_interface:1140");
            }
            return;
        }
        try {
            this.write_value((Serializable)object);
        }
        catch (ClassCastException classCastException) {
            Trc.ffdc(classCastException, CLASS, "write_abstract_interface:1147");
            if (object instanceof Serializable) {
                throw classCastException;
            }
            Utility.throwNotSerializableForCorba(object.getClass().getName());
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, object == null ? null : object.getClass().getName(), CLASS, "write_abstract_interface:1157");
        }
    }

    private final boolean fast_write_abstract_interface_as_Object(java.lang.Object object) {
        if (object != null && object instanceof Object) {
            if (object instanceof DynamicStub) {
                object = ((DynamicStub)object).getStub();
            }
            ObjectImpl objectImpl = (ObjectImpl)object;
            try {
                Delegate delegate = objectImpl._get_delegate();
                if (!(delegate instanceof DisconnectedDelegate)) {
                    this.write_boolean(true);
                    this.write_Object((Object)objectImpl);
                    return true;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                // empty catch block
            }
        }
        this.write_boolean(false);
        return false;
    }

    public final java.lang.Object fast_write_abstract_interface(java.lang.Object object) {
        if (this.fast_write_abstract_interface_as_Object(object)) {
            return object;
        }
        return this.fastWriteVal((Serializable)object);
    }

    @Override
    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    @Override
    public final void write_value(Serializable serializable, String string) {
        boolean bl = false;
        java.lang.Object object = this.fastWriteVal(serializable, string);
        if (object != PENDING_WRITE) {
            return;
        }
        try {
            if (this.valueHandler == null) {
                bl = true;
                this.valueHandler = ValueHandlerPool.getValueHandler();
            }
            boolean bl2 = this.prevMustChunk;
            this.valueHandler.writeValue((OutputStream)this, (Serializable)this.currentObject, this.streamFormatVersion);
            this.postFastWriteVal(bl2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Trc.ffdc("Caught OOM: " + outOfMemoryError, CLASS, "write_value:1229");
            throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126020, CompletionStatus.COMPLETED_NO);
        }
        finally {
            if (bl) {
                ValueHandlerPool.returnValueHandler(this.valueHandler);
                this.valueHandler = null;
            }
        }
    }

    @Override
    public void write_value(Serializable serializable) {
        this.write_value(serializable, (String)null);
    }

    public final void postFastWriteVal(boolean bl) {
        if (this.mustChunk) {
            this.end_block();
            this.writeEndTag(true);
        } else {
            this.writeEndTag(false);
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public final java.lang.Object fastWriteVal(Serializable serializable) {
        return this.fastWriteVal(serializable, null);
    }

    private final java.lang.Object fastWriteValInternal(Serializable serializable, String string) {
        if (serializable == null) {
            this.write_long(0);
            return serializable;
        }
        Integer n = null;
        if (this.valueCache != null && (n = (Integer)this.valueCache.get(serializable)) != null) {
            int n2 = n;
            this.writeIndirection(n2);
            return serializable;
        }
        if (this.isCollocated && this.crossReferencePointer != -1) {
            this.write_long(-16);
            this.write_long(this.crossReferencePointer);
            this.crossReferencePointer = -1;
            this.isCollocated = false;
            return serializable;
        }
        boolean bl = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (serializable instanceof String) {
            this.writeString((String)((java.lang.Object)serializable));
        } else if (serializable instanceof Class) {
            if (string == null) {
                this.writeClass(RepositoryId.kClassDescValueRepID, (Class)serializable);
            } else {
                this.writeClass(string, (Class)serializable);
            }
        } else if (serializable instanceof ValueBase) {
            Class<?> clazz = serializable.getClass();
            this.writeValueBase((ValueBase)serializable, clazz);
        } else if (serializable instanceof IDLEntity) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else {
            return PENDING_WRITE;
        }
        this.postFastWriteVal(bl);
        return serializable;
    }

    public final java.lang.Object fastWriteVal(Serializable serializable, String string) {
        java.lang.Object object;
        java.lang.Object object2 = this.fastWriteValInternal(serializable = writeValueTransformer.transformValue(serializable, this.getPartnerMajor()), string);
        if (object2 != PENDING_WRITE) {
            return object2;
        }
        this.prevMustChunk = this.mustChunk;
        Class<?> clazz = serializable.getClass();
        if (clazz.isArray()) {
            String string2 = RepositoryId.createSequenceRepID(clazz, this.getOldSUID(), this.getPartnerMajor(), this.getPartnerMinor());
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, clazz);
                this.updateIndirectionTable(n, serializable, serializable);
                this.writeRepositoryId(string2);
                this.start_block();
                --this.end_flag;
            } else {
                int n = this.writeValueTag(false, false, clazz);
                this.updateIndirectionTable(n, serializable, serializable);
                this.writeRepositoryId(string2);
                if (this.useOldNestingDepths()) {
                    --this.end_flag;
                }
            }
            this.currentObject = serializable;
            return PENDING_WRITE;
        }
        Serializable serializable2 = serializable;
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz, this.getPartnerMajor(), this.getPartnerMinor());
        serializable = objectStreamClass.writeReplace(serializable2);
        if (serializable != serializable2) {
            if (serializable == null) {
                this.write_long(0);
                return serializable;
            }
            object = clazz;
            clazz = serializable.getClass();
            if (clazz != object) {
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, object, clazz, CLASS, "fastWriteVal:1397");
                }
                objectStreamClass = ObjectStreamClass.lookup(clazz, this.getPartnerMajor(), this.getPartnerMinor());
            }
            if ((object2 = this.fastWriteValInternal(serializable, string)) != PENDING_WRITE) {
                return object2;
            }
        }
        if (objectStreamClass.isCustomIDL()) {
            this.mustChunk = true;
        }
        object = RepositoryId.createForJavaType(clazz, this.getOldSUID(), this.getPartnerMajor(), this.getPartnerMinor());
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, clazz);
            this.updateIndirectionTable(n, serializable, serializable2);
            this.writeRepositoryId((String)object);
            --this.end_flag;
            this.start_block();
        } else {
            int n = this.writeValueTag(false, false, clazz);
            this.updateIndirectionTable(n, serializable, serializable2);
            this.writeRepositoryId((String)object);
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
        }
        this.currentObject = serializable;
        return PENDING_WRITE;
    }

    @Override
    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        try {
            if (serializable == null) {
                this.write_long(0);
                return;
            }
            if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                int n = (Integer)this.valueCache.get(serializable);
                this.writeIndirection(n);
                return;
            }
            boolean bl = this.mustChunk;
            if (this.mustChunk) {
                if (this.inBlock) {
                    this.end_block();
                }
                int n = this.writeValueTag(true, false, serializable.getClass());
                this.writeRepositoryId(boxedValueHelper.get_id());
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
            } else {
                int n = this.writeValueTag(false, false, serializable.getClass());
                this.writeRepositoryId(boxedValueHelper.get_id());
                this.updateIndirectionTable(n, serializable, serializable);
                if (this.useOldNestingDepths()) {
                    --this.end_flag;
                }
            }
            boxedValueHelper.write_value((OutputStream)this, serializable);
            this.postFastWriteVal(bl);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Trc.ffdc("Caught OOM: " + outOfMemoryError, CLASS, "write_value(Serializable,BoxedValueHelper):1473");
            throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126021, CompletionStatus.COMPLETED_NO);
        }
    }

    public final int get_offset() {
        return this.get_offset(false);
    }

    public abstract int get_offset(boolean var1);

    public final void start_block() {
        this.checkPadding();
        this.align(4);
        this.rememberBlockSizePosition();
        this.startNewChunk = true;
        this.inBlock = true;
    }

    public final void end_block() {
        this.end_block(0, false);
    }

    public final void end_block(int n, boolean bl) {
        if (!this.inBlock) {
            return;
        }
        if (!bl) {
            this.inBlock = false;
            if (this.startNewChunk) {
                this.forgetBlockSizePosition();
                this.startNewChunk = false;
                return;
            }
        }
        this.startNewChunk = false;
        this.rewriteBlockSize(n, this.addIndirectionBytes);
        this.forgetBlockSizePosition();
    }

    protected abstract void rewriteBlockSize(int var1, int var2);

    public final void start_value(String string) {
        this.end_block();
        this.mustChunk = true;
        this.writeValueTag(true, false, null);
        this.writeRepositoryId(string);
        this.start_block();
        --this.end_flag;
    }

    public final void end_value() {
        this.end_block();
        this.writeEndTag(true);
        this.start_block();
    }

    @Override
    public final org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public final boolean isOptimisedTCVersion() {
        if (!this.checkedOptimisedTCVersion) {
            if (this.orb instanceof ORB && ((ORB)this.orb).getAlwaysUseOMG4796()) {
                this.optimisedTCVersion = true;
            } else {
                short s = this.getPartnerMajor();
                short s2 = this.getPartnerMinor();
                this.optimisedTCVersion = PartnerVersionUtil.isOptimisedTCVersion(s, s2);
            }
            this.checkedOptimisedTCVersion = true;
        }
        return this.optimisedTCVersion;
    }

    protected final boolean useOldNullTC() {
        if (!this.checkedOldNullTC) {
            short s = this.getPartnerMajor();
            short s2 = this.getPartnerMinor();
            this.oldNullTC = PartnerVersionUtil.useOldNullTC(s, s2);
            this.checkedOldNullTC = true;
        }
        return this.oldNullTC;
    }

    @Override
    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new BAD_PARAM("Null Param (7) - boolean array", 1229124103, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(1, n2 - n3);
                for (int i = 0; i < n4; ++i) {
                    this.writeBoolean(blArray[n + n3]);
                    ++n3;
                }
            }
        }
    }

    @Override
    public void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM("Null Param (10) - short_array", 1229124106, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(2, (n2 - n3) * 2);
                for (int i = 0; i < n4; ++i) {
                    this.writeShort(sArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    @Override
    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    @Override
    public void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM("Null Param (11) - ushort_array", 1229124107, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(4, (n2 - n3) * 4);
                for (int i = 0; i < n4; ++i) {
                    this.writeLong(nArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    @Override
    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    @Override
    public void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM("Null Param (12) - ulong_array", 1229124108, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(8, (n2 - n3) * 8);
                for (int i = 0; i < n4; ++i) {
                    this.writeLongLong(lArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    @Override
    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    @Override
    public void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new BAD_PARAM("Null Param (13) - ulonglong_array", 1229124109, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                n4 = this.alignAndReserve(4, (n2 - n3) * 4);
                for (int i = 0; i < n4; ++i) {
                    int n5 = Float.floatToIntBits(fArray[n + n3]);
                    this.writeLong(n5, this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    @Override
    public void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new BAD_PARAM("Null Param (14) - double_array", 1229124110, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                n4 = this.alignAndReserve(8, (n2 - n3) * 8);
                for (int i = 0; i < n4; ++i) {
                    long l = Double.doubleToLongBits(dArray[n + n3]);
                    this.writeLongLong(l, this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    @Override
    public final void write_string_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM("Null Param (15) - string_array", 1229124111, CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < n2; ++i) {
            this.write_string(stringArray[i + n]);
        }
    }

    @Override
    public final void write_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_any(anyArray[i + n]);
        }
    }

    protected boolean fragmenting() {
        return this.fragmentSize() > 0;
    }

    protected int fragmentSize() {
        if (this.fragSize == -1) {
            this.fragSize = 0;
            if (this.isFragmentable() && this.orb instanceof ORB) {
                this.fragSize = ((ORB)this.orb).getFragmentSize();
                if (this.fragSize < 0) {
                    this.fragSize = 0;
                }
            }
        }
        return this.fragSize;
    }

    protected int bufferSize() {
        if (this.fragmentSize() > 0) {
            return this.useCFW ? this.fragSize - 16 : this.fragSize;
        }
        return this.requestedBufLen > 0 ? this.requestedBufLen : 1024;
    }

    protected final int getTcsC() {
        if (this.tcsChar == -1) {
            this.tcsChar = this.connInfo.getCharCodeSet();
        }
        return this.tcsChar;
    }

    protected final int getTcsW() {
        if (this.tcsWChar == -1) {
            this.tcsWChar = this.connInfo.getWCharCodeSet();
            if (this.tcsWChar == 0 && this.orb instanceof ORB) {
                this.tcsWChar = ((ORB)this.orb).getWCharDefault();
            }
            if (this.tcsWChar == 0) {
                this.tcsWChar = 65792;
            }
        }
        return this.tcsWChar;
    }

    @Override
    public final void reset() {
        boolean bl = this.resetBufferData();
        if (bl) {
            this.end_flag = 0;
        }
    }

    protected abstract boolean resetBufferData();

    public final boolean getPrevMustChunk() {
        return this.prevMustChunk;
    }

    public final Serializable getCurrentObject() {
        return (Serializable)this.currentObject;
    }

    public final boolean getOldSUID() {
        if (this.oldSUID == -1) {
            short s;
            short s2 = this.getPartnerMajor();
            this.oldSUID = PartnerVersionUtil.useOldSUID(s2, s = this.getPartnerMinor()) ? 1 : 0;
        }
        return this.oldSUID == 1;
    }

    public static int getDefaultBufferSize() {
        return 1024;
    }

    private final void updateValueCache(int n, java.lang.Object object) {
        if (!(object instanceof StackTraceElement[]) && !(object instanceof StackTraceElement) || !PartnerVersionUtil.needOldThrowable(this.getPartnerMajor(), this.getPartnerMinor())) {
            this.valueCache.put(object, (java.lang.Object)n);
        }
    }

    private final void updateIndirectionTable(int n, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new IdentityHashtable();
        }
        this.updateValueCache(n, object);
        if (object2 != object) {
            this.updateValueCache(n, object2);
        }
        if (this.isCollocated) {
            this.setSerializedFieldsInfo(n, object);
        }
    }

    private final void writeRepositoryId(String string) {
        int n;
        boolean bl = this.interop.useAlternativeRepIDEncoding.inUse();
        if (bl) {
            string = RepositoryId.unescape(string);
        }
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            int n2 = (Integer)this.repositoryIdCache.get(string);
            this.writeIndirection(n2);
            return;
        }
        byte[] byArray = null;
        if (!bl) {
            byArray = RepositoryId.getByteArray(string);
            if (byArray == null) {
                n = string.length() + 1;
                byArray = new byte[n];
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] > '\u00ff') {
                        throw new INTERNAL("Tried to marshal a Repository ID containing characters that are not part of the ISO Latin-1 character set. Repository ID=" + string, 1229125061, CompletionStatus.COMPLETED_NO);
                    }
                    byArray[i] = (byte)cArray[i];
                }
                byArray[n - 1] = 0;
                RepositoryId.setByteArray(string, byArray);
            }
        } else {
            byArray = this.convertStringToTcsBytes(string);
        }
        n = byArray.length;
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(4, 4 + n);
        this.writeLong(n, this.littleEndian);
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new Hashtable();
        }
        this.repositoryIdCache.put(string, this.get_offset() - 4);
        this.write_octet_array(byArray, 0, n, false);
    }

    protected abstract byte[] convertStringToTcsBytes(String var1);

    private final void write_codebase(String string, int n) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            int n2 = (Integer)this.codebaseCache.get(string);
            this.writeIndirection(n2);
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new Hashtable();
            }
            this.codebaseCache.put(string, n);
        }
    }

    private final int writeValueTag(boolean bl, boolean bl2, Class clazz) {
        int n = 0;
        int n2 = 0;
        String string = null;
        if (clazz != null && (!(this.orb instanceof ORB) || ((ORB)this.orb).getCodebaseURLEnabled())) {
            string = Util.getCodebase((Class)clazz);
        }
        if (bl && bl2) {
            if (string == null) {
                n2 = RepositoryId.kPreComputed_StandardRMIChunked_NoRep;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
            } else {
                n2 = RepositoryId.kPreComputed_CodeBaseRMIChunked_NoRep;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl && !bl2) {
            if (string == null) {
                n2 = RepositoryId.kPreComputed_StandardRMIChunked;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
            } else {
                n2 = RepositoryId.kPreComputed_CodeBaseRMIChunked;
                this.write_long(n2);
                n = this.get_offset(true) - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            n2 = RepositoryId.kPreComputed_StandardRMIUnchunked;
            this.write_long(n2);
            n = this.get_offset(true) - 4;
        } else {
            n2 = RepositoryId.kPreComputed_CodeBaseRMIUnchunked;
            this.write_long(n2);
            n = this.get_offset(true) - 4;
            this.write_codebase(string, this.get_offset());
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "write value tag ", Trc.hex(n2), " index_hex ", Trc.hex(n), CLASS, "writeValueTag:2037");
        }
        return n;
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        Class<?> clazz = iDLEntity.getClass();
        String string = RepositoryId.createForJavaType(clazz, false, this.getPartnerMajor(), this.getPartnerMinor());
        String string2 = Util.getCodebase(clazz);
        int n = this.writeValueTag(true, false, clazz);
        this.updateIndirectionTable(n, iDLEntity, iDLEntity);
        this.writeRepositoryId(string);
        --this.end_flag;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{OutputStream.class, clazz};
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz2.getMethod(CDRWriter.kWriteMethod, classArray);
                }
            });
            java.lang.Object[] objectArray = new java.lang.Object[]{this, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trc.ffdc(classNotFoundException, CLASS, "writeIDLEntity:2085");
            MARSHAL mARSHAL = new MARSHAL("ClassNotFoundException: " + classNotFoundException.getMessage(), 1229125798, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)classNotFoundException);
            throw mARSHAL;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            Trc.ffdc(exception, CLASS, "writeIDLEntity:2093");
            MARSHAL mARSHAL = new MARSHAL("PrivilegedActionException:" + exception.getMessage(), 1229125799, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)exception);
            throw mARSHAL;
        }
        catch (IllegalAccessException illegalAccessException) {
            Trc.ffdc(illegalAccessException, CLASS, "writeIDLEntity:2100");
            MARSHAL mARSHAL = new MARSHAL("IllegalAccessException :" + illegalAccessException.getMessage(), 1229125800, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)illegalAccessException);
            throw mARSHAL;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof BAD_PARAM) {
                Trc.ffdc((Exception)throwable, CLASS, "writeIDLEntity:2109");
                throw (BAD_PARAM)throwable;
            }
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                Trc.ffdc((Exception)throwable, CLASS, "writeIDLEntity:2115");
            }
            Trc.ffdc(throwable + ":" + throwable.getMessage(), CLASS, "writeIDLEntity:2117");
            MARSHAL mARSHAL = new MARSHAL("InvocationTargetException:" + throwable.getMessage(), 1229125801, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause(throwable);
            throw mARSHAL;
        }
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write((OutputStream)this);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal((DataOutputStream)this);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boxedValueHelper.write_value((OutputStream)this, serializable);
        }
    }

    protected abstract void writeEndTag(int var1);

    private void writeEndTag(boolean bl) {
        if (bl) {
            this.writeEndTag(this.end_flag);
            if (!this.useOldNestingDepths()) {
                ++this.end_flag;
            }
        }
        if (this.useOldNestingDepths()) {
            ++this.end_flag;
        }
    }

    private void writeClass(String string, Class clazz) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.writeRepositoryId(string);
            } else {
                this.writeRepositoryId(RepositoryId.kClassDescValueRepID);
            }
            this.start_block();
            --this.end_flag;
            Utility.writeClassValue(this, clazz);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.writeRepositoryId(string);
            } else {
                this.writeRepositoryId(RepositoryId.kClassDescValueRepID);
            }
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
            Utility.writeClassValue(this, clazz);
        }
    }

    private void writeString(String string) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, string, string);
            this.writeRepositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
            this.start_block();
            --this.end_flag;
            this.write_wstring(string);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, string, string);
            this.writeRepositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
            this.write_wstring(string);
        }
    }

    private void writeValueBase(ValueBase valueBase, Class clazz) {
        this.mustChunk = true;
        int n = this.writeValueTag(true, false, clazz);
        this.updateIndirectionTable(n, valueBase, valueBase);
        String string = valueBase._truncatable_ids()[0];
        this.writeRepositoryId(string);
        this.start_block();
        --this.end_flag;
        this.writeIDLValue((Serializable)valueBase, string);
    }

    @Override
    public void writeSystemException(SystemException systemException) {
        Utility.writeSystemException(systemException, (OutputStream)this);
    }

    @Override
    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    @Override
    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public void setIsCollocated(boolean bl) {
        this.isCollocated = bl;
    }

    public void setCrossReferencePointer(int n) {
        this.crossReferencePointer = n;
    }

    @Override
    public String[] _truncatable_ids() {
        return _ids;
    }

    @Override
    public abstract void printBuffer();

    protected boolean useOldNestingDepths() {
        if (!this.haveCheckedOldNestingDepths) {
            short s = this.getPartnerMajor();
            short s2 = this.getPartnerMinor();
            this.useOldNestingDepths = PartnerVersionUtil.useOldNestingDepths(s, s2);
            this.haveCheckedOldNestingDepths = true;
        }
        return this.useOldNestingDepths;
    }

    public final boolean isFragmentable() {
        return this.fragmentable;
    }

    public void close() {
        this.typeMap = null;
        this.currentObject = null;
        if (this.valueCache != null) {
            this.valueCache.clear();
            this.valueCache = null;
        }
        if (this.valueHandler != null) {
            this.valueHandler.reset();
            this.valueHandler = null;
        }
        this.serializedFieldsInfo.clear();
        this.serializedFieldsInfo = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:2326");
        throw notSerializableException;
    }

    @Override
    public void writeSpecialPadding(int n) {
        for (int i = 0; i < n; ++i) {
            this.writeBoolean(false);
        }
    }

    public void setSerializedFieldsInfo(java.lang.Object object, java.lang.Object object2) {
        this.serializedFieldsInfo.put(object, object2);
    }

    public HashMap getSerializedFieldsInfo() {
        return this.serializedFieldsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("sun.util.calendar.ZoneInfo");
            writeValueTransformer = null == clazz ? WriteNoopTransformer.INSTANCE : WriteZoneInfoTransformer.INSTANCE;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "Could not load '", "sun.util.calendar.ZoneInfo", "'.", CLASS, "<clinit>:283");
                }
                writeValueTransformer = null == clazz ? WriteNoopTransformer.INSTANCE : WriteZoneInfoTransformer.INSTANCE;
            }
            catch (Throwable throwable) {
                writeValueTransformer = null == clazz ? WriteNoopTransformer.INSTANCE : WriteZoneInfoTransformer.INSTANCE;
                throw throwable;
            }
        }
        SWAPBYTE_SHIFTS = new int[]{0, 8, 16, 24, 32, 40, 48, 56};
        NOSWAPBYTES_SHIFTS = new int[][]{{8, 0}, {24, 16, 8, 0}, {56, 48, 40, 32, 24, 16, 8, 0}};
        _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
        _ids = new String[]{_id};
    }
}

