/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.UserKey;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.corba.Element;
import com.ibm.rmi.corba.ObjectManagerInterface;
import com.ibm.rmi.corba.UserKeyImpl;
import com.ibm.rmi.util.Utility;
import java.rmi.Remote;
import javax.rmi.CORBA.Tie;

public final class TransientObjectManager
implements ObjectManagerInterface {
    private static final String CLASS = TransientObjectManager.class.getName();
    private static final int INIT_SIZE = 8;
    private int maxSize;
    private Element[] elementArray;
    private Element freeList;

    @Override
    public synchronized UserKey storeServant(Object object) {
        if (this.freeList == null) {
            this.grow();
        }
        Element element = this.freeList;
        this.freeList = (Element)this.freeList.servant;
        UserKeyImpl userKeyImpl = new UserKeyImpl(element.store(object));
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.info(Trc.FINEST, object.getClass().getName(), ((Object)userKeyImpl).toString(), CLASS, "storeServant:64");
        }
        return userKeyImpl;
    }

    @Override
    public synchronized Object lookupServant(UserKey userKey) {
        byte[] byArray = userKey.getBytes();
        int n = Utility.bytesToInt(byArray, 0);
        int n2 = Utility.bytesToInt(byArray, 4);
        if (n < 0 || n + 1 > this.maxSize) {
            if (Trc.enabled(1) || Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "key " + ((Object)userKey).toString() + " is out of range: index is " + n + " but valid range is 0-" + (this.maxSize - 1), CLASS, "lookupServant:80");
            }
            return null;
        }
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            return this.elementArray[n].servant;
        }
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "stale key " + ((Object)userKey).toString(), CLASS, "lookupServant:90");
        }
        return null;
    }

    @Override
    public synchronized void deleteServant(UserKey userKey) {
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.info(Trc.FINEST, ((Object)userKey).toString(), CLASS, "deleteServant:99");
        }
        byte[] byArray = userKey.getBytes();
        int n = Utility.bytesToInt(byArray, 0);
        int n2 = Utility.bytesToInt(byArray, 4);
        if (n < 0 || n + 1 > this.maxSize) {
            if (Trc.enabled(1) || Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "key " + ((Object)userKey).toString() + " is out of range: index is " + n + " but valid range is 0-" + (this.maxSize - 1), CLASS, "deleteServant:107");
            }
            return;
        }
        if (this.elementArray[n].counter == n2 && this.elementArray[n].valid) {
            this.freeList = this.elementArray[n].delete(this.freeList);
            return;
        }
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "stale key " + ((Object)userKey).toString(), CLASS, "deleteServant:121");
        }
    }

    @Override
    public synchronized UserKey getKey(Object object) {
        for (int i = 0; i < this.maxSize; ++i) {
            if (!this.elementArray[i].valid || this.elementArray[i].servant != object) continue;
            return new UserKeyImpl(this.elementArray[i].toBytes());
        }
        return null;
    }

    @Override
    public Object preinvoke(Object object, String string) {
        return null;
    }

    @Override
    public void postinvoke(Object object) {
    }

    private void grow() {
        int n = this.maxSize;
        if (n == 0) {
            this.maxSize = 8;
            this.elementArray = new Element[8];
        } else {
            this.maxSize *= 2;
            Element[] elementArray = this.elementArray;
            this.elementArray = new Element[this.maxSize];
            System.arraycopy(elementArray, 0, this.elementArray, 0, n);
        }
        this.elementArray[this.maxSize - 1] = new Element(this.maxSize - 1, this.freeList);
        for (int i = this.maxSize - 2; i >= n; --i) {
            this.elementArray[i] = new Element(i, this.elementArray[i + 1]);
        }
        this.freeList = this.elementArray[n];
        if (Trc.enabled(1) || Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "grew from " + n + " to " + this.maxSize, CLASS, "grow:169");
        }
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.maxSize; ++i) {
            if (!this.elementArray[i].valid) continue;
            ++n;
            stringBuffer.append(this.elementArray[i] + " ");
        }
        return "Using " + n + " of " + this.maxSize + ":" + stringBuffer.toString();
    }

    public Remote[] getAllServants() {
        if (this.elementArray == null) {
            return new Remote[0];
        }
        Remote[] remoteArray = new Remote[this.elementArray.length];
        int n = 0;
        for (int i = 0; i < remoteArray.length; ++i) {
            if (!this.elementArray[i].valid || !(this.elementArray[i].servant instanceof Tie)) continue;
            Tie tie = (Tie)this.elementArray[i].servant;
            remoteArray[n++] = tie.getTarget();
        }
        return remoteArray;
    }
}

