/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.corba.InitialNamingClient;
import com.ibm.rmi.corba.ORB;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextHelper;

public class InitialReferenceClient
extends InitialNamingClient {
    private static final String CLASS = InitialReferenceClient.class.getName();
    private String defaultInitRef = null;
    private Hashtable initRefs = new Hashtable();
    private Hashtable localRefs = new Hashtable();
    private static final String initRefParm = "-ORBInitRef";
    private static final String defaultInitRefParm = "-ORBDefaultInitRef";
    private static final String initRefProperty = "com.ibm.CORBA.ORBInitRef.";
    private static final String defaultInitRefProperty = "com.ibm.CORBA.ORBDefaultInitRef";
    private String[] reservedNames = new String[]{"InterfaceRepository", "SecurityCurrent", "TransactionCurrent", "ORBPolicyManager", "PolicyCurrent", "ComponentHomeFinder", "TypeCodeFactory", "PSS"};

    InitialReferenceClient(ORB oRB) {
        super(oRB);
    }

    @Override
    String[] list_initial_services() {
        HashSet hashSet;
        block3: {
            hashSet = new HashSet(this.initRefs.keySet());
            hashSet.addAll(this.localRefs.keySet());
            if (this.orb.isSINOClient()) {
                try {
                    hashSet.addAll(Arrays.asList(super.list_initial_services()));
                }
                catch (Exception exception) {
                    if (!Trc.enabled(1)) break block3;
                    Trc.info(Trc.FINEST, exception.toString(), CLASS, "list_initial_services:104");
                }
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    protected Object resolve_initial_references(String string) throws InvalidName {
        RuntimeException runtimeException = null;
        Object object = (Object)this.localRefs.get(string);
        if (object != null) {
            return object;
        }
        ObjectURL objectURL = (ObjectURL)this.initRefs.get(string);
        if (objectURL != null) {
            try {
                if (objectURL.isRir() && objectURL.getKeyString().equals(string)) {
                    if (Trc.enabled()) {
                        Trc.warn("rir object " + string + " points to itself : throwing BAD_PARAM", CLASS, "resolve_initial_references:147");
                    }
                    throw new BAD_PARAM("rir object " + string + " points to itself", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                return this.orb.objectURLToObject(objectURL);
            }
            catch (RuntimeException runtimeException2) {
                if (Trc.enabled(1)) {
                    Trc.info(Trc.FINEST, runtimeException2.toString(), CLASS, "resolve_initial_references:158");
                }
                runtimeException = runtimeException2;
            }
        }
        if (this.defaultInitRef == null) {
            this.defaultInitRef = "corbaloc::" + this.orb.getORBInitialHost() + ":" + this.orb.getORBInitialPort();
        }
        try {
            return this.orb.string_to_object(this.defaultInitRef + '/' + string);
        }
        catch (RuntimeException runtimeException3) {
            block18: {
                if (Trc.enabled(1)) {
                    Trc.info(Trc.FINEST, runtimeException3.toString(), CLASS, "resolve_initial_references:175");
                }
                if (runtimeException == null) {
                    runtimeException = runtimeException3;
                }
                if (this.orb.isSINOClient()) {
                    try {
                        return super.resolve_initial_references(string);
                    }
                    catch (RuntimeException runtimeException4) {
                        if (Trc.enabled(1)) {
                            Trc.info(Trc.FINEST, runtimeException4.toString(), CLASS, "resolve_initial_references:192");
                        }
                    }
                    catch (InvalidName invalidName) {
                        if (!Trc.enabled(1)) break block18;
                        Trc.info(Trc.FINEST, invalidName.toString(), CLASS, "resolve_initial_references:197");
                    }
                }
            }
            if (runtimeException == null) {
                throw new InvalidName(string);
            }
            InvalidName invalidName = new InvalidName(string + ":" + runtimeException.toString());
            invalidName.initCause((Throwable)runtimeException);
            throw invalidName;
        }
    }

    void setDefaultRefs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n + 1 < stringArray.length) {
            boolean bl;
            boolean bl2 = initRefParm.equalsIgnoreCase(stringArray[n]);
            boolean bl3 = bl = bl2 ? false : defaultInitRefParm.equalsIgnoreCase(stringArray[n]);
            if (bl2 | bl) {
                String string = stringArray[n + 1].trim();
                if (string == null || string.length() == 0 || string.toUpperCase().startsWith("-ORB")) {
                    if (Trc.enabled()) {
                        Trc.warn("ignoring bad parameter " + stringArray[n] + " " + stringArray[n + 1], CLASS, "setDefaultRefs:252");
                    }
                } else if (bl2) {
                    int n2 = string.indexOf(61);
                    if (n2 == -1 || n2 == 0 || n2 + 1 == string.length()) {
                        throw new BAD_PARAM(stringArray[n] + " " + string + " should be <ObjectID>=<ObjectURL>", 1229124131, CompletionStatus.COMPLETED_NO);
                    }
                    String string2 = string.substring(0, n2).trim();
                    String string3 = string.substring(n2 + 1).trim();
                    this.createInitRef(string2, string3, true);
                } else if (bl) {
                    this.setDefaultInitRef(string, true);
                }
            }
            ++n;
        }
    }

    void setDefaultRefsFromProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String string = properties.getProperty(defaultInitRefProperty);
        if (string != null) {
            this.setDefaultInitRef(string, false);
        }
        Enumeration<java.lang.Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf(initRefProperty) == -1) continue;
                String string3 = string2.substring(string2.indexOf(initRefProperty) + initRefProperty.length());
                String string4 = properties.getProperty(string2);
                this.createInitRef(string3, string4, false);
            }
            catch (ClassCastException classCastException) {
                if (!Trc.enabled()) continue;
                Trc.warn(classCastException.toString(), CLASS, "setDefaultRefsFromProperties:316");
            }
        }
    }

    private void setDefaultInitRef(String string, boolean bl) {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINEST, (bl ? "-ORBDefaultInitRef " : "com.ibm.CORBA.ORBDefaultInitRef=") + string, CLASS, "setDefaultInitRef:332");
        }
        if (string.indexOf(47) != -1) {
            throw new BAD_PARAM((bl ? "-ORBDefaultInitRef " : "com.ibm.CORBA.ORBDefaultInitRef=") + string + ": should not contain a /", 1229124133, CompletionStatus.COMPLETED_NO);
        }
        if (this.defaultInitRef != null) {
            if (Trc.enabled(1)) {
                Trc.complete(Trc.FINEST, "ignoring value " + string + " : already set to " + this.defaultInitRef, CLASS, "setDefaultInitRef:348");
            }
            return;
        }
        if (!string.toLowerCase().startsWith("corbaloc:") && !string.toLowerCase().startsWith("corbaname:")) {
            throw new BAD_PARAM((bl ? "-ORBDefaultInitRef " : "com.ibm.CORBA.ORBDefaultInitRef=") + string + "is invalid: must be " + "corbaloc:" + " or " + "corbaname:", 1229124134, CompletionStatus.COMPLETED_NO);
        }
        ORB.createObjectURL(string.trim());
        this.defaultInitRef = string;
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINEST, "defaultInitRef set to " + string, CLASS, "setDefaultInitRef:371");
        }
    }

    private void createInitRef(String string, String string2, boolean bl) {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINEST, (bl ? "-ORBInitRef " : "com.ibm.CORBA.ORBInitRef..") + string + "=" + string2, CLASS, "createInitRef:380");
        }
        if (this.initRefs.containsKey(string)) {
            if (Trc.enabled(1)) {
                Trc.complete(Trc.FINEST, "ignoring value " + string2 + ": initial value for " + string + " already set", CLASS, "createInitRef:387");
            }
            return;
        }
        ObjectURL objectURL = ORB.createObjectURL(string2);
        if (objectURL == null) {
            throw new BAD_PARAM((bl ? "-ORBInitRef " : "com.ibm.CORBA.ORBInitRef..") + string + "=" + string2 + ": is invalid", 1229124132, CompletionStatus.COMPLETED_NO);
        }
        this.initRefs.put(string, objectURL);
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINEST, string + "=" + objectURL + " :initial reference set", CLASS, "createInitRef:403");
        }
    }

    private boolean isReservedName(String string) {
        for (int i = 0; i < this.reservedNames.length; ++i) {
            if (!string.equals(this.reservedNames[i])) continue;
            return true;
        }
        return false;
    }

    void register_initial_reference(String string, Object object) throws InvalidName {
        if (Trc.enabled(1)) {
            Trc.begin1(Trc.FINEST, string, CLASS, "register_initial_reference:446");
        }
        if (string == null || string.equals("")) {
            throw new InvalidName("Invalid initial reference id");
        }
        if (this.isReservedName(string) || this.localRefs.get(string) != null) {
            throw new InvalidName(string + ":initial reference id already registered");
        }
        if (ObjectKey.isMBI(string)) {
            throw new InvalidName(string + ":reference ids starting xMBI are reserved for IBM internal usage");
        }
        if (object == null) {
            throw new BAD_PARAM("null obj encountered registering initial reference", 1330446363, CompletionStatus.COMPLETED_NO);
        }
        if (string.equals("NameService") && !object._is_a(NamingContextHelper.id())) {
            throw new BAD_PARAM("The object " + object.getClass() + " is not an org.omg.CosNaming.NamingContext", 1229124143, CompletionStatus.COMPLETED_NO);
        }
        this.localRefs.put(string, object);
        if (!(object instanceof LocalObject)) {
            this.orb.publishINSService(string, object);
        }
        if (Trc.enabled(1)) {
            Trc.complete(Trc.FINEST, CLASS, "register_initial_reference:478");
        }
    }
}

