/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.corba.ORBSingleton;
import com.ibm.rmi.corba.TCUtility;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CDRWriter;
import com.ibm.rmi.io.ValueUtility;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Validator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class AnyImpl
extends Any
implements Externalizable {
    private static final String CLASS = AnyImpl.class.getName();
    private transient org.omg.CORBA.ORB orb;
    private CDRInputStream stream;
    private long primitiveValue;
    private java.lang.Object complexValue;
    private TypeCodeImpl typeCode;
    private static final short pvMajor = PartnerVersionUtil.getORB50();
    private static final short pvMinor = 0;
    private static final short pvExt = 0;
    private static final byte cmsfv = 2;
    private static final byte giopMajor = 1;
    private static final byte giopMinor = 2;
    private transient CDRWriter lastOutputStream;
    private static final boolean[] isStreamed = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, true, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false};

    public AnyImpl(org.omg.CORBA.ORB oRB) {
        this.orb = oRB;
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_null);
        this.stream = null;
        this.complexValue = null;
        this.primitiveValue = 0L;
    }

    public AnyImpl(org.omg.CORBA.ORB oRB, Any any) {
        this(oRB);
        if (any instanceof AnyImpl) {
            AnyImpl anyImpl = (AnyImpl)any;
            this.typeCode = anyImpl.typeCode;
            this.primitiveValue = anyImpl.primitiveValue;
            this.complexValue = anyImpl.complexValue;
            if (anyImpl.stream != null) {
                this.stream = (CDRInputStream)anyImpl.stream.dup();
            }
        } else {
            this.read_value(any.create_input_stream(), any.type());
        }
    }

    public AnyImpl() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(pvMajor);
        objectOutput.writeShort(0);
        objectOutput.writeShort(this.typeCode.kind().value());
        switch (this.typeCode.kind().value()) {
            case 8: 
            case 9: 
            case 10: {
                objectOutput.writeByte((byte)this.primitiveValue);
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                objectOutput.writeShort((short)this.primitiveValue);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectOutput.writeInt((int)this.primitiveValue);
                break;
            }
            case 7: 
            case 23: 
            case 24: {
                objectOutput.writeLong(this.primitiveValue);
                break;
            }
            case 0: {
                break;
            }
            case 18: {
                String string = (String)this.complexValue;
                objectOutput.writeInt(string.length());
                objectOutput.writeBytes(string);
                break;
            }
            case 27: {
                String string = (String)this.complexValue;
                objectOutput.writeUTF(string);
                break;
            }
            default: {
                ORBSingleton oRBSingleton = (ORBSingleton)ORB.init();
                CDRWriter cDRWriter = (CDRWriter)oRBSingleton.newOutputStream();
                cDRWriter.setGIOPVersions((byte)1, (byte)2, pvMajor, (short)0, (short)0, (byte)2);
                cDRWriter.putEndian();
                cDRWriter.write_any(this);
                byte[] byArray = cDRWriter.toByteArray();
                cDRWriter.close();
                objectOutput.writeInt(byArray.length);
                objectOutput.write(byArray);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.orb = ORB.init();
        this.typeCode = TypeCodeImpl.get_primitive_tc(0);
        this.primitiveValue = 0L;
        this.complexValue = null;
        this.stream = null;
        short s = objectInput.readShort();
        short s2 = objectInput.readShort();
        if (s != pvMajor || s2 != 0) {
            String string = "Unexpected PartnerVersion " + s + ":" + s2 + " while reading externalized form";
            Trc.ffdc(string, CLASS, "readExternal:296");
            throw new IOException(string);
        }
        short s3 = objectInput.readShort();
        switch (s3) {
            case 8: {
                this.primitiveValue = objectInput.readByte();
                this.insert_boolean(this.primitiveValue == 1L);
                break;
            }
            case 10: {
                this.primitiveValue = objectInput.readByte();
                this.insert_octet((byte)this.primitiveValue);
                break;
            }
            case 9: {
                this.primitiveValue = objectInput.readByte();
                this.insert_char((char)this.primitiveValue);
                break;
            }
            case 26: {
                this.primitiveValue = objectInput.readShort();
                this.insert_wchar((char)this.primitiveValue);
                break;
            }
            case 2: {
                this.primitiveValue = objectInput.readShort();
                this.insert_short((short)this.primitiveValue);
                break;
            }
            case 4: {
                this.primitiveValue = objectInput.readShort();
                this.insert_ushort((short)this.primitiveValue);
                break;
            }
            case 6: {
                this.primitiveValue = objectInput.readInt();
                this.insert_float(Float.intBitsToFloat((int)this.primitiveValue));
                break;
            }
            case 3: {
                this.primitiveValue = objectInput.readInt();
                this.insert_long((int)this.primitiveValue);
                break;
            }
            case 5: {
                this.primitiveValue = objectInput.readInt();
                this.insert_ulong((int)this.primitiveValue);
                break;
            }
            case 7: {
                this.primitiveValue = objectInput.readLong();
                this.insert_double(Double.longBitsToDouble(this.primitiveValue));
                break;
            }
            case 23: {
                this.primitiveValue = objectInput.readLong();
                this.insert_longlong(this.primitiveValue);
                break;
            }
            case 24: {
                this.primitiveValue = objectInput.readLong();
                this.insert_ulonglong(this.primitiveValue);
                break;
            }
            case 0: {
                break;
            }
            case 18: {
                int n = objectInput.readInt();
                boolean bl = Validator.isValidPostiveInteger(n);
                if (!bl) {
                    throw new IOException("Invalid String length " + n);
                }
                byte[] byArray = new byte[n];
                objectInput.readFully(byArray);
                this.insert_string(new String(byArray));
                break;
            }
            case 27: {
                this.insert_wstring(objectInput.readUTF());
                break;
            }
            default: {
                int n = objectInput.readInt();
                boolean bl = Validator.isValidPostiveInteger(n);
                if (!bl) {
                    throw new IOException("Invalid data length " + n);
                }
                byte[] byArray = new byte[n];
                objectInput.readFully(byArray);
                ORBSingleton oRBSingleton = (ORBSingleton)this.orb;
                CDRInputStream cDRInputStream = (CDRInputStream)oRBSingleton.newInputStream(byArray, byArray.length);
                cDRInputStream.consumeEndian();
                cDRInputStream.setGIOPVersions((byte)1, (byte)2, pvMajor, (short)0, (short)0);
                AnyImpl anyImpl = (AnyImpl)cDRInputStream.read_any();
                cDRInputStream.close();
                this.typeCode = anyImpl.typeCode;
                this.complexValue = anyImpl.complexValue;
                this.primitiveValue = anyImpl.primitiveValue;
                this.stream = anyImpl.stream;
            }
        }
    }

    public TypeCode type() {
        return this.typeCode;
    }

    public void type(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        this.stream = null;
        this.primitiveValue = 0L;
        this.complexValue = null;
    }

    public boolean equal(Any any) {
        if (!this.typeCode.equal(any.type())) {
            return false;
        }
        switch (this.typeCode.kind().value()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == any.extract_short();
            }
            case 3: {
                return this.extract_long() == any.extract_long();
            }
            case 4: {
                return this.extract_ushort() == any.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == any.extract_ulong();
            }
            case 6: {
                return this.extract_float() == any.extract_float();
            }
            case 7: {
                return this.extract_double() == any.extract_double();
            }
            case 8: {
                return this.extract_boolean() == any.extract_boolean();
            }
            case 9: {
                return this.extract_char() == any.extract_char();
            }
            case 10: {
                return this.extract_octet() == any.extract_octet();
            }
            case 11: {
                return this.extract_any().equal(any.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(any.extract_TypeCode());
            }
            case 18: {
                return this.extract_string().equals(any.extract_string());
            }
            case 23: {
                return this.extract_longlong() == any.extract_longlong();
            }
            case 24: {
                return this.extract_ulonglong() == any.extract_ulonglong();
            }
            case 17: {
                return this.create_input_stream().read_long() == any.create_input_stream().read_long();
            }
            case 25: {
                throw new NO_IMPLEMENT("LONG_DOUBLE_NOT_IMPLEMENTED (1) - TCKind._tk_longdouble", 1229124490, CompletionStatus.COMPLETED_NO);
            }
            case 26: {
                return this.extract_wchar() == any.extract_wchar();
            }
            case 27: {
                return this.extract_wstring().equals(any.extract_wstring());
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 30: {
                return this.compareComplexTypes(this, any);
            }
        }
        return false;
    }

    private boolean compareComplexTypes(Any any, Any any2) {
        if (any == any2) {
            return true;
        }
        if (any == null && any2 != null || any != null && any2 == null || any == null && any2 == null) {
            return false;
        }
        boolean bl = true;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (!any.type().equivalent(any2.type())) {
            bl = false;
        }
        if (bl) {
            org.omg.CORBA.portable.OutputStream outputStream = this.orb.create_output_stream();
            org.omg.CORBA.portable.OutputStream outputStream2 = this.orb.create_output_stream();
            any.write_value(outputStream);
            any2.write_value(outputStream2);
            byArray = ((CDRWriter)outputStream).toByteArray();
            byArray2 = ((CDRWriter)outputStream2).toByteArray();
            if (byArray == null || byArray2 == null) {
                bl = false;
            }
        }
        if (bl && byArray.length != byArray2.length) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        this.lastOutputStream = (CDRWriter)this.orb.create_output_stream();
        return this.lastOutputStream;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.stream != null) {
            return (CDRInputStream)this.stream.dup();
        }
        OutputStream outputStream = (OutputStream)this.orb.create_output_stream();
        TCUtility.marshalIn((org.omg.CORBA.portable.OutputStream)outputStream, TCUtility.getRealTypeCode(this.typeCode).kind().value(), this.primitiveValue, this.complexValue);
        return outputStream.create_input_stream();
    }

    public void read_value(org.omg.CORBA.portable.InputStream inputStream, TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        int n = this.typeCode.kind().value();
        int n2 = TCUtility.getRealTypeCode(this.typeCode).kind().value();
        if (isStreamed[n2]) {
            if (inputStream instanceof CDRInputStream && ((CDRInputStream)inputStream).wasCreatedFrom(this.lastOutputStream)) {
                this.stream = (CDRInputStream)inputStream;
            } else {
                OutputStream outputStream = (OutputStream)this.orb.create_output_stream();
                this.typeCode.copy((InputStream)inputStream, outputStream);
                this.stream = (CDRInputStream)outputStream.create_input_stream();
            }
        } else {
            java.lang.Object[] objectArray = new java.lang.Object[]{this.complexValue};
            long[] lArray = new long[1];
            TCUtility.unmarshalIn(inputStream, n2, lArray, objectArray);
            this.primitiveValue = lArray[0];
            this.complexValue = objectArray[0];
            this.stream = null;
            try {
                int n3;
                if ((n == 18 || n == 27) && (n3 = this.typeCode.length()) != 0 && ((String)this.complexValue).length() > n3) {
                    throw new MARSHAL("erroneous bounded string - _tk_string | _tk_wstring", 1229125772, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (BadKind badKind) {
                Trc.ffdc(badKind, CLASS, "read_value:678");
                throw new MARSHAL("(org.omg.CORBA.TypeCodePackage.BadKind)", 1229125773, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public void write_value(org.omg.CORBA.portable.OutputStream outputStream) {
        if (this.stream != null) {
            this.typeCode.copy((CDRInputStream)this.stream.dup(), (OutputStream)outputStream);
        } else {
            TCUtility.marshalIn(outputStream, TCUtility.getRealTypeCode(this.typeCode).kind().value(), this.primitiveValue, this.complexValue);
        }
    }

    public void insert_Streamable(Streamable streamable) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, streamable._type());
        this.complexValue = streamable;
    }

    public void insert_short(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_short);
        this.primitiveValue = s;
    }

    public short extract_short() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_short))) {
            throw new BAD_OPERATION("extracting short", 1229123969, CompletionStatus.COMPLETED_NO);
        }
        return (short)this.primitiveValue;
    }

    public void insert_long(int n) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_long);
        this.primitiveValue = n;
    }

    public int extract_long() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_long))) {
            throw new BAD_OPERATION("extracting long", 1229123970, CompletionStatus.COMPLETED_NO);
        }
        return (int)this.primitiveValue;
    }

    public void insert_ushort(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort);
        this.primitiveValue = s;
    }

    public short extract_ushort() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort))) {
            throw new BAD_OPERATION("extracting ushort", 1229123971, CompletionStatus.COMPLETED_NO);
        }
        return (short)this.primitiveValue;
    }

    public void insert_ulong(int n) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong);
        this.primitiveValue = n;
    }

    public int extract_ulong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong))) {
            throw new BAD_OPERATION("extracting ulong", 1229123972, CompletionStatus.COMPLETED_NO);
        }
        return (int)this.primitiveValue;
    }

    public void insert_float(float f) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_float);
        this.primitiveValue = Float.floatToIntBits(f);
    }

    public float extract_float() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_float))) {
            throw new BAD_OPERATION("extracting float", 1229123973, CompletionStatus.COMPLETED_NO);
        }
        return Float.intBitsToFloat((int)this.primitiveValue);
    }

    public void insert_double(double d) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_double);
        this.primitiveValue = Double.doubleToLongBits(d);
    }

    public double extract_double() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_double))) {
            throw new BAD_OPERATION("extracting double", 1229123974, CompletionStatus.COMPLETED_NO);
        }
        return Double.longBitsToDouble(this.primitiveValue);
    }

    public void insert_longlong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong);
        this.primitiveValue = l;
    }

    public long extract_longlong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong))) {
            throw new BAD_OPERATION("extracting longlong", 1229123975, CompletionStatus.COMPLETED_NO);
        }
        return this.primitiveValue;
    }

    public void insert_ulonglong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong);
        this.primitiveValue = l;
    }

    public long extract_ulonglong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong))) {
            throw new BAD_OPERATION("extracting ulonglong", 1229123976, CompletionStatus.COMPLETED_NO);
        }
        return this.primitiveValue;
    }

    public void insert_boolean(boolean bl) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean);
        this.primitiveValue = bl ? 1L : 0L;
    }

    public boolean extract_boolean() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean))) {
            throw new BAD_OPERATION("extracting boolean", 1229123977, CompletionStatus.COMPLETED_NO);
        }
        return this.primitiveValue != 0L;
    }

    public void insert_char(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_char);
        this.primitiveValue = c;
    }

    public char extract_char() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_char))) {
            throw new BAD_OPERATION("extracting char", 1229123978, CompletionStatus.COMPLETED_NO);
        }
        return (char)this.primitiveValue;
    }

    public void insert_wchar(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_wchar);
        this.primitiveValue = c;
    }

    public char extract_wchar() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_wchar))) {
            throw new BAD_OPERATION("extracting wchar", 1229123980, CompletionStatus.COMPLETED_NO);
        }
        return (char)this.primitiveValue;
    }

    public void insert_octet(byte by) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_octet);
        this.primitiveValue = by;
    }

    public byte extract_octet() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_octet))) {
            throw new BAD_OPERATION("extracting octet", 1229123979, CompletionStatus.COMPLETED_NO);
        }
        return (byte)this.primitiveValue;
    }

    public void insert_string(String string) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_string);
        this.complexValue = string;
    }

    public String extract_string() {
        if (this.typeCode.kind() != TCKind.tk_string) {
            throw new BAD_OPERATION("extracting string", 1229123981, CompletionStatus.COMPLETED_NO);
        }
        return (String)this.complexValue;
    }

    public void insert_wstring(String string) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_wstring);
        this.complexValue = string;
    }

    public String extract_wstring() {
        if (this.typeCode.kind() != TCKind.tk_wstring) {
            throw new BAD_OPERATION("extracting wstring", 1229123982, CompletionStatus.COMPLETED_NO);
        }
        return (String)this.complexValue;
    }

    public void insert_any(Any any) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_any);
        this.complexValue = any;
        this.stream = null;
    }

    public Any extract_any() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_any))) {
            throw new BAD_OPERATION("extracting any", 1229123983, CompletionStatus.COMPLETED_NO);
        }
        return (Any)this.complexValue;
    }

    public void insert_Object(Object object) {
        if (object != null && object instanceof LocalObject) {
            throw new BAD_PARAM("LocalObjects cannot be passed to insert_Object", 1229124138, CompletionStatus.COMPLETED_NO);
        }
        if (object == null) {
            this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_objref);
        } else {
            TypeCode typeCode = ValueUtility.getTypeCode(this.orb, object);
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        }
        this.complexValue = object;
    }

    public void insert_Object(Object object, TypeCode typeCode) {
        if (object != null && object instanceof LocalObject) {
            throw new BAD_PARAM("LocalObjects cannot be passed to insert_Object", 1229124138, CompletionStatus.COMPLETED_NO);
        }
        try {
            if (!typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") && !object._is_a(typeCode.id())) {
                throw new BAD_OPERATION("inserting Object (1)", 1229123984, CompletionStatus.COMPLETED_NO);
            }
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
            this.complexValue = object;
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "insert_Object:1098");
            throw new BAD_OPERATION("inserting Object (2)", 1229123985, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object extract_Object() {
        Object object = null;
        try {
            object = (Object)this.complexValue;
            if (this.typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") || object._is_a(this.typeCode.id())) {
                return object;
            }
            throw new BAD_OPERATION("extracting Object (1)", 1229123986, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "extract_Object:1124");
            throw new BAD_OPERATION("extracting Object (2)", 1229123987, CompletionStatus.COMPLETED_NO);
        }
    }

    public void insert_TypeCode(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode);
        this.complexValue = typeCode;
    }

    public TypeCode extract_TypeCode() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode))) {
            throw new BAD_OPERATION("extracting TypeCode", 1229123988, CompletionStatus.COMPLETED_NO);
        }
        return (TypeCode)this.complexValue;
    }

    public void insert_Principal(Principal principal) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal);
        this.complexValue = principal;
    }

    public Principal extract_Principal() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal))) {
            throw new BAD_OPERATION("extracting Principal", 1229123989, CompletionStatus.COMPLETED_NO);
        }
        return (Principal)this.complexValue;
    }

    public Serializable extract_Value() throws BAD_OPERATION {
        int n = TCUtility.getRealTypeCode(this.typeCode).kind().value();
        if (n != 29 && n != 30 && n != 32) {
            throw new BAD_OPERATION("extracting Value (1)", 1229123990, CompletionStatus.COMPLETED_NO);
        }
        if (n == 32 && this.complexValue instanceof Object) {
            throw new BAD_OPERATION("extracting Value (2)", 1229123990, CompletionStatus.COMPLETED_NO);
        }
        return (Serializable)this.complexValue;
    }

    public void insert_Value(Serializable serializable) {
        this.complexValue = serializable;
        if (serializable == null) {
            this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_value);
        } else {
            TypeCode typeCode = ValueUtility.getTypeCode(this.orb, serializable);
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        }
    }

    public void insert_Value(Serializable serializable, TypeCode typeCode) throws MARSHAL {
        this.complexValue = serializable;
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
    }
}

