/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.CORBA.iiop.ExtendedServerDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.iiop.ServerDelegate;
import com.ibm.CORBA.iiop.ServerSubcontract;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.corba.INSRegistry;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class SubcontractRegistry
implements com.ibm.CORBA.iiop.SubcontractRegistry {
    public static final String[] default_serverClassNames = new String[]{"com.ibm.CORBA.iiop.ServerDelegate", "com.ibm.CORBA.iiop.ExtendedServerDelegate", "com.ibm.CORBA.poa.POAServerDelegate", "com.ibm.CORBA.poa.POAServerDelegate"};
    public static final int[] default_scIds = new int[]{16, 18, 21, 22};
    protected ServerSubcontract[] serverRegistry;
    protected int[] scIds;
    protected ServerSubcontract bootstrapServer = null;
    private INSRegistry insRegistry = null;
    private Map subcontractCache = Collections.synchronizedMap(new WeakHashMap());
    protected ORB orb;
    protected boolean closed = false;
    private static final String CLASS = SubcontractRegistry.class.getName();

    public SubcontractRegistry(ORB oRB) {
        this.orb = oRB;
        this.initialize();
    }

    protected void initialize() {
        int n = default_scIds.length;
        this.scIds = new int[n];
        System.arraycopy(default_scIds, 0, this.scIds, 0, n);
        this.serverRegistry = new ServerSubcontract[n];
    }

    @Override
    public void registerDefaultSubcontracts() {
        for (int i = 0; i < this.serverRegistry.length; ++i) {
            if (this.serverRegistry[i] != null) continue;
            this.registerServerSubcontract(default_serverClassNames[i], i, default_scIds[i]);
        }
        this.closed = true;
    }

    @Override
    public synchronized boolean registerServerSubcontract(String string, int n, int n2) {
        try {
            if (this.closed) {
                throw new Exception("registration period is closed - this method should only be called by a SubcontractInit plugin during ORB init processing");
            }
            this.validate(n, n2);
            Class clazz = Util.loadClass((String)string, null, null);
            ServerSubcontract serverSubcontract = (ServerSubcontract)clazz.newInstance();
            serverSubcontract.setOrb(this.orb);
            serverSubcontract.setId(n2);
            this.scIds[n] = n2;
            this.serverRegistry[n] = serverSubcontract;
        }
        catch (Exception exception) {
            Trc.ffdc("failed to register server subcontract: " + string + " subcontract type: " + n + " subcontract id: " + n2 + exception, CLASS, "registerServerSubcontract:157");
            return false;
        }
        return true;
    }

    private void validate(int n, int n2) {
        if (n < 0 || n > default_scIds.length - 1) {
            throw new IllegalArgumentException("Invalid subcontract type: " + n);
        }
        if (this.serverRegistry[n] != null) {
            throw new IllegalArgumentException("A server subcontract is already registered for subcontract type: " + n);
        }
        for (int i = 0; i < default_scIds.length; ++i) {
            if (i == n || default_scIds[i] != n2) continue;
            throw new IllegalArgumentException("Subcontract id: " + n2 + " is already registered for subcontract type: " + i);
        }
    }

    @Override
    public boolean registerClient(Class clazz, int n) {
        return true;
    }

    @Override
    public boolean registerServer(ServerSubcontract serverSubcontract, int n) {
        int n2;
        if (serverSubcontract instanceof ExtendedServerDelegate) {
            n2 = 1;
        } else if (serverSubcontract instanceof ServerDelegate) {
            n2 = 0;
        } else {
            if (Trc.enabled(1) || Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "subcontract type cannot be inferred from the server subcontract - use orb.registerServerSubcontract ", serverSubcontract, CLASS, "registerServer:207");
            }
            return false;
        }
        return this.registerServerSubcontract(serverSubcontract.getClass().getName(), n2, n);
    }

    @Override
    public void registerBootstrapServer(ServerSubcontract serverSubcontract) {
        this.bootstrapServer = serverSubcontract;
    }

    public void setINSRegistry(INSRegistry iNSRegistry) {
        this.insRegistry = iNSRegistry;
    }

    @Override
    public ServerSubcontract getServerSubcontract(int n) {
        ServerSubcontract serverSubcontract = null;
        if (n >= 0 && n < this.serverRegistry.length) {
            serverSubcontract = this.serverRegistry[n];
        }
        if (serverSubcontract == null) {
            throw new INTERNAL("Unknown subcontract type:" + n, 1229125022, CompletionStatus.COMPLETED_NO);
        }
        return serverSubcontract;
    }

    private ServerSubcontract getServerSubcontractForId(int n) {
        Object var2_2 = null;
        for (int i = 0; i < this.scIds.length; ++i) {
            if (this.scIds[i] != n) continue;
            return this.getServerSubcontract(i);
        }
        throw new INTERNAL("Unknown subcontract id:" + n, 1229125018, CompletionStatus.COMPLETED_NO);
    }

    @Override
    public ServerSubcontract getServerSubcontract(ObjectKey objectKey) {
        ServerSubcontract serverSubcontract = null;
        if (objectKey.isSINO()) {
            return this.bootstrapServer;
        }
        try {
            if (objectKey.isMBI()) {
                int n = objectKey.getSCID();
                serverSubcontract = this.getServerSubcontractForId(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serverSubcontract == null && this.insRegistry != null) {
            serverSubcontract = this.insRegistry.getSubcontract(objectKey.getBytes());
        }
        return serverSubcontract;
    }

    private ClientSubcontract findClientSubcontract(IOR iOR, Class clazz) {
        int n = this.scIds[0];
        ClientSubcontract clientSubcontract = null;
        try {
            if (clazz == null) {
                clazz = this.getServerSubcontract(0).getClientSubcontractClass();
            }
            clientSubcontract = (ClientSubcontract)((Object)clazz.newInstance());
            clientSubcontract.unmarshal(iOR);
            clientSubcontract.setOrb(this.orb);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "findClientSubcontract:308");
            throw new INTERNAL("Unable to create ClientSubcontract for scid:" + n, 1229125021, CompletionStatus.COMPLETED_NO);
        }
        return clientSubcontract;
    }

    public ClientSubcontract getClientSubcontract(IOR iOR) {
        Class clazz = null;
        ClientSubcontract clientSubcontract = null;
        Profile profile = iOR.getProfile();
        ObjectKey objectKey = profile.getObjectKeyObject();
        boolean bl = objectKey.isMBI();
        if (!bl) {
            clientSubcontract = this.findClientSubcontract(iOR, clazz);
        } else {
            WeakReference weakReference = (WeakReference)this.subcontractCache.get(profile);
            if (weakReference != null) {
                clientSubcontract = (ClientSubcontract)((Object)weakReference.get());
            }
            if (clientSubcontract == null) {
                try {
                    int n = objectKey.getSCID();
                    ServerSubcontract serverSubcontract = this.getServerSubcontractForId(n);
                    clazz = serverSubcontract.getClientSubcontractClass();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                clientSubcontract = this.findClientSubcontract(iOR, clazz);
                this.subcontractCache.put(profile, new WeakReference<ClientSubcontract>(clientSubcontract));
            }
        }
        return clientSubcontract;
    }
}

