/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class SharingTokensMacroResolver
extends MacroResolver {
    private static final Pattern PATTERN_SHARINGTOKENS_ATTRIBUTE = Pattern.compile("^(.+?),(.+?)$");
    private static final String S_SHARINGTOKENS_ATTRIBUTE_MACRO_ID = "NIFSHARINGTOKENS";
    private static final String className = "SharingTokensMacroResolver";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_SHARINGTOKENS_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        Matcher matcherNIFPAttribute = PATTERN_SHARINGTOKENS_ATTRIBUTE.matcher(sMacroText);
        if (!matcherNIFPAttribute.matches()) {
            return MacroResolver.getUnresolvedMacro(S_SHARINGTOKENS_ATTRIBUTE_MACRO_ID, sMacroText);
        }
        String s1 = matcherNIFPAttribute.group(1).trim();
        String s2 = matcherNIFPAttribute.group(2).trim();
        boolean fSharing = StringUtils.doesTheseStringsShareTokens(s1, s2, ";");
        Logr.methodReturn(className, "resolveMacro", new Boolean(fSharing).toString());
        return new Boolean(fSharing).toString();
    }
}

