/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.macroresolvers;

import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.macroresolvers.MacroResolver;
import org.w3c.dom.Document;

public class FormatStringToHTMLBullet
extends MacroResolver {
    private static final String S_PAKDEPENTVERSIONS_ATTRIBUTE_MACRO_ID = "NIFFORMATSTRINGTOHTMLBULLET";
    private static final String S_EMPTY = "";
    private static final String S_HTML_UL_OPEN = "<UL>";
    private static final String S_HTML_UL_CLOSE = "</UL>";
    private static final String S_HTML_LI_OPEN = "<LI>";
    private static final String S_HTML_LI_CLOSE = "</LI>";
    private static final String className = "FormatStringToHTMLBullet";

    @Override
    protected boolean isMacroIDAcceptable(String sMacroID) {
        return S_PAKDEPENTVERSIONS_ATTRIBUTE_MACRO_ID.equals(sMacroID);
    }

    @Override
    protected String resolveMacro(String sMacroID, String sMacroText, Document documentPluginDefinitions) {
        Logr.methodEntry(className, "resolveMacro");
        String sTokenString = sMacroText;
        String[] asTokenString = StringUtils.convertStringToTokenArray(sTokenString, ";");
        if (asTokenString == null || asTokenString.length == 0) {
            return S_EMPTY;
        }
        String s = this.formatStringTokensInHTMLBullet(asTokenString);
        Logr.methodReturn(className, "resolveMacro", s);
        return s;
    }

    private String formatStringTokensInHTMLBullet(String[] asTokenString) {
        String sStringInHTMLBullet = S_EMPTY;
        sStringInHTMLBullet = String.valueOf(sStringInHTMLBullet) + S_HTML_UL_OPEN;
        String[] stringArray = asTokenString;
        int n = asTokenString.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            sStringInHTMLBullet = String.valueOf(sStringInHTMLBullet) + S_HTML_LI_OPEN;
            sStringInHTMLBullet = String.valueOf(sStringInHTMLBullet) + element.toString();
            sStringInHTMLBullet = String.valueOf(sStringInHTMLBullet) + S_HTML_LI_CLOSE;
            ++n2;
        }
        sStringInHTMLBullet = String.valueOf(sStringInHTMLBullet) + S_HTML_UL_CLOSE;
        return sStringInHTMLBullet;
    }
}

