/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.filesystems;

import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemNotSupportedException;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class FileSystemEntry {
    private FileSystem m_fsParent = null;
    private URI m_uriPath = null;
    private final String className = "FileSystemEntry";

    public long getSize() throws IOException {
        return this.m_fsParent.getSize(this.m_uriPath);
    }

    public void touch() throws IOException {
        this.m_fsParent.touch(this.m_uriPath);
    }

    public void setLastModifiedTime(long lTime) throws IOException {
        this.m_fsParent.setLastModifiedTime(this.m_uriPath, lTime);
    }

    public FileSystemEntry(URI uriPath, InstallToolkitBridge itb) throws IOException {
        try {
            this.m_fsParent = FileSystem.getFileSystem(uriPath, itb);
            this.m_uriPath = uriPath;
        }
        catch (ParserConfigurationException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (InstantiationException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (FileSystemNotSupportedException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    public FileSystemEntry(URI uriPathParent, String sEntryPath, InstallToolkitBridge itb) throws IOException {
        try {
            URI uriPath = FileSystem.getFileSystem(uriPathParent, itb).getFSURI(uriPathParent, sEntryPath);
            this.m_fsParent = FileSystem.getFileSystem(uriPath, itb);
            this.m_uriPath = uriPath;
        }
        catch (ParserConfigurationException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (InstantiationException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (FileSystemNotSupportedException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (URISyntaxException e) {
            Logr.warn("FileSystemEntry", "FileSystemEntry", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    public void setPermissions(int nPermissions) throws IOException {
        this.m_fsParent.setPermissions(this.m_uriPath, nPermissions);
    }

    public void setPermissions(String sPermissions) throws IOException {
        try {
            this.setPermissions(Integer.parseInt(sPermissions));
        }
        catch (NumberFormatException e) {
            Logr.warn("FileSystemEntry", "setPermissions", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    public int getPermissions() throws IOException {
        return this.m_fsParent.getPermissions(this.m_uriPath);
    }

    public void writeUTF8(String sMessage, boolean fAppend) throws IOException {
        this.m_fsParent.writeUTF8Entry(this.m_uriPath, sMessage, fAppend);
    }

    public InputStream getInputStream() throws IOException {
        return this.m_fsParent.readEntry(this.m_uriPath);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.m_fsParent.writeEntry(this.m_uriPath);
    }

    public OutputStream getOutputStream(boolean fAppend) throws IOException {
        return this.m_fsParent.writeEntry(this.m_uriPath, fAppend);
    }

    public String getContents() throws IOException {
        return this.m_fsParent.getContents(this.m_uriPath);
    }

    public String getUTF8Contents() throws IOException {
        return this.m_fsParent.getUTF8Contents(this.m_uriPath);
    }

    public void delete() throws IOException {
        this.m_fsParent.deleteEntry(this.m_uriPath);
    }

    public void deleteThisDirectoryRecursively() throws IOException {
        this.m_fsParent.deleteThisDirectoryRecursively(this.m_uriPath);
    }

    public void deleteOnExit() throws IOException {
        this.m_fsParent.deleteEntryOnExit(this.m_uriPath);
    }

    public void copyTo(FileSystemEntry fseTo) throws IOException {
        this.m_fsParent.copyTo(this.m_uriPath, fseTo.m_uriPath);
    }

    public void moveTo(FileSystemEntry fsePathTo) throws IOException {
        this.m_fsParent.moveTo(this.m_uriPath, fsePathTo.getURI());
    }

    public void linkTo(String sPathToLinkTo) throws IOException {
        this.m_fsParent.createSymbolicLink(this.m_uriPath, sPathToLinkTo);
    }

    public URI getURI() {
        return this.m_uriPath;
    }

    public boolean exists() {
        return this.m_fsParent.exists(this.m_uriPath);
    }

    public boolean isDirectory() {
        return this.m_fsParent.isDirectory(this.m_uriPath);
    }

    public void mkdirs() throws IOException {
        this.m_fsParent.mkdirs(this.m_uriPath);
    }

    public FileSystemEntry getParent() throws IOException {
        return new FileSystemEntry(this.m_fsParent.getParent(this.m_uriPath), this.m_fsParent.getInstallToolkitBridge());
    }

    public FileSystemEntry getParentDirOrFSRoot() throws IOException {
        return new FileSystemEntry(this.m_fsParent.getParentDirOrFSRoot(this.m_uriPath), this.m_fsParent.getInstallToolkitBridge());
    }

    public String getEntryName() throws IOException {
        return this.m_fsParent.getEntryName(this.m_uriPath);
    }

    public long getLastModified() {
        try {
            return this.m_fsParent.getLastModified(this.m_uriPath);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public String getCanonicalPath() throws IOException {
        return this.m_fsParent.getCanonicalPath(this.m_uriPath);
    }

    public String getAbsolutePath() throws IOException {
        return this.m_fsParent.getAbsolutePath(this.m_uriPath);
    }

    public String getAbsolutePathWithFlagment() throws IOException {
        return this.m_fsParent.getAbsolutePathWithFlagment(this.m_uriPath);
    }

    public void renameTo(FileSystemEntry fsePathTo) throws IOException {
        this.m_fsParent.renameTo(this.m_uriPath, fsePathTo.getURI());
    }

    public FileSystemEntry[] getDirectoryEntries() {
        try {
            URI[] auriEntries = this.m_fsParent.getDirectoryEntries(this.m_uriPath);
            FileSystemEntry[] afseReturn = new FileSystemEntry[auriEntries.length];
            int i = 0;
            while (i < auriEntries.length) {
                afseReturn[i] = new FileSystemEntry(auriEntries[i], this.m_fsParent.getInstallToolkitBridge());
                ++i;
            }
            return afseReturn;
        }
        catch (IOException iOException) {
            return new FileSystemEntry[0];
        }
    }

    public FileSystemEntry[] getEntriesDirectlyUnderThisDir() {
        try {
            URI[] auriEntries = this.m_fsParent.getEntriesDirectlyUnderThisDir(this.m_uriPath);
            FileSystemEntry[] afseReturn = new FileSystemEntry[auriEntries.length];
            int i = 0;
            while (i < auriEntries.length) {
                afseReturn[i] = new FileSystemEntry(auriEntries[i], this.m_fsParent.getInstallToolkitBridge());
                ++i;
            }
            return afseReturn;
        }
        catch (IOException iOException) {
            return new FileSystemEntry[0];
        }
    }

    public String getChecksum() throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        return this.m_fsParent.getChecksum(this.getInputStream());
    }

    public boolean equals(Object o) {
        FileSystemEntry fseIn;
        return o instanceof FileSystemEntry && (fseIn = (FileSystemEntry)o).getURI().equals(this.getURI());
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public String toString() {
        return this.getURI().toString();
    }

    public void flush() throws IOException {
        this.m_fsParent.flushFileSystemFor(this.m_uriPath);
    }

    public void setHidden() {
        this.m_fsParent.setHidden(this.m_uriPath);
    }

    public boolean readable() {
        return this.m_fsParent.isReadable(this.m_uriPath);
    }

    public boolean writeable() {
        return this.m_fsParent.isWriteable(this.m_uriPath);
    }
}

