/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.fileactions.ReplaceFileActionPlugin;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.util.Hashtable;

public class ReplaceSymLinkFileActionPlugin
extends ReplaceFileActionPlugin {
    public static final String S_SYMBOLIC_LINK_KEY = "symbolic-link";
    private static final String S_FILE_ACTION_ID = "replacesymlink";
    private static final String S_INVERSE_FILE_ACTION_ID = "replacesymlink";
    private static final String S_REMOVE_SYMLINK_ACTION_ID = "removesymlink";
    private static final String S_INVALID_CALL_ERROR = "This function should never have been called on this class.";
    private static final String className = "ReplaceSymLinkFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        FileSystemEntry fseTo = this.getCurrentFileSystemEntry(hashtableFileDetails);
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            if (this.doesCurrentFileExist(hashtableFileDetails) && !this.isCurrentFileASymbolicLink(hashtableFileDetails)) {
                super.execute(hashtableFileDetails);
            }
            if (FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseTo);
            }
            return;
        }
        String sLinkTarget = hashtableFileDetails.get(S_SYMBOLIC_LINK_KEY).toString();
        try {
            Logr.debug("ReplaceSymLinkFileAction - fseTo :" + fseTo.getAbsolutePath() + " sLinkTarget: " + sLinkTarget);
            fseTo.linkTo(sLinkTarget);
        }
        catch (IOException e) {
            Logr.warn(className, "execute", e.getMessage(), e);
            throw new NIFFileActionIOException(e.getMessage(), this.getIOExceptionMessage(fseTo.getURI().getPath(), sLinkTarget), fseTo.getURI().getPath());
        }
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        Logr.methodEntry(className, "isThisFileActionAcceptable");
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return "replacesymlink".equals(sFileActionID);
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) throws IOException {
        throw new IOException(S_INVALID_CALL_ERROR);
    }

    @Override
    protected Hashtable getInverseFileAction(Hashtable hashtableFileDetails) throws IOException {
        Hashtable<String, String> hashtableReturn = new Hashtable<String, String>(hashtableFileDetails);
        hashtableReturn.remove("installoperation");
        if (!this.doesCurrentFileExist(hashtableFileDetails)) {
            hashtableReturn.put("installoperation", S_REMOVE_SYMLINK_ACTION_ID);
            return hashtableReturn;
        }
        if (!this.isCurrentFileASymbolicLink(hashtableFileDetails)) {
            hashtableReturn.put("installoperation", super.getInverseFileActionID(hashtableFileDetails));
            return hashtableReturn;
        }
        hashtableReturn.put("installoperation", "replacesymlink");
        hashtableReturn.put(S_SYMBOLIC_LINK_KEY, this.getSymbolicLinkTarget(hashtableFileDetails));
        return hashtableReturn;
    }

    private String getSymbolicLinkTarget(Hashtable hashtableFileDetails) throws IOException {
        try {
            URI uri = this.getCurrentFileSystemEntry(hashtableFileDetails).getURI();
            String symbolicLinkTarget = FileSystem.getFileSystem(uri, this.getInstallToolkitBridge()).getSymbolicLinkTarget(uri);
            Logr.methodReturn(className, "getSymbolicLinkTarget", symbolicLinkTarget);
            return symbolicLinkTarget;
        }
        catch (Exception e) {
            Logr.warn(className, "getSymbolicLinkTarget", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    private boolean isCurrentFileASymbolicLink(Hashtable hashtableFileDetails) throws IOException {
        try {
            if (this.doesCurrentFileExist(hashtableFileDetails)) {
                URI uri = this.getCurrentFileSystemEntry(hashtableFileDetails).getURI();
                boolean isSymbolicLink = FileSystem.getFileSystem(uri, this.getInstallToolkitBridge()).isSymbolicLink(uri);
                return isSymbolicLink;
            }
        }
        catch (Exception e) {
            Logr.warn(className, "isCurrentFileASymbolicLink(Hashtable)", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        return false;
    }

    private boolean doesCurrentFileExist(Hashtable hashtableFileDetails) throws IOException {
        boolean currentFileSystemEntryExists = this.getCurrentFileSystemEntry(hashtableFileDetails).exists();
        return currentFileSystemEntryExists;
    }

    private String getIOExceptionMessage(String sLinkFrom, String sLinkTo) {
        return PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_REPLACESYMLINKFILEACTION_IOEXCEPTIONDESCRIPTION, (Object[])new Object[]{sLinkFrom, sLinkTo});
    }
}

