/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.fileactions;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.fileactions.NIFFileActionIOException;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.util.Hashtable;

public class RemoveFileActionPlugin
extends FileActionPlugin {
    private static final String S_FILE_ACTION_ID = "remove";
    private static final String S_INVERSE_FILE_ACTION_ID = "add";
    private static final String S_FILE_ACTION_REM_SYMLINK_ID = "removesymlink";
    private static final String className = "RemoveFileActionPlugin";

    @Override
    public void execute(Hashtable hashtableFileDetails) throws IOException {
        if (!this.doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(hashtableFileDetails) && !RemoveFileActionPlugin.getFileActionID(hashtableFileDetails).equals(S_FILE_ACTION_REM_SYMLINK_ID)) {
            Logr.debug("File doesn't exist; nop.");
            return;
        }
        if (FileActionPlugin.isBackupFlagActive(hashtableFileDetails)) {
            FileSystemEntry fseInstallLocationPath = (FileSystemEntry)hashtableFileDetails.get("installlocation");
            FileSystemEntry fseBackupRepositoryPath = (FileSystemEntry)hashtableFileDetails.get("backuprepository");
            String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
            FileSystemEntry fseFrom = new FileSystemEntry(fseInstallLocationPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
            FileSystemEntry fseTo = new FileSystemEntry(fseBackupRepositoryPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
            if (FileActionPlugin.isCheckPermissionsNeeded(hashtableFileDetails)) {
                FileActionPlugin.checkWritePermissions(fseFrom);
            }
            try {
                Logr.debug("RemoveFileAction - fseFrom :" + fseFrom.getAbsolutePath() + " fseTo :" + fseTo.getAbsolutePath());
                fseFrom.copyTo(fseTo);
            }
            catch (IOException e) {
                Logr.warn(className, "execute", e.getMessage(), e);
                throw new NIFFileActionIOException(e, fseFrom.getURI().getPath());
            }
        }
        FileSystemEntry fseInstallLocationPath = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
        FileSystemEntry fseTo = new FileSystemEntry(fseInstallLocationPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
        try {
            fseTo.delete();
        }
        catch (IOException e) {
            Logr.warn(className, "execute", e.getMessage(), e);
            boolean callDeleteOnExit = new Boolean(System.getProperty("deleteOnExit"));
            if (callDeleteOnExit) {
                fseTo.deleteOnExit();
            }
            throw new NIFFileActionIOException(e.getMessage(), this.getIOExceptionDescription(fseTo.getURI().getPath()), fseTo.getURI().getPath());
        }
    }

    @Override
    protected boolean isThisFileActionAcceptable(Hashtable hashtableFileDetails) {
        String sFileActionID = FileActionPlugin.getFileActionID(hashtableFileDetails);
        return S_FILE_ACTION_ID.equals(sFileActionID);
    }

    @Override
    protected String getInverseFileActionID(Hashtable hashtableFileDetails) {
        if (!this.doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(hashtableFileDetails)) {
            return "nop";
        }
        return S_INVERSE_FILE_ACTION_ID;
    }

    private boolean doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(Hashtable hashtableFileDetails) {
        FileSystemEntry fseInstallRoot = (FileSystemEntry)hashtableFileDetails.get("installlocation");
        String sRelativePath = hashtableFileDetails.get("relativepath").toString();
        try {
            FileSystemEntry fseCheck = new FileSystemEntry(fseInstallRoot.getURI(), sRelativePath, this.getInstallToolkitBridge());
            return fseCheck.exists();
        }
        catch (IOException e) {
            Logr.warn(className, "doesTheFileToBeOperatedUponAlreadyExistInInstallRoot", e.getMessage(), e);
            return false;
        }
    }

    private String getIOExceptionDescription(String sPathOfTheFileToBeRemoved) {
        return PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_REMOVEFILEACTIONPLUGIN_IOEXCEPTIONDESCRIPTION, (Object)sPathOfTheFileToBeRemoved);
    }
}

