/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.events;

import com.ibm.ws.pak.internal.utils.events.NIFEvent;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import java.util.Hashtable;

public class FileModifiedEvent
extends NIFEvent {
    private final Hashtable m_hashtableEventProperties = new Hashtable();

    public FileModifiedEvent(FileSystemEntry fsePath, long lCurrentSize) {
        this.m_hashtableEventProperties.put("fsePath", fsePath);
        this.m_hashtableEventProperties.put("currentSize", new Long(lCurrentSize));
    }

    @Override
    public int getEventType() {
        return 6;
    }

    @Override
    public Hashtable getEventProperties() {
        return this.m_hashtableEventProperties;
    }

    @Override
    public Object getEventProperty(Object oPropertyKey) {
        return this.m_hashtableEventProperties.get(oPropertyKey);
    }

    public FileSystemEntry getSpecifiedFileSystemEntry() {
        FileSystemEntry fse = (FileSystemEntry)this.getEventProperty("fsePath");
        return fse;
    }

    public long getCurrentSize() {
        Long currentSize = (Long)this.getEventProperty("currentSize");
        return currentSize;
    }

    public void setCurrentSize(long lCurrentSize) {
        this.m_hashtableEventProperties.put("currentSize", new Long(lCurrentSize));
    }
}

