/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.componentactions.ChecksumUpdater;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentActionParams;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentFileActions;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentizedRepositoryConstants;
import com.ibm.ws.pak.internal.utils.fileactions.FileActionPlugin;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FilesListParser {
    private ComponentActionParams m_caps = null;

    public FilesListParser(ComponentActionParams caps) {
        this.m_caps = caps;
    }

    public ComponentFileActions getComponentFileActionsForThisComponent() throws IOException {
        String sFileListFileContentsForThisComponent = this.getContentsOfTheFilesListFileForThisComponent();
        Vector vhashtablesFileDetails = this.convertFilesListToFileDetailsHashtables(sFileListFileContentsForThisComponent);
        ComponentFileActions cfaThisComponent = new ComponentFileActions(this.m_caps.getInstallToolkitBridge());
        int i = 0;
        while (i < vhashtablesFileDetails.size()) {
            Hashtable hashtableFileDetailsThis = (Hashtable)vhashtablesFileDetails.elementAt(i);
            Hashtable hashtableFileDetailsForComponentActionThisPass1 = this.augmentFileDetailsWithRepositoryLocations(hashtableFileDetailsThis);
            Hashtable hashtableFileDetailsForComponentActionThisPass2 = this.augmentFileDetailsWithBackupFlagAndCheckPermissionsFlag(hashtableFileDetailsForComponentActionThisPass1, this.m_caps.isBackupMode(), this.m_caps.isCheckPermissionsNeeded());
            cfaThisComponent.addFileAction(hashtableFileDetailsForComponentActionThisPass2);
            ++i;
        }
        return cfaThisComponent;
    }

    public FileSystemEntry getInverseFilesListFileForThisComponent() throws IOException {
        return new FileSystemEntry(this.m_caps.getBackupRepositoryPath().getURI(), String.valueOf(this.m_caps.getComponentName()) + "/" + "files.list", this.m_caps.getInstallToolkitBridge());
    }

    public String getInverseFilesListForThisComponent() throws IOException {
        String sFilesListFileContentsForThisComponent = this.getContentsOfTheFilesListFileForThisComponent();
        Vector vhashtablesFileDetails = this.convertFilesListToFileDetailsHashtables(sFilesListFileContentsForThisComponent);
        String sV6FullUninstallFilesListFileContentsForThisComponent = this.getCurrentV6FullUninstallFilesListForThisComponent();
        Vector vhashtablesV6FullUninstallFilesListForThisComponent = this.convertFilesListToFileDetailsHashtables(sV6FullUninstallFilesListFileContentsForThisComponent);
        Vector<Hashtable> vhashtablesInverseFilesList = new Vector<Hashtable>(vhashtablesFileDetails.size());
        int i = 0;
        while (i < vhashtablesFileDetails.size()) {
            Hashtable hashtableFileDetails = (Hashtable)vhashtablesFileDetails.elementAt(i);
            Hashtable hashtableAugmentedFileDetailsPass1 = this.augmentFileDetailsWithRepositoryLocations(hashtableFileDetails);
            Hashtable hashtableAugmentedFileDetailsPass2 = this.augmentFileDetailsWithBackupFlagAndCheckPermissionsFlag(hashtableAugmentedFileDetailsPass1, this.m_caps.isBackupMode(), this.m_caps.isCheckPermissionsNeeded());
            Hashtable hashtableAugmentedInverseFileDetails = this.getInverseFileActionDetails(hashtableAugmentedFileDetailsPass2, vhashtablesV6FullUninstallFilesListForThisComponent);
            Hashtable hashtableInverseFileDetailsPass1 = this.unaugmentFileDetailsWithRepositoryLocations(hashtableAugmentedInverseFileDetails);
            Hashtable hashtableInverseFileDetailsPass2 = this.unaugmentFileDetailsWithBackupFlagAndCheckPermissionsFlag(hashtableInverseFileDetailsPass1);
            vhashtablesInverseFilesList.add(hashtableInverseFileDetailsPass2);
            ++i;
        }
        return this.convertFilesListHashtableToFilesListFile(vhashtablesInverseFilesList);
    }

    public FileSystemEntry getV6FullUninstallFilesListFileForThisComponent() throws IOException {
        return new FileSystemEntry(this.m_caps.getProductBackupRepository().getURI(), String.valueOf(this.m_caps.getComponentName()) + "/" + "files.list", this.m_caps.getInstallToolkitBridge());
    }

    public String getV6FullUninstallInverseFilesListForThisComponent() throws IOException {
        return this.getV6FullUninstallInverseFilesListForThisComponent(false);
    }

    public String getV6FullUninstallInverseFilesListForThisComponent(boolean fInFailureRecoveryMode) throws IOException {
        String sFilesListFileContentsForThisComponent = this.getContentsOfTheFilesListFileForThisComponent();
        Vector vhashtablesFilesListForThisComponent = this.convertFilesListToFileDetailsHashtables(sFilesListFileContentsForThisComponent);
        String sV6FullUninstallFilesListFileContentsForThisComponent = this.getCurrentV6FullUninstallFilesListForThisComponent();
        Vector vhashtablesV6FullUninstallFilesListForThisComponent = this.convertFilesListToFileDetailsHashtables(sV6FullUninstallFilesListFileContentsForThisComponent);
        if (vhashtablesV6FullUninstallFilesListForThisComponent.size() == 0) {
            int i = 0;
            while (i < vhashtablesFilesListForThisComponent.size()) {
                Hashtable hashtableFileThis = (Hashtable)vhashtablesFilesListForThisComponent.elementAt(i);
                this.updateV6FullUninstallFilesListActionForThisFile(hashtableFileThis, vhashtablesV6FullUninstallFilesListForThisComponent);
                ++i;
            }
        } else {
            int i = 0;
            while (i < vhashtablesFilesListForThisComponent.size()) {
                Hashtable hashtableFileThis = (Hashtable)vhashtablesFilesListForThisComponent.elementAt(i);
                this.updateV6FullUninstallFilesListForThisFile(hashtableFileThis, vhashtablesV6FullUninstallFilesListForThisComponent);
                ++i;
            }
        }
        vhashtablesV6FullUninstallFilesListForThisComponent = this.updateChecksumForThisComponentV6FullUninstallInverseFilesList(vhashtablesFilesListForThisComponent, vhashtablesV6FullUninstallFilesListForThisComponent, fInFailureRecoveryMode);
        return this.convertFilesListHashtableToFilesListFile(vhashtablesV6FullUninstallFilesListForThisComponent);
    }

    private Vector updateChecksumForThisComponentV6FullUninstallInverseFilesList(Vector vhashtablesFilesListForThisComponent, Vector vhashtablesV6FullUninstallFilesListForThisComponent, boolean fInFailureRecoveryMode) throws IOException {
        ChecksumUpdater checksumUpdater = new ChecksumUpdater(this.m_caps.getProductInstallRoot(), vhashtablesV6FullUninstallFilesListForThisComponent, this.m_caps.getInstallToolkitBridge());
        int i = 0;
        while (i < vhashtablesFilesListForThisComponent.size()) {
            String sRelativePath;
            Hashtable hashtableFileThis = (Hashtable)vhashtablesFilesListForThisComponent.elementAt(i);
            if (FileActionPlugin.isChecksumUpdateRequired(hashtableFileThis, this.m_caps.getInstallToolkitBridge()) && ((sRelativePath = this.getRelativePathContainedInThisPath((String)hashtableFileThis.get("relativepath"), vhashtablesV6FullUninstallFilesListForThisComponent)) != null || !fInFailureRecoveryMode)) {
                if (sRelativePath == null) {
                    throw new IOException(PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_POSSIBLE_CORRUPTION_IN_COMPONENT_FILES_LIST, (Object[])new String[]{(String)hashtableFileThis.get("relativepath"), this.m_caps.getComponentName()}));
                }
                checksumUpdater.add(sRelativePath);
            }
            ++i;
        }
        vhashtablesV6FullUninstallFilesListForThisComponent = checksumUpdater.getChecksumUpdatedV6FullUninstallFilesList();
        return vhashtablesV6FullUninstallFilesListForThisComponent;
    }

    private String getRelativePathContainedInThisPath(String sPathThis, Vector vhashtablesV6FullUninstallFilesListForThisComponent) {
        int i = 0;
        while (i < vhashtablesV6FullUninstallFilesListForThisComponent.size()) {
            Hashtable hashtableFileThis = (Hashtable)vhashtablesV6FullUninstallFilesListForThisComponent.elementAt(i);
            String sRelativePathThis = (String)hashtableFileThis.get("relativepath");
            if (sPathThis.indexOf(sRelativePathThis) == 0) {
                return sRelativePathThis;
            }
            ++i;
        }
        return null;
    }

    private String getCurrentV6FullUninstallFilesListForThisComponent() throws IOException {
        FileSystemEntry fseV6FullUninstallFilesList = this.getV6FullUninstallFilesListFileForThisComponent();
        if (fseV6FullUninstallFilesList.exists()) {
            return fseV6FullUninstallFilesList.getUTF8Contents();
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<componentfiles componentname=\"" + this.m_caps.getComponentName() + "\"/>";
    }

    private String convertFilesListHashtableToFilesListFile(Vector vhashtablesFileDetails) throws IOException {
        try {
            Document nodeDocumentThis = SimpleXMLParser.createNewDocument();
            Hashtable<String, String> hashtableHeaderAttributes = new Hashtable<String, String>();
            hashtableHeaderAttributes.put("componentname", this.m_caps.getComponentName());
            Element nodeRoot = SimpleXMLParser.addNestedElement("componentfiles", null, hashtableHeaderAttributes, nodeDocumentThis);
            int i = 0;
            while (i < vhashtablesFileDetails.size()) {
                Element nodeFileThis = SimpleXMLParser.addNestedElement("file", null, null, nodeRoot);
                Hashtable hashtableFileDetailsThis = (Hashtable)vhashtablesFileDetails.elementAt(i);
                this.setFileNodeElementsFromFileDetails(nodeFileThis, hashtableFileDetailsThis);
                ++i;
            }
            return SimpleXMLParser.getNodeAsXML(nodeDocumentThis, true);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void updateV6FullUninstallFilesListForThisFile(Hashtable hashtableFileThis, Vector vhashtablesV6FullUninstallFilesListForThisComponent) {
        String sRelativePathThisFile = hashtableFileThis.get("relativepath").toString();
        int i = 0;
        while (i < vhashtablesV6FullUninstallFilesListForThisComponent.size()) {
            Hashtable hashtableThisV6FullUninstallEntry = (Hashtable)vhashtablesV6FullUninstallFilesListForThisComponent.elementAt(i);
            String sRelativePathThisV6FullUninstallEntry = hashtableThisV6FullUninstallEntry.get("relativepath").toString();
            if (sRelativePathThisFile.equals(sRelativePathThisV6FullUninstallEntry)) {
                vhashtablesV6FullUninstallFilesListForThisComponent.remove(hashtableThisV6FullUninstallEntry);
                break;
            }
            ++i;
        }
        this.updateV6FullUninstallFilesListActionForThisFile(hashtableFileThis, vhashtablesV6FullUninstallFilesListForThisComponent);
    }

    private void updateV6FullUninstallFilesListActionForThisFile(Hashtable hashtableFileThis, Vector vhashtablesV6FullUninstallFilesListForThisComponent) {
        Hashtable hashtableUpdateEntry = this.getInverseFileActionDetailsForV6FullUninstall(hashtableFileThis);
        if (hashtableUpdateEntry == null) {
            return;
        }
        vhashtablesV6FullUninstallFilesListForThisComponent.add(hashtableUpdateEntry);
    }

    private Vector convertFilesListToFileDetailsHashtables(String sFilesListContents) throws IOException {
        Vector<Hashtable> vhashtablesFileDetails = new Vector<Hashtable>();
        try {
            SimpleXMLParser sxp = new SimpleXMLParser(sFilesListContents);
            Vector vnodesFiles = sxp.getNodes("componentfiles/file");
            int i = 0;
            while (i < vnodesFiles.size()) {
                Node nodeFileThis = (Node)vnodesFiles.elementAt(i);
                Hashtable hashtableFileDetails = this.getFileDetailsForThisFileNode(nodeFileThis);
                vhashtablesFileDetails.add(hashtableFileDetails);
                ++i;
            }
            return vhashtablesFileDetails;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    private Hashtable getInverseFileActionDetails(Hashtable hashtableFileDetails, Vector vhashtablesV6FullUninstallFilesListForThisComponent) throws IOException {
        Hashtable hashtableReturn = new Hashtable(hashtableFileDetails);
        String sInverseChecksum = this.getInverseChecksumForThisFile(hashtableFileDetails, vhashtablesV6FullUninstallFilesListForThisComponent);
        hashtableReturn = FileActionPlugin.getInverseFileAction(hashtableFileDetails, this.m_caps.getInstallToolkitBridge());
        hashtableReturn.put("checksum", sInverseChecksum);
        return hashtableReturn;
    }

    private Hashtable getInverseFileActionDetailsForV6FullUninstall(Hashtable hashtableFileDetails) {
        String sInstallOperation = hashtableFileDetails.get("installoperation").toString();
        Object oV6InverseAction = ComponentizedRepositoryConstants.HASHTABLE_MAP_UPDATE_ACTION_TO_V6_FULL_UNINSTALL_ACTION.get(sInstallOperation);
        if (oV6InverseAction == null) {
            return null;
        }
        Hashtable hashtableReturn = (Hashtable)hashtableFileDetails.clone();
        hashtableReturn.put("installoperation", oV6InverseAction.toString());
        return hashtableReturn;
    }

    private String getInverseChecksumForThisFile(Hashtable hashtableFileDetails, Vector vhashtablesV6FullUninstallFilesListForThisComponent) {
        String sIncomingChecksum = hashtableFileDetails.get("checksum").toString();
        int i = 0;
        while (i < vhashtablesV6FullUninstallFilesListForThisComponent.size()) {
            String sRelativePathIncoming;
            Hashtable hashtableV6FullUninstallFileDetailsThis = (Hashtable)vhashtablesV6FullUninstallFilesListForThisComponent.elementAt(i);
            String sRelativePathThis = hashtableV6FullUninstallFileDetailsThis.get("relativepath").toString();
            if (sRelativePathThis.equals(sRelativePathIncoming = hashtableFileDetails.get("relativepath").toString())) {
                Object oChecksum = hashtableV6FullUninstallFileDetailsThis.get("checksum");
                if (oChecksum == null) {
                    return sIncomingChecksum;
                }
                return oChecksum.toString();
            }
            ++i;
        }
        return sIncomingChecksum;
    }

    private void setFileNodeElementsFromFileDetails(Node nodeFile, Hashtable hashtableFileDetails) {
        Enumeration enumerationKeys = hashtableFileDetails.keys();
        while (enumerationKeys.hasMoreElements()) {
            Object oKeyThis = enumerationKeys.nextElement();
            Object oValue = hashtableFileDetails.get(oKeyThis);
            SimpleXMLParser.addNestedElement(oKeyThis.toString(), oValue.toString(), null, nodeFile);
        }
    }

    private Hashtable getFileDetailsForThisFileNode(Node nodeFileThis) {
        Vector velementsChildren = SimpleXMLParser.getChildElements(nodeFileThis);
        Hashtable<String, String> hashtableFileDetails = new Hashtable<String, String>();
        int i = 0;
        while (i < velementsChildren.size()) {
            Node nodeChildThis = (Node)velementsChildren.elementAt(i);
            String sParamName = nodeChildThis.getNodeName();
            String sParamValue = SimpleXMLParser.getNodeText(nodeChildThis).trim();
            hashtableFileDetails.put(sParamName, sParamValue);
            ++i;
        }
        return hashtableFileDetails;
    }

    private Hashtable augmentFileDetailsWithRepositoryLocations(Hashtable hashtableFileDetails) throws IOException {
        Hashtable hashtableReturn = (Hashtable)hashtableFileDetails.clone();
        hashtableReturn.put("sourcerepository", new FileSystemEntry(this.m_caps.getSourceRepositoryPaths()[0].getURI(), this.m_caps.getComponentName(), this.m_caps.getInstallToolkitBridge()));
        hashtableReturn.put("installlocation", this.m_caps.getProductInstallRoot());
        hashtableReturn.put("backuprepository", new FileSystemEntry(this.m_caps.getBackupRepositoryPath().getURI(), this.m_caps.getComponentName(), this.m_caps.getInstallToolkitBridge()));
        return hashtableReturn;
    }

    private Hashtable unaugmentFileDetailsWithRepositoryLocations(Hashtable hashtableAugmentedFileDetails) {
        Hashtable hashtableReturn = (Hashtable)hashtableAugmentedFileDetails.clone();
        hashtableReturn.remove("sourcerepository");
        hashtableReturn.remove("installlocation");
        hashtableReturn.remove("backuprepository");
        return hashtableReturn;
    }

    private Hashtable augmentFileDetailsWithBackupFlagAndCheckPermissionsFlag(Hashtable hashtableFileDetails, boolean fBackupFlag, boolean fCheckPermissionFlag) {
        Hashtable hashtableReturn = (Hashtable)hashtableFileDetails.clone();
        hashtableReturn.put("isbackupoperation", new Boolean(fBackupFlag));
        hashtableReturn.put("checkpermissions", new Boolean(fCheckPermissionFlag));
        return hashtableReturn;
    }

    private Hashtable unaugmentFileDetailsWithBackupFlagAndCheckPermissionsFlag(Hashtable hashtableFileDetails) {
        Hashtable hashtableReturn = (Hashtable)hashtableFileDetails.clone();
        hashtableReturn.remove("isbackupoperation");
        hashtableReturn.remove("checkpermissions");
        return hashtableReturn;
    }

    private String getContentsOfTheFilesListFileForThisComponent() throws IOException {
        return new FileSystemEntry(this.m_caps.getSourceRepositoryPaths()[0].getURI(), String.valueOf(this.m_caps.getComponentName()) + "/" + "files.list", this.m_caps.getInstallToolkitBridge()).getUTF8Contents();
    }
}

