/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import java.io.IOException;

public class FilesListActionUtils {
    private InstallToolkitBridge m_itb = null;

    public FilesListActionUtils(InstallToolkitBridge itb) {
        this.m_itb = itb;
    }

    public void addFile(FileSystemEntry fseSourceRepositoryPath, FileSystemEntry fseDestinationRepositoryPath, String sRelativePath, int nPermission) throws IOException {
        this.copyFileUsingRelativePaths(fseSourceRepositoryPath, fseDestinationRepositoryPath, sRelativePath, nPermission);
    }

    public void replaceFile(String sRelativePath, FileSystemEntry fseSourceRepositoryPath, FileSystemEntry fseDestinationRepositoryPath, FileSystemEntry fseBackupRepositoryPath, boolean fBackupFileFlag, int nPermission) throws IOException {
        if (fBackupFileFlag) {
            this.copyFileUsingRelativePaths(fseDestinationRepositoryPath, fseBackupRepositoryPath, sRelativePath, nPermission);
        }
        this.copyFileUsingRelativePaths(fseSourceRepositoryPath, fseDestinationRepositoryPath, sRelativePath, nPermission);
    }

    public void removeFile(String sRelativePath, FileSystemEntry fseDestinationRepositoryPath, FileSystemEntry fseBackupRepositoryPath, boolean fBackupFileFlag, int nPermission) throws IOException {
        if (fBackupFileFlag) {
            this.copyFileUsingRelativePaths(fseDestinationRepositoryPath, fseBackupRepositoryPath, sRelativePath, nPermission);
        }
        FileSystemEntry fseThis = new FileSystemEntry(fseDestinationRepositoryPath.getURI(), sRelativePath, this.m_itb);
        fseThis.delete();
        this.deleteParentDirectoriesRecursivelyIfEmpty(fseThis.getParent(), fseDestinationRepositoryPath);
    }

    public void createSymbolicLink(String sRelativePath, FileSystemEntry fseDestinationRepositoryPath, String sPathToLinkTo) throws IOException {
        new FileSystemEntry(fseDestinationRepositoryPath.getURI(), sRelativePath, this.m_itb).linkTo(sPathToLinkTo);
    }

    public void copyFileUsingRelativePaths(FileSystemEntry fseSourceRepositoryPath, FileSystemEntry fseDestinationRepositoryPath, String sRelativePath, int nPermission) throws IOException {
        FileSystemEntry fsePathFrom = new FileSystemEntry(fseSourceRepositoryPath.getURI(), sRelativePath, this.m_itb);
        FileSystemEntry fsePathTo = new FileSystemEntry(fseDestinationRepositoryPath.getURI(), sRelativePath, this.m_itb);
        fsePathFrom.copyTo(fsePathTo);
        fsePathTo.setPermissions(nPermission);
    }

    public void deleteParentDirectoriesRecursivelyIfEmpty(FileSystemEntry fseTopLevelDirectory, FileSystemEntry fseStartingDirectory) throws IOException {
        if (!fseTopLevelDirectory.exists() || !fseStartingDirectory.exists()) {
            return;
        }
        FileSystemEntry fseCurrentPath = new FileSystemEntry(fseStartingDirectory.getURI(), this.m_itb);
        while (!fseCurrentPath.equals(fseTopLevelDirectory)) {
            if (fseCurrentPath.getDirectoryEntries().length != 0) break;
            fseCurrentPath.delete();
            fseCurrentPath = new FileSystemEntry(fseCurrentPath.getParent().getURI(), this.m_itb);
        }
    }
}

