/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils.componentactions;

import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ChecksumUpdater {
    private FileSystemEntry m_fseInstallRoot = null;
    private Vector m_vhashtablesV6FullUninstallFilesListForThisComponent = null;
    private Hashtable m_hashtableRelativePathAndChecksumPairs = null;
    private InstallToolkitBridge m_itb = null;
    private static final String S_EMPTY = "";

    public ChecksumUpdater(FileSystemEntry fseInstallRoot, Vector vhashtablesV6FullUninstallFilesListForThisComponent, InstallToolkitBridge itb) {
        this.m_fseInstallRoot = fseInstallRoot;
        this.m_vhashtablesV6FullUninstallFilesListForThisComponent = vhashtablesV6FullUninstallFilesListForThisComponent;
        this.m_itb = itb;
        this.m_hashtableRelativePathAndChecksumPairs = new Hashtable();
    }

    public void add(String sRelativePath) {
        this.m_hashtableRelativePathAndChecksumPairs.put(sRelativePath, S_EMPTY);
    }

    public Vector getChecksumUpdatedV6FullUninstallFilesList() throws IOException {
        Enumeration enumKeys = this.m_hashtableRelativePathAndChecksumPairs.keys();
        while (enumKeys.hasMoreElements()) {
            String sRelativePath = (String)enumKeys.nextElement();
            String sChecksum = this.getChecksum(sRelativePath);
            this.m_hashtableRelativePathAndChecksumPairs.put(sRelativePath, sChecksum);
            this.updateChecksumForThisEntry(sRelativePath, sChecksum);
        }
        return this.m_vhashtablesV6FullUninstallFilesListForThisComponent;
    }

    private void updateChecksumForThisEntry(String sRelativePath, String sChecksum) {
        int i = 0;
        while (i < this.m_vhashtablesV6FullUninstallFilesListForThisComponent.size()) {
            Hashtable hashtableEntryThis = (Hashtable)this.m_vhashtablesV6FullUninstallFilesListForThisComponent.elementAt(i);
            String sRelativePathThis = (String)hashtableEntryThis.get("relativepath");
            if (sRelativePath.equalsIgnoreCase(sRelativePathThis)) {
                hashtableEntryThis.put("checksum", sChecksum);
                return;
            }
            ++i;
        }
    }

    private String getChecksum(String sRelativePath) throws FileNotFoundException, IOException {
        FileSystemEntry fseThis = new FileSystemEntry(this.m_fseInstallRoot.getURI(), sRelativePath, this.m_itb);
        try {
            FileSystemEntry fseZipThis = URIUtils.convertPathToDefaultTargetMachineFSE(fseThis.getURI().getPath(), this.m_itb);
            fseZipThis.flush();
            return fseThis.getChecksum();
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
    }
}

