/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils;

import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";
    private static final String className = "XMLUtils";

    public static void saveDocument(Document document, FileSystemEntry fseTo) throws IOException {
        Logr.methodEntry(className, "saveDocument");
        XMLUtils.saveDocument(document, fseTo, false);
        Logr.methodExit(className, "saveDocument");
    }

    public static void saveDocument(Document document, FileSystemEntry fseTo, boolean fFlushOutputStream) throws IOException {
        try {
            Logr.methodEntry(className, "saveDocument");
            Logr.debug("Save xml document :" + fseTo.getAbsolutePath());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            OutputStream outputStream = fseTo.getOutputStream();
            DOMSource domsource = new DOMSource(document);
            StreamResult streamresult = new StreamResult(outputStream);
            transformer.setOutputProperty("indent", S_YES);
            transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
            transformer.transform(domsource, streamresult);
            if (fFlushOutputStream) {
                outputStream.flush();
            }
            outputStream.close();
            Logr.methodExit(className, "saveDocument");
            return;
        }
        catch (TransformerConfigurationException e) {
            Logr.warn(className, "saveDocument", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (TransformerException e) {
            Logr.warn(className, "saveDocument", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            Logr.warn(className, "saveDocument", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
    }

    public static SimpleXMLParser getSimpleXMLParserFromFileSystemEntry(FileSystemEntry fse) throws IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "getSimpleXMLParserFromFileSystemEntry");
        SimpleXMLParser sxp = null;
        try (InputStream inputStream = null;){
            inputStream = fse.getInputStream();
            sxp = new SimpleXMLParser(inputStream);
        }
        Logr.methodExit(className, "getSimpleXMLParserFromFileSystemEntry");
        return sxp;
    }
}

