/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils;

import com.ibm.websphere.product.WASDirectory;
import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.install.metadata.NIFPackageEntry;
import com.ibm.ws.pak.internal.install.metadata.NIFStack;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.URIUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.ExecEngine;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.filesystems.PlatformConstants;
import com.ibm.ws.pak.internal.utils.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import com.ibm.ws.pak.internal.utils.product.ProductPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebSphereOSArchUtils {
    public final String ARCH_ALL = "unspecified";
    protected static final String S_OS_ARCH = "os.arch";
    public static final String S_WIN = "windows";
    public static final String S_WINTEL = "wintel";
    public static final String S_UNIX = "unix";
    public static final String S_ZOS = "zos";
    public static final String S_OS400 = "os400";
    private static final String S_PPC = "ppc";
    private static final String S_PPC32 = "ppc32";
    private static final String S_PPC64 = "ppc64";
    private static final String S_IA64 = "ia64";
    private static final String S_IA32 = "ia32";
    private static final String S_AMD64 = "x86_64";
    private static final String S_PARISC = "pa-risc";
    private static final String S_S390_32 = "s390_32";
    private static final String S_S390 = "s390";
    private static final String S_S390_64 = "s390_64";
    private static final String S_SPARC = "sparc";
    private static final String S_SPARC64 = "sparc64";
    private static final String INSTALL_PACKAGE_INSTALL_FACTORY_INFORMATION = "install-package/installFactoryInformation";
    private static final String WAS_PRIMARY_PAK_RELATIVE_BACKUP_PATH = "properties/version/nif/backup";
    private static final String WAS_PRIMARY_PAK_FILENAME = "was.primary.pak";
    private static final String S_TARGET_PLATFORM = "targetOSandArchs";
    private static final String[] S_GETCONF_KERNEL_BITMODE = new String[]{"getconf", "KERNEL_BITMODE"};
    private static final String className = "WebSphereOSArchUtils";
    private static HashMap primaryPakOfferingMap = null;
    private static String OPS_ID = "WXDOP";
    private static String DAT_ID = "WXDDG";
    private static String BIZ_ID = "WXDCG";
    private static String RTJ_ID = "RTJ";
    private String m_sArch = null;
    private String m_sOS = null;
    private boolean isUnix = false;
    private static WebSphereOSArchUtils osp;
    private static WebSphereOSArchUtils wp;

    protected WebSphereOSArchUtils(String os, String arch) {
        Logr.debug("WebSphereOSArchUtils() : Setting os=" + os + " and Arch=" + arch);
        this.m_sOS = os;
        this.m_sArch = arch;
        if (!this.m_sOS.equalsIgnoreCase(S_WIN)) {
            this.isUnix = true;
        }
    }

    public static WebSphereOSArchUtils getPlatform() throws IOException {
        if (osp == null) {
            String os = PlatformConstants.getTargetPlatformCode();
            String arch = null;
            if (os.equals(S_WIN)) {
                arch = WebSphereOSArchUtils.getWindowsArch();
            } else if (os.equals("aix")) {
                arch = WebSphereOSArchUtils.getAixArch();
            } else if (os.equals("hpux")) {
                arch = WebSphereOSArchUtils.getHpuxArch();
            } else if (os.equals("solaris")) {
                arch = WebSphereOSArchUtils.getSolarisArch();
            } else if (os.equals("linux")) {
                arch = WebSphereOSArchUtils.getLinuxArch();
            } else {
                Logr.error("WebSphereOSArchUtils.getPlatform() : PLATFORM_NOT_SUPPORTED");
                throw new IOException("PLATFORM_NOT_SUPPORTED");
            }
            osp = new WebSphereOSArchUtils(os, arch);
        }
        return osp;
    }

    public static WebSphereOSArchUtils getPlatform(String installLocation, InstallToolkitBridge itb) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        if (wp == null) {
            String os = PlatformConstants.getTargetPlatformCode();
            String arch = WebSphereOSArchUtils.getWASArch(installLocation, itb);
            if (arch == null) {
                arch = WebSphereOSArchUtils.getArchFromNativeFile(installLocation);
            }
            if (arch == null) {
                arch = WebSphereOSArchUtils.getWXDArch(installLocation, itb);
            }
            if (os.equals(S_WIN)) {
                if (arch == null) {
                    arch = WebSphereOSArchUtils.getWindowsArch();
                }
            } else if (os.equals("aix")) {
                if (arch == null) {
                    arch = WebSphereOSArchUtils.getAixArch();
                }
            } else if (os.equals("hpux")) {
                if (arch == null) {
                    arch = WebSphereOSArchUtils.getHpuxArch();
                }
            } else if (os.equals("solaris")) {
                if (arch == null) {
                    arch = WebSphereOSArchUtils.getSolarisArch();
                }
            } else if (os.equals("linux")) {
                if (arch == null) {
                    arch = WebSphereOSArchUtils.getLinuxArch();
                } else if (arch.equals(S_S390)) {
                    arch = S_S390_32;
                }
            } else if (os.equals(S_OS400)) {
                if (arch == null) {
                    arch = S_PPC64;
                }
            } else {
                Logr.error("WebSphereOSArchUtils.getPlatform() : PLATFORM_NOT_SUPPORTED");
                throw new IOException("PLATFORM_NOT_SUPPORTED");
            }
            wp = new WebSphereOSArchUtils(os, arch);
        }
        return wp;
    }

    private static void initPrimaryPakOfferingMap() {
        if (primaryPakOfferingMap == null) {
            primaryPakOfferingMap = new HashMap();
            primaryPakOfferingMap.put(OPS_ID, "xd.primary.ext.pak");
            primaryPakOfferingMap.put(DAT_ID, "xd.primary.data.pak");
            primaryPakOfferingMap.put(BIZ_ID, "xd.primary.compute.pak");
            primaryPakOfferingMap.put(RTJ_ID, "rtj.primary.pak");
        }
    }

    private static String getWASBackupPakURI(String installLocation, InstallToolkitBridge itb) throws URISyntaxException {
        String path = String.valueOf(new URI(installLocation).getPath()) + "/" + WAS_PRIMARY_PAK_RELATIVE_BACKUP_PATH + "/" + WAS_PRIMARY_PAK_FILENAME;
        return URIUtils.convertPathToURI(path, itb).toString();
    }

    private static String getWASArch(String installLocation, InstallToolkitBridge itb) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        FileSystemEntry fse = new FileSystemEntry(new URI(WebSphereOSArchUtils.getWASBackupPakURI(installLocation, itb)), "maintenance.xml", itb);
        if (fse.exists()) {
            return WebSphereOSArchUtils.getArchFromMetadata(fse, INSTALL_PACKAGE_INSTALL_FACTORY_INFORMATION);
        }
        return null;
    }

    private static String getArchFromNativeFile(String installLocation) throws URISyntaxException, IOException {
        String slibPath;
        WASDirectory wasdir = new WASDirectory(installLocation);
        if (!wasdir.isThisProductInstalled("ND")) {
            return null;
        }
        String os = PlatformConstants.getTargetPlatformCode();
        if (os.equals(S_WIN)) {
            String slibPath2 = String.valueOf(new URI(installLocation).getPath()) + "/bin/libWs60ProcessManagement.dll";
            if (new File(slibPath2).exists()) {
                return WebSphereOSArchUtils.getArchByDllDecoder(slibPath2);
            }
        } else if (os.equals("aix")) {
            String slibPath3 = String.valueOf(new URI(installLocation).getPath()) + "/bin/libWs60ProcessManagement.so";
            if (new File(slibPath3).exists()) {
                return WebSphereOSArchUtils.getArchByXcoffDecoder(slibPath3);
            }
        } else if (os.equals("solaris")) {
            String slibPath4 = String.valueOf(new URI(installLocation).getPath()) + "/bin/libWs60ProcessManagement.so";
            if (new File(slibPath4).exists()) {
                return WebSphereOSArchUtils.getArchByElfDecoder(slibPath4);
            }
        } else if (os.equals("linux")) {
            String slibPath5 = String.valueOf(new URI(installLocation).getPath()) + "/bin/libWs60ProcessManagement.so";
            if (new File(slibPath5).exists()) {
                return WebSphereOSArchUtils.getArchByElfDecoder(slibPath5);
            }
        } else if (os.equals("hpux") && new File(slibPath = String.valueOf(new URI(installLocation).getPath()) + "/bin/libWs60ProcessManagement.sl").exists()) {
            return S_PARISC;
        }
        return null;
    }

    private static String getArchByXcoffDecoder(String XcoffFilePath) throws IOException {
        String arch;
        FileInputStream fis = new FileInputStream(XcoffFilePath);
        int archHi = fis.read() & 0xFF;
        int archLo = fis.read() & 0xFF;
        int archB = archLo + (archHi << 8);
        fis.close();
        switch (archB) {
            case 479: {
                arch = S_PPC32;
                break;
            }
            case 495: {
                arch = S_PPC64;
                break;
            }
            case 503: {
                arch = S_PPC64;
                break;
            }
            default: {
                arch = null;
            }
        }
        return arch;
    }

    private static String getArchByElfDecoder(String elfFilePath) throws IOException {
        String arch;
        FileInputStream fis = new FileInputStream(elfFilePath);
        int b1 = fis.read();
        int b2 = fis.read();
        int b3 = fis.read();
        int b4 = fis.read();
        if (b1 != 127 || b2 != 69 || b3 != 76 || b4 != 70) {
            Logr.debug("not an ELF format file");
        }
        int b5 = fis.read();
        fis.skip(13L);
        int archB = fis.read();
        if (archB == 0) {
            archB = fis.read();
        }
        fis.close();
        switch (archB) {
            case 2: {
                arch = S_SPARC;
                break;
            }
            case 3: {
                arch = S_IA32;
                break;
            }
            case 15: {
                arch = S_PARISC;
                break;
            }
            case 20: {
                arch = S_PPC32;
                break;
            }
            case 21: {
                arch = S_PPC64;
                break;
            }
            case 43: {
                arch = S_SPARC64;
                break;
            }
            case 50: {
                arch = S_IA64;
                break;
            }
            case 62: {
                arch = S_AMD64;
                break;
            }
            case 22: {
                arch = S_S390_32;
                if (b5 != 2) break;
                arch = S_S390_64;
                break;
            }
            default: {
                arch = null;
            }
        }
        return arch;
    }

    private static String getArchByDllDecoder(String dllFilePath) throws IOException {
        int archB;
        String arch = "";
        try (FileInputStream fis = new FileInputStream(dllFilePath);){
            fis.skip(60L);
            int offsetLo = fis.read() & 0xFF;
            int offsetHigh = fis.read() & 0xFF;
            int fileOffset = offsetLo + (offsetHigh << 8);
            fis.skip(fileOffset - 62);
            int pByte = fis.read();
            int eByte = fis.read();
            fis.skip(2L);
            if (pByte != 80 || eByte != 69) {
                Logr.debug("not an PE format file");
                String string = arch;
                return string;
            }
            int archLo = fis.read() & 0xFF;
            int archHi = fis.read() & 0xFF;
            archB = archLo + (archHi << 8);
        }
        switch (archB) {
            case 332: {
                arch = S_IA32;
                break;
            }
            case 496: {
                arch = S_PPC32;
                break;
            }
            case 512: {
                arch = S_IA64;
                break;
            }
            case 34404: {
                arch = S_AMD64;
                break;
            }
            default: {
                arch = null;
            }
        }
        return arch;
    }

    private static String getWXDArch(String installLocation, InstallToolkitBridge itb) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        if (!NIFStack.isOpen()) {
            FileSystemEntry fseBackupPath = new FileSystemEntry(URIUtils.convertPathToURI(ProductPlugin.getCurrentBackupPath(), itb), itb);
            NIFStack.open(fseBackupPath, itb);
        }
        WebSphereOSArchUtils.initPrimaryPakOfferingMap();
        String primaryPakFileName = (String)primaryPakOfferingMap.get(ProductPlugin.getCurrentProductOffering());
        NIFPackageEntry nifpe = NIFStack.getElementWithThisNIFPackageName(primaryPakFileName);
        if (nifpe == null) {
            return null;
        }
        String sPlatform = nifpe.getParamValue(S_TARGET_PLATFORM);
        if (sPlatform == null) {
            return null;
        }
        return sPlatform.substring(sPlatform.indexOf(".") + 1);
    }

    private static String getArchFromMetadata(FileSystemEntry fse, String nodeName) throws IOException, ParserConfigurationException, SAXException {
        SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fse);
        Vector vNode = sxp.getNodes(nodeName);
        Vector vNodeParams = SimpleXMLParser.getAllNamedChildNodes((Node)vNode.get(0), "param");
        int i = 0;
        while (i < vNodeParams.size()) {
            Node nodeParamThis = (Node)vNodeParams.elementAt(i);
            if (SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "name").equals(S_TARGET_PLATFORM)) {
                String sPlatform = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "value");
                String sArch = sPlatform.substring(sPlatform.indexOf(".") + 1);
                if (sArch.equalsIgnoreCase(S_WINTEL)) {
                    return S_WIN;
                }
                return sArch;
            }
            ++i;
        }
        return null;
    }

    private static String getAixArch() {
        String sBit = WebSphereOSArchUtils.getStandardOutputFromProcessCall(S_GETCONF_KERNEL_BITMODE).trim();
        String sArch = System.getProperty(S_OS_ARCH).toLowerCase();
        if (sArch.startsWith(S_PPC)) {
            sArch = S_PPC + sBit;
        }
        return sArch;
    }

    private static String getWindowsArch() {
        String arch = System.getProperty(S_OS_ARCH);
        if (arch.equalsIgnoreCase("x86")) {
            return S_IA32;
        }
        if (arch.equalsIgnoreCase("amd64")) {
            return S_AMD64;
        }
        return arch;
    }

    private static String getHpuxArch() {
        String arch = System.getProperty(S_OS_ARCH);
        if (arch.equalsIgnoreCase("PA_RISC2.0")) {
            return S_PARISC;
        }
        if (arch.equalsIgnoreCase("IA64W")) {
            return S_IA64;
        }
        return arch;
    }

    private static String getSolarisArch() {
        String arch = System.getProperty(S_OS_ARCH);
        if (arch.startsWith(S_SPARC)) {
            return S_SPARC;
        }
        return S_AMD64;
    }

    private static String getLinuxArch() {
        String arch = System.getProperty(S_OS_ARCH);
        if (arch.equalsIgnoreCase("x86") || arch.equalsIgnoreCase(S_IA32)) {
            return S_IA32;
        }
        if (arch.equalsIgnoreCase("amd64")) {
            return S_AMD64;
        }
        if (arch.startsWith(S_PPC)) {
            return S_PPC32;
        }
        if (arch.equalsIgnoreCase(S_S390) || arch.equalsIgnoreCase("s390x")) {
            return S_S390_32;
        }
        return arch;
    }

    public boolean matchOS(String os) {
        if (os.equals(S_UNIX) && this.isUnix) {
            return true;
        }
        return os.equals(this.m_sOS);
    }

    public boolean matchArch(String arch) {
        if (arch.equals("unspecified")) {
            return true;
        }
        return arch.equals(this.m_sArch);
    }

    public String getArch() {
        return this.m_sArch;
    }

    public String getOS() {
        return this.m_sOS;
    }

    public boolean getIsUnix() {
        return this.isUnix;
    }

    protected static String getStandardOutputFromProcessCall(String[] sCommandArgs) {
        ExecEngine execEngine = new ExecEngine();
        execEngine.executeIncomingArguments(sCommandArgs, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
        String sOutput = execEngine.getProcessStdOut();
        return sOutput;
    }

    public static String replaceOSArchWithWASOSArch(String theString, String osPlaceHolder, String archPlaceHolder, String installLocation, InstallToolkitBridge itb) {
        if (theString == null) {
            return null;
        }
        String toReturnString = theString;
        WebSphereOSArchUtils plt = null;
        try {
            plt = WebSphereOSArchUtils.getPlatform(installLocation, itb);
            if (osPlaceHolder != null) {
                toReturnString = toReturnString.replaceAll(osPlaceHolder, plt.m_sOS);
            }
            if (archPlaceHolder != null) {
                toReturnString = toReturnString.replaceAll(archPlaceHolder, plt.m_sArch);
            }
        }
        catch (Exception e) {
            Logr.warn(className, "replaceOSArchWithWASOSArch", e.getMessage(), e);
            toReturnString = null;
        }
        Logr.methodReturn(className, "replaceOSArchWithWASOSArch", toReturnString);
        return toReturnString;
    }

    public static void main(String[] args) throws IOException {
        WebSphereOSArchUtils p = WebSphereOSArchUtils.getPlatform();
        System.out.println("OS: " + p.getOS());
        System.out.println("Arch: " + p.getArch());
    }
}

