/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.utils;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private static final String S_EMPTY = "";

    public static String replaceAll(String s, String sToken, String sReplace) {
        if (s == null || s.trim().length() == 0 || s.indexOf(sToken) < 0) {
            return s;
        }
        int index = s.indexOf(sToken);
        while (index >= 0) {
            String s1 = s.substring(0, index);
            String s2 = s.substring(index + sToken.length());
            s = String.valueOf(s1) + sReplace + s2;
            index = s.indexOf(sToken);
        }
        return s;
    }

    public static String returnObjectToStringOrNullIfObjectIsNull(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String[] combine(String[][] aas) {
        if (aas == null) {
            return null;
        }
        int nTotal = 0;
        String[][] stringArray = aas;
        int n = aas.length;
        int n2 = 0;
        while (n2 < n) {
            String[] aa = stringArray[n2];
            if (aa != null) {
                nTotal += aa.length;
            }
            ++n2;
        }
        String[] asReturn = new String[nTotal];
        int nBase = 0;
        String[][] stringArray2 = aas;
        int n3 = aas.length;
        int n4 = 0;
        while (n4 < n3) {
            String[] aa = stringArray2[n4];
            if (aa != null) {
                int x = 0;
                while (x < aa.length) {
                    asReturn[nBase + x] = aa[x];
                    ++x;
                }
                nBase += aa.length;
            }
            ++n4;
        }
        return asReturn;
    }

    public static String[] getCollectionAsStringArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        Object[] ao = collection.toArray();
        String[] asReturn = new String[ao.length];
        int i = 0;
        while (i < ao.length) {
            asReturn[i] = ao[i].toString();
            ++i;
        }
        return asReturn;
    }

    public static boolean isThisStringContainingThisToken(String sThis, String sToken, String sTokenSeparator) {
        StringTokenizer st = new StringTokenizer(sThis, sTokenSeparator);
        while (st.hasMoreTokens()) {
            String sTokenThis = st.nextToken();
            if (!sToken.equals(sTokenThis.trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean doesTheseStringsShareTokens(String s1, String s2, String sTokenSeparator) {
        if (s1 == null || s2 == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(s1, sTokenSeparator);
        while (st.hasMoreElements()) {
            String sTokenThis = st.nextToken();
            if (!StringUtils.isThisStringContainingThisToken(s2, sTokenThis, sTokenSeparator)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesTheseStringsShareAllTokens(String s1, String s2, String sTokenSeparator) {
        String sTokenThis;
        if (s1 == null || s2 == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(s1, sTokenSeparator);
        while (st.hasMoreElements()) {
            sTokenThis = st.nextToken();
            if (StringUtils.isThisStringContainingThisToken(s2, sTokenThis, sTokenSeparator)) continue;
            return false;
        }
        st = new StringTokenizer(s2, sTokenSeparator);
        while (st.hasMoreElements()) {
            sTokenThis = st.nextToken();
            if (StringUtils.isThisStringContainingThisToken(s1, sTokenThis, sTokenSeparator)) continue;
            return false;
        }
        return true;
    }

    public static boolean isThisTokenInThisArray(String sToken, String[] asArray) {
        String[] stringArray = asArray;
        int n = asArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (sToken == null ? element == null : sToken.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] convertStringToTokenArray(String sTokens, String sTokenSeparator) {
        Vector vsTokens = StringUtils.convertStringToTokenVector(sTokens, sTokenSeparator);
        return vsTokens.toArray(new String[vsTokens.size()]);
    }

    public static Vector convertStringToTokenVector(String sTokens, String sTokenSeparator) {
        if (sTokens == null) {
            return new Vector();
        }
        Vector<String> vsTokens = new Vector<String>();
        StringTokenizer st = new StringTokenizer(sTokens, sTokenSeparator);
        while (st.hasMoreTokens()) {
            vsTokens.add(st.nextToken().trim());
        }
        return vsTokens;
    }

    public static String convertStringArrayToTokenString(String[] asTokens, String sTokenSeparator) {
        if (asTokens == null) {
            return null;
        }
        String sReturn = S_EMPTY;
        int i = 0;
        while (i < asTokens.length) {
            if (i > 0) {
                sReturn = String.valueOf(sReturn) + sTokenSeparator;
            }
            sReturn = String.valueOf(sReturn) + asTokens[i].trim();
            ++i;
        }
        return sReturn;
    }

    public static String convertStringVectorToTokenString(Vector vsTokens, String sTokenSeparator) {
        if (vsTokens == null) {
            return null;
        }
        String sReturn = S_EMPTY;
        int i = 0;
        while (i < vsTokens.size()) {
            sReturn = String.valueOf(sReturn) + ((String)vsTokens.elementAt(i)).trim();
            if (i < vsTokens.size() - 1) {
                sReturn = String.valueOf(sReturn) + sTokenSeparator;
            }
            ++i;
        }
        return sReturn;
    }

    public static String removeFirstOccurranceOfTokenFromString(String s, String sToken, String sTokenSeparator) {
        if (s == null) {
            return null;
        }
        Vector<String> vsReturn = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, sTokenSeparator);
        boolean fRemoved = false;
        while (st.hasMoreTokens()) {
            String sTokenThis = st.nextToken();
            if (!fRemoved && sTokenThis.equals(sToken)) {
                fRemoved = true;
                continue;
            }
            vsReturn.add(sTokenThis);
        }
        return StringUtils.convertStringVectorToTokenString(vsReturn, sTokenSeparator);
    }

    public static String[] tokenize(String s, String sSeparatingString) {
        if (s == null || s.equals(S_EMPTY)) {
            return new String[0];
        }
        int nSeparatorLength = sSeparatingString.length();
        int nIndex = s.indexOf(sSeparatingString);
        if (nIndex < 0) {
            return new String[]{s};
        }
        Vector<String> vsReturn = new Vector<String>();
        while (nIndex >= 0) {
            String sToken = s.substring(0, nIndex);
            if (sToken != null && !sToken.equals(S_EMPTY)) {
                vsReturn.add(sToken);
            }
            s = s.substring(nIndex + nSeparatorLength);
            nIndex = s.indexOf(sSeparatingString);
        }
        if (!s.equals(S_EMPTY)) {
            vsReturn.add(s);
        }
        return vsReturn.toArray(new String[vsReturn.size()]);
    }

    public static String[] tokenizeBySeparators(String s, String sSeparators) {
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, sSeparators);
        Vector<String> vs = new Vector<String>();
        while (st.hasMoreTokens()) {
            vs.add(st.nextToken());
        }
        String[] as = new String[vs.size()];
        int i = 0;
        while (i < vs.size()) {
            as[i] = (String)vs.elementAt(i);
            ++i;
        }
        return as;
    }

    public static String replaceSeparators(String s, String sSeparatorsToBeReplaced, String sSeparatorToBeUsed) {
        if (s == null) {
            return null;
        }
        String[] as = StringUtils.tokenizeBySeparators(s, sSeparatorsToBeReplaced);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (as != null && i < as.length) {
            sb.append(as[i]);
            if (i < as.length - 1) {
                sb.append(sSeparatorToBeUsed);
            }
            ++i;
        }
        return sb.toString();
    }
}

