/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.metadata;

import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.metadata.ModifyNIFMetaDataPlugin;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.XMLUtils;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class UpdateNIFPlugin
extends ModifyNIFMetaDataPlugin {
    private String m_sCurrentParamValues = null;
    private static final String S_EMPTY = "";
    private static final String S_PLUGINPATH_PARAM = "pluginpath";
    private static final String S_PLUGINID_PARAM = "pluginid";
    private static final String S_PARAMNAME_PARAM = "paramname";
    private static final String S_PARAMVALUES_PARAM = "paramvalues";
    private static final String S_PARAMVALUE_PARAM = "paramvalue";
    private static final String S_PATHTOPRIMARY_PARAM = "pathtoprimary";
    private static final String S_METADATANAME_PARAM = "metadataname";
    private static final String S_MODE_PARAM = "mode";
    private static final String[] AS_EMPTY = new String[0];
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"paramvalues", "paramvalue"};
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"pluginpath", "pluginid", "paramname", "pathtoprimary", "metadataname", "mode"};
    private static final String S_NEW_MODE = "new";
    private static final String S_ADD_MODE = "add";
    private static final String S_REMOVE_MODE = "remove";
    private static final String S_PREFIX_MODE = "prefix";
    private static final String S_NO_OP = "no-op";
    private static final String className = "UpdateNIFPlugin";

    @Override
    public FileSystemEntry getMetaDataFileSystemEntry() throws IOException, URISyntaxException {
        String[] asPathsToPrimary;
        Logr.methodEntry(className, "getMetaDataFileSystemEntry");
        String[] stringArray = asPathsToPrimary = StringUtils.tokenize(this.getParamValue(S_PATHTOPRIMARY_PARAM), ";");
        int n = asPathsToPrimary.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            FileSystemEntry fse = new FileSystemEntry(new URI(element), this.getParamValue(S_METADATANAME_PARAM), this.getInstallToolkitBridge());
            if (fse.exists()) {
                return fse;
            }
            ++n2;
        }
        Logr.debug("UpdateNIFPlugin.getMetaDataFileSystemEntry : Cannot find " + this.getParamValue(S_PATHTOPRIMARY_PARAM));
        return null;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    @Override
    protected void modifyMetaData(Document documentThis) throws NIFException {
        Logr.methodEntry(className, "modifyMetaData");
        if (this.getMode() != 1) {
            SimpleXMLParser sxpParser = new SimpleXMLParser(documentThis);
            Vector vnodeContainer = sxpParser.getNodes(this.getParamValue(S_PLUGINPATH_PARAM));
            Node nodeThis = (Node)vnodeContainer.elementAt(0);
            this.m_sCurrentParamValues = this.getParamValueForThisNode(nodeThis, this.getParamValue(S_PARAMNAME_PARAM));
        }
        Logr.methodExit(className, "modifyMetaData");
        this.transformNIFDocument(documentThis);
    }

    @Override
    protected void modifyMetaData() throws IOException, URISyntaxException, NIFException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "modifyMetaData");
        if (this.getParamValue(S_MODE_PARAM).equals(S_NO_OP)) {
            return;
        }
        FileSystemEntry fseMaintenanceMetaDataTo = new FileSystemEntry(new URI(this.getParamValue(S_PATHTOPRIMARY_PARAM)), this.getParamValue(S_METADATANAME_PARAM), this.getInstallToolkitBridge());
        Document documentThis = null;
        if (fseMaintenanceMetaDataTo.exists()) {
            documentThis = (Document)XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseMaintenanceMetaDataTo).getDocument().cloneNode(true);
            fseMaintenanceMetaDataTo.delete();
        } else {
            documentThis = (Document)this.getPluginDefinitionDocument().cloneNode(true);
        }
        this.modifyMetaData(documentThis);
        XMLUtils.saveDocument(documentThis, fseMaintenanceMetaDataTo);
        Logr.methodExit(className, "modifyMetaData");
    }

    private void transformNIFDocument(Document document) throws NIFException {
        Logr.methodEntry(className, "transformNIFDocument");
        try {
            String[] asParamValues = this.getParamValuesToSet();
            NIFPlugin.setPluginParamInThisDocument(document, this.getParamValue(S_PLUGINPATH_PARAM), this.getParamValue(S_PLUGINID_PARAM), this.getParamValue(S_PARAMNAME_PARAM), asParamValues);
        }
        catch (SAXException e) {
            throw new NIFException(e);
        }
        Logr.methodExit(className, "transformNIFDocument");
    }

    private String[] getParamValuesToSet() {
        if (this.getParamValue(S_PARAMVALUE_PARAM) != null) {
            if (this.getMode() == 1) {
                return new String[]{this.getParamValue(S_PARAMVALUE_PARAM)};
            }
            if (this.getMode() == 2) {
                return new String[]{String.valueOf(this.m_sCurrentParamValues) + ";" + this.getParamValue(S_PARAMVALUE_PARAM)};
            }
            if (this.getMode() == 4) {
                return new String[]{String.valueOf(this.getParamValue(S_PARAMVALUE_PARAM)) + ";" + this.m_sCurrentParamValues};
            }
            if (this.getMode() == 3) {
                String sParamValue = this.getParamValue(S_PARAMVALUE_PARAM);
                Vector vCurrentParamValues = this.getExpandedParams(this.m_sCurrentParamValues);
                int i = 0;
                while (i < vCurrentParamValues.size()) {
                    String sCurrentParamValue = vCurrentParamValues.elementAt(i).toString();
                    if (sCurrentParamValue.equals(sParamValue)) {
                        vCurrentParamValues.removeElementAt(i);
                    }
                    ++i;
                }
                this.m_sCurrentParamValues = S_EMPTY;
                i = 0;
                while (i < vCurrentParamValues.size()) {
                    this.m_sCurrentParamValues = i == vCurrentParamValues.size() - 1 ? String.valueOf(this.m_sCurrentParamValues) + vCurrentParamValues.elementAt(i).toString() : String.valueOf(this.m_sCurrentParamValues) + vCurrentParamValues.elementAt(i).toString() + ";";
                    ++i;
                }
                return new String[]{this.m_sCurrentParamValues};
            }
        }
        if (this.getParamValue(S_PARAMVALUES_PARAM) != null) {
            return StringUtils.getCollectionAsStringArray(this.getExpandedParams(this.getParamValue(S_PARAMVALUE_PARAM)));
        }
        return AS_EMPTY;
    }

    private String getParamValueForThisNode(Node nodeThis, String sParamNameThis) {
        Vector vnodesParams = SimpleXMLParser.getAllNamedChildNodes(nodeThis, "param");
        int i = 0;
        while (i < vnodesParams.size()) {
            Node nodeParamThis = (Node)vnodesParams.elementAt(i);
            String sParamName = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "name");
            String sParamValue = SimpleXMLParser.getNodeAttributeValue(nodeParamThis, "value");
            if (sParamName.equals(sParamNameThis)) {
                return sParamValue;
            }
            ++i;
        }
        return S_EMPTY;
    }

    private int getMode() {
        String sMode = this.getParamValue(S_MODE_PARAM);
        if (sMode.equals(S_NEW_MODE)) {
            return 1;
        }
        if (sMode.equals(S_ADD_MODE)) {
            return 2;
        }
        if (sMode.equals(S_REMOVE_MODE)) {
            return 3;
        }
        if (sMode.equals(S_PREFIX_MODE)) {
            return 4;
        }
        return 0;
    }
}

