/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.failurerecovery;

import com.ibm.ws.pak.internal.install.failurerecovery.UpdateStatusEntry;
import com.ibm.ws.pak.internal.utils.SimpleXMLParser;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UpdateStatusStage {
    private static final String className = "UpdateStatusStage";
    private String m_sStageName = null;
    private Vector m_vuseEntries = null;
    private UpdateStatusEntry m_useCurrentEntry = null;
    private static final String[] AS_ALL_STATGES = new String[]{"preinstall", "install", "postinstall", "preuninstall", "uninstall", "postuninstall"};

    public static Vector parseStages(Node nodeStageParent) {
        Logr.methodEntry(className, "parseStages");
        Vector vnodeStages = SimpleXMLParser.getAllNamedChildNodes(nodeStageParent, AS_ALL_STATGES);
        Vector<UpdateStatusStage> vussStages = new Vector<UpdateStatusStage>();
        int i = 0;
        while (vnodeStages != null && i < vnodeStages.size()) {
            Node nodeStage = (Node)vnodeStages.elementAt(i);
            vussStages.add(UpdateStatusStage.parse(nodeStage));
            ++i;
        }
        return vussStages;
    }

    public UpdateStatusEntry findTheInitializedEntry(String sMaintenanceName) {
        Logr.methodEntry(className, "findTheInitializedEntry");
        int i = 0;
        while (i < this.m_vuseEntries.size()) {
            UpdateStatusEntry useEntryThis = (UpdateStatusEntry)this.m_vuseEntries.elementAt(i);
            UpdateStatusEntry useEntryFound = useEntryThis.findTheInitializedEntry(sMaintenanceName);
            if (useEntryFound != null) {
                return useEntryFound;
            }
            ++i;
        }
        return null;
    }

    public String getMode() {
        Logr.methodEntry(className, "getMode");
        Vector<String> vsModes = new Vector<String>();
        int i = 0;
        while (i < this.m_vuseEntries.size()) {
            UpdateStatusEntry useEntry = (UpdateStatusEntry)this.m_vuseEntries.elementAt(i);
            vsModes.add(useEntry.getMode());
            ++i;
        }
        return UpdateStatusEntry.findHighestMode(vsModes.toArray(new String[vsModes.size()]));
    }

    public void setMode(String sMaintenanceName, String sMode) {
        Logr.methodEntry(className, "setMode");
        int i = 0;
        while (i < this.m_vuseEntries.size()) {
            UpdateStatusEntry useEntry = (UpdateStatusEntry)this.m_vuseEntries.elementAt(i);
            useEntry.setMode(sMaintenanceName, sMode);
            ++i;
        }
    }

    public static UpdateStatusStage parse(Node nodeThis) {
        Logr.methodEntry(className, "parse");
        String sStageName = nodeThis.getNodeName();
        Vector vNodes = SimpleXMLParser.getChildElements(nodeThis);
        Vector<UpdateStatusEntry> vuseEntries = new Vector<UpdateStatusEntry>();
        int i = 0;
        while (vNodes != null && i < vNodes.size()) {
            vuseEntries.add(UpdateStatusEntry.parse((Node)vNodes.elementAt(i)));
            ++i;
        }
        return new UpdateStatusStage(sStageName, vuseEntries);
    }

    public UpdateStatusStage(String sStageName, Vector vusePackages) {
        this.m_sStageName = sStageName;
        this.m_vuseEntries = vusePackages;
        if (this.m_vuseEntries == null) {
            this.m_vuseEntries = new Vector();
        }
    }

    public void initializeThisPackage(String sFileName, String sMaintenanceName, String sUritoreinstall, String sUritouninstall, boolean fIsprimary) {
        Logr.methodEntry(className, "initializeThisPackage");
        this.m_useCurrentEntry = new UpdateStatusEntry(sFileName, sMaintenanceName, sUritoreinstall, sUritouninstall, fIsprimary);
        this.m_vuseEntries.add(this.m_useCurrentEntry);
    }

    public boolean isFailed() {
        Logr.methodEntry(className, "isFailed");
        int i = 0;
        while (i < this.m_vuseEntries.size()) {
            UpdateStatusEntry usePackage = (UpdateStatusEntry)this.m_vuseEntries.elementAt(i);
            if (usePackage.isFailed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public UpdateStatusEntry getFailedPackage() {
        Logr.methodEntry(className, "getFailedPackage");
        int i = 0;
        while (i < this.m_vuseEntries.size()) {
            UpdateStatusEntry useThis = (UpdateStatusEntry)this.m_vuseEntries.elementAt(i);
            if (useThis.isFailed()) {
                return useThis;
            }
            ++i;
        }
        return null;
    }

    public void buildNode(Node nodeRoot) {
        Element elementStage = SimpleXMLParser.addNestedElement(this.getStageName(), null, null, nodeRoot);
        Vector vuseAllPackages = this.getAllPackages();
        int i = 0;
        while (vuseAllPackages != null && i < vuseAllPackages.size()) {
            UpdateStatusEntry useThis = (UpdateStatusEntry)vuseAllPackages.elementAt(i);
            useThis.buildNode(elementStage);
            ++i;
        }
    }

    public String getStageName() {
        return this.m_sStageName;
    }

    public void setStageName(String sStageName) {
        this.m_sStageName = sStageName;
    }

    public Vector getAllPackages() {
        return this.m_vuseEntries;
    }

    public void addPackage(UpdateStatusEntry usePackage) {
        this.m_vuseEntries.add(usePackage);
    }
}

