/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install.failurerecovery;

import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.install.failurerecovery.ICleaningPackagesPlugin;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class MovingFilesPlugin
extends NIFPlugin
implements ICleaningPackagesPlugin {
    private static final String className = "MovingFilesPlugin";
    private static final String S_PARAM_URISTOBECLEANED = "URIsToBeCleaned";
    private static final String S_PARAM_TARGETLOCATIONURI = "targetLocationURI";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"URIsToBeCleaned", "targetLocationURI"};
    private static final String[] AS_OPTIONAL_PARAMS = new String[0];

    @Override
    public void clean() throws NIFException {
        Logr.methodEntry(className, "clean");
        try {
            String[] asURIsToBeCleaned;
            FileSystemEntry fseTarget = this.getTargetLocation();
            if (!fseTarget.exists()) {
                fseTarget.mkdirs();
            }
            String[] stringArray = asURIsToBeCleaned = this.getListOfParamValues(S_PARAM_URISTOBECLEANED);
            int n = asURIsToBeCleaned.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                FileSystemEntry fseThis = new FileSystemEntry(new URI(element), this.getInstallToolkitBridge());
                if (fseThis.exists()) {
                    Logr.debug("Move from : " + fseThis.getAbsolutePath() + " to : " + fseTarget.getAbsolutePath());
                    fseThis.moveTo(fseTarget);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            Logr.warn(className, "clean", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "clean", e.getMessage(), e);
            throw new NIFException(e, (Throwable)e);
        }
        Logr.methodExit(className, "clean");
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    private FileSystemEntry getTargetLocation() throws IOException, URISyntaxException {
        return new FileSystemEntry(new URI(this.getParamValue(S_PARAM_TARGETLOCATIONURI)), this.getInstallToolkitBridge());
    }
}

