/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install;

import com.ibm.ws.pak.internal.NIFConstants;
import com.ibm.ws.pak.internal.NIFException;
import com.ibm.ws.pak.internal.NIFPlugin;
import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.install.NIFInstallPlugin;
import com.ibm.ws.pak.internal.install.SatelliteApplicationPlugin;
import com.ibm.ws.pak.internal.install.metadata.MaintenanceInfoPlugin;
import com.ibm.ws.pak.internal.utils.SatelliteUtils;
import com.ibm.ws.pak.internal.utils.StringUtils;
import com.ibm.ws.pak.internal.utils.componentactions.ComponentAction;
import com.ibm.ws.pak.internal.utils.events.NIFEvent;
import com.ibm.ws.pak.internal.utils.events.NIFEventMulticaster;
import com.ibm.ws.pak.internal.utils.events.NIFEventObserver;
import com.ibm.ws.pak.internal.utils.events.NIFInstallPluginEvent;
import com.ibm.ws.pak.internal.utils.events.NIFPackageApplicationPluginEvent;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystem;
import com.ibm.ws.pak.internal.utils.filesystems.FileSystemEntry;
import com.ibm.ws.pak.internal.utils.logging.Logr;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DeploySatellitesPlugin
extends NIFInstallPlugin {
    private Throwable m_eInitException = null;
    private SatelliteApplicationPlugin[] m_anifipAllSatellites = new SatelliteApplicationPlugin[0];
    private int m_nTotalComponentsToBeProcessed = -1;
    private String m_sLastComponentName = null;
    private int m_nComponentsProcessedSoFar = 0;
    private boolean m_fLastOperationFlag = false;
    private final NIFEventObserver nifeoOurNIFInstallPluginEventObserver = new NIFEventObserver(){
        {
            NIFEventMulticaster.instance().setAsFirstListner(this, 5);
        }

        @Override
        public void eventOccured(NIFEvent nife) {
            DeploySatellitesPlugin.this.handleNIFInstallEvent((NIFInstallPluginEvent)nife);
        }
    };
    private static final String S_SATELLITES_PARAM = "satellites";
    private static final String S_TASKSBEFOREDEPLOYSATELLITES_PARAM = "tasksbeforedeploysatellites";
    private static final String S_TASKSAFTERDEPLOYSATELLITES_PARAM = "tasksafterdeploysatellites";
    private static final String S_SATELLITESMETADATANAME_PARAM = "satellitesmetadataname";
    private static final String S_SATELLITESINSTALLPLUGINPATH_PARAM = "satellitesinstallpluginpath";
    private static final String S_EMBEDDEDSATELLITESDIRURI_PARAM = "embeddedsatelitesdirurl";
    private static final String S_ADDEMBEDDEDSATELLITESTAG_PARAM = "addembeddedsatellitestag";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"satellites", "satellitesmetadataname", "satellitesinstallpluginpath"};
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"embeddedsatelitesdirurl", "addembeddedsatellitestag", "tasksbeforedeploysatellites", "tasksafterdeploysatellites"};
    private static final int N_HUNDRED = 100;
    private static final String S_EMPTY = "";
    private static final String className = "DeploySatellitesPlugin";

    @Override
    public void init() {
        Logr.methodEntry(className, "init");
        super.init();
        this.reinitMemberVariables();
        try {
            if (this.shouldAddEmbeddedSatellites()) {
                this.addEmbeddedSatellites();
            }
            String[] asSatellites = StringUtils.getCollectionAsStringArray(this.getExpandedParams(this.getParamValue(S_SATELLITES_PARAM)));
            Document[] adocumentSatellites = SatelliteUtils.getSatelliteDocuments(asSatellites, this.getParamValue(S_SATELLITESMETADATANAME_PARAM), this.getInstallToolkitBridge());
            Document[] adocumentApplicable = this.initSatelliteInstallPlugins(adocumentSatellites);
            this.initTotalNumberOfComponentsToBeProcessed(adocumentApplicable);
        }
        catch (ClassNotFoundException e) {
            Logr.warn(className, "init", e.getMessage(), e);
            this.m_eInitException = e;
        }
        catch (IllegalAccessException e) {
            Logr.warn(className, "init", e.getMessage(), e);
            this.m_eInitException = e;
        }
        catch (InstantiationException e) {
            Logr.warn(className, "init", e.getMessage(), e);
            this.m_eInitException = e;
        }
        catch (IOException e) {
            Logr.warn(className, "init", e.getMessage(), e);
            this.m_eInitException = e;
        }
        catch (ParserConfigurationException e) {
            Logr.warn(className, "init", e.getMessage(), e);
            this.m_eInitException = e;
        }
        catch (SAXException e) {
            Logr.warn(className, "init", e.getMessage(), e);
            this.m_eInitException = e;
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "init", e.getMessage(), e);
            this.m_eInitException = e;
        }
        Logr.methodExit(className, "init");
    }

    @Override
    public int execute() throws NIFException {
        int nReturnCodeThis;
        Logr.methodEntry(className, "execute");
        if (this.m_eInitException != null) {
            Exception e = new Exception(this.m_eInitException);
            Logr.warn(className, "execute", e.getMessage(), e);
            throw new NIFException(this.m_eInitException.getMessage());
        }
        int nReturnCode = 0;
        try {
            nReturnCode = this.performTasksBeforeDeploySatellites();
            if (nReturnCode != 1) {
                try {
                    nReturnCode = this.backupSatellites();
                }
                finally {
                    try {
                        FileSystem.flushAllFileSystems();
                    }
                    catch (IOException e) {
                        Logr.warn(className, "execute", e.getMessage(), e);
                        throw new NIFException(e, (Throwable)e);
                    }
                }
            }
            if (nReturnCode != 1) {
                nReturnCodeThis = this.configureSatellites(false);
                nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(nReturnCode, nReturnCodeThis);
            }
            if (nReturnCode != 1) {
                nReturnCodeThis = this.installSatellites();
                nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(nReturnCode, nReturnCodeThis);
            }
            if (nReturnCode != 1) {
                nReturnCodeThis = this.configureSatellites(true);
                nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(nReturnCode, nReturnCodeThis);
            }
            NIFEventMulticaster.instance().unsubscribe(this.nifeoOurNIFInstallPluginEventObserver, 5);
        }
        finally {
            try {
                this.performTasksAfterUpgrade();
            }
            finally {
                try {
                    FileSystem.flushAllFileSystems();
                }
                catch (IOException e) {
                    Logr.warn(className, "execute", e.getMessage(), e);
                    throw new NIFException(e, (Throwable)e);
                }
            }
        }
        if (nReturnCode != 1) {
            nReturnCodeThis = this.performTasksAfterDeploySatellites();
            nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(nReturnCode, nReturnCodeThis);
        }
        Logr.methodReturn(className, "execute", new Integer(nReturnCode).toString());
        return nReturnCode;
    }

    private void performTasksAfterUpgrade() throws NIFException {
        Logr.methodEntry(className, "performTasksAfterUpgrade");
        System.setProperty("installmode", "finishing");
        int nCounter = 0;
        while (nCounter < this.m_anifipAllSatellites.length) {
            this.m_anifipAllSatellites[nCounter].execute();
            ++nCounter;
        }
        System.setProperty("installmode", "unknown");
        Logr.methodExit(className, "performTasksAfterUpgrade");
    }

    private int configureSatellites(boolean fExecuteInstallConfig) {
        Logr.methodEntry(className, "configureSatellites");
        Logr.methodExit(className, "configureSatellites");
        return 0;
    }

    protected int backupSatellites() throws NIFException {
        Logr.methodEntry(className, "backupSatellites");
        int nReturnCode = 0;
        int nCounter = 0;
        System.setProperty("installmode", "backup");
        while (nReturnCode != 1 && nCounter < this.m_anifipAllSatellites.length) {
            int nReturnCodeThis = this.m_anifipAllSatellites[nCounter].execute();
            nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(nReturnCode, nReturnCodeThis);
            ++nCounter;
        }
        System.setProperty("installmode", "unknown");
        Logr.methodReturn(className, "backupSatellites", new Integer(nReturnCode).toString());
        return nReturnCode;
    }

    protected int installSatellites() throws NIFException {
        Logr.methodEntry(className, "installSatellites");
        int nReturnCode = 0;
        int nCounter = 0;
        System.setProperty("installmode", "install");
        while (nReturnCode != 1 && nCounter < this.m_anifipAllSatellites.length) {
            int nReturnCodeThis = this.m_anifipAllSatellites[nCounter].execute();
            nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(nReturnCode, nReturnCodeThis);
            ++nCounter;
        }
        System.setProperty("installmode", "unknown");
        Logr.methodReturn(className, "installSatellites", new Integer(nReturnCode).toString());
        return nReturnCode;
    }

    @Override
    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    @Override
    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    private Document[] initSatelliteInstallPlugins(Document[] adocumentSatellites) throws IOException, SAXException, ParserConfigurationException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Logr.methodEntry(className, "initSatelliteInstallPlugins");
        Vector<Document> vdocumentApplicable = new Vector<Document>();
        Vector<SatelliteApplicationPlugin> vnifipAllSatellites = new Vector<SatelliteApplicationPlugin>();
        Document[] documentArray = adocumentSatellites;
        int n = adocumentSatellites.length;
        int n2 = 0;
        while (n2 < n) {
            Document adocumentSatellite = documentArray[n2];
            this.instantiateInfoPluginForThisNIFPackage(adocumentSatellite);
            SatelliteApplicationPlugin nifipSatelliteThis = (SatelliteApplicationPlugin)NIFInstallPlugin.getInstallPluginFor(adocumentSatellite, this.getParamValue(S_SATELLITESINSTALLPLUGINPATH_PARAM), this.getInstallToolkitBridge());
            if (nifipSatelliteThis.getCondition()) {
                vdocumentApplicable.add(adocumentSatellite);
                vnifipAllSatellites.add(nifipSatelliteThis);
            }
            ++n2;
        }
        this.m_anifipAllSatellites = vnifipAllSatellites.toArray(new SatelliteApplicationPlugin[vnifipAllSatellites.size()]);
        Document[] adocumentApplicable = new Document[vdocumentApplicable.size()];
        int i = 0;
        while (i < vdocumentApplicable.size()) {
            adocumentApplicable[i] = (Document)vdocumentApplicable.elementAt(i);
            ++i;
        }
        Logr.methodReturn(className, "initSatelliteInstallPlugins", adocumentApplicable);
        return adocumentApplicable;
    }

    private void initTotalNumberOfComponentsToBeProcessed(Document[] adocumentSatellites) throws IOException, SAXException, ParserConfigurationException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Logr.methodEntry(className, "initTotalNumberOfComponentsToBeProcessed");
        this.m_nTotalComponentsToBeProcessed = 0;
        Document[] documentArray = adocumentSatellites;
        int n = adocumentSatellites.length;
        int n2 = 0;
        while (n2 < n) {
            Document adocumentSatellite = documentArray[n2];
            this.m_nTotalComponentsToBeProcessed += ComponentAction.getTotalComponentActions(adocumentSatellite, this.getInstallToolkitBridge());
            ++n2;
        }
        Logr.methodExit(className, "initTotalNumberOfComponentsToBeProcessed");
    }

    private void instantiateInfoPluginForThisNIFPackage(Document documentNIFPackage) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException, ParserConfigurationException, SAXException {
        Logr.methodEntry(className, "instantiateInfoPluginForThisNIFPackage");
        MaintenanceInfoPlugin.getMaintenanceInfoPlugin(documentNIFPackage, this.getInstallToolkitBridge());
        Logr.methodExit(className, "instantiateInfoPluginForThisNIFPackage");
    }

    private void handleNIFInstallEvent(NIFInstallPluginEvent nifipe) {
        if (nifipe instanceof NIFPackageApplicationPluginEvent) {
            NIFPackageApplicationPluginEvent nifpapeThis = (NIFPackageApplicationPluginEvent)nifipe;
            nifpapeThis.setMessage(this.getProgressMessageText(nifpapeThis, nifpapeThis.getComponentName()));
            this.updateCountOfComponentsProcessedSoFar(nifpapeThis);
            nifpapeThis.setPercent(this.getAdjustedPercentComplete(nifpapeThis));
        }
    }

    private void updateCountOfComponentsProcessedSoFar(NIFPackageApplicationPluginEvent nifpapeThis) {
        if (!nifpapeThis.getComponentName().equals(this.m_sLastComponentName)) {
            this.m_nComponentsProcessedSoFar = this.m_nComponentsProcessedSoFar == -1 ? 0 : ++this.m_nComponentsProcessedSoFar;
        } else if (nifpapeThis.isABackupOperation() != this.m_fLastOperationFlag) {
            ++this.m_nComponentsProcessedSoFar;
        }
        this.m_sLastComponentName = nifpapeThis.getComponentName();
        this.m_fLastOperationFlag = nifpapeThis.isABackupOperation();
    }

    private String getProgressMessageText(NIFPackageApplicationPluginEvent nifpape, String componentName) {
        if (nifpape.isABackupOperation()) {
            return PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_BACKUP_MODE_PROGRESS_MESSAGE_TEXT, (Object)componentName);
        }
        if (nifpape.isABackupPackage()) {
            return PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_UNAPPLY_MODE_PROGRESS_MESSAGE_TEXT, (Object)componentName);
        }
        return PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_APPLY_MODE_PROGRESS_MESSAGE_TEXT, (Object)componentName);
    }

    private int getAdjustedPercentComplete(NIFPackageApplicationPluginEvent nifpape) {
        double dTotalPercentComplete = 0.0;
        if (nifpape.getTotalFiles() != 0) {
            double dCurrentFilePercentComplete = (double)(nifpape.getFileNumber() + 1) / ((double)nifpape.getTotalFiles() * (double)this.m_nTotalComponentsToBeProcessed * (double)this.getComponentMultiplier(nifpape));
            double dCurrentComponentPercentComplete = (double)this.m_nComponentsProcessedSoFar / ((double)this.m_nTotalComponentsToBeProcessed * (double)this.getComponentMultiplier(nifpape));
            dTotalPercentComplete = (dCurrentFilePercentComplete + dCurrentComponentPercentComplete) * 100.0;
        } else {
            dTotalPercentComplete = (double)this.m_nComponentsProcessedSoFar / ((double)this.m_nTotalComponentsToBeProcessed * (double)this.getComponentMultiplier(nifpape)) * 100.0;
        }
        return (int)dTotalPercentComplete;
    }

    private int getComponentMultiplier(NIFPackageApplicationPluginEvent nifpape) {
        if (nifpape.isABackupPackage()) {
            return 1;
        }
        return 2;
    }

    private void reinitMemberVariables() {
        this.m_eInitException = null;
        this.m_anifipAllSatellites = new SatelliteApplicationPlugin[0];
        this.m_nTotalComponentsToBeProcessed = 0;
        this.m_sLastComponentName = null;
        this.m_nComponentsProcessedSoFar = -1;
        this.m_fLastOperationFlag = false;
    }

    private void addEmbeddedSatellites() throws IOException {
        Logr.methodEntry(className, "addEmbeddedSatellites");
        String sEmbeddedSatellitesDirURI = this.getParamValue(S_EMBEDDEDSATELLITESDIRURI_PARAM);
        if (sEmbeddedSatellitesDirURI == null || sEmbeddedSatellitesDirURI.trim().equals(S_EMPTY)) {
            Logr.debug("sEmbeddedSatellitesDirURI=null || sEmbeddedSatellitesDirURI=");
            return;
        }
        URI uriEmbeddedSatellitesDirURI = null;
        try {
            uriEmbeddedSatellitesDirURI = new URI(sEmbeddedSatellitesDirURI);
        }
        catch (URISyntaxException e) {
            Logr.warn(className, "addEmbeddedSatellites", e.getMessage(), e);
            throw new IOException(e.getMessage());
        }
        FileSystemEntry fseEmbeddedSatellitesDir = new FileSystemEntry(uriEmbeddedSatellitesDirURI, this.getInstallToolkitBridge());
        FileSystemEntry[] afseEmbeddedSatellites = fseEmbeddedSatellitesDir.getEntriesDirectlyUnderThisDir();
        if (afseEmbeddedSatellites == null || afseEmbeddedSatellites.length == 0) {
            return;
        }
        String sSatelliteURIs = this.getParamValue(S_SATELLITES_PARAM);
        FileSystemEntry[] fileSystemEntryArray = afseEmbeddedSatellites;
        int n = afseEmbeddedSatellites.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystemEntry afseEmbeddedSatellite = fileSystemEntryArray[n2];
            sSatelliteURIs = String.valueOf(sSatelliteURIs) + ";" + afseEmbeddedSatellite.getURI().toString();
            ++n2;
        }
        this.setPluginParam(S_SATELLITES_PARAM, new String[]{sSatelliteURIs});
        this.setPluginParam(S_EMBEDDEDSATELLITESDIRURI_PARAM, new String[]{S_EMPTY});
        Logr.methodExit(className, "addEmbeddedSatellites");
    }

    private boolean shouldAddEmbeddedSatellites() {
        Logr.methodEntry(className, "shouldAddEmbeddedSatellites");
        Logr.methodReturn(className, "shouldAddEmbeddedSatellites", new Boolean(this.getParamValue(S_ADDEMBEDDEDSATELLITESTAG_PARAM)).toString());
        return new Boolean(this.getParamValue(S_ADDEMBEDDEDSATELLITESTAG_PARAM));
    }

    private int performTasksBeforeDeploySatellites() throws NIFException {
        Logr.methodEntry(className, "performTasksBeforeDeploySatellites");
        Logr.methodReturn(className, "performTasksBeforeDeploySatellites", new Integer(this.performTasksForDeploySatellites(S_TASKSBEFOREDEPLOYSATELLITES_PARAM)).toString());
        return this.performTasksForDeploySatellites(S_TASKSBEFOREDEPLOYSATELLITES_PARAM);
    }

    private int performTasksAfterDeploySatellites() throws NIFException {
        Logr.methodEntry(className, "performTasksAfterDeploySatellites");
        Logr.methodReturn(className, "performTasksAfterDeploySatellites", new Integer(this.performTasksForDeploySatellites(S_TASKSAFTERDEPLOYSATELLITES_PARAM)).toString());
        return this.performTasksForDeploySatellites(S_TASKSAFTERDEPLOYSATELLITES_PARAM);
    }

    private int performTasksForDeploySatellites(String sPluginPathParam) throws NIFException {
        Logr.methodEntry(className, "performTasksForDeploySatellites");
        String sTasks = this.getParamValue(sPluginPathParam);
        if (sTasks == null || sTasks.trim().length() == 0) {
            return 0;
        }
        NIFPlugin[] aplugin = null;
        try {
            aplugin = NIFInstallPlugin.getListOfInstallPluginsFor(this.getPluginDefinitionDocument(), sTasks, this.getInstallToolkitBridge());
        }
        catch (Exception e) {
            throw new NIFException(e, (Throwable)e);
        }
        if (aplugin == null || aplugin.length == 0) {
            return 0;
        }
        int nReturnCode = 0;
        int i = 0;
        while (nReturnCode != 1 && i < aplugin.length) {
            int nReturnCodeThis = ((NIFInstallPlugin)aplugin[i]).execute();
            nReturnCode = NIFConstants.getTheReturnCodeOfHigherPriority(nReturnCode, nReturnCodeThis);
            ++i;
        }
        Logr.methodReturn(className, "performTasksForDeploySatellites", new Integer(nReturnCode).toString());
        return nReturnCode;
    }
}

