/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.NodeConsumer;
import org.apache.xml.utils.XMLString;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DTMTreeWalker {
    private ContentHandler m_contentHandler = null;
    protected DTM m_dtm;
    boolean nextIsRaw = false;

    public void setDTM(DTM dTM) {
        this.m_dtm = dTM;
    }

    public ContentHandler getcontentHandler() {
        return this.m_contentHandler;
    }

    public void setcontentHandler(ContentHandler contentHandler) {
        this.m_contentHandler = contentHandler;
    }

    public DTMTreeWalker() {
    }

    public DTMTreeWalker(ContentHandler contentHandler, DTM dTM) {
        this.m_contentHandler = contentHandler;
        this.m_dtm = dTM;
    }

    public void traverse(int n) throws SAXException {
        int n2 = n;
        while (-1 != n) {
            this.startNode(n);
            int n3 = this.m_dtm.getFirstChild(n);
            while (-1 == n3) {
                this.endNode(n);
                if (n2 == n) break;
                n3 = this.m_dtm.getNextSibling(n);
                if (-1 != n3 || -1 != (n = this.m_dtm.getParent(n)) && n2 != n) continue;
                if (-1 != n) {
                    this.endNode(n);
                }
                n3 = -1;
                break;
            }
            n = n3;
        }
    }

    public void traverse(int n, int n2) throws SAXException {
        while (-1 != n) {
            this.startNode(n);
            int n3 = this.m_dtm.getFirstChild(n);
            while (-1 == n3) {
                this.endNode(n);
                if (-1 != n2 && n2 == n) break;
                n3 = this.m_dtm.getNextSibling(n);
                if (-1 != n3 || -1 != (n = this.m_dtm.getParent(n)) && (-1 == n2 || n2 != n)) continue;
                n3 = -1;
                break;
            }
            n = n3;
        }
    }

    private final void dispatachChars(int n) throws SAXException {
        this.m_dtm.dispatchCharactersEvents(n, this.m_contentHandler, false);
    }

    protected void startNode(int n) throws SAXException {
        if (this.m_contentHandler instanceof NodeConsumer) {
            // empty if block
        }
        switch (this.m_dtm.getNodeType(n)) {
            case 8: {
                XMLString xMLString = this.m_dtm.getStringValue(n);
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.m_contentHandler);
                xMLString.dispatchAsComment(lexicalHandler);
                break;
            }
            case 11: {
                break;
            }
            case 9: {
                this.m_contentHandler.startDocument();
                break;
            }
            case 1: {
                Object object;
                DTM dTM = this.m_dtm;
                int n2 = dTM.getFirstNamespaceNode(n, true);
                while (-1 != n2) {
                    object = dTM.getNodeNameX(n2);
                    this.m_contentHandler.startPrefixMapping((String)object, dTM.getNodeValue(n2));
                    n2 = dTM.getNextNamespaceNode(n, n2, true);
                }
                String string = dTM.getNamespaceURI(n);
                if (null == string) {
                    string = "";
                }
                object = new AttributesImpl();
                int n3 = dTM.getFirstAttribute(n);
                while (n3 != -1) {
                    ((AttributesImpl)object).addAttribute(dTM.getNamespaceURI(n3), dTM.getLocalName(n3), dTM.getNodeName(n3), "CDATA", dTM.getNodeValue(n3));
                    n3 = dTM.getNextAttribute(n3);
                }
                this.m_contentHandler.startElement(string, this.m_dtm.getLocalName(n), this.m_dtm.getNodeName(n), (Attributes)object);
                break;
            }
            case 7: {
                String string = this.m_dtm.getNodeName(n);
                if (string.equals("xslt-next-is-raw")) {
                    this.nextIsRaw = true;
                    break;
                }
                this.m_contentHandler.processingInstruction(string, this.m_dtm.getNodeValue(n));
                break;
            }
            case 4: {
                LexicalHandler lexicalHandler;
                boolean bl = this.m_contentHandler instanceof LexicalHandler;
                LexicalHandler lexicalHandler2 = lexicalHandler = bl ? (LexicalHandler)((Object)this.m_contentHandler) : null;
                if (bl) {
                    lexicalHandler.startCDATA();
                }
                this.dispatachChars(n);
                if (!bl) break;
                lexicalHandler.endCDATA();
                break;
            }
            case 3: {
                if (this.nextIsRaw) {
                    this.nextIsRaw = false;
                    this.m_contentHandler.processingInstruction("javax.xml.transform.disable-output-escaping", "");
                    this.dispatachChars(n);
                    this.m_contentHandler.processingInstruction("javax.xml.transform.enable-output-escaping", "");
                    break;
                }
                this.dispatachChars(n);
                break;
            }
            case 5: {
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                ((LexicalHandler)((Object)this.m_contentHandler)).startEntity(this.m_dtm.getNodeName(n));
                break;
            }
        }
    }

    protected void endNode(int n) throws SAXException {
        switch (this.m_dtm.getNodeType(n)) {
            case 9: {
                this.m_contentHandler.endDocument();
                break;
            }
            case 1: {
                String string = this.m_dtm.getNamespaceURI(n);
                if (null == string) {
                    string = "";
                }
                this.m_contentHandler.endElement(string, this.m_dtm.getLocalName(n), this.m_dtm.getNodeName(n));
                int n2 = this.m_dtm.getFirstNamespaceNode(n, true);
                while (-1 != n2) {
                    String string2 = this.m_dtm.getNodeNameX(n2);
                    this.m_contentHandler.endPrefixMapping(string2);
                    n2 = this.m_dtm.getNextNamespaceNode(n, n2, true);
                }
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (!(this.m_contentHandler instanceof LexicalHandler)) break;
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.m_contentHandler);
                lexicalHandler.endEntity(this.m_dtm.getNodeName(n));
                break;
            }
        }
    }
}

