/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.IImperativeInstruction;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.JavaClassImporter;
import com.ibm.xylem.JavaClassWrapper;
import com.ibm.xylem.JavaMethodWrapper;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.instructions.ObjectFactory;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.IConvertible;
import com.ibm.xylem.types.JavaClassInformation;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.types.UnitType;
import com.ibm.xylem.utils.SecurityUtil;
import com.ibm.xylem.utils.WrappedRuntimeException;
import com.ibm.xylem.utils.XylemError;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;

public class StaticMethodInvocationInstruction
extends NaryPrimopInstruction
implements IImperativeInstruction {
    protected String m_function;
    protected String m_class;
    protected Type m_type;

    public StaticMethodInvocationInstruction() {
    }

    public StaticMethodInvocationInstruction(String string, Instruction[] instructionArray, Type type) {
        super(instructionArray);
        this.m_function = string;
        if (type == null) {
            type = new TypeVariable();
        }
        this.setCachedType(type);
        this.m_type = type;
        this.m_class = null;
    }

    @Override
    public Type getTypeParameter(int n) {
        if (n == 0) {
            return this.m_type;
        }
        return null;
    }

    @Override
    public void setTypeParameter(int n, Type type) {
        if (n == 0) {
            this.m_type = type;
        }
    }

    @Override
    public int getTypeParameterCount() {
        return 1;
    }

    public StaticMethodInvocationInstruction(String string, String string2, Instruction[] instructionArray, Type type) {
        super(instructionArray);
        this.m_function = string2;
        if (type == null) {
            type = new TypeVariable();
        }
        this.setCachedType(type);
        this.m_type = type;
        this.m_class = string;
        if ("com.ibm.xylem.commandline.SparseStreamPopulator".equals(this.m_class)) {
            this.m_type = new JavaObjectType("Object").getStreamType();
        }
    }

    public String getFunction() {
        return this.m_function;
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.m_type;
    }

    public void setFunction(String string) {
        this.m_function = string;
    }

    public Instruction[] getParameters() {
        return this.m_parameters;
    }

    public int getParameterCount() {
        return this.m_parameters.length;
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        Instruction[] instructionArray = new Instruction[this.m_parameters.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            instructionArray[i] = this.m_parameters[i].cloneWithoutTypeInformation();
        }
        return new StaticMethodInvocationInstruction(this.m_class, this.m_function, instructionArray, this.m_type);
    }

    @Override
    public Instruction cloneShallow() {
        Instruction[] instructionArray = (Instruction[])this.m_parameters.clone();
        return new StaticMethodInvocationInstruction(this.m_class, this.m_function, instructionArray, this.m_type);
    }

    @Override
    public String innerToString() {
        return "static-method-invoke@" + (this.m_type != null ? this.m_type.prettyPrint() : "null") + " " + (this.m_class == null || this.m_class.length() == 0 ? "" : this.m_class + ".") + this.m_function;
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            String string3 = codeGenerationTracker.generateConventionally(this.m_parameters[i], dataFlowCodeGenerationHelper);
            stringBuffer.append(string3);
            if (i >= this.m_parameters.length - 1) continue;
            stringBuffer.append(", ");
        }
        Type type = this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment);
        if (UnitType.s_unitType.equals(type)) {
            dataFlowCodeGenerationHelper.append((this.m_class == null || this.m_class.length() == 0 ? "" : this.m_class + ".") + this.m_function + "(" + stringBuffer.toString() + ");\n");
            return "1";
        }
        dataFlowCodeGenerationHelper.appendAssignment(string2, type, (this.m_class == null || this.m_class.length() == 0 ? "" : this.m_class + ".") + this.m_function + "(" + stringBuffer.toString() + ")", codeGenerationTracker);
        return string2;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        JavaMethodWrapper javaMethodWrapper = this.getMethod(codeGenerationTracker.getCurrentModule().getFunction(bCELCodeGenerationHelper.getCurrentFunction()));
        if (!javaMethodWrapper.isStatic()) {
            instructionListBuilder.appendThis();
        }
        com.ibm.xtq.bcel.generic.Type[] typeArray = new com.ibm.xtq.bcel.generic.Type[this.m_parameters.length];
        for (int i = 0; i < this.m_parameters.length; ++i) {
            codeGenerationTracker.generateConventionally(this.m_parameters[i], bCELCodeGenerationHelper, null, instructionListBuilder);
            typeArray[i] = javaMethodWrapper.getParamType(i).getBCELType();
        }
        if (javaMethodWrapper.isStatic()) {
            instructionListBuilder.appendInvokeStatic(javaMethodWrapper.getDeclaringClassName(), javaMethodWrapper.getName(), javaMethodWrapper.getReturnType().getBCELType(), typeArray);
        } else {
            instructionListBuilder.appendInvokeMethod(javaMethodWrapper.getDeclaringClassName(), javaMethodWrapper.getName(), javaMethodWrapper.getReturnType().getBCELType(), typeArray);
        }
        if (UnitType.s_unitType.equals(this.m_type)) {
            instructionListBuilder.appendConstant(1);
        }
    }

    public String getClassName() {
        if (this.m_class == null) {
            int n = this.m_function.lastIndexOf(46);
            if (n == -1 || n + 1 >= this.m_function.length()) {
                throw new RuntimeException();
            }
            return this.m_function.substring(0, n);
        }
        return this.m_class;
    }

    public String getMethodName() {
        if (this.m_class == null) {
            int n = this.m_function.lastIndexOf(46);
            if (n == -1 || n + 1 >= this.m_function.length()) {
                throw new RuntimeException();
            }
            return this.m_function.substring(n + 1, this.m_function.length());
        }
        return this.m_function;
    }

    private final JavaMethodWrapper getMethod(Function function) {
        String string = this.getClassName();
        String string2 = this.getMethodName();
        try {
            int n;
            JavaClassWrapper javaClassWrapper = null;
            while (javaClassWrapper == null) {
                try {
                    javaClassWrapper = new JavaClassWrapper(ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    n = string.lastIndexOf(46);
                    if (n != -1) {
                        string = string.substring(0, n) + "$" + string.substring(n + 1, string.length());
                        continue;
                    }
                    throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.getClassName());
                }
            }
            JavaClassWrapper[] javaClassWrapperArray = new JavaClassWrapper[this.m_parameters.length];
            for (n = 0; n < this.m_parameters.length; ++n) {
                Type type = this.m_parameters[n].evaluateType(function);
                javaClassWrapperArray[n] = type.getJavaType();
            }
            JavaMethodWrapper javaMethodWrapper = JavaClassWrapper.getMethod(javaClassWrapper, string2, javaClassWrapperArray);
            return javaMethodWrapper;
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if (SecurityUtil.disableExtensionCalls()) {
            String string = this.m_class == null || this.m_class.length() == 0 ? this.m_function : this.m_class + "." + this.m_function;
            throw new XylemError("ERR_FUNCTION_CANNOT_BE_INVOKED_WHEN_JAVA_SECURITY_ENABLED", new Object[]{string, "com.ibm.xtq.processor.overrideSecureProcessing"});
        }
        String string = this.getClassName();
        String string2 = this.getMethodName();
        Object object = environment == null ? null : (Object)environment.m_statics.get(string);
        try {
            Object object2;
            JavaClassWrapper javaClassWrapper = null;
            if (object == null) {
                while (javaClassWrapper == null) {
                    try {
                        javaClassWrapper = new JavaClassWrapper(ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        int n = string.lastIndexOf(46);
                        if (n != -1) {
                            string = string.substring(0, n) + "$" + string.substring(n + 1, string.length());
                            continue;
                        }
                        throw new XylemError("ERR_SYSTEM", "Could not find class for " + this.getClassName());
                    }
                }
            } else {
                javaClassWrapper = new JavaClassWrapper(object.getClass());
            }
            Object[] objectArray = new Object[this.m_parameters.length];
            JavaClassWrapper[] javaClassWrapperArray = new JavaClassWrapper[this.m_parameters.length];
            for (int i = 0; i < this.m_parameters.length; ++i) {
                object2 = this.m_parameters[i].evaluateType(function);
                if (environment != null) {
                    objectArray[i] = this.m_parameters[i].evaluate(environment, function, iDebuggerInterceptor, false);
                    if (objectArray[i] instanceof IConvertible) {
                        objectArray[i] = ((IConvertible)objectArray[i]).convert((Type)object2);
                    }
                }
                javaClassWrapperArray[i] = ((Type)object2).getJavaType();
            }
            JavaMethodWrapper javaMethodWrapper = JavaClassWrapper.getMethod(javaClassWrapper, string2, javaClassWrapperArray);
            if (environment == null) {
                object2 = javaMethodWrapper;
                return Debugger.leave(iDebuggerInterceptor, this, environment, function, object2);
            }
            object2 = javaMethodWrapper.invoke(object, objectArray);
            Type type = this.evaluateType(function);
            Object object3 = object2 = type.createStream(object2);
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, object3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new WrappedRuntimeException(throwable);
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        StaticMethodInvocationInstruction staticMethodInvocationInstruction = (StaticMethodInvocationInstruction)object;
        return staticMethodInvocationInstruction.m_function.equals(this.m_function);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.m_function.hashCode();
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        this.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        this.typeCheckChildren(typeEnvironment, bindingEnvironment, linkedList);
        try {
            JavaClassInformation javaClassInformation = JavaClassImporter.retrieveJavaClassInformation(this.getClassName(), typeEnvironment.getModule());
            String string = this.m_function.startsWith(this.getClassName()) ? this.m_function.substring(this.getClassName().length() + 1) : this.m_function;
            Collection collection = javaClassInformation.getStaticMethods(string);
            for (JavaClassInformation.Method method : collection) {
                Type[] typeArray = method.getParameterTypes();
                if (typeArray.length != this.m_parameters.length) continue;
                TypeEnvironment typeEnvironment2 = typeEnvironment.copy();
                try {
                    int n;
                    for (n = 0; n < typeArray.length; ++n) {
                        typeEnvironment2.unify(typeArray[n], this.m_parameters[n].getCachedType(), this);
                    }
                    for (n = 0; n < typeArray.length; ++n) {
                        typeEnvironment.unify(typeArray[n], this.m_parameters[n].getCachedType(), this);
                    }
                    typeEnvironment.unify(method.getReturnType(), this.m_type, this);
                    break;
                }
                catch (TypeCheckException typeCheckException) {
                    s_logger.debug("[StaticMethodInvocationInstruction.typeCheck] method did not match.  reason: " + typeCheckException.getMessage());
                }
            }
        }
        catch (Exception exception) {
            s_logger.warn("[StaticMethodInvocationInstruction.typeCheck] cannot retrieve information for class " + this.getClassName() + " and method " + this.m_function);
            s_logger.debug(exception);
        }
        return this.setCachedType(this.m_type);
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_type = readObjectFileHelper.readType();
        this.m_function = readObjectFileHelper.readString();
        boolean bl = readObjectFileHelper.readBoolean();
        if (bl) {
            this.m_class = readObjectFileHelper.readString();
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeType(this.m_type);
        writeObjectFileHelper.writeString(this.m_function);
        writeObjectFileHelper.writeBoolean(this.m_class != null);
        if (this.m_class != null) {
            writeObjectFileHelper.writeString(this.m_class);
        }
    }
}

