/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.providers.RollbackLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.SummaryPage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class RollbackSummaryPage
extends SummaryPage {
    private final CustomMessageWizardPage.WarningId featureSetWarning = new CustomMessageWizardPage.WarningId();
    private TableViewer rollbackViewer;
    private Section detailSection;
    private Text detailText;

    public RollbackSummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.RollbackSummaryPage");
    }

    @Override
    protected void createFeatureControl(Composite container) {
        Section packagesSection = this.getToolkit().createSection(container, 512);
        packagesSection.setText(Messages.RollbackWizard_SummaryPage_RollbackSection);
        Composite packagesComposite = this.getToolkit().createComposite((Composite)packagesSection);
        TableColumnLayout tableColLayout = new TableColumnLayout();
        packagesComposite.setLayout((Layout)tableColLayout);
        packagesSection.setClient((Control)packagesComposite);
        packagesSection.setLayoutData((Object)new GridData(4, 4, true, true));
        int style = 68356;
        this.rollbackViewer = new TableViewer(packagesComposite, style);
        this.rollbackViewer.getTable().setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.heightHint = this.rollbackViewer.getTable().getItemHeight() * 3;
        this.rollbackViewer.getTable().setLayoutData((Object)gd);
        this.rollbackViewer.getTable().setLinesVisible(false);
        this.rollbackViewer.getTable().setHeaderVisible(true);
        TableColumn featureCol = new TableColumn(this.rollbackViewer.getTable(), 0x800000);
        featureCol.setText(Messages.RollbackWizard_SummaryPage_Col1);
        TableColumn packageCol = new TableColumn(this.rollbackViewer.getTable(), 0x800000);
        packageCol.setText(Messages.RollbackWizard_SummaryPage_Col2);
        TableColumn locationCol = new TableColumn(this.rollbackViewer.getTable(), 0x800000);
        locationCol.setText(Messages.InstallLocationSection_columnName);
        tableColLayout.setColumnData((Widget)featureCol, (ColumnLayoutData)new ColumnWeightData(35, 220, true));
        tableColLayout.setColumnData((Widget)packageCol, (ColumnLayoutData)new ColumnWeightData(25, 180, true));
        tableColLayout.setColumnData((Widget)locationCol, (ColumnLayoutData)new ColumnWeightData(40, 290, true));
        this.rollbackViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = RollbackSummaryPage.this.rollbackViewer.getSelection();
                if (selection != null && !selection.isEmpty() && selection instanceof StructuredSelection) {
                    StructuredSelection structuredSelection = (StructuredSelection)selection;
                    Object element = structuredSelection.getFirstElement();
                    RollbackSummaryPage.this.detailSection.setVisible(true);
                    RollbackSummaryPage.this.detailText.setText(RollbackSummaryPage.this.getDetailLabel(element));
                    RollbackSummaryPage.this.detailText.redraw();
                } else {
                    RollbackSummaryPage.this.detailText.setText("");
                    RollbackSummaryPage.this.detailText.redraw();
                    RollbackSummaryPage.this.detailSection.setVisible(false);
                }
            }
        });
        this.rollbackViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.rollbackViewer.setLabelProvider((IBaseLabelProvider)new RollbackLabelProvider());
        this.rollbackViewer.setInput(null);
    }

    private void showRollback() {
        this.rollbackViewer.getTable().removeAll();
        List jobs = this.getSelectedJobs();
        this.rollbackViewer.setInput((Object)SortUtil.sortByProfileNameAndVersion((List)jobs, (boolean)false));
        int count = this.rollbackViewer.getTable().getItemCount();
        if (count > 0) {
            Object firstItem = this.rollbackViewer.getTable().getItem(0).getData();
            this.rollbackViewer.setSelection((ISelection)new StructuredSelection(firstItem));
        } else {
            this.rollbackViewer.setSelection(null);
        }
    }

    @Override
    protected void createEnvSpaceSummaryControl(Composite container) {
        Composite comp = this.getToolkit().createComposite(container);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite subComp1 = this.getToolkit().createComposite(comp);
        GridLayout subComp1Layout = new GridLayout();
        subComp1Layout.marginWidth = 0;
        subComp1.setLayout((Layout)subComp1Layout);
        subComp1.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSpaceSummaryControl(subComp1);
        Composite subComp2 = this.getToolkit().createComposite(comp);
        GridLayout subComp2Layout = new GridLayout();
        subComp2Layout.marginWidth = 0;
        subComp2.setLayout((Layout)subComp2Layout);
        subComp2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createRollbackDetailsControl(subComp2);
    }

    private void createRollbackDetailsControl(Composite parent) {
        this.detailSection = this.getToolkit().createSection(parent, 512);
        this.detailSection.setText(com.ibm.cic.agent.core.sharedUI.Messages.DetailsPage_title);
        Composite detailComposite = this.getToolkit().createComposite((Composite)this.detailSection);
        detailComposite.setLayout((Layout)new GridLayout());
        this.detailSection.setClient((Control)detailComposite);
        this.detailSection.setLayoutData((Object)new GridData(4, 4, true, true));
        ISelection selection = this.rollbackViewer.getSelection();
        this.detailSection.setVisible(selection != null && !selection.isEmpty());
        int orignalBorderStyle = this.getToolkit().getBorderStyle();
        this.getToolkit().setBorderStyle(0);
        this.detailText = this.getToolkit().createText(detailComposite, "", 74);
        GridData data = new GridData(4, 4, true, true);
        this.detailText.setLayoutData((Object)data);
        this.getToolkit().setBorderStyle(orignalBorderStyle);
    }

    private String getDetailLabel(Object element) {
        if (element instanceof RollbackJob) {
            IOffering offering = ((RollbackJob)element).getOffering();
            return AgentUIUtils.getOfferingOrFixLabel((IOfferingOrFix)offering);
        }
        return "";
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.showRollback();
            this.reflowFor((Control)this.rollbackViewer.getTable());
            this.checkFeatureSet();
        }
        super.setVisible(visible);
    }

    private void checkFeatureSet() {
        IStatus status = SharedUIUtils.getFeatureSetCheckStatus((List)this.getSelectedJobs());
        if (status.isOK()) {
            this.setWarningState(this.featureSetWarning, null);
        } else {
            this.setWarningStateWithStatus(this.featureSetWarning, status);
        }
    }

    @Override
    protected void setFocus() {
        List jobs = this.getSelectedJobs();
        this.setPageComplete(!jobs.isEmpty());
    }
}

