/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.providers.RollbackLabelProvider;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.RebootCompletionPage;
import com.ibm.cic.common.core.model.IOffering;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RollbackCompletionPage
extends RebootCompletionPage {
    private Label rolledBackLabel;
    private TableViewer rolledBackViewer;
    private Label notRolledBackLabel;
    private TableViewer notRolledBackViewer;
    private final List<AgentJob> rolledBackPkgs = new ArrayList<AgentJob>();
    private final List<AgentJob> notRolledBackPkgs = new ArrayList<AgentJob>();

    public RollbackCompletionPage(FormToolkit toolkit, AgentUIWizard wizard, IStatus status) {
        super(toolkit, Messages.UpdateCompletionPage_title, "", wizard, status);
        super.setHelpRef("com.ibm.cic.agent.ui.RollbackCompletionPage");
    }

    @Override
    protected Composite createDetailControl(Composite container) {
        this.checkRollbackPackages();
        Composite detailComp = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComp.setLayout((Layout)gridLayout);
        detailComp.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean createTwoTables = !this.rolledBackPkgs.isEmpty() && !this.notRolledBackPkgs.isEmpty();
        Label fillerLabel1 = new Label(detailComp, 0);
        GridData data = new GridData();
        data.widthHint = createTwoTables ? 10 : 120;
        fillerLabel1.setLayoutData((Object)data);
        Composite tabelComp = new Composite(detailComp, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = createTwoTables ? 2 : 1;
        tabelComp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        tabelComp.setLayoutData((Object)gd);
        this.createDetailResultTextControl(tabelComp, layout.numColumns);
        Composite rolledbackComp = new Composite(tabelComp, 0);
        rolledbackComp.setLayout((Layout)new GridLayout());
        rolledbackComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rolledBackLabel = new Label(rolledbackComp, 0);
        int style = 101124;
        this.rolledBackViewer = new TableViewer(rolledbackComp, style);
        gd = new GridData(1808);
        gd.heightHint = this.rolledBackViewer.getTable().getItemHeight() * 6;
        this.rolledBackViewer.getTable().setLayoutData((Object)gd);
        this.rolledBackViewer.getTable().setLinesVisible(false);
        this.rolledBackViewer.getTable().setHeaderVisible(true);
        TableColumn versionCol = new TableColumn(this.rolledBackViewer.getTable(), 0x800000);
        versionCol.setText(Messages.RollbackWizard_SummaryPage_Col1);
        TableColumn packageCol = new TableColumn(this.rolledBackViewer.getTable(), 0x800000);
        packageCol.setText(Messages.RollbackWizard_SummaryPage_Col2);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, 130, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 190, true));
        this.rolledBackViewer.getTable().setLayout((Layout)tableLayout);
        this.rolledBackViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.rolledBackViewer.setLabelProvider((IBaseLabelProvider)new RollbackLabelProvider());
        this.rolledBackViewer.setInput(null);
        if (createTwoTables) {
            Composite notRolledbackComp = new Composite(tabelComp, 0);
            notRolledbackComp.setLayout((Layout)new GridLayout());
            notRolledbackComp.setLayoutData((Object)new GridData(1808));
            this.notRolledBackLabel = new Label(notRolledbackComp, 0);
            int style2 = 101124;
            this.notRolledBackViewer = new TableViewer(notRolledbackComp, style2);
            gd = new GridData(1808);
            gd.heightHint = this.rolledBackViewer.getTable().getItemHeight() * 6;
            this.notRolledBackViewer.getTable().setLayoutData((Object)gd);
            this.notRolledBackViewer.getTable().setLinesVisible(false);
            this.notRolledBackViewer.getTable().setHeaderVisible(true);
            TableColumn col1 = new TableColumn(this.notRolledBackViewer.getTable(), 0x800000);
            col1.setText(Messages.RollbackWizard_SummaryPage_Col1);
            TableColumn col2 = new TableColumn(this.notRolledBackViewer.getTable(), 0x800000);
            col2.setText(Messages.RollbackWizard_SummaryPage_Col2);
            tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, 130, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 190, true));
            this.notRolledBackViewer.getTable().setLayout((Layout)tableLayout);
            this.notRolledBackViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.notRolledBackViewer.setLabelProvider((IBaseLabelProvider)new RollbackLabelProvider());
            this.notRolledBackViewer.setInput(null);
        }
        Label fillerLabel2 = new Label(detailComp, 0);
        data = new GridData();
        data.widthHint = !this.rolledBackPkgs.isEmpty() && !this.notRolledBackPkgs.isEmpty() ? 10 : 120;
        fillerLabel2.setLayoutData((Object)data);
        return tabelComp;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.showResultText();
            this.showRollbackDetails();
            this.reflowFor((Control)this.resultText);
            this.reflowFor((Control)this.rolledBackViewer.getTable());
            if (this.notRolledBackViewer != null) {
                this.reflowFor((Control)this.notRolledBackViewer.getTable());
            }
            this.reflowFor(this.getControl());
        }
        super.setVisible(visible);
    }

    private void showResultText() {
        List jobs = this.getSelectedJobs();
        if (jobs.size() > 0) {
            if (this.result == 0) {
                this.resultText.setText(Messages.RollbackWizard_CompletionPage_Success);
            } else if (this.result == 3) {
                this.resultText.setText(Messages.RollbackWizard_CompletionPage_completeWithWarning);
            } else if (this.result == 2) {
                this.resultText.setText(Messages.RollbackWizard_CompletionPage_cancel);
            } else {
                this.resultText.setText(Messages.RollbackWizard_CompletionPage_fail);
            }
        } else {
            this.resultText.setText("");
        }
    }

    private void showRollbackDetails() {
        this.rolledBackViewer.getTable().removeAll();
        if (this.notRolledBackViewer != null) {
            this.notRolledBackViewer.getTable().removeAll();
        }
        if (!this.rolledBackPkgs.isEmpty()) {
            if (this.rolledBackPkgs.size() > 1) {
                this.rolledBackLabel.setText(Messages.RollbackWizard_CompletionPage_RollbacksSuccessLabel);
            } else {
                this.rolledBackLabel.setText(Messages.RollbackWizard_CompletionPage_RollbackSuccessLabel);
            }
            this.rolledBackViewer.setInput((Object)SortUtil.sortByProfileNameAndVersion(this.rolledBackPkgs, (boolean)false));
            if (!this.notRolledBackPkgs.isEmpty()) {
                if (this.notRolledBackPkgs.size() > 1) {
                    this.notRolledBackLabel.setText(Messages.RollbackWizard_CompletionPage_RollbacksFailLabel);
                } else {
                    this.notRolledBackLabel.setText(Messages.RollbackWizard_CompletionPage_RollbackFailLabel);
                }
                this.notRolledBackViewer.setInput((Object)SortUtil.sortByProfileNameAndVersion(this.notRolledBackPkgs, (boolean)false));
            }
        } else {
            if (this.notRolledBackPkgs.size() > 1) {
                this.rolledBackLabel.setText(Messages.RollbackWizard_CompletionPage_RollbacksFailLabel);
            } else {
                this.rolledBackLabel.setText(Messages.RollbackWizard_CompletionPage_RollbackFailLabel);
            }
            this.rolledBackViewer.setInput((Object)SortUtil.sortByProfileNameAndVersion(this.notRolledBackPkgs, (boolean)false));
        }
    }

    private void checkRollbackPackages() {
        List jobs = this.getSelectedJobs();
        int i = 0;
        while (i < jobs.size()) {
            AgentJob job = (AgentJob)jobs.get(i);
            IOffering offering = job.getOffering();
            Profile profile = job.getProfile();
            if (!profile.getProfileKind().equals("self") && !profile.getProfileKind().equals("license") && offering != null) {
                IOffering installedOffering = AgentUI.getDefault().getAgent().findInstalledOffering((IProfile)profile, offering.getIdentity());
                if (installedOffering != null && installedOffering.getVersion().equals((Object)offering.getVersion())) {
                    this.rolledBackPkgs.add(job);
                } else {
                    this.notRolledBackPkgs.add(job);
                }
            }
            ++i;
        }
    }

    @Override
    protected String getRebootRequestLabel() {
        return com.ibm.cic.agent.core.sharedUI.Messages.RebootCompletionPage_rebootRollbackLabel;
    }
}

