/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.parts.AgentRepositoryTable;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenAvailablePkgWizard;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenOfferingsInRepPage;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResponseFileGenRepositoryPage
extends AbstractCicWizardPage
implements IPropertyChangeListener {
    private static final int RepTableDefaultColWidth_Rep = 450;
    private static final int RepTableDefaultColWidth_Status = 80;
    private final List<String> repLocations = new ArrayList<String>();
    private final Map<String, List> locationProperties = new HashMap<String, List>();
    private final Map<String, Boolean> locationOpen = new HashMap<String, Boolean>();
    private final Map<String, IStatus> locationStatus = new HashMap<String, IStatus>();
    private AgentRepositoryTable repositoryTable;
    private final CicPreferenceManager prefMan = CicPreferenceManager.getInstance();
    private final ResponseFileGenAvailablePkgWizard wizard;

    public ResponseFileGenRepositoryPage(FormToolkit toolkit, String pageTitle, String pageDes, ResponseFileGenAvailablePkgWizard wizard) {
        super(pageTitle, toolkit, pageDes);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.repositoryTable = new AgentRepositoryTable(this.repLocations, this.locationProperties, this.locationOpen, this.locationStatus, 450, 80);
        this.repositoryTable.loadRepositorySettings(AgentUI.getDefault().getPreferenceStore(), this.prefMan, false);
        this.repositoryTable.createControl(container, true, false, this.getToolkit(), 1);
        this.repositoryTable.addPropertyChangeListener(this);
        this.setControl((Control)container);
        this.updateCompletionStatus();
    }

    protected void setFocus() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("OpenOrCloseRepository")) {
            this.updateCompletionStatus();
        }
    }

    private void updateCompletionStatus() {
        for (Boolean isOpen : this.locationOpen.values()) {
            if (!isOpen.booleanValue()) continue;
            this.setPageComplete(true);
            return;
        }
        this.setPageComplete(false);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public IWizardPage getNextPage() {
        final boolean[] repChanged = new boolean[1];
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    SubProgressMonitor connectedRepMon = new SubProgressMonitor(monitor, 1);
                    ResponseFileGenRepositoryPage.this.repositoryTable.addRepositoriesToGroup((IProgressMonitor)connectedRepMon);
                    repChanged[0] = ResponseFileGenRepositoryPage.this.wizard.setSelectedRepositories(RepositoryGroup.getDefault().getRepositories());
                    if (repChanged[0]) {
                        SubProgressMonitor getOfferingMon = new SubProgressMonitor(monitor, 1);
                        List offerings = UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((boolean)true, (IRepository)RepositoryGroup.getDefault(), (boolean)true, (IProgressMonitor)getOfferingMon);
                        ResponseFileGenRepositoryPage.this.wizard.setAllOfferings(offerings);
                        SubProgressMonitor getFixMon = new SubProgressMonitor(monitor, 1);
                        List fixes = RepositoryGroup.getDefault().getAllFixes((IProgressMonitor)getFixMon);
                        ResponseFileGenRepositoryPage.this.wizard.setAllFixes(fixes);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
        this.repositoryTable.getRepositoriesViewer().refresh();
        List allOfferings = this.wizard.getAllOfferings();
        List allFixes = this.wizard.getAllFixes();
        IWizardPage nextPage = this.wizard.getNextPage((IWizardPage)this);
        if (nextPage instanceof ResponseFileGenOfferingsInRepPage && repChanged[0]) {
            ResponseFileGenOfferingsInRepPage offeringPage = (ResponseFileGenOfferingsInRepPage)nextPage;
            if (allOfferings.isEmpty() && !allFixes.isEmpty()) {
                offeringPage.setShouldSkip(true);
                offeringPage.setInput(null);
                nextPage = offeringPage.getNextPage();
            } else {
                offeringPage.setShouldSkip(false);
                offeringPage.setInput(allOfferings.toArray());
            }
        }
        return nextPage;
    }
}

