/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractCicTreeDetailsWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableOfferingSection;
import com.ibm.cic.agent.internal.ui.wizards.IOfferingsInRepPage;
import com.ibm.cic.agent.internal.ui.wizards.OfferingOrFixInRepDetailPage;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenAvailablePkgWizard;
import com.ibm.cic.agent.internal.ui.wizards.ResponseFileGenFixesInRepPage;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ResponseFileGenOfferingsInRepPage
extends AbstractCicTreeDetailsWizardPage
implements IOfferingsInRepPage {
    private final List<AbstractJob> jobs = new ArrayList<AbstractJob>();
    private List lastSelectedJobs = new ArrayList();
    private final HashSet processedOfferings = new HashSet();
    private Object[] lastInput;
    private Object[] currentInput;
    protected AvailableOfferingSection offeringSection;
    protected OfferingOrFixInRepDetailPage offeringDetailPage;
    private boolean firstTimeGoNext = true;
    private final ResponseFileGenAvailablePkgWizard wizard;
    private boolean shouldSkip;

    public ResponseFileGenOfferingsInRepPage(FormToolkit toolkit, String title, String desc, ResponseFileGenAvailablePkgWizard wizard) {
        super(title, toolkit, desc);
        this.wizard = wizard;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.offeringSection = new AvailableOfferingSection(context, parent, this, false);
        return this.offeringSection;
    }

    @Override
    public IDetailsPage createDetailsSection() {
        this.offeringDetailPage = new OfferingOrFixInRepDetailPage();
        return this.offeringDetailPage;
    }

    @Override
    public void refreshDetailPage() {
        if (this.offeringDetailPage != null) {
            this.offeringDetailPage.refreshDetails();
        }
    }

    @Override
    public List getJobs() {
        return this.jobs;
    }

    @Override
    public IWizardPage getNextPage() {
        List currentSelectedJobs = AgentUIUtils.getSelectedJobs(this.getJobs());
        boolean refreshFixTreeViewer = true;
        if (Arrays.deepEquals(this.lastSelectedJobs.toArray(), currentSelectedJobs.toArray()) && !this.wizard.getFixChanged() && !this.firstTimeGoNext) {
            refreshFixTreeViewer = false;
        }
        this.firstTimeGoNext = false;
        IWizardPage nextPage = this.wizard.getNextPage((IWizardPage)this);
        this.lastSelectedJobs = currentSelectedJobs;
        ArrayList<AbstractJob> fixJobList = new ArrayList<AbstractJob>();
        if (refreshFixTreeViewer) {
            fixJobList.addAll(this.genFixJobs());
        }
        if (nextPage instanceof ResponseFileGenFixesInRepPage) {
            ResponseFileGenFixesInRepPage fixPage = (ResponseFileGenFixesInRepPage)nextPage;
            fixPage.setRebuildFixTree(refreshFixTreeViewer);
            if (refreshFixTreeViewer) {
                fixPage.setFixJobs(fixJobList);
                if (fixJobList.isEmpty()) {
                    fixPage.setShouldSkip(true);
                    return this.wizard.getNextPage((IWizardPage)fixPage);
                }
                fixPage.setShouldSkip(false);
                return fixPage;
            }
            if (fixPage.shouldSkip()) {
                return this.wizard.getNextPage((IWizardPage)fixPage);
            }
            return fixPage;
        }
        return this;
    }

    private List<AbstractJob> genFixJobs() {
        ArrayList<AbstractJob> fixJobs = new ArrayList<AbstractJob>();
        List allFixes = this.wizard.getAllFixes();
        for (IFix fix : allFixes) {
            AbstractJob fixJob = this.wizard.createJob((IOfferingOrFix)fix);
            if (AgentUIUtils.inExistingFixJobs((AgentJob)fixJob, fixJobs, false)) continue;
            fixJobs.add(fixJob);
        }
        return fixJobs;
    }

    @Override
    public void setFocus() {
        if (!Arrays.deepEquals(this.lastInput, this.currentInput)) {
            this.offeringSection.resetTreeViewer();
        }
    }

    @Override
    public AbstractJob createJob(IOfferingOrFix offeringOrFix) {
        return this.wizard.createJob(offeringOrFix);
    }

    public boolean isPageComplete() {
        if (this.shouldSkip) {
            return true;
        }
        for (AbstractJob job : this.jobs) {
            if (!job.isSelected()) continue;
            return true;
        }
        List allFixes = this.wizard.getAllFixes();
        return allFixes != null && !allFixes.isEmpty();
    }

    @Override
    public Set getProcessedOfferings() {
        return this.processedOfferings;
    }

    public void setInput(Object[] inputElements) {
        this.lastInput = this.currentInput;
        this.currentInput = inputElements;
        this.jobs.clear();
        this.processedOfferings.clear();
        this.lastSelectedJobs.clear();
        if (inputElements != null) {
            Object[] objectArray = inputElements;
            int n = inputElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof IOffering && this.processedOfferings.add(item)) {
                    IOffering offering = (IOffering)item;
                    AbstractJob job = this.wizard.createJob((IOfferingOrFix)offering);
                    this.jobs.add(job);
                }
                ++n2;
            }
        }
    }

    public boolean shouldSkip() {
        return this.shouldSkip;
    }

    public void setShouldSkip(boolean shouldSkip) {
        this.shouldSkip = shouldSkip;
    }

    @Override
    public OfferingOrFixInRepDetailPage getDetailPage() {
        return this.offeringDetailPage;
    }

    @Override
    public void setSelection(Object[] selectedObjects) {
        this.wizard.setOfferingSelections(Arrays.asList(selectedObjects));
        this.wizard.getContainer().updateButtons();
    }

    @Override
    public void setOfferingOrFixLicenseTypeMap(Map offeringOrFixLicenseTypeMap) {
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }
}

