/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.InstallOfferingJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.LicenseImportHelper;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIWizardPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.LicenseDetailsPanel;
import com.ibm.cic.agent.internal.ui.wizards.LicenseImportWizard;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.UserFeedback;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.misc.PaUserFeedbackProvider;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LicenseImportPage
extends AbstractAgentUIWizardPage {
    private static final String LUMKIT_EXTENSION = CicConstants.getJarFileDotExt();
    private static final String LUMKIT_EXTENSION_FILTER = "*" + LUMKIT_EXTENSION;
    private Text pathText;
    private boolean canAdvance = false;
    private LicenseDetailsPanel details;
    private Font boldFont;
    private final IOffering selectedOffering;
    private boolean hasPrepared = false;
    private final IOffering initPEKOffering;
    private AbstractJob initImportPEKJob;
    private final IFeatureBase featureOrGroup;
    private IDialogSettings dialogSettings;
    private static final String lastBrowsedPath = "lastBrowsedPath";

    public LicenseImportPage(FormToolkit toolkit, AgentUIWizard wizard, IOffering offering, IFeatureBase featureOrGroup, IOffering intPEKOffering) {
        super(com.ibm.cic.agent.internal.ui.licenses.Messages.LicenseImportPage_title, toolkit, Messages.LicenseManagementWizard_packagesTitle, Messages.LicenseImportPage_header, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.LicenseImportPage");
        this.selectedOffering = offering;
        this.initPEKOffering = intPEKOffering;
        this.featureOrGroup = featureOrGroup;
        if (intPEKOffering != null) {
            this.initImportPEKJob = this.generateImportPEKJob(this.initPEKOffering);
        }
        IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
    }

    private AbstractJob generateImportPEKJob(IOffering pekOffering) {
        Logger.getGlobalLogger().statusNotOK(RepositoryUtils.resolve((IOfferingOrFix)pekOffering, (IProgressMonitor)new NullProgressMonitor()));
        InstallOfferingJob job = new InstallOfferingJob(pekOffering);
        job.setFeatures((Collection)pekOffering.getFeatureGroup().getChildren());
        Profile licprofile = Profile.getLicenseProfile((Agent)AgentUI.getDefault().getAgent());
        job.setProfile(licprofile);
        return job;
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = this.toolkit.createComposite(parent, 0);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout());
        this.createMessageSection(container);
        this.createPathSection(container);
        this.createDetailTitle(container);
        this.details = new LicenseDetailsPanel(this.getToolkit());
        this.details.createControl(container);
        if (this.initImportPEKJob != null) {
            this.details.setInput(this.initImportPEKJob);
        }
        this.setControl((Control)container);
    }

    private void createMessageSection(Composite parent) {
        Composite messageComp = this.getToolkit().createComposite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = 5;
        layout.marginBottom = 5;
        messageComp.setLayout((Layout)layout);
        messageComp.setLayoutData((Object)new GridData(768));
        Label infoIcon = this.toolkit.createLabel(messageComp, "", 0);
        infoIcon.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        infoIcon.setImage(DisplayKeeper.INSTANCE.getDisplay().getSystemImage(2));
        Label browseMsg = this.getToolkit().createLabel(messageComp, Messages.importPermanentOffering_browseOrSearch, 64);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalIndent = 5;
        browseMsg.setLayoutData((Object)data);
        Label fillerLabel = this.toolkit.createLabel(messageComp, "");
        data = new GridData(768);
        data.horizontalSpan = 2;
        fillerLabel.setLayoutData((Object)data);
        final Link msgLink = new Link(messageComp, 0);
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        msgLink.setLayoutData((Object)data);
        msgLink.setText(NLS.bind((String)Messages.importPermanentOffering_checkRepositories, (Object)Messages.importPermanentOffering_repositoryPage));
        msgLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mainId = "com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage";
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)msgLink.getShell(), (String)mainId, (String[])new String[]{"com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage"}, null);
                if (dlg.open() == 0) {
                    LicenseImportPage.this.search();
                }
            }
        });
    }

    private void createPathSection(Composite parent) {
        Composite pathComposite = this.getToolkit().createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        pathComposite.setLayout((Layout)gridLayout);
        pathComposite.setLayoutData((Object)new GridData(768));
        Label pathLabel = this.getToolkit().createLabel(pathComposite, Messages.LicenseImportPage_path);
        pathLabel.setFont(this.getBoldFont());
        GridData labelData = new GridData();
        labelData.horizontalSpan = 3;
        pathLabel.setLayoutData((Object)labelData);
        this.pathText = this.getToolkit().createText(pathComposite, "", 2056);
        GridData textData = new GridData(768);
        this.pathText.setLayoutData((Object)textData);
        this.pathText.setEnabled(false);
        Button browseButton = this.getToolkit().createButton(pathComposite, Messages.LicenseImportPage_browse, 8);
        Button searchButton = this.getToolkit().createButton(pathComposite, Messages.importPermanentOffering_serachButton, 8);
        if (this.initPEKOffering != null) {
            String repLocation = TextProcessor.process((String)this.initPEKOffering.getRepository().getLocationStr());
            this.pathText.setText(repLocation);
            this.validatePEKOffering(this.initImportPEKJob);
        }
        browseButton.addSelectionListener((SelectionListener)new BrowseListener());
        searchButton.addSelectionListener((SelectionListener)new SearchListener());
    }

    private void createDetailTitle(Composite parent) {
        Composite inner = this.toolkit.createComposite(parent);
        GridData innerData = new GridData(768);
        inner.setLayoutData((Object)innerData);
        GridLayout innerLayout = new GridLayout();
        innerLayout.marginWidth = 0;
        inner.setLayout((Layout)innerLayout);
        Label detailsLabel = this.toolkit.createLabel(inner, Messages.LicenseImportPage_details);
        detailsLabel.setFont(this.getBoldFont());
    }

    private LicenseImportWizard getLicenseImportWizard() {
        AgentUIWizard wizard = this.getAgentWizard();
        return (LicenseImportWizard)wizard;
    }

    private IRepositoryGroup getLicenseRepositoryGroup() {
        return this.getLicenseImportWizard().getLicenseRepositoryGroup();
    }

    private void pathChanged() {
        String path = this.pathText.getText().trim();
        String deprocessedPath = TextProcessor.deprocess((String)path);
        InstallOfferingJob importJob = null;
        if (deprocessedPath.length() == 0) {
            this.invalidState(null);
        } else if (!deprocessedPath.endsWith(LUMKIT_EXTENSION)) {
            this.invalidState(Messages.LicenseImportPage_notJarFile);
        } else {
            File zipfile = new File(deprocessedPath);
            if (!zipfile.exists()) {
                this.invalidState(Messages.LicenseImportPage_invalidPath);
            } else {
                importJob = new LicenseImportHelper().getInstallJob(this.getLicenseRepositoryGroup(), zipfile);
                if (importJob == null) {
                    this.invalidState(Messages.LicenseImportPage_noLicenses);
                } else {
                    this.validatePEKOffering((AbstractJob)importJob);
                }
            }
        }
        this.getContainer().updateButtons();
        this.details.setInput((AbstractJob)importJob);
    }

    public boolean shouldSkip() {
        if (this.initImportPEKJob != null) {
            if (!LicenseUtils.isPekApplicableToOffering((IOffering)this.initPEKOffering, (IOffering)this.selectedOffering) || this.featureOrGroup != null && !LicenseUtils.isPekApplicableToFeature((IOffering)this.initPEKOffering, (IOffering)this.selectedOffering, (IFeatureBase)this.featureOrGroup)) {
                return false;
            }
            IStatus status = Status.OK_STATUS;
            if (!this.hasPrepared) {
                boolean useWizardGroup;
                Agent agent = AgentUI.getDefault().getAgent();
                Agent.SetRestoreExternalAgentGroup agentGroupSetAndRestore = null;
                boolean bl = useWizardGroup = !this.getLicenseRepositoryGroup().getRepositories().isEmpty();
                if (!useWizardGroup) {
                    agentGroupSetAndRestore = new Agent.SetRestoreExternalAgentGroup(agent, this.getLicenseRepositoryGroup());
                }
                try {
                    status = AgentUI.getDefault().prepareOfferings(new IOfferingOrFix[]{this.initPEKOffering, this.selectedOffering});
                }
                finally {
                    if (agentGroupSetAndRestore != null) {
                        agentGroupSetAndRestore.restorePreviousAgentGroup();
                    }
                }
            }
            if (status.isOK()) {
                this.hasPrepared = true;
                List jobs = this.getAgentWizard().getJobs();
                jobs.clear();
                jobs.add(this.initImportPEKJob);
                InstallOfferingJob installedOfferingJob = new InstallOfferingJob(this.selectedOffering);
                jobs.add(installedOfferingJob);
                HashMap<IOffering, String> map = new HashMap<IOffering, String>();
                String[] licenseType = LicenseUtils.getUnlocalizedLicenseKindsArray((IOffering)this.initPEKOffering);
                if (licenseType != null && licenseType.length > 0) {
                    if (licenseType[0].equals("perm")) {
                        map.put(this.initPEKOffering, "PERMANENT");
                        map.put(this.selectedOffering, "PERMANENT");
                    } else if (licenseType[0].equals("term")) {
                        map.put(this.initPEKOffering, "TERM");
                        map.put(this.selectedOffering, "TERM");
                    }
                }
                this.getAgentWizard().setOfferingOrFixLicenseTypeMap(map);
                return true;
            }
            this.hasPrepared = false;
            return false;
        }
        return super.shouldSkip();
    }

    private void validatePEKOffering(AbstractJob importJob) {
        IOffering licenseOffering = importJob.getOffering();
        if (!LicenseUtils.isPekApplicableToOffering((IOffering)licenseOffering, (IOffering)this.selectedOffering) || this.featureOrGroup != null && !LicenseUtils.isPekApplicableToFeature((IOffering)licenseOffering, (IOffering)this.selectedOffering, (IFeatureBase)this.featureOrGroup)) {
            if (this.featureOrGroup == null) {
                this.invalidState(NLS.bind((String)Messages.LicenseImportPage_wrongLicenseFile, (Object)this.selectedOffering.getName()));
            } else if (this.featureOrGroup instanceof IFeatureGroup) {
                this.invalidState(NLS.bind((String)Messages.LicenseImportPage_wrongLicenseForFeatureGroup, (Object)this.selectedOffering.getName(), (Object)SharedUIUtils.getFeatureBaseLabel((IFeatureBase)this.featureOrGroup)));
            } else if (this.featureOrGroup instanceof IFeature) {
                this.invalidState(NLS.bind((String)Messages.LicenseImportPage_wrongLicenseForFeature, (Object)this.selectedOffering.getName(), (Object)SharedUIUtils.getFeatureBaseLabel((IFeatureBase)this.featureOrGroup)));
            }
        } else {
            boolean useWizardGroup;
            this.setErrorMessage(null);
            List jobs = this.getAgentWizard().getJobs();
            jobs.clear();
            jobs.add(importJob);
            InstallOfferingJob installedOfferingJob = new InstallOfferingJob(this.selectedOffering);
            jobs.add(installedOfferingJob);
            HashMap<IOffering, String> map = new HashMap<IOffering, String>();
            String[] licenseType = LicenseUtils.getUnlocalizedLicenseKindsArray((IOffering)licenseOffering);
            if (licenseType != null && licenseType.length > 0) {
                if (licenseType[0].equals("perm")) {
                    map.put(licenseOffering, "PERMANENT");
                    map.put(this.selectedOffering, "PERMANENT");
                } else if (licenseType[0].equals("term")) {
                    map.put(licenseOffering, "TERM");
                    map.put(this.selectedOffering, "TERM");
                }
            }
            this.getAgentWizard().setOfferingOrFixLicenseTypeMap(map);
            Agent agent = AgentUI.getDefault().getAgent();
            Agent.SetRestoreExternalAgentGroup agentGroupSetAndRestore = null;
            boolean bl = useWizardGroup = !this.getLicenseRepositoryGroup().getRepositories().isEmpty();
            if (useWizardGroup) {
                agentGroupSetAndRestore = new Agent.SetRestoreExternalAgentGroup(agent, this.getLicenseRepositoryGroup());
            }
            try {
                IStatus status = null;
                if (!this.hasPrepared) {
                    status = AgentUI.getDefault().prepareOfferings(new IOfferingOrFix[]{licenseOffering, this.selectedOffering});
                    this.hasPrepared = true;
                } else {
                    status = AgentUI.getDefault().prepareOfferings(new IOfferingOrFix[]{licenseOffering});
                }
                this.canAdvance = status.isOK();
            }
            finally {
                if (agentGroupSetAndRestore != null) {
                    agentGroupSetAndRestore.restorePreviousAgentGroup();
                }
            }
        }
    }

    private void search() {
        IStatus[] status;
        IOffering[] pekOffering;
        block11: {
            pekOffering = new IOffering[1];
            status = new IStatus[]{Status.OK_STATUS};
            UserFeedbackProvider oldProvider = null;
            try {
                oldProvider = UserFeedback.setProvider((UserFeedbackProvider)new PaUserFeedbackProvider());
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(com.ibm.cic.agent.internal.console.Messages.ProgressDialog_Obtain_offerings, 5);
                        status[0] = AgentUI.getDefault().getAgent().getRepositoryGroupStatus(true, monitor);
                        if (status[0].matches(8)) {
                            monitor.done();
                        } else if (monitor.isCanceled()) {
                            status[0] = Status.CANCEL_STATUS;
                            monitor.done();
                        } else {
                            monitor.worked(1);
                            List offerings = UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((IRepository)Agent.getInstance().getRepositoryGroup(), (boolean)true, (IProgressMonitor)monitor);
                            monitor.worked(3);
                            if (monitor.isCanceled()) {
                                status[0] = Status.CANCEL_STATUS;
                                monitor.done();
                            } else {
                                int i = 0;
                                while (i < offerings.size()) {
                                    IOffering offering;
                                    IOfferingOrFix offeringOrFix = (IOfferingOrFix)offerings.get(i);
                                    if (offeringOrFix instanceof IOffering && LicenseUtils.isPEKOffering((IOffering)(offering = (IOffering)offeringOrFix)) && LicenseUtils.isPekApplicableToOffering((IOffering)offering, (IOffering)LicenseImportPage.this.selectedOffering)) {
                                        if (LicenseImportPage.this.featureOrGroup != null) {
                                            if (LicenseUtils.isPekApplicableToFeature((IOffering)offering, (IOffering)LicenseImportPage.this.selectedOffering, (IFeatureBase)LicenseImportPage.this.featureOrGroup)) {
                                                pekOffering[0] = offering;
                                                break;
                                            }
                                        } else {
                                            pekOffering[0] = offering;
                                            break;
                                        }
                                    }
                                    ++i;
                                }
                                monitor.done();
                            }
                        }
                    }
                });
            }
            catch (InvocationTargetException ex) {
                AgentUI.reportException(ex);
                UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
                break block11;
            }
            catch (InterruptedException interruptedException) {
                try {}
                catch (Throwable throwable) {
                    UserFeedback.setProvider(oldProvider);
                    throw throwable;
                }
                UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
                break block11;
            }
            UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
        }
        if (!status[0].matches(8)) {
            if (pekOffering[0] != null) {
                String repLocation = TextProcessor.process((String)pekOffering[0].getRepository().getLocationStr());
                this.pathText.setText(repLocation);
                AbstractJob importJob = this.generateImportPEKJob(pekOffering[0]);
                this.validatePEKOffering(importJob);
                this.details.setInput(importJob);
            } else if (status[0].matches(4)) {
                this.pathText.setText("");
                this.details.setInput(null);
                this.invalidState(Messages.importPermanentOffering_repositoriesNotAccessible);
            } else {
                this.pathText.setText("");
                this.details.setInput(null);
                this.invalidState(Messages.importPermanentOffering_noPEKOfferingFound);
            }
        }
        this.getContainer().updateButtons();
    }

    private void invalidState(String errorMessage) {
        this.getAgentWizard().getJobs().clear();
        this.canAdvance = false;
        this.setErrorMessage(errorMessage);
    }

    public boolean canFlipToNextPage() {
        return this.canAdvance;
    }

    public boolean isPageComplete() {
        return this.canAdvance;
    }

    private Font getBoldFont() {
        if (this.boldFont == null) {
            FontData[] fontdata = JFaceResources.getDefaultFont().getFontData();
            this.boldFont = JFaceResources.getFontRegistry().getBold(fontdata[0].getName());
        }
        return this.boldFont;
    }

    public class BrowseListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            String path;
            String lastPath = LicenseImportPage.this.dialogSettings.get(LicenseImportPage.lastBrowsedPath);
            String pathFilter = null;
            if (lastPath != null) {
                File file = new File(lastPath);
                if (file.isFile()) {
                    pathFilter = file.getParent();
                } else if (file.isDirectory()) {
                    pathFilter = lastPath;
                }
            }
            if ((path = UiServices.getInstance().getFileDialog(AgentUI.getActiveWorkbenchShell()).filterExtensions(new String[]{LUMKIT_EXTENSION_FILTER}).filterPath(pathFilter).run()) != null) {
                LicenseImportPage.this.dialogSettings.put(LicenseImportPage.lastBrowsedPath, path);
                String processedPath = TextProcessor.process((String)path);
                LicenseImportPage.this.pathText.setText(processedPath);
                LicenseImportPage.this.pathChanged();
            }
        }
    }

    public class SearchListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            LicenseImportPage.this.search();
        }
    }
}

