/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreeFixNode;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreePackageNode;
import com.ibm.cic.agent.internal.ui.utils.InstalledOfferingTreeProfileNode;
import com.ibm.cic.agent.internal.ui.utils.ProfileNode;
import com.ibm.cic.agent.internal.ui.wizards.CheckboxTreeMasterSection;
import com.ibm.cic.agent.internal.ui.wizards.IInstalledOfferingsPage;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class InstalledOfferingSection
extends CheckboxTreeMasterSection {
    private JobContentProvider contentProvider;
    private Map<Profile, InstalledOfferingTreeProfileNode> profilesMap;
    private final IInstalledOfferingsPage wizardPage;
    private int validProfileNumber = 0;

    public InstalledOfferingSection(IFormContext context, Composite parent, IInstalledOfferingsPage wizardPage) {
        super(context, parent, 4096, new String[]{Messages.LogFilterDialog_selectAllBtn, Messages.LogFilterDialog_deselectAllBtn}, 256);
        this.wizardPage = wizardPage;
        this.configureViewer((TreeViewer)this.getCheckboxTreeViewer());
        this.getSection().setText(Messages.InstalledOfferingSection_header);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.doSelectAll(true);
                break;
            }
            case 1: {
                this.doSelectAll(false);
                break;
            }
        }
    }

    private TreeItem getFirstCheckedItem(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = tree.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem[] packageItems;
                TreeItem item = treeItemArray[n2];
                TreeItem[] treeItemArray2 = packageItems = item.getItems();
                int n3 = packageItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem[] fixItems;
                    TreeItem packageItem = treeItemArray2[n4];
                    if (packageItem.getChecked()) {
                        return packageItem;
                    }
                    TreeItem[] treeItemArray3 = fixItems = packageItem.getItems();
                    int n5 = fixItems.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        TreeItem fixItem = treeItemArray3[n6];
                        if (fixItem.getChecked()) {
                            return fixItem;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void primeSelection() {
        TreeViewer viewer = this.getTreePart().getTreeViewer();
        if (viewer != null) {
            TreeItem firstCheckedPkgItem = this.getFirstCheckedItem(viewer);
            if (firstCheckedPkgItem != null) {
                viewer.setSelection((ISelection)new StructuredSelection(firstCheckedPkgItem.getData()));
            } else {
                TreeItem item;
                Tree tree = viewer.getTree();
                if (tree.getItemCount() > 0 && (item = tree.getItem(0)).getItemCount() > 0) {
                    TreeItem childItem = item.getItem(0);
                    viewer.setSelection((ISelection)new StructuredSelection(childItem.getData()));
                }
            }
        }
    }

    private void checkDefaultTreeNodes() {
        Object[] roots = this.getRootNodes();
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            InstalledOfferingTreeProfileNode profileNode = (InstalledOfferingTreeProfileNode)root;
            if (profileNode.isValid()) {
                ++this.validProfileNumber;
            }
            for (InstalledOfferingTreePackageNode packageNode : profileNode.getPackages()) {
                if (packageNode.isSelected() && packageNode.isValid()) {
                    this.elementChecked(viewer, packageNode, true);
                    this.updateParents(viewer, packageNode.getProfileNode(), true);
                } else if (packageNode.isSelected() && !packageNode.isValid()) {
                    packageNode.setSelected(false);
                    DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)AgentUI.getActiveWorkbenchShell(), (String)Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, (String)Messages.InstalledOfferingPage_uninstallIM_msg);
                        }
                    });
                }
                for (InstalledOfferingTreeFixNode fixNode : packageNode.getFixes()) {
                    if (!fixNode.isSelected()) continue;
                    this.updateItem(viewer, fixNode, true);
                }
            }
            ++n2;
        }
    }

    @Override
    protected void checkItem(CheckboxTreeViewer viewer, Object element, boolean checked, boolean grayed) {
        super.checkItem(viewer, element, checked, grayed);
        if (element instanceof InstalledOfferingTreePackageNode) {
            ((InstalledOfferingTreePackageNode)element).setSelected(checked);
        } else if (element instanceof InstalledOfferingTreeFixNode) {
            InstalledOfferingTreeFixNode fixNode = (InstalledOfferingTreeFixNode)element;
            fixNode.setSelected(checked);
            IFix fix = fixNode.getFix();
            InstalledOfferingTreeProfileNode profileNode = null;
            InstalledOfferingTreePackageNode pkgNode = fixNode.getPackageNode();
            if (pkgNode != null) {
                profileNode = pkgNode.getProfileNode();
            }
            if (profileNode != null) {
                List pkgNodeList = profileNode.getPackages();
                int i = 0;
                while (i < pkgNodeList.size()) {
                    InstalledOfferingTreePackageNode packageNode = (InstalledOfferingTreePackageNode)pkgNodeList.get(i);
                    IOffering offering = packageNode.getOffering();
                    if (FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) {
                        List fixNodeList = packageNode.getFixes();
                        int j = 0;
                        while (j < fixNodeList.size()) {
                            InstalledOfferingTreeFixNode fNode = (InstalledOfferingTreeFixNode)fixNodeList.get(j);
                            if (fixNode != fNode && fix.equals(fNode.getFix())) {
                                if (checked) {
                                    if (!viewer.getChecked((Object)fNode)) {
                                        super.checkItem(viewer, fNode, checked, grayed);
                                    }
                                } else if (viewer.getChecked((Object)fNode)) {
                                    if (!this.wizardPage.fixDependOnOffering()) {
                                        super.checkItem(viewer, fNode, checked, grayed);
                                    } else {
                                        super.checkItem(viewer, fNode, false, false);
                                        InstalledOfferingTreePackageNode parentNode = fNode.getPackageNode();
                                        this.checkItem(viewer, parentNode, false, false);
                                        this.updateParents(viewer, this.getParent(parentNode), false);
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        Tree tree;
        super.configureViewer(viewer);
        this.contentProvider = new JobContentProvider();
        viewer.setLabelProvider((IBaseLabelProvider)new JobLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setSorter((ViewerSorter)new OfferingSorter());
        this.createColumns(viewer);
        this.profilesMap = this.wizardPage.generateInput();
        viewer.setInput((Object)this.getRootNodes());
        viewer.expandAll();
        this.checkDefaultTreeNodes();
        this.wizardPage.defaultChecked();
        if (this.validProfileNumber <= 0) {
            this.getTreePart().setButtonEnabled(0, false);
            this.getTreePart().setButtonEnabled(1, false);
        }
        if ((tree = viewer.getTree()).getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            tree.setTopItem(item);
        }
    }

    private boolean containsUnselected(CheckboxTreeViewer viewer, Object element) {
        Object[] children = this.getChildren(element);
        int i = 0;
        while (i < children.length) {
            if (!viewer.getChecked(children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private TreeColumn createColumn(Tree tree, String name, int width) {
        TreeColumn column = new TreeColumn(tree, 0x800000);
        column.setText(name);
        column.setWidth(width);
        column.setResizable(true);
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        this.createColumn(tree, Messages.InstalledOfferingSection_columnName, 350);
        this.createColumn(tree, Messages.InstalledOfferingSection_columnVersion, 150);
        this.createColumn(tree, Messages.InstalledOfferingSection_columnVendor, 80);
    }

    private void doSelectAll(boolean checked) {
        Object[] roots = this.getRootNodes();
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            InstalledOfferingTreeProfileNode profileNode = (InstalledOfferingTreeProfileNode)root;
            if (profileNode.isValid()) {
                for (InstalledOfferingTreePackageNode packageNode : profileNode.getPackages()) {
                    for (InstalledOfferingTreeFixNode fixNode : packageNode.getFixes()) {
                        this.updateItem(viewer, fixNode, checked);
                    }
                    this.elementChecked(viewer, packageNode, checked);
                    this.updateParents(viewer, packageNode.getProfileNode(), checked);
                }
            }
            ++n2;
        }
        this.wizardPage.checkStatusChanged(checked);
    }

    @Override
    protected void elementChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (element instanceof ProfileNode && !(checked = this.containsUnselected(viewer, element))) {
            Object[] children;
            Object[] objectArray = children = this.getChildren(element);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.elementChecked(viewer, child, checked);
                ++n2;
            }
            this.updateItem(viewer, element, checked);
            return;
        }
        super.elementChecked(viewer, element, checked);
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getCheckboxTreeViewer().getLabelProvider();
    }

    private Object[] getRootNodes() {
        return this.profilesMap.values().toArray();
    }

    @Override
    protected void onCheckStateChange(CheckStateChangedEvent event) {
        Object selectedItem;
        StructuredSelection strutSelection;
        Object element = event.getElement();
        if (element instanceof InstalledOfferingTreeProfileNode) {
            if (!((InstalledOfferingTreeProfileNode)element).isValid()) {
                boolean checked = event.getChecked();
                if (checked) {
                    CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
                    viewer.setChecked(element, false);
                }
                return;
            }
        } else if (element instanceof InstalledOfferingTreePackageNode && !((InstalledOfferingTreePackageNode)element).isValid()) {
            boolean checked = event.getChecked();
            if (checked) {
                CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
                viewer.setChecked(element, false);
            }
            return;
        }
        if (element instanceof InstalledOfferingTreeFixNode) {
            CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
            if (!this.wizardPage.fixDependOnOffering()) {
                this.elementChecked(viewer, element, event.getChecked());
            } else if (event.getChecked()) {
                this.elementChecked(viewer, element, event.getChecked());
            } else {
                InstalledOfferingTreeFixNode fixNode = (InstalledOfferingTreeFixNode)element;
                this.elementChecked(viewer, element, event.getChecked());
                InstalledOfferingTreePackageNode parentNode = fixNode.getPackageNode();
                this.checkItem(viewer, parentNode, false, false);
                this.updateParents(viewer, this.getParent(parentNode), event.getChecked());
            }
        } else {
            super.onCheckStateChange(event);
        }
        boolean resetSelection = true;
        ISelection selection = this.getCheckboxTreeViewer().getSelection();
        if (selection != null && selection instanceof StructuredSelection && (strutSelection = (StructuredSelection)selection).size() == 1 && (selectedItem = strutSelection.getFirstElement()).equals(event.getElement())) {
            resetSelection = false;
        }
        if (resetSelection) {
            this.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection(event.getElement()));
        }
        this.wizardPage.checkStatusChanged(event.getChecked());
    }

    private static class JobContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private JobContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof InstalledOfferingTreeProfileNode) {
                return ((InstalledOfferingTreeProfileNode)parentElement).getPackages().toArray();
            }
            if (parentElement instanceof InstalledOfferingTreePackageNode) {
                return ((InstalledOfferingTreePackageNode)parentElement).getFixes().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public Object getParent(Object element) {
            if (element instanceof InstalledOfferingTreePackageNode) {
                return ((InstalledOfferingTreePackageNode)element).getProfileNode();
            }
            if (element instanceof InstalledOfferingTreeFixNode) {
                return ((InstalledOfferingTreeFixNode)element).getPackageNode();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private static class JobLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private final Color disabledColor;
        private final AgentUILabelProvider agentLabelProvider;

        public JobLabelProvider(Display display) {
            this.disabledColor = CommonUIUtils.createDisabledColor((Display)display);
            this.agentLabelProvider = AgentUI.getDefault().getLabelProvider();
            this.agentLabelProvider.connect((Object)this);
        }

        public void dispose() {
            super.dispose();
            this.disabledColor.dispose();
            this.agentLabelProvider.disconnect((Object)this);
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            if (element instanceof InstalledOfferingTreePackageNode) {
                IOffering offering = ((InstalledOfferingTreePackageNode)element).getOffering();
                switch (columnIndex) {
                    case 1: {
                        return AgentUIUtils.getDisplayableVersion((IOfferingOrFix)offering);
                    }
                    case 2: {
                        return offering.getProperties().getProperty("vendor.name", "");
                    }
                }
            }
            if (element instanceof InstalledOfferingTreeFixNode) {
                IFix fix = ((InstalledOfferingTreeFixNode)element).getFix();
                switch (columnIndex) {
                    case 1: {
                        return AgentUIUtils.getDisplayableVersion((IOfferingOrFix)fix);
                    }
                    case 2: {
                        return fix.getProperties().getProperty("vendor.name", "");
                    }
                }
            }
            return "";
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof InstalledOfferingTreeProfileNode ? !((InstalledOfferingTreeProfileNode)element).isValid() : element instanceof InstalledOfferingTreePackageNode && !((InstalledOfferingTreePackageNode)element).isValid()) {
                return this.disabledColor;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof InstalledOfferingTreePackageNode) {
                IOffering offering = ((InstalledOfferingTreePackageNode)element).getOffering();
                return this.agentLabelProvider.getOfferingImage(offering);
            }
            if (element instanceof InstalledOfferingTreeProfileNode) {
                return this.agentLabelProvider.get(CommonImages.DESC_PROFILE_OBJ);
            }
            if (element instanceof InstalledOfferingTreeFixNode) {
                return this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof InstalledOfferingTreeFixNode) {
                IFix fix = ((InstalledOfferingTreeFixNode)element).getFix();
                return fix.getName();
            }
            if (element instanceof InstalledOfferingTreePackageNode) {
                return ((InstalledOfferingTreePackageNode)element).getOffering().getName();
            }
            if (element instanceof InstalledOfferingTreeProfileNode) {
                return ((InstalledOfferingTreeProfileNode)element).getProfile().getProfileId();
            }
            return super.getText(element);
        }
    }

    private static class OfferingSorter
    extends ViewerSorter {
        private OfferingSorter() {
        }

        public int category(Object element) {
            if (element instanceof InstalledOfferingTreePackageNode) {
                return 1;
            }
            if (element instanceof InstalledOfferingTreeFixNode) {
                return 2;
            }
            return super.category(element);
        }

        public void sort(Viewer viewer, Object[] elements) {
            AgentUIUtils.sortByNameAndVersion(viewer, this, elements, true);
        }
    }
}

