/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.IAgentObserverRegistrar;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.agent.internal.core.notify.AgentListener;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.factories.LauncherFactory;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.AgentInstallLocationPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIDisableCancelWizard;
import com.ibm.cic.agent.internal.ui.wizards.CommonLocationPage;
import com.ibm.cic.agent.internal.ui.wizards.CompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.ConditionalInstallPage;
import com.ibm.cic.agent.internal.ui.wizards.EclipseLocationPage;
import com.ibm.cic.agent.internal.ui.wizards.EclipseStyleLicensePage;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.InstallCompletionPage;
import com.ibm.cic.agent.internal.ui.wizards.InstallLocationPage;
import com.ibm.cic.agent.internal.ui.wizards.InstallSummaryPage;
import com.ibm.cic.agent.internal.ui.wizards.LocaleLanguagePage;
import com.ibm.cic.agent.internal.ui.wizards.MultipleProfileInstallLocationPage;
import com.ibm.cic.agent.internal.ui.wizards.MultipleProfileInstallSummaryPage;
import com.ibm.cic.agent.iwm.internal.ui.ENurturePage;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.CICImages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;

public class InstallWizard
extends AgentUIDisableCancelWizard {
    private Map launchers;
    private final AgentListener listener = new AgentListener();
    private Profile profileToConfigure;

    public InstallWizard() {
        super(null, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_installing, CICImages.WIZ_INSTALL);
    }

    public InstallWizard(String returnPageId) {
        super(returnPageId, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_installing, CICImages.WIZ_INSTALL);
    }

    public void addPages() {
        ConditionalInstallPage conditionalInstall = new ConditionalInstallPage(this.toolkit, this);
        if (!conditionalInstall.shouldSkip()) {
            this.addPage((IWizardPage)conditionalInstall);
            conditionalInstall.setHelpRef("com.ibm.cic.agent.ui.ConditionalInstallPage");
        }
        EclipseStyleLicensePage licensePage = new EclipseStyleLicensePage(this.toolkit, this);
        licensePage.setHelpRef("com.ibm.cic.agent.ui.EclipseStyleLicensePage");
        if (!licensePage.shouldSkip()) {
            this.addPage((IWizardPage)licensePage);
        }
        this.conditionallyAddNurturePage();
        boolean onlyInstallAgent = AgentUtil.onlyInstallAgent((List)this.getSelectedJobs());
        AgentUtil.setOnlyInstallingAgent((boolean)onlyInstallAgent);
        if (onlyInstallAgent) {
            this.addPage((IWizardPage)new AgentInstallLocationPage(this.toolkit, this));
        } else {
            CommonLocationPage commonLocationPage;
            if (this.isMultipleProfileInstall()) {
                this.profileToConfigure = this.determineProfileToConfigure();
            }
            String commonLocationPageDes = Messages.CommonLocationPage_description;
            if (AgentUtil.hasInstallAgentJob((List)this.getSelectedJobs())) {
                commonLocationPageDes = Messages.CommonLocationPage_desWithIM;
            }
            if (!(commonLocationPage = new CommonLocationPage(this.toolkit, this, commonLocationPageDes)).shouldSkip()) {
                this.addPage((IWizardPage)commonLocationPage);
                commonLocationPage.setHelpRef("com.ibm.cic.agent.ui.CommonLocationPage");
            } else {
                List agentJob = this.getSelectedAgentJob();
                if (agentJob != null && !agentJob.isEmpty()) {
                    AbstractJob job = (AbstractJob)agentJob.get(0);
                    if (!InstallAgentUtils.hasAgentInstalled()) {
                        this.addPage((IWizardPage)new AgentInstallLocationPage(this.toolkit, this));
                    } else {
                        Profile agentProfile = job.getProfile();
                        List agentProfileList = this.getAgentProfileList();
                        if (agentProfile != null && agentProfileList != null && agentProfileList.isEmpty()) {
                            agentProfileList.add(agentProfile);
                        }
                    }
                }
            }
            if (!this.isMultipleProfileInstall()) {
                InstallLocationPage installLocationPage = new InstallLocationPage(this.toolkit, this);
                List selectedProductOfferings = AgentUIUtils.getSelectedProductOfferings(this.getSelectedJobs());
                if (this.onlyInstallExtensions(selectedProductOfferings)) {
                    installLocationPage.setDescription(Messages.InstallLocationPage_des_extensions);
                }
                this.addPage((IWizardPage)installLocationPage);
            } else {
                MultipleProfileInstallLocationPage multipleProfileInstallLocPage = new MultipleProfileInstallLocationPage(this.toolkit, this);
                this.addPage((IWizardPage)multipleProfileInstallLocPage);
            }
            if (!Agent.getInstance().isPortable()) {
                this.addPage((IWizardPage)new EclipseLocationPage(this.toolkit, this));
            }
            LocaleLanguagePage localeLangPage = new LocaleLanguagePage(this.toolkit, this);
            localeLangPage.setHelpRef("com.ibm.cic.agent.ui.LocaleLanguagePage");
            this.addPage((IWizardPage)localeLangPage);
            FeatureSelectionPage featureSelectionPage = new FeatureSelectionPage(this.toolkit, com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_featuresTitle, Messages.InstallWizard_featuresDescription, this, true);
            featureSelectionPage.setHelpRef("com.ibm.cic.agent.ui.FeatureSelectionPage");
            this.addPage((IWizardPage)featureSelectionPage);
            this.addExtensionPages("com.ibm.cic.agent.ui.MissingCustomPanelInstallWizard");
            this.addSingleConfigurationPage(com.ibm.cic.agent.internal.ui.licenses.Messages.InstallWizard_featuresTitle, "com.ibm.cic.agent.ui.MissingCustomPanelSingleConfigurationPage");
        }
        if (!this.isMultipleProfileInstall()) {
            this.addPage((IWizardPage)new InstallSummaryPage(this.toolkit, this));
        } else {
            this.addPage((IWizardPage)new MultipleProfileInstallSummaryPage(this.toolkit, this));
        }
        this.launchers = !Agent.getInstance().isPortable() && !Agent.getInstance().isServerMode() ? this.getLaunchersForSelectedOffering() : Collections.EMPTY_MAP;
        this.startAgentListener();
    }

    private Profile determineProfileToConfigure() {
        MapList profileProductJobsMap = this.getProfileProductJobsMap();
        if (profileProductJobsMap != null && !profileProductJobsMap.isEmpty()) {
            Profile firstProfile = null;
            Profile shadowProfile = null;
            Set profileSet = profileProductJobsMap.keySet();
            for (Profile profile : profileSet) {
                List productJobs;
                if (firstProfile == null) {
                    firstProfile = profile;
                }
                if (!profile.isShadow()) continue;
                if (shadowProfile == null) {
                    shadowProfile = profile;
                }
                if (!AgentUtil.hasEclipseContext((AgentJob[])AgentJob.toArray((Collection)(productJobs = profileProductJobsMap.get((Object)profile)))) || !AgentUtil.isAllowExistingEclipse((AgentJob[])AgentJob.toArray((Collection)productJobs))) continue;
                return profile;
            }
            if (shadowProfile != null) {
                return shadowProfile;
            }
            return firstProfile;
        }
        return null;
    }

    private void startAgentListener() {
        Agent agent = AgentUI.getDefault().getAgent();
        agent.getEventManager().addInstallOfferingOrFixListener((IAgentEventManager.AgentJobListener)this.listener);
        agent.getEventManager().addBeginFetchOfferingOrFixListener((IAgentEventManager.BeginFetchListener)this.listener);
        agent.getEventManager().addFetchCompletedOfferingOrFixListener((IAgentEventManager.FetchCompletedListener)this.listener);
    }

    private void conditionallyAddNurturePage() {
        ENurturePage nurturePage = new ENurturePage(this.toolkit, this);
        nurturePage.init(new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (IAgent.class.equals((Object)adapter)) {
                    return AgentUI.getDefault().getAgent();
                }
                if (IAgentJob[].class.equals((Object)adapter) || AgentJob[].class.equals((Object)adapter)) {
                    return InstallWizard.this.getSelectedJobs().toArray(new AgentJob[InstallWizard.this.getSelectedJobs().size()]);
                }
                if (IAgentObserverRegistrar.class.equals((Object)adapter)) {
                    return AgentUI.getDefault().getAgent().getEventManager();
                }
                return null;
            }
        });
        if (nurturePage.canAddPageToWizard()) {
            this.addPage((IWizardPage)nurturePage);
        }
    }

    private Map getLaunchersForSelectedOffering() {
        HashMap<IOffering, List<LauncherFactory.Launcher>> map = new HashMap<IOffering, List<LauncherFactory.Launcher>>();
        List jobs = this.getSelectedJobs();
        for (AbstractJob job : jobs) {
            IOffering offering = job.getOffering();
            if (offering == null) continue;
            LauncherFactory.Launcher[] offeringLaunchers = LauncherFactory.getInstance().findLaunchersFor(offering);
            List<LauncherFactory.Launcher> list = Arrays.asList(offeringLaunchers);
            map.put(offering, list);
        }
        return map;
    }

    private boolean onlyInstallExtensions(List productOfferings) {
        ArrayList<IOffering> extensions = new ArrayList<IOffering>();
        int i = 0;
        while (i < productOfferings.size()) {
            IOffering offering = (IOffering)productOfferings.get(i);
            if (Agent.isExtensionOffering((IOfferingOrFix)offering)) {
                extensions.add(offering);
            }
            ++i;
        }
        return !extensions.isEmpty() && extensions.size() == productOfferings.size();
    }

    protected String getUserFeedbackTitle() {
        return Messages.InstallWizard_warningTitle;
    }

    protected String getDefaultUserFeedbackMessage() {
        return Messages.InstallWizard_warningMessage;
    }

    @Override
    protected AbstractJob createJob(Profile profile, IOfferingOrFix offering) {
        InstallJob job = new InstallJob(offering);
        job.setSelected(false);
        return job;
    }

    @Override
    public CompletionPage createCompletionPage(IStatus status) {
        InstallCompletionPage installCompletePage = new InstallCompletionPage(this.toolkit, this, status);
        installCompletePage.setLaunchers(this.launchers);
        return installCompletePage;
    }

    @Override
    protected String getRestartMessage() {
        return Messages.RestartProfileMsg;
    }

    @Override
    protected WizardType getWizardType() {
        return WizardType.INSTALL;
    }

    @Override
    protected IStatus performTask(IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        List jobs = this.getJobs();
        CicMultiStatus returnStatus = Statuses.ST.createMultiStatus();
        AgentJob[] jobsToInstall = AgentUtil.convertShadowProfiles((List)jobs);
        SortUtil.sortByProfileNameAndVersion((AgentJob[])jobsToInstall, (boolean)false);
        IStatus status = agent.install(jobsToInstall, this.getCollectedArtifacts(), (Agent.IDisableCancel)this, monitor);
        if (!status.isOK()) {
            if (status.matches(4) || status.matches(8)) {
                return status;
            }
            if (returnStatus.isOK()) {
                returnStatus = Statuses.ST.createMultiStatusFromStatus(status);
            } else {
                returnStatus.add(status);
            }
        }
        return returnStatus;
    }

    @Override
    public void setInput(Object[] items) {
        List currentJobs = this.getJobs();
        currentJobs.clear();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof AbstractJob) {
                currentJobs.add(item);
            }
            ++n2;
        }
    }

    public boolean isHelpAvailable() {
        return true;
    }

    protected String getStatusMessage(IStatus status) {
        if (status.matches(8)) {
            return Messages.InstallCanceledMsg;
        }
        return Messages.InstallFailedMsg;
    }

    protected String getKeepDownloadedMessage() {
        return Messages.KeepDownloadedMsgForInstall;
    }

    protected String getKeepDownloadedDlgTitle(IStatus status) {
        if (status.matches(8)) {
            return Messages.InstallCanceledTitle;
        }
        return Messages.InstallFailedTitle;
    }

    @Override
    public void dispose() {
        this.stopAgentListener();
        super.dispose();
    }

    private void stopAgentListener() {
        Agent agent = AgentUI.getDefault().getAgent();
        if (agent != null) {
            agent.getEventManager().removeInstallOfferingOrFixListener((IAgentEventManager.AgentJobListener)this.listener);
            agent.getEventManager().removeBeginFetchOfferingOrFixListener((IAgentEventManager.BeginFetchListener)this.listener);
            agent.getEventManager().removeFetchCompletedOfferingOrFixListener((IAgentEventManager.FetchCompletedListener)this.listener);
        }
    }

    public Profile getProfileToConfigure() {
        return this.profileToConfigure;
    }
}

