/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.FeatureViewerSorter;
import com.ibm.cic.agent.internal.ui.utils.JobFeatureContentProvider;
import com.ibm.cic.agent.internal.ui.utils.SummaryFeatureLabelProvider;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.EditInstallSummaryPage;
import com.ibm.cic.agent.internal.ui.wizards.FeatureSelectionPage;
import com.ibm.cic.agent.internal.ui.wizards.SummaryPage;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class InstallSummaryPage
extends EditInstallSummaryPage {
    private TreeViewer featureViewer;

    public InstallSummaryPage(FormToolkit toolkit, AgentUIWizard wizard) {
        super(toolkit, wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.InstallSummaryPage");
    }

    public InstallSummaryPage(FormToolkit toolkit, AgentUIWizard wizard, String description) {
        super(toolkit, wizard, description);
        super.setHelpRef("com.ibm.cic.agent.ui.InstallSummaryPage");
    }

    @Override
    protected void createFeatureControl(Composite container) {
        Section featuresSection = this.getToolkit().createSection(container, 512);
        featuresSection.setText(Messages.InstallSummaryPage_featureTableTitle);
        Composite featuresComposite = this.getToolkit().createComposite((Composite)featuresSection);
        GridLayout compLayout = new GridLayout();
        compLayout.marginHeight = 0;
        featuresComposite.setLayout((Layout)compLayout);
        featuresSection.setClient((Control)featuresComposite);
        featuresSection.setLayoutData((Object)new GridData(4, 4, true, true));
        int style = 2820;
        this.featureViewer = new TreeViewer(featuresComposite, style);
        this.getToolkit().adapt(this.featureViewer.getControl(), true, true);
        GridData gd = new GridData(1808);
        gd.heightHint = this.featureViewer.getTree().getItemHeight() * 2;
        this.featureViewer.getTree().setLayoutData((Object)gd);
        this.featureViewer.getTree().setHeaderVisible(true);
        TreeColumn featureCol = new TreeColumn(this.featureViewer.getTree(), 16384);
        featureCol.setText(Messages.InstallSummaryPage_featureTable_col1);
        featureCol.setWidth(400);
        this.featureViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int treeWidth = ((InstallSummaryPage)InstallSummaryPage.this).featureViewer.getTree().getClientArea().width;
                int scrollBarWidth = 0;
                TreeColumn col = InstallSummaryPage.this.featureViewer.getTree().getColumn(0);
                col.setWidth(treeWidth - scrollBarWidth);
            }
        });
        IWizard wizard = this.getWizard();
        IWizardPage previousPage = wizard.getPreviousPage((IWizardPage)this);
        while (previousPage != null && !(previousPage instanceof FeatureSelectionPage)) {
            previousPage = wizard.getPreviousPage(previousPage);
        }
        if (previousPage == null) {
            this.featureViewer.setContentProvider((IContentProvider)new JobFeatureContentProvider());
        } else {
            ITreeContentProvider featureTreeContentProvider = ((FeatureSelectionPage)previousPage).getFeatureContentProvider();
            Map map = ((FeatureSelectionPage)previousPage).getJobToGroupMap();
            this.featureViewer.setContentProvider((IContentProvider)new JobFeatureContentProvider(featureTreeContentProvider, map));
        }
        this.featureViewer.setLabelProvider((IBaseLabelProvider)new SummaryFeatureLabelProvider());
        this.featureViewer.addFilter((ViewerFilter)new SummaryPage.FeatureFilter());
        this.featureViewer.setSorter((ViewerSorter)new FeatureViewerSorter());
        this.featureViewer.setInput(null);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.showFeatures();
            this.reflowFor((Control)this.featureViewer.getTree());
        }
        super.setVisible(visible);
    }

    private void showFeatures() {
        List jobs = this.getSelectedJobs();
        IContentProvider contentProvider = this.featureViewer.getContentProvider();
        if (contentProvider instanceof JobFeatureContentProvider) {
            ((JobFeatureContentProvider)contentProvider).clearJobToChildrenMap();
        }
        this.featureViewer.setInput((Object)jobs.toArray());
        if (!AgentUIUtils.hasFixJob(jobs)) {
            if (jobs.size() > 1) {
                this.featureViewer.expandToLevel(2);
            } else {
                this.featureViewer.expandAll();
            }
        } else {
            this.featureViewer.expandToLevel(2);
        }
        Tree tree = this.featureViewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            tree.setTopItem(item);
        }
    }

    @Override
    protected List getSelectedJobs() {
        return super.getSortedSelectedJobs(false);
    }
}

