/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.sharedUI.IContainsOffering;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.wizards.AvailableRollbackPage;
import com.ibm.cic.agent.internal.ui.wizards.CheckboxTreeMasterSection;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryRollbackWizard;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.framework.Version;

public class AvailableRollbackSection
extends CheckboxTreeMasterSection {
    private final List recommendedNodes = new ArrayList();
    private JobContentProvider contentProvider;
    private List currentProfiles = new ArrayList();
    private final Map profilesMap = new HashMap();
    private final AvailableRollbackPage wizardPage;

    public AvailableRollbackSection(IFormContext context, Composite parent, AvailableRollbackPage wizardPage) {
        super(context, parent, 4096, null, 512);
        this.wizardPage = wizardPage;
        this.configureViewer((TreeViewer)this.getCheckboxTreeViewer());
        this.getSection().setText(Messages.AvailableUpdateSection_title);
    }

    private void buildVersionTree(List inputElement) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask(Messages.AvailableUpdateSection_progressMsg, AvailableRollbackSection.this.currentProfiles.size());
                    for (Profile profile : AvailableRollbackSection.this.currentProfiles) {
                        ProfileNode profileNode = (ProfileNode)AvailableRollbackSection.this.profilesMap.get(profile);
                        if (profileNode == null) {
                            profileNode = AvailableRollbackSection.this.createProfileNode(profile, monitor);
                            AvailableRollbackSection.this.profilesMap.put(profile, profileNode);
                        }
                        monitor.worked(1);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.recommendedNodes.clear();
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, runnable);
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        this.contentProvider = new JobContentProvider();
        viewer.setLabelProvider((IBaseLabelProvider)new JobLabelProvider(DisplayKeeper.INSTANCE.getDisplay()));
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setSorter((ViewerSorter)new OfferingSorter());
        this.createColumns(viewer);
        viewer.setInput(null);
    }

    protected void checkInputChanged() {
        PrimaryRollbackWizard wizard = this.wizardPage.getPrimaryRollbackWizard();
        List<Profile> newProfiles = Arrays.asList(wizard.getSelectedProfiles());
        if (!newProfiles.equals(this.currentProfiles)) {
            this.currentProfiles = newProfiles;
            this.profilesMap.clear();
            wizard.getJobs().clear();
            this.createRootNodes(this.currentProfiles);
            CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
            if (!this.hasOfferingsToRollback()) {
                MessageDialog.openInformation((Shell)viewer.getTree().getShell(), (String)Messages.RollbackWizard_AvailableRollbackPage_NoRollback_Title, (String)com.ibm.cic.agent.core.sharedUI.Messages.RollbackWizard_AvailableRollbackPage_NoRollback_Msg);
                viewer.setInput(null);
            } else {
                viewer.setInput(newProfiles);
                viewer.expandAll();
            }
        } else {
            this.wizardPage.validateSelectedOfferings(null, null);
            this.wizardPage.updateButtons();
        }
    }

    private boolean hasOfferingsToRollback() {
        Object[] profileNodes;
        Object[] objectArray = profileNodes = this.getRootNodes(this.currentProfiles);
        int n = profileNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object profileNode2 = objectArray[n2];
            ProfileNode profileNode = (ProfileNode)profileNode2;
            List packageNodes = profileNode.getPackages();
            Iterator it = packageNodes.iterator();
            while (it.hasNext()) {
                List versionNodes = ((PackageNode)it.next()).getVersions();
                if (versionNodes == null || versionNodes.isEmpty() || versionNodes.size() <= 0) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void checkItem(CheckboxTreeViewer viewer, Object element, boolean checked, boolean grayed) {
        super.checkItem(viewer, element, checked, grayed);
        if (element instanceof VersionNode) {
            VersionNode versionNode = (VersionNode)element;
            versionNode.getJob().setSelected(checked);
        }
    }

    @Override
    protected void updateParents(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (element != null && element instanceof VersionNode && checked) {
            PackageNode parent = ((VersionNode)element).getPackageNode();
            List versionNodes = parent.getVersions();
            int i = 0;
            while (i < versionNodes.size()) {
                VersionNode node = (VersionNode)versionNodes.get(i);
                if (!node.equals(element)) {
                    this.checkAll(viewer, node, false);
                }
                ++i;
            }
        }
        super.updateParents(viewer, element, checked);
    }

    @Override
    protected void onCheckStateChange(CheckStateChangedEvent event) {
        Object selectedItem;
        StructuredSelection strutSelection;
        List previousSelectedJobs = this.wizardPage.getPrimaryRollbackWizard().getSelectedJobs();
        super.onCheckStateChange(event);
        ArrayList currentSelectedJobs = new ArrayList(this.wizardPage.getPrimaryRollbackWizard().getSelectedJobs());
        ArrayList addedJobs = new ArrayList(currentSelectedJobs);
        addedJobs.removeAll(previousSelectedJobs);
        ArrayList removedJobs = new ArrayList(previousSelectedJobs);
        removedJobs.removeAll(currentSelectedJobs);
        this.wizardPage.validateSelectedOfferings(addedJobs, removedJobs);
        boolean resetSelection = true;
        ISelection currentSelection = this.getCheckboxTreeViewer().getSelection();
        if (currentSelection != null && currentSelection instanceof StructuredSelection && (strutSelection = (StructuredSelection)currentSelection).size() == 1 && (selectedItem = strutSelection.getFirstElement()).equals(event.getElement())) {
            resetSelection = false;
        }
        if (resetSelection) {
            this.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection(event.getElement()));
        }
        this.wizardPage.updateButtons();
    }

    @Override
    protected void elementChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        int i;
        if (!checked) {
            this.checkAll(viewer, element, checked);
            return;
        }
        if (element instanceof ProfileNode) {
            List packageNodes = ((ProfileNode)element).getPackages();
            i = 0;
            while (i < packageNodes.size()) {
                this.elementChecked(viewer, packageNodes.get(i), checked);
                ++i;
            }
        }
        if (element instanceof PackageNode) {
            List versionNodes = ((PackageNode)element).getVersions();
            i = 0;
            while (i < versionNodes.size()) {
                VersionNode versionNode = (VersionNode)versionNodes.get(i);
                if (checked && versionNode.isRecommended()) {
                    this.elementChecked(viewer, versionNode, checked);
                }
                ++i;
            }
        }
        if (element instanceof VersionNode) {
            VersionNode versionNode = (VersionNode)element;
            PackageNode parentNode = versionNode.getPackageNode();
            List versionNodes = parentNode.getVersions();
            int i2 = 0;
            while (i2 < versionNodes.size()) {
                VersionNode node = (VersionNode)versionNodes.get(i2);
                if (!node.equals(versionNode)) {
                    this.elementChecked(viewer, node, false);
                }
                ++i2;
            }
        }
        this.updateItem(viewer, element, checked);
    }

    private TreeColumn createColumn(Tree tree, String name, int width) {
        TreeColumn column = new TreeColumn(tree, 0x800000);
        column.setText(name);
        column.setWidth(width);
        column.setResizable(true);
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        this.createColumn(tree, Messages.RollbackWizard_AvailableRollbackPage_RollbackCol, 400);
        this.createColumn(tree, Messages.AvailableUpdateSection_dependencyCol, 110);
        this.createColumn(tree, Messages.InstalledOfferingSection_columnVendor, 90);
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getCheckboxTreeViewer().getLabelProvider();
    }

    private Object[] getRootNodes(List profiles) {
        ArrayList profileNodes = new ArrayList();
        for (Object profile : profiles) {
            profileNodes.add(this.profilesMap.get(profile));
        }
        return profileNodes.toArray();
    }

    private void createRootNodes(List profiles) {
        this.buildVersionTree(profiles);
    }

    private ProfileNode createProfileNode(Profile profile, IProgressMonitor monitor) {
        ProfileNode profileNode = new ProfileNode(profile);
        Agent agent = AgentUI.getDefault().getAgent();
        this.createPackageNodes(profileNode, agent, monitor);
        return profileNode;
    }

    private void createPackageNodes(ProfileNode profileNode, Agent agent, IProgressMonitor monitor) {
        IOffering[] currentlyInstalledOfferings;
        Profile profile = profileNode.getProfile();
        IOffering[] iOfferingArray = currentlyInstalledOfferings = agent.getInstalledOfferings(profile);
        int n = currentlyInstalledOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            List allowedRollback = agent.getRollbackOfferings(profile, offering);
            IOffering[] allowedRollbackArray = allowedRollback.toArray(new IOffering[allowedRollback.size()]);
            if (allowedRollbackArray != null && allowedRollbackArray.length > 0) {
                PackageNode packageNode = profileNode.addPackage(offering);
                this.createVersionNodes(offering, allowedRollbackArray, packageNode, profile, agent, monitor);
            }
            ++n2;
        }
    }

    private void createVersionNodes(IOffering offering, IOffering[] previouslyInstalledOfferings, PackageNode packageNode, Profile profile, Agent agent, IProgressMonitor monitor) {
        PrimaryRollbackWizard wizard = this.wizardPage.getPrimaryRollbackWizard();
        List wizardJobs = wizard.getJobs();
        VersionNode recommendedRollback = null;
        IOffering[] iOfferingArray = previouslyInstalledOfferings;
        int n = previouslyInstalledOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering rollbackOffering = iOfferingArray[n2];
            if (!rollbackOffering.getVersion().equals((Object)offering.getVersion())) {
                AbstractJob rollbackJob = wizard.createJob(profile, (IOfferingOrFix)rollbackOffering);
                if (rollbackJob instanceof RollbackJob) {
                    ((RollbackJob)rollbackJob).setRollbackFromOffering(offering);
                }
                wizardJobs.add(rollbackJob);
                VersionNode versionNode = packageNode.addVersion(rollbackJob);
                if (recommendedRollback == null) {
                    recommendedRollback = versionNode;
                } else {
                    Version recommendedVersion = recommendedRollback.getOffering().getVersion();
                    Version currentVersion = rollbackOffering.getVersion();
                    if (currentVersion.compareTo(recommendedVersion) > 0) {
                        recommendedRollback = versionNode;
                    }
                }
            }
            ++n2;
        }
        if (recommendedRollback != null) {
            recommendedRollback.setRecommended(true);
            this.recommendedNodes.add(recommendedRollback);
        }
    }

    class JobContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        JobContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ProfileNode) {
                return ((ProfileNode)parentElement).getPackages().toArray();
            }
            if (parentElement instanceof PackageNode) {
                return ((PackageNode)parentElement).getVersions().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return AvailableRollbackSection.this.getRootNodes((List)inputElement);
        }

        public Object getParent(Object element) {
            if (element instanceof PackageNode) {
                return ((PackageNode)element).getProfileNode();
            }
            if (element instanceof VersionNode) {
                return ((VersionNode)element).getPackageNode();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private static class JobLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private final AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();
        private final Color installedPkgColor;

        public JobLabelProvider(Display display) {
            this.agentLabelProvider.connect((Object)this);
            this.installedPkgColor = CommonUIUtils.createDisabledColor((Display)display);
        }

        public void dispose() {
            this.agentLabelProvider.disconnect((Object)this);
            this.installedPkgColor.dispose();
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getText(element);
            }
            if (columnIndex == 2 && element instanceof VersionNode) {
                IOffering offering = ((VersionNode)element).getJob().getOffering();
                return offering.getProperties().getProperty("vendor.name", "");
            }
            return "";
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 0 && (element instanceof ProfileNode || element instanceof PackageNode)) {
                return this.installedPkgColor;
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof PackageNode) {
                IOffering offering = ((PackageNode)element).getInstalledOffering();
                return this.agentLabelProvider.getOfferingImage(offering);
            }
            if (element instanceof ProfileNode) {
                return this.agentLabelProvider.get(CommonImages.DESC_PROFILE_OBJ);
            }
            if (element instanceof VersionNode) {
                return this.agentLabelProvider.get(CommonImages.DESC_ROLLBACK_OBJ);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof VersionNode) {
                String version = AgentUIUtils.getDisplayableVersion((IOfferingOrFix)((VersionNode)element).getJob().getOffering());
                return NLS.bind((String)Messages.AvailableUpdateSection_version, (Object)version);
            }
            if (element instanceof PackageNode) {
                IOffering installedOffering = ((PackageNode)element).getInstalledOffering();
                String label = String.valueOf(installedOffering.getName()) + " " + AgentUIUtils.getDisplayableVersion((IOfferingOrFix)installedOffering) + " " + Messages.AvailableUpdateSection_installed;
                return label;
            }
            if (element instanceof ProfileNode) {
                return ((ProfileNode)element).getProfile().getProfileId();
            }
            return super.getText(element);
        }
    }

    private static class OfferingSorter
    extends ViewerSorter {
        private OfferingSorter() {
        }

        public int category(Object element) {
            if (element instanceof ProfileNode) {
                return 0;
            }
            if (element instanceof PackageNode) {
                return 1;
            }
            if (element instanceof VersionNode) {
                return 2;
            }
            return super.category(element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof VersionNode && e2 instanceof VersionNode) {
                IOffering offering1 = ((VersionNode)e1).getOffering();
                IOffering offering2 = ((VersionNode)e2).getOffering();
                Version v1 = offering1.getVersion();
                Version v2 = offering2.getVersion();
                return v2.compareTo(v1);
            }
            return super.compare(viewer, e1, e2);
        }

        public void sort(Viewer viewer, Object[] elements) {
            AgentUIUtils.sortByNameAndVersion(viewer, this, elements);
        }
    }

    private static class PackageNode
    implements IContainsOffering,
    IAdaptable {
        private final IOffering installedOffering;
        private final ProfileNode profileNode;
        private final List versions = new ArrayList();

        public PackageNode(IOffering installedOffering, ProfileNode profileNode) {
            this.installedOffering = installedOffering;
            this.profileNode = profileNode;
        }

        public VersionNode addVersion(AbstractJob job) {
            VersionNode versionNode = new VersionNode(job, this);
            this.getVersions().add(versionNode);
            return versionNode;
        }

        public IOffering getInstalledOffering() {
            return this.installedOffering;
        }

        public IOffering getOffering() {
            return this.installedOffering;
        }

        public ProfileNode getProfileNode() {
            return this.profileNode;
        }

        public List getVersions() {
            return this.versions;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IOffering.class) {
                return this.getInstalledOffering();
            }
            if (adapter == Profile.class && this.profileNode != null) {
                return this.profileNode.getProfile();
            }
            return null;
        }
    }

    private static class ProfileNode
    implements IAdaptable {
        private final List packages = new ArrayList();
        private final Profile profile;

        public ProfileNode(Profile profile) {
            this.profile = profile;
        }

        public PackageNode addPackage(IOffering installedOffering) {
            PackageNode packageNode = new PackageNode(installedOffering, this);
            this.packages.add(packageNode);
            return packageNode;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IProfile.class || adapter == Profile.class) {
                return this.getProfile();
            }
            return null;
        }

        public List getPackages() {
            return this.packages;
        }

        public Profile getProfile() {
            return this.profile;
        }
    }

    private static class VersionNode
    implements IAdaptable {
        private final AbstractJob job;
        private final PackageNode packageNode;
        private boolean isRecommended;

        public VersionNode(AbstractJob job, PackageNode parent) {
            this.job = job;
            this.packageNode = parent;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IOffering.class) {
                return this.getOffering();
            }
            if (adapter == AbstractJob.class) {
                return this.job;
            }
            return null;
        }

        public AbstractJob getJob() {
            return this.job;
        }

        public IOffering getOffering() {
            return this.job.getOffering();
        }

        public PackageNode getPackageNode() {
            return this.packageNode;
        }

        public boolean isRecommended() {
            return this.isRecommended;
        }

        public void setRecommended(boolean isRecommended) {
            this.isRecommended = isRecommended;
        }
    }
}

