/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.ProfilePartitioner;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.SharedUIDependenciesCheckUtils;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIDependenciesCheckUtils;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.InstallAgentUtils;
import com.ibm.cic.agent.internal.ui.wizards.AbstractAgentUIPrimaryPage;
import com.ibm.cic.agent.internal.ui.wizards.AgentUIWizard;
import com.ibm.cic.agent.internal.ui.wizards.AvailableFixPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableOfferingDetailPage;
import com.ibm.cic.agent.internal.ui.wizards.AvailableOfferingSection;
import com.ibm.cic.agent.internal.ui.wizards.IAvailableOfferingPage;
import com.ibm.cic.agent.internal.ui.wizards.IOfferingsInRepPage;
import com.ibm.cic.agent.internal.ui.wizards.InstallWizard;
import com.ibm.cic.agent.internal.ui.wizards.PrimaryInstallWizard;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.msdrepo.MasterSetupDiskRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.utils.CanceledException;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.TreeSection;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.common.ui.wizards.CustomMessageWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;

public class AvailableOfferingPage
extends AbstractAgentUIPrimaryPage
implements IAvailableOfferingPage,
IOfferingsInRepPage {
    private final List jobs = new ArrayList();
    private List lastSelectedJobs = new ArrayList();
    private boolean firstTimeToNextPage = true;
    private final HashSet processedOfferings = new HashSet();
    private final Set existingFixJobs = new HashSet();
    protected AvailableOfferingSection offeringSection;
    protected AvailableOfferingDetailPage offeringDetailPage;
    private boolean hasPackageInstalled = false;
    private boolean firstTimeVisible = true;
    private PrimaryInstallWizard wizard = null;
    private boolean setInitialFixJobs = true;
    private ProfilePartitioner profilePartitioner = null;
    private boolean multipleProfileInstall = false;
    private boolean rePartitionProfiles = false;
    private boolean goingToNextPageWasCanceled = false;
    private final CustomMessageWizardPage.WarningId initialWarning = new CustomMessageWizardPage.WarningId();
    private final CustomMessageWizardPage.WarningId offeringDependencyWarning = new CustomMessageWizardPage.WarningId();
    private final CustomMessageWizardPage.WarningId imApplicabilityWarning = new CustomMessageWizardPage.WarningId();

    public AvailableOfferingPage(PrimaryInstallWizard wizard) {
        super(com.ibm.cic.agent.internal.ui.licenses.Messages.AvailableOfferingPage_title, "", wizard);
        super.setHelpRef("com.ibm.cic.agent.ui.AvailableOfferingPage");
        this.hasPackageInstalled = SharedUIUtils.haveInstalledOfferings();
        this.wizard = wizard;
    }

    @Override
    public boolean canFlipToNextPage() {
        IStatus status;
        IStatus status2;
        this.setWarningMessage(this.imApplicabilityWarning, null);
        if (!super.canFlipToNextPage()) {
            this.setErrorMessage(null);
            this.setWarningMessage(this.initialWarning, null);
            this.setWarningMessage(this.offeringDependencyWarning, null);
            return false;
        }
        IOffering[] offerings = this.offeringSection.getSelectedOfferings();
        IOffering[] selectedProductOfferings = InstallAgentUtils.getSelectedProductOfferings(offerings);
        if (!(selectedProductOfferings.length <= 1 || AgentUIUtils.supportMultipleProfileInstall(selectedProductOfferings) && !Agent.getInstance().isPortable() || (status2 = AgentUtil.validateCompatibleOfferings((IOffering[])selectedProductOfferings)).isOK())) {
            String message = status2.getMessage();
            if (message != null && message.trim().length() > 0) {
                this.setErrorMessage(message);
            } else {
                this.setErrorMessage(Messages.AvailableOfferingPage_incompatibleOfferings);
            }
            return false;
        }
        if (!this.hasPackageInstalled) {
            int numExtensionOfferings = 0;
            IOffering[] iOfferingArray = offerings;
            int n = offerings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering = iOfferingArray[n2];
                if (Agent.isExtensionOffering((IOfferingOrFix)offering)) {
                    ++numExtensionOfferings;
                }
                ++n2;
            }
            if (numExtensionOfferings > 0 && numExtensionOfferings == selectedProductOfferings.length) {
                this.setErrorMessage(AgentUtil.makeUnresolvedRequirementsError((IOffering)selectedProductOfferings[0]));
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setWarningMessage(this.initialWarning, null);
        StringBuffer msg = new StringBuffer();
        List selectedOfferingOrFix = AgentUIUtils.getSelectedVisibleOfferingsOrFixes(Arrays.asList(this.offeringSection.getSelectedJobs()));
        String warningMessage = this.getProductOfferingDiskSetInfo(selectedOfferingOrFix);
        if (warningMessage != null && warningMessage.length() > 0) {
            if (msg.length() != 0) {
                msg.append(LogUtil.NEWLINE);
            }
            msg.append(warningMessage);
        }
        if (msg.length() > 0) {
            this.setWarningMessage(this.initialWarning, msg.toString());
        }
        List currentSelectedJobs = AgentUIUtils.getSelectedJobs(this.getJobs());
        if (this.lastSelectedJobs == null || !this.lastSelectedJobs.equals(currentSelectedJobs)) {
            this.setWarningMessage(this.offeringDependencyWarning, null);
        }
        if (StatusUtil.isErrorOrCancel((IStatus)(status = AgentUtil.checkAgentOfferingApplicability((List)currentSelectedJobs)))) {
            this.setErrorMessageWithStatus(status);
            return false;
        }
        if (status.matches(2)) {
            this.setWarningMessageWithStatus(this.imApplicabilityWarning, status);
        }
        return true;
    }

    private String getProductOfferingDiskSetInfo(List selectedOfferingOrFix) {
        String return_value = "";
        boolean isESDInstall = DiskUtil.canFindAvailableDisks((List)selectedOfferingOrFix);
        if (!isESDInstall) {
            return return_value;
        }
        StringBuffer offeringsLabel = new StringBuffer();
        int i = 0;
        while (i < selectedOfferingOrFix.size()) {
            IOfferingOrFix offeringOrFix = (IOfferingOrFix)selectedOfferingOrFix.get(i);
            IRepository rep = offeringOrFix.getRepository();
            if (rep != null) {
                boolean hasMissingDisk;
                block14: {
                    hasMissingDisk = false;
                    IVolumeAccessByDisk diskRep = RepoAs.IVolumeAccessByDisk((IReadArtifactRepo)rep);
                    if (diskRep != null) {
                        IArtifactSession session = IArtifactSessionFactory.INSTANCE.createArtifactSession();
                        try {
                            try {
                                IVolumeAccessByDisk.IDiskSet[] diskSets;
                                IVolumeAccessByDisk.IDiskSet[] iDiskSetArray = diskSets = diskRep.getDiskSets(session, (IProgressMonitor)new NullProgressMonitor());
                                int n = diskSets.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IVolumeAccessByDisk.IDiskSetDisks availableDisks;
                                    IVolumeAccessByDisk.IDiskSetDisks unavailableDisks;
                                    int[] unavailableDiskNum;
                                    IVolumeAccessByDisk.IDiskSet diskSet2 = iDiskSetArray[n2];
                                    IVolumeAccessByDisk.IDiskSet diskSet = diskSet2;
                                    if (!diskSet.equals(MasterSetupDiskRepository.PSEUDO_MASTER_DISK_SET) && (unavailableDiskNum = (unavailableDisks = (availableDisks = DiskUtil.getAvailableDisks((IArtifactSession)session, (IVolumeAccessByDisk)diskRep, (IVolumeAccessByDisk.IDiskSet)diskSet, (IProgressMonitor)new NullProgressMonitor())).getOtherDisks()).getDiskNumbers()) != null && unavailableDiskNum.length > 0) {
                                        hasMissingDisk = true;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            catch (Exception e) {
                                AgentUI.reportException(e, false);
                                session.close();
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            session.close();
                            throw throwable;
                        }
                        session.close();
                    }
                }
                if (hasMissingDisk) {
                    if (offeringsLabel.length() > 0) {
                        offeringsLabel.append(", ");
                    }
                    offeringsLabel.append(OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix, (boolean)false));
                }
            }
            ++i;
        }
        if (offeringsLabel.length() > 0) {
            return_value = NLS.bind((String)Messages.AvailableOfferingPage_diskInfo, (Object)offeringsLabel.toString());
        }
        return return_value;
    }

    @Override
    protected IDetailsPage createDetailsSection() {
        this.offeringDetailPage = new AvailableOfferingDetailPage(this);
        return this.offeringDetailPage;
    }

    @Override
    public void refreshDetailPage() {
        if (this.offeringDetailPage != null) {
            this.offeringDetailPage.refreshDetails();
        }
    }

    @Override
    public AvailableOfferingDetailPage getDetailPage() {
        return this.offeringDetailPage;
    }

    @Override
    protected AgentUIWizard createInnerWizard() {
        InstallWizard installWizard = new InstallWizard();
        installWizard.setMultipleProfileInstall(this.multipleProfileInstall);
        return installWizard;
    }

    @Override
    protected TreeSection createTreeSection(IFormContext context, Composite parent) {
        this.offeringSection = new AvailableOfferingSection(context, parent, this);
        return this.offeringSection;
    }

    @Override
    public List getJobs() {
        return this.jobs;
    }

    @Override
    public IWizardPage getNextPage() {
        WrapDetailUIDErrorDialog errorDialog;
        AgentJob[] selectedProductJobArray;
        final List currentSelectedJobs = AgentUIUtils.getSelectedJobs(this.getJobs());
        final List unselectedJobs = AgentUIUtils.getDeselectedJobs(this.lastSelectedJobs, currentSelectedJobs);
        final boolean[] refreshFixTreeViewer = new boolean[]{true};
        if (this.lastSelectedJobs != null && this.lastSelectedJobs.equals(currentSelectedJobs)) {
            if (!this.offeringSection.isCheckForUpdateButtonWasClicked() && !this.goingToNextPageWasCanceled) {
                refreshFixTreeViewer[0] = false;
            }
            if (this.firstTimeToNextPage && AgentInput.getInstance().getMode() == 1) {
                this.rePartitionProfiles = true;
                selectedProductJobArray = AgentUtil.getSelectedProductAgentJobArray((Collection)currentSelectedJobs);
                this.profilePartitioner = AgentUIUtils.supportMultipleProfileInstall(selectedProductJobArray) ? new ProfilePartitioner(selectedProductJobArray) : null;
                this.multipleProfileInstall = false;
            }
        } else {
            this.rePartitionProfiles = true;
            selectedProductJobArray = AgentUtil.getSelectedProductAgentJobArray((Collection)currentSelectedJobs);
            this.profilePartitioner = AgentUIUtils.supportMultipleProfileInstall(selectedProductJobArray) ? new ProfilePartitioner(selectedProductJobArray) : null;
            this.multipleProfileInstall = false;
        }
        if (this.firstTimeToNextPage) {
            this.firstTimeToNextPage = false;
        }
        final IWizardPage nextPage = this.wizard.getNextPage((IWizardPage)this);
        this.lastSelectedJobs = currentSelectedJobs;
        final IStatus[] validationStatus = new IStatus[]{Status.OK_STATUS};
        final List[] newFixJobList = new ArrayList[1];
        final List[] initialFixJobs = new ArrayList[1];
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(null, 12);
                    SubProgressMonitor subMonitor1 = new SubProgressMonitor(monitor, 8);
                    if (unselectedJobs != null && !unselectedJobs.isEmpty()) {
                        subMonitor1.beginTask(null, 10);
                        SubProgressMonitor sm1 = new SubProgressMonitor((IProgressMonitor)subMonitor1, 1);
                        IStatus unloadStatus = Agent.getInstance().unloadAgentBundles((IProgressMonitor)sm1);
                        if (!unloadStatus.isOK()) {
                            AgentUI.reportStatus(unloadStatus, false);
                        }
                        sm1.done();
                        SubProgressMonitor sm2 = new SubProgressMonitor((IProgressMonitor)subMonitor1, 9);
                        validationStatus[0] = SharedUIUtils.prepareAndResolveSelectedJobs((List)AvailableOfferingPage.this.getJobs(), (IProgressMonitor)sm2);
                    } else {
                        validationStatus[0] = SharedUIUtils.prepareAndResolveSelectedJobs((List)AvailableOfferingPage.this.getJobs(), (IProgressMonitor)subMonitor1);
                    }
                    if (!StatusUtil.isErrorOrCancel((IStatus)validationStatus[0])) {
                        if (AvailableOfferingPage.this.rePartitionProfiles && AvailableOfferingPage.this.profilePartitioner != null) {
                            SubProgressMonitor partitionProgress = new SubProgressMonitor(monitor, 2);
                            try {
                                Map partitionStatus = AvailableOfferingPage.this.profilePartitioner.perform((IProgressMonitor)partitionProgress);
                                if (partitionStatus != null && !partitionStatus.isEmpty()) {
                                    ArrayList<String> offeringNameList = new ArrayList<String>(partitionStatus.size());
                                    CicMultiStatus returnStatus = Statuses.ST.createMultiStatus();
                                    Set entries = partitionStatus.entrySet();
                                    for (Map.Entry entry : entries) {
                                        IStatus jobStatus;
                                        AgentJob job = (AgentJob)entry.getKey();
                                        IOffering offering = job.getOffering();
                                        if (offering != null) {
                                            offeringNameList.add(OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering));
                                        }
                                        if ((jobStatus = (IStatus)entry.getValue()) == null) continue;
                                        returnStatus.add(jobStatus);
                                    }
                                    String errorMsg = AvailableOfferingPage.this.generateErrorMessageForProfilePartitioner(offeringNameList);
                                    returnStatus.setMessage(errorMsg);
                                    validationStatus[0] = returnStatus;
                                    AvailableOfferingPage.this.rePartitionProfiles = true;
                                } else {
                                    AvailableOfferingPage.this.rePartitionProfiles = false;
                                    Collection profiles = AvailableOfferingPage.this.profilePartitioner.getProfiles();
                                    if (profiles.size() > 1) {
                                        AvailableOfferingPage.this.multipleProfileInstall = true;
                                    }
                                    MapList offeringToFixJobList = null;
                                    if (AvailableOfferingPage.this.existingFixJobs != null && !AvailableOfferingPage.this.existingFixJobs.isEmpty()) {
                                        offeringToFixJobList = AvailableOfferingPage.this.generateOfferingFixJobMap(currentSelectedJobs, new ArrayList(AvailableOfferingPage.this.existingFixJobs));
                                    }
                                    AvailableOfferingPage.this.profilePartitioner.setProfilesInJobs();
                                    if (AvailableOfferingPage.this.existingFixJobs != null && !AvailableOfferingPage.this.existingFixJobs.isEmpty() && offeringToFixJobList != null) {
                                        AvailableOfferingPage.this.adjustFixJobProfiles(currentSelectedJobs, offeringToFixJobList);
                                    }
                                }
                            }
                            catch (CanceledException e) {
                                validationStatus[0] = e.getStatus();
                                AvailableOfferingPage.this.rePartitionProfiles = true;
                                partitionProgress.done();
                            }
                        }
                        if (!StatusUtil.isErrorOrCancel((IStatus)validationStatus[0])) {
                            SubProgressMonitor subMonitor3;
                            IStatus dependencyStatus;
                            AvailableFixPage fixPage;
                            SubProgressMonitor subMonitor32;
                            IStatus dependencyStatus2;
                            if (refreshFixTreeViewer[0]) {
                                SubProgressMonitor subMonitor2 = new SubProgressMonitor(monitor, 1);
                                newFixJobList[0] = AvailableOfferingPage.this.searchFixesForSelectedOfferings((IProgressMonitor)subMonitor2);
                                initialFixJobs[0] = new ArrayList(newFixJobList[0]);
                            } else {
                                initialFixJobs[0] = new ArrayList(AvailableOfferingPage.this.existingFixJobs);
                            }
                            if (AvailableOfferingPage.this.setInitialFixJobs) {
                                if (initialFixJobs[0].isEmpty() && !(dependencyStatus2 = AvailableOfferingPage.this.checkSelectedOfferingsDependencies((IProgressMonitor)(subMonitor32 = new SubProgressMonitor(monitor, 1)))).isOK()) {
                                    validationStatus[0] = AgentUIDependenciesCheckUtils.processDependencyStatus(dependencyStatus2, false);
                                }
                            } else if (refreshFixTreeViewer[0] && newFixJobList[0].isEmpty()) {
                                subMonitor32 = new SubProgressMonitor(monitor, 1);
                                dependencyStatus2 = AvailableOfferingPage.this.checkSelectedOfferingsDependencies((IProgressMonitor)subMonitor32);
                                if (!dependencyStatus2.isOK()) {
                                    validationStatus[0] = AgentUIDependenciesCheckUtils.processDependencyStatus(dependencyStatus2, false);
                                }
                            } else if (!refreshFixTreeViewer[0] && nextPage != null && nextPage instanceof AvailableFixPage && (fixPage = (AvailableFixPage)nextPage).shouldSkip() && !(dependencyStatus = AvailableOfferingPage.this.checkSelectedOfferingsDependencies((IProgressMonitor)(subMonitor3 = new SubProgressMonitor(monitor, 1)))).isOK()) {
                                validationStatus[0] = AgentUIDependenciesCheckUtils.processDependencyStatus(dependencyStatus, false);
                            }
                        }
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
        this.goingToNextPageWasCanceled = false;
        if (validationStatus[0].matches(4)) {
            this.goingToNextPageWasCanceled = true;
            this.setErrorMessageWithStatus(validationStatus[0]);
            if (validationStatus[0].isMultiStatus() && validationStatus[0].getChildren() != null && validationStatus[0].getChildren().length > 0) {
                errorDialog = new WrapDetailUIDErrorDialog(this.getShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Error, null, validationStatus[0], 15);
                errorDialog.open();
            }
            return this;
        }
        if (validationStatus[0].matches(8)) {
            this.goingToNextPageWasCanceled = true;
            this.setErrorMessage(com.ibm.cic.common.core.utils.Messages.Operation_Canceled_By_User);
            return this;
        }
        if (validationStatus[0].matches(2)) {
            this.setErrorMessage(null);
            this.setWarningMessageWithStatus(this.offeringDependencyWarning, validationStatus[0]);
            if (validationStatus[0].isMultiStatus()) {
                errorDialog = new WrapDetailUIDErrorDialog(this.getShell(), com.ibm.cic.common.core.sharedUI.Messages.DialogTitle_Warning, null, validationStatus[0], 15);
                errorDialog.open();
            }
        } else {
            this.setErrorMessage(null);
            this.setWarningMessage(this.initialWarning, null);
            this.setWarningMessage(this.offeringDependencyWarning, null);
            this.setWarningMessage(this.imApplicabilityWarning, null);
        }
        this.offeringSection.setCheckForUpdateButtonWasClicked(false);
        if (nextPage instanceof AvailableFixPage) {
            AvailableFixPage fixPage = (AvailableFixPage)nextPage;
            fixPage.setRebuildFixTree(refreshFixTreeViewer[0]);
            fixPage.setIsMultipleProfileInstall(this.multipleProfileInstall);
            if (this.setInitialFixJobs) {
                this.setInitialFixJobs = false;
                if (initialFixJobs[0].isEmpty()) {
                    fixPage.setShouldSkip(true);
                    return super.getNextPage();
                }
                fixPage.setShouldSkip(false);
                fixPage.setFixJobs(initialFixJobs[0]);
                fixPage.setSelectedOfferingJobs(AgentUIUtils.getSelectedJobs(this.getJobs()));
                return fixPage;
            }
            if (refreshFixTreeViewer[0]) {
                fixPage.setSelectedOfferingJobs(AgentUIUtils.getSelectedJobs(this.getJobs()));
                fixPage.setFixJobs(newFixJobList[0]);
                if (newFixJobList[0].isEmpty()) {
                    fixPage.setShouldSkip(true);
                    return super.getNextPage();
                }
                fixPage.setShouldSkip(false);
                return fixPage;
            }
            if (fixPage.shouldSkip()) {
                return super.getNextPage();
            }
            return fixPage;
        }
        return this;
    }

    private String generateErrorMessageForProfilePartitioner(List offeringNameList) {
        String errorMsg = "";
        if (offeringNameList.size() == 1) {
            errorMsg = NLS.bind((String)Messages.AvailableOfferingPage_cannotInstallPkg, offeringNameList.get(0));
        } else if (offeringNameList.size() > 1) {
            StringBuffer part1OfferingName = new StringBuffer();
            String part2OfferingName = "";
            int i = 0;
            while (i < offeringNameList.size()) {
                if (i == offeringNameList.size() - 1) {
                    part2OfferingName = (String)offeringNameList.get(i);
                } else {
                    if (i > 0) {
                        part1OfferingName.append(", ");
                    }
                    part1OfferingName.append((String)offeringNameList.get(i));
                }
                ++i;
            }
            errorMsg = NLS.bind((String)Messages.AvailableOfferingPage_cannotInstallPkgs, (Object)part1OfferingName.toString(), (Object)part2OfferingName);
        }
        return errorMsg;
    }

    private MapList generateOfferingFixJobMap(List offeringJobs, List fixJobs) {
        IFix fix;
        MapList return_result = new MapList();
        ArrayList noProfileFixJobs = new ArrayList(fixJobs);
        block0: for (AgentJob fixJob : fixJobs) {
            fix = fixJob.getFix();
            Profile fixProfile = fixJob.getProfile();
            if (fix == null) continue;
            for (AgentJob offeringJob : offeringJobs) {
                Profile offeringProfile = offeringJob.getProfile();
                IOffering offering = offeringJob.getOffering();
                if (offering == null || offeringProfile != fixProfile || !FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) continue;
                return_result.add((Object)offering, (Object)fixJob);
                noProfileFixJobs.remove(fixJob);
                continue block0;
            }
        }
        if (!noProfileFixJobs.isEmpty()) {
            block2: for (AgentJob fixJob : noProfileFixJobs) {
                fix = fixJob.getFix();
                if (fix == null) continue;
                for (AgentJob offeringJob : offeringJobs) {
                    IOffering offering = offeringJob.getOffering();
                    if (offering == null || !FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) continue;
                    return_result.add((Object)offering, (Object)fixJob);
                    continue block2;
                }
            }
        }
        return return_result;
    }

    private void adjustFixJobProfiles(List offeringJobs, MapList offeringToFixJobMap) {
        for (AgentJob offeringJob : offeringJobs) {
            List fixJobs;
            Profile offeringProfile = offeringJob.getProfile();
            IOffering offering = offeringJob.getOffering();
            if (offering == null || (fixJobs = offeringToFixJobMap.get((Object)offering)) == null || fixJobs.isEmpty()) continue;
            for (AgentJob fixJob : fixJobs) {
                fixJob.setProfile(offeringProfile);
            }
        }
    }

    private IStatus checkSelectedOfferingsDependencies(IProgressMonitor monitor) {
        IStatus returnStatus = Status.OK_STATUS;
        AgentJob[] selectedProductOfferingArray = AgentUtil.getSelectedProductAgentJobArray((Collection)this.getJobs());
        if (selectedProductOfferingArray == null || selectedProductOfferingArray.length == 0) {
            return returnStatus;
        }
        try {
            returnStatus = this.multipleProfileInstall ? SharedUIDependenciesCheckUtils.checkDependenciesMultiFinalProfilesPrepareUnprepare((AgentJob[])selectedProductOfferingArray, (IProgressMonitor)monitor) : AgentUIDependenciesCheckUtils.checkDependenciesProfilePrepareUnpreparePreliminary(selectedProductOfferingArray, Agent.getInstance().getNonNullAgentProfile(), monitor);
        }
        catch (CoreException e) {
            returnStatus = new Status(4, "com.ibm.cic.agent.ui", Messages.AvailableOfferingPage_dependencyException, (Throwable)e);
        }
        return returnStatus;
    }

    private List searchFixesForSelectedOfferings(IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        List selectedProductJobs = AgentUtil.getSelectedProductAgentJobs((Collection)this.getJobs());
        ArrayList<AbstractJob> fixJobs = new ArrayList<AbstractJob>();
        List allFixes = agent.findAllFixes(true, monitor);
        if (!allFixes.isEmpty()) {
            int i = 0;
            while (i < selectedProductJobs.size()) {
                AgentJob offeringJob = (AgentJob)selectedProductJobs.get(i);
                IOffering pOffering = offeringJob.getOffering();
                if (pOffering != null) {
                    for (IFix fix : allFixes) {
                        if (!FixUtil.isFixApplicable((IFix)fix, (IOffering)pOffering) || !BitModeUtils.checkFixSupportedPlatforms((IFix)fix, (IOffering)pOffering)) continue;
                        AbstractJob fixJob = null;
                        fixJob = this.wizard.createJob(offeringJob.getProfile(), (IOfferingOrFix)fix);
                        if (AgentUIUtils.inExistingFixJobs((AgentJob)fixJob, fixJobs, this.multipleProfileInstall)) continue;
                        fixJobs.add(fixJob);
                    }
                }
                ++i;
            }
        }
        return fixJobs;
    }

    @Override
    public boolean isPageComplete() {
        return this.canFlipToNextPage();
    }

    @Override
    public Set getProcessedOfferings() {
        return this.processedOfferings;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.firstTimeVisible) {
            this.firstTimeVisible = false;
            this.checkJobsToleranceForAgent();
            this.checkInstalledOfferings();
        }
    }

    protected void checkJobsToleranceForAgent() {
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AvailableOfferingPage.this.offeringSection.checkJobsToleranceForAgent();
            }
        });
    }

    protected void checkInstalledOfferings() {
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AvailableOfferingPage.this.offeringSection.checkInstalledOfferings();
            }
        });
    }

    @Override
    public void setInput(Object[] inputElements) {
        List currentJobs = this.getJobs();
        currentJobs.clear();
        this.lastSelectedJobs.clear();
        this.existingFixJobs.clear();
        if (inputElements != null) {
            Object[] objectArray = inputElements;
            int n = inputElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof IOffering) {
                    IOffering offering;
                    if (this.processedOfferings.add(item) && !SharedUIUtils.isHiddenAgentOffering((IOfferingOrFix)(offering = (IOffering)item), (boolean)false)) {
                        AbstractJob job = this.wizard.createJob((IOfferingOrFix)offering);
                        if (AgentUI.getDefault().getAgent().isAgentOffering((IOfferingOrFix)offering)) {
                            job.setSelected(true);
                        }
                        currentJobs.add(job);
                    }
                } else if (item instanceof AbstractJob) {
                    AbstractJob job = (AbstractJob)item;
                    IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                    if (offeringOrFix instanceof IOffering) {
                        this.processedOfferings.add(offeringOrFix);
                        if (!SharedUIUtils.isHiddenAgentOffering((IOfferingOrFix)offeringOrFix, (boolean)true)) {
                            currentJobs.add(item);
                            if (job.isSelected()) {
                                this.lastSelectedJobs.add(job);
                            }
                        }
                    } else {
                        this.existingFixJobs.add(item);
                    }
                }
                ++n2;
            }
        }
    }

    protected String combinePPAMsg(String messageToBeDisplayed) {
        if (this.isPPAConnected()) {
            return String.valueOf(messageToBeDisplayed) + "\n" + Messages.AvailableOfferingPage_ppaMsg;
        }
        return messageToBeDisplayed;
    }

    private boolean isPPAConnected() {
        IRepositoryGroup repGroup = AgentUI.getDefault().getAgent().getRepositoryGroup();
        Collection repositories = repGroup.getRepositories();
        for (IRepository rep : repositories) {
            String location = rep.getRepositoryInfo().getLocationStr();
            if (!CommonDef.Urls.EntitledRepositoryUrl.equals(location)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractJob createJob(IOfferingOrFix offeringOrFix) {
        return this.wizard.createJob(offeringOrFix);
    }

    @Override
    public boolean isShowAllChecked() {
        return this.offeringSection.isShowAllChecked();
    }

    @Override
    public String messageHigherNotEntitledVersionsAreAvailable() {
        return com.ibm.cic.agent.internal.core.Messages.HigherVersionsNotAvailable_Install;
    }

    @Override
    public void setSelection(Object[] selectedObjects) {
        super.setSelection(selectedObjects);
    }
}

