/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.wizards;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.internal.ui.utils.BaseJobContentProvider;
import com.ibm.cic.agent.internal.ui.utils.BaseJobNodeLabelProvider;
import com.ibm.cic.agent.internal.ui.utils.FixContainerNode;
import com.ibm.cic.agent.internal.ui.utils.FixNode;
import com.ibm.cic.agent.internal.ui.utils.PackageNode;
import com.ibm.cic.agent.internal.ui.utils.VersionNode;
import com.ibm.cic.agent.internal.ui.wizards.CheckboxTreeFilterSection;
import com.ibm.cic.agent.internal.ui.wizards.IFixesInRepPage;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.parts.StructuredViewerPart;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AvailableFixSection
extends CheckboxTreeFilterSection {
    private BaseJobContentProvider contentProvider;
    private FixTreeJobLabelProvider labelProvider;
    protected Map roots;
    private RecommendedFilter recommendedFilter;
    protected List recommendedNodes = new ArrayList();
    private final IFixesInRepPage fixPage;
    private boolean showAll = false;
    private Button showRecommendedButton;
    private final boolean isWizardMode;
    private final boolean[] searchForFixWasCanceled = new boolean[1];
    private boolean checkCondition = true;

    @Override
    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        return new CheckboxTreeFilterSection.TreeViewerWithFilterPartAdapter(this, buttonLabels, this.buttonsOrientation);
    }

    public AvailableFixSection(IFormContext context, Composite parent, IFixesInRepPage wizardPage, String[] buttonLabels) {
        super(context, parent, 4096, buttonLabels, 256);
        this.fixPage = wizardPage;
        this.roots = new HashMap();
        this.isWizardMode = AgentInput.getInstance().getMode() == 1 && AgentInput.getInstance().getWizardSubMode() != 8;
        this.configureViewer((TreeViewer)this.getCheckboxTreeViewer());
    }

    public AvailableFixSection(IFormContext context, Composite parent, IFixesInRepPage wizardPage, String[] buttonLabels, boolean checkCondition) {
        this(context, parent, wizardPage, buttonLabels);
        this.checkCondition = checkCondition;
    }

    public AvailableFixSection(IFormContext context, Composite parent, IFixesInRepPage wizardPage) {
        this(context, parent, wizardPage, new String[]{Messages.AvailableUpdateSection_selectRecommendedBtn, Messages.AvailableFixSection_searchOtherFixes});
    }

    protected void buildVersionTree(List<AgentJob> offeringJobs, List fixJobs) {
        if (offeringJobs == null || fixJobs == null) {
            return;
        }
        Collection groupedOfferingJobs = AgentUtil.groupByProfile((AgentJob[])AgentJob.toArray(offeringJobs), (boolean)false);
        MapList archJobMap = new MapList();
        for (AgentJob[] jobs : groupedOfferingJobs) {
            Profile profile = jobs[0].getProfile();
            String arch = profile.isInstallLocationChangeable() ? BitModeUtils.getRecommendedProfileArch((AgentJob[])jobs) : profile.getArch();
            archJobMap.addAll((Object)arch, Arrays.asList(jobs));
        }
        for (AbstractJob fixJob : fixJobs) {
            IFix fix = fixJob.getFix();
            Set allArchs = archJobMap.keySet();
            for (String arch : allArchs) {
                List offJobs = archJobMap.get((Object)arch);
                for (AgentJob offeringJob : offJobs) {
                    FixNode fixNode;
                    VersionNode parent;
                    IOffering offering = offeringJob.getOffering();
                    if (offering == null || !FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) continue;
                    if (this.fixPage.isMultipleProfileInstall()) {
                        if (fixJob.getProfile() != offeringJob.getProfile()) continue;
                        parent = (VersionNode)this.roots.get(offering);
                        if (parent == null) {
                            parent = new VersionNode((AbstractJob)offeringJob, null);
                            this.roots.put(offering, parent);
                        }
                        fixNode = new FixNode(fixJob, parent);
                        parent.getFixes().add(fixNode);
                        if (!fixNode.canBeInstalled() || !fixNode.isRecommended() || !BitModeUtils.checkSupportsSpecificPlatform((IOfferingOrFix)fix, (String)Platform.getOS(), (String)arch)) continue;
                        this.recommendedNodes.add(fixNode);
                        continue;
                    }
                    parent = (VersionNode)this.roots.get(offering);
                    if (parent == null) {
                        parent = new VersionNode((AbstractJob)offeringJob, null);
                        this.roots.put(offering, parent);
                    }
                    fixNode = new FixNode(fixJob, parent);
                    parent.getFixes().add(fixNode);
                    if (!fixNode.canBeInstalled() || !fixNode.isRecommended() || !BitModeUtils.checkSupportsSpecificPlatform((IOfferingOrFix)fix, (String)Platform.getOS(), (String)arch)) continue;
                    this.recommendedNodes.add(fixNode);
                }
            }
        }
    }

    private TreeItem getFirstCheckedItem(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = tree.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getChecked()) {
                    TreeItem[] packageItems;
                    TreeItem[] treeItemArray2 = packageItems = item.getItems();
                    int n3 = packageItems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem packageItem = treeItemArray2[n4];
                        if (packageItem.getChecked()) {
                            return packageItem;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void primeSelection() {
        TreeViewer viewer = this.getTreePart().getTreeViewer();
        if (viewer != null) {
            TreeItem firstCheckedPkgItem = this.getFirstCheckedItem(viewer);
            if (firstCheckedPkgItem != null) {
                viewer.setSelection((ISelection)new StructuredSelection(firstCheckedPkgItem.getData()));
            } else {
                Tree tree = viewer.getTree();
                if (tree.getItemCount() > 0) {
                    TreeItem item = tree.getItem(0);
                    viewer.setSelection((ISelection)new StructuredSelection(item.getData()));
                }
            }
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.doCheckRecommended();
                break;
            }
            case 1: {
                this.searchForFixWasCanceled[0] = false;
                this.searchForOtherFixes();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void doCheckRecommended() {
        this.clearAllSelection();
        this.checkRecommended();
        this.checkJobsToleranceForAgent();
    }

    protected void clearAllSelection() {
        Collection rootNodes = this.roots.values();
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        for (Object parentObject : rootNodes) {
            this.elementChecked(viewer, parentObject, false);
        }
    }

    public void checkRecommended() {
        if (this.recommendedNodes.isEmpty()) {
            return;
        }
        this.getCheckboxTreeViewer().setCheckedElements(this.recommendedNodes.toArray());
        int i = 0;
        while (i < this.recommendedNodes.size()) {
            this.updateParents(this.getCheckboxTreeViewer(), this.recommendedNodes.get(i), true);
            ++i;
        }
        this.fixPage.setSelection();
    }

    private void checkDefaultSelectedJobs() {
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        for (Object parent : this.roots.values()) {
            List childrenNodes = this.getChildrenFixNodes(parent);
            for (FixNode fixNode : childrenNodes) {
                if (!fixNode.isSelected()) continue;
                AbstractJob job = fixNode.getJob();
                IStatus precheckStatus = Status.OK_STATUS;
                if (job != null) {
                    precheckStatus = AgentUIUtils.runPrecheckBundles((AgentJob)job);
                }
                if (!StatusUtil.isErrorOrCancel((IStatus)precheckStatus) && fixNode.canBeInstalled()) {
                    this.elementChecked(viewer, fixNode, true);
                    this.updateParents(viewer, fixNode.getParent(), true);
                    continue;
                }
                fixNode.setSelected(false);
            }
        }
        this.fixPage.setSelection();
    }

    @Override
    protected void checkItem(CheckboxTreeViewer viewer, Object element, boolean checked, boolean grayed) {
        if (element instanceof VersionNode || element instanceof PackageNode) {
            if (!checked && !grayed) {
                viewer.setGrayChecked(element, true);
            } else {
                viewer.setChecked(element, checked);
                viewer.setGrayed(element, grayed);
            }
        } else if (element instanceof FixNode) {
            viewer.setChecked(element, checked);
            viewer.setGrayed(element, grayed);
            ((FixNode)element).setSelected(checked);
            AbstractJob fixJob = ((FixNode)element).getJob();
            IFix fix = fixJob.getFix();
            for (IOffering offering : this.roots.keySet()) {
                if (!FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) continue;
                Object parent = this.roots.get(offering);
                List childrenNodes = this.getChildrenFixNodes(parent);
                int i = 0;
                while (i < childrenNodes.size()) {
                    FixNode otherFixNode = (FixNode)childrenNodes.get(i);
                    AbstractJob otherFixJob = otherFixNode.getJob();
                    if (otherFixNode != element && fix.equals(otherFixJob.getFix())) {
                        if (this.fixPage.isMultipleProfileInstall()) {
                            if (fixJob.getProfile() == otherFixJob.getProfile()) {
                                viewer.setChecked((Object)otherFixNode, checked);
                                viewer.setGrayed((Object)otherFixNode, grayed);
                                this.updateParents(viewer, otherFixNode.getParent(), checked);
                            }
                        } else {
                            viewer.setChecked((Object)otherFixNode, checked);
                            viewer.setGrayed((Object)otherFixNode, grayed);
                            this.updateParents(viewer, otherFixNode.getParent(), checked);
                        }
                    }
                    ++i;
                }
            }
        } else {
            super.checkItem(viewer, element, checked, grayed);
        }
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        viewer.setLabelProvider(this.getLabelProvider());
        viewer.setContentProvider((IContentProvider)this.getContentProvider());
        viewer.setSorter((ViewerSorter)new OfferingSorter());
        this.recommendedFilter = new RecommendedFilter();
        viewer.addFilter((ViewerFilter)this.recommendedFilter);
        this.createColumns(viewer);
        this.filterBoxPart.setFilterContainerVisible(true);
    }

    private void setTopItemVisible(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            tree.setTopItem(item);
        }
    }

    void checkJobsToleranceForAgent() {
        if (!this.uncheckJobsThatDontTolerateAgent()) {
            return;
        }
        this.fixPage.setSelection();
        this.fixPage.getPrimaryWizard().checkForAgentUpdate();
    }

    private boolean uncheckJobsThatDontTolerateAgent() {
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        boolean uncheckedJob = false;
        List rootNodes = this.getRootNodesInOrder();
        for (Object parent : rootNodes) {
            List childrenNodes = this.getChildrenFixNodes(parent);
            int j = 0;
            while (j < childrenNodes.size()) {
                FixNode fixNode = (FixNode)childrenNodes.get(j);
                if (fixNode.isSelected() && !fixNode.getToleranceStatus().isOK()) {
                    if (!uncheckedJob) {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)fixNode));
                        uncheckedJob = true;
                    }
                    this.elementChecked(viewer, fixNode, false);
                    this.updateParents(viewer, fixNode.getParent(), false);
                }
                ++j;
            }
        }
        return uncheckedJob;
    }

    private List getRootNodesInOrder() {
        Object[] expandedElements;
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        ArrayList<Object> rootNodes = new ArrayList<Object>();
        Object[] objectArray = expandedElements = viewer.getExpandedElements();
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof VersionNode || object instanceof PackageNode) {
                rootNodes.add(object);
            }
            ++n2;
        }
        return rootNodes;
    }

    private void setRecommendedButtonsVisible(boolean visible) {
        this.getTreePart().setButtonVisible(0, visible);
        this.showRecommendedButton.setVisible(visible);
    }

    protected Object[] getTreeInput() {
        return this.roots.values().toArray();
    }

    protected void resetTreeViewer(boolean checkDefaultSelectedJobs) {
        this.roots.clear();
        this.recommendedNodes.clear();
        this.buildVersionTree(this.fixPage.getSelectedOfferingJobs(), this.fixPage.getFixJobs());
        this.setSelectionForShowRecommendedOnlyButton();
        CheckboxTreeViewer viewer = this.getCheckboxTreeViewer();
        viewer.setInput((Object)this.getTreeInput());
        viewer.expandAll();
        this.setTopItemVisible((TreeViewer)viewer);
        if (checkDefaultSelectedJobs) {
            this.checkDefaultSelectedJobs();
        } else {
            this.checkRecommended();
        }
        this.primeSelection();
        AgentUIUtils.showOrHideFilterBoxAsync((TreeViewer)viewer, this.filterBoxPart);
    }

    private void setSelectionForShowRecommendedOnlyButton() {
        if (this.isWizardMode) {
            if (this.recommendedNodes.isEmpty()) {
                this.showAll = true;
                this.showRecommendedButton.setSelection(false);
            } else {
                boolean nonRecommendedFixesAvailable = this.isNonRecommendedFixesAvailable();
                if (nonRecommendedFixesAvailable) {
                    this.showAll = true;
                    this.showRecommendedButton.setSelection(false);
                }
            }
        } else if (this.recommendedNodes.isEmpty()) {
            this.showAll = true;
            this.showRecommendedButton.setSelection(false);
        }
        this.setRecommendedButtonsVisible(!this.recommendedNodes.isEmpty());
    }

    protected boolean isNonRecommendedFixesAvailable() {
        for (Object oOffering : this.roots.keySet()) {
            Object parent = this.roots.get(oOffering);
            List childrenNodes = this.getChildrenFixNodes(parent);
            for (Object oFixNode : childrenNodes) {
                FixNode fixnode = (FixNode)oFixNode;
                if (fixnode.isRecommended()) continue;
                return true;
            }
        }
        return false;
    }

    private TreeColumn createColumn(Tree tree, String name, TableLayout tableLayout, int width) {
        TreeColumn column = new TreeColumn(tree, 0x800000);
        column.setText(name);
        column.setResizable(true);
        if (tableLayout == null) {
            column.setWidth(width);
        } else {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(width, width, true));
        }
        return column;
    }

    private void createColumns(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        tree.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        this.createColumn(tree, Messages.AvailableFixSection_fixCol, tableLayout, 480);
        this.createColumn(tree, Messages.AvailableUpdateSection_recommendedCol, tableLayout, 100);
        this.createColumn(tree, Messages.InstalledOfferingSection_columnVendor, tableLayout, 120);
        this.createColumn(tree, Messages.AvailableOfferingSection_columnInstalled, tableLayout, 120);
        tree.setLayout((Layout)tableLayout);
    }

    @Override
    protected Control createFilterButtons(Composite parent) {
        Composite buttonsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        buttonsGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1, 1, false, false);
        buttonsGroup.setLayoutData((Object)gd);
        this.showRecommendedButton = this.getToolkit().createButton(buttonsGroup, Messages.AvailableFixSection_showRecommendedOnlyBtn, 0x800020);
        this.showRecommendedButton.setSelection(true);
        this.showRecommendedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvailableFixSection.this.handleShowRecommendedPressed(e);
            }
        });
        return buttonsGroup;
    }

    @Override
    protected void elementChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        if (element instanceof VersionNode || element instanceof PackageNode) {
            this.parentNodeChecked(viewer, element, checked);
        } else {
            super.elementChecked(viewer, element, checked);
        }
    }

    private void parentNodeChecked(CheckboxTreeViewer viewer, Object element, boolean checked) {
        Object[] children = this.getChildren(element);
        if (children.length > 0) {
            if (checked) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element2 = objectArray[n2];
                    FixNode child = (FixNode)element2;
                    AgentJob job = (AgentJob)child.getAdapter(AbstractJob.class);
                    if (child.canBeInstalled() && (job == null || !StatusUtil.isErrorOrCancel((IStatus)AgentUIUtils.runPrecheckBundles(job))) && child.getToleranceStatus().isOK()) {
                        this.elementChecked(viewer, child, checked);
                    }
                    ++n2;
                }
                this.updateItem(viewer, element, checked);
            } else {
                super.elementChecked(viewer, element, checked);
            }
        } else {
            super.elementChecked(viewer, element, checked);
        }
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new BaseJobContentProvider();
        }
        return this.contentProvider;
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new FixTreeJobLabelProvider(DisplayKeeper.INSTANCE.getDisplay());
        }
        return this.labelProvider;
    }

    private List getChildrenFixNodes(Object parent) {
        if (parent instanceof PackageNode) {
            return ((PackageNode)parent).getChildren();
        }
        if (parent instanceof VersionNode) {
            return ((VersionNode)parent).getFixes();
        }
        return new ArrayList();
    }

    private List getVisibleChildrenFixNodes(Object parent) {
        return Arrays.asList(this.getChildren(parent));
    }

    protected List<FixNode> getExtraFixNodes() {
        return new ArrayList<FixNode>(1);
    }

    private void handleShowRecommendedPressed(SelectionEvent e) {
        this.showAll = !((Button)e.getSource()).getSelection();
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
        viewer.refresh();
        if (this.showAll) {
            Collection parentNodes = this.roots.values();
            for (Object parent : parentNodes) {
                List fixNodes = this.getChildrenFixNodes(parent);
                int j = 0;
                while (j < fixNodes.size()) {
                    FixNode fNode = (FixNode)fixNodes.get(j);
                    if (fNode.isSelected()) {
                        this.checkItem(viewer, fNode, true, false);
                    }
                    ++j;
                }
            }
            List<FixNode> extraFixNode = this.getExtraFixNodes();
            for (FixNode fNode : extraFixNode) {
                if (!fNode.isSelected()) continue;
                this.checkItem(viewer, fNode, true, false);
            }
        }
        viewer.expandAll();
        this.setTopItemVisible((TreeViewer)viewer);
        this.fixPage.refreshDetailPage();
    }

    @Override
    protected void onCheckStateChange(CheckStateChangedEvent event) {
        Object selectedItem;
        StructuredSelection strutSelection;
        if (this.checkCondition) {
            boolean checked;
            if (this.checkIfGrayedItemWasChecked(event)) {
                CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
                viewer.setChecked(event.getElement(), false);
                return;
            }
            if (event.getChecked() && !(checked = this.checkJobsToleranceForAgentOnCheckStateChanged(event))) {
                event = new CheckStateChangedEvent(event.getCheckable(), event.getElement(), checked);
            }
        }
        if (event.getElement() instanceof VersionNode || event.getElement() instanceof PackageNode || event.getElement() instanceof FixContainerNode) {
            boolean checkAll = false;
            Object parent = event.getElement();
            List fixNodes = this.getVisibleChildrenFixNodes(parent);
            int i = 0;
            while (i < fixNodes.size()) {
                FixNode fNode = (FixNode)fixNodes.get(i);
                if (fNode.canBeInstalled() && !fNode.isSelected()) {
                    checkAll = true;
                    break;
                }
                ++i;
            }
            event = new CheckStateChangedEvent(event.getCheckable(), event.getElement(), checkAll);
        }
        super.onCheckStateChange(event);
        boolean resetSelection = true;
        ISelection currentSelection = this.getCheckboxTreeViewer().getSelection();
        if (currentSelection != null && currentSelection instanceof StructuredSelection && (strutSelection = (StructuredSelection)currentSelection).size() == 1 && (selectedItem = strutSelection.getFirstElement()).equals(event.getElement())) {
            resetSelection = false;
        }
        if (resetSelection) {
            this.getCheckboxTreeViewer().setSelection((ISelection)new StructuredSelection(event.getElement()));
        }
        this.fixPage.setSelection();
    }

    private boolean checkIfGrayedItemWasChecked(CheckStateChangedEvent event) {
        Object element;
        if (event.getChecked() && (element = event.getElement()) instanceof FixNode) {
            FixNode fixNode = (FixNode)element;
            return !fixNode.canBeInstalled();
        }
        return false;
    }

    private boolean checkJobsToleranceForAgentOnCheckStateChanged(CheckStateChangedEvent event) {
        IStatus sta;
        AgentJob job;
        IStatus status = Status.OK_STATUS;
        Object element = event.getElement();
        FixNode checkedNode = null;
        if (element instanceof VersionNode || element instanceof PackageNode) {
            List fixNodes = this.getChildrenFixNodes(element);
            boolean allFixesNotTolerant = true;
            CicMultiStatus fixToleranceStatus = Statuses.ST.createMultiStatus();
            int i = 0;
            while (i < fixNodes.size()) {
                FixNode fixNode = (FixNode)fixNodes.get(i);
                if (fixNode.canBeInstalled()) {
                    IStatus fixStatus = fixNode.getToleranceStatus();
                    if (!fixStatus.isOK()) {
                        fixToleranceStatus.add(fixStatus);
                        if (checkedNode == null) {
                            checkedNode = fixNode;
                        }
                    } else {
                        allFixesNotTolerant = false;
                    }
                }
                ++i;
            }
            if (!fixToleranceStatus.isOK() && allFixesNotTolerant) {
                status = fixToleranceStatus;
            }
        } else if (element instanceof FixNode) {
            FixNode fixNode = (FixNode)element;
            status = fixNode.getToleranceStatus();
            checkedNode = fixNode;
        }
        if (checkedNode != null && (job = (AgentJob)checkedNode.getAdapter(AbstractJob.class)) != null && StatusUtil.isErrorOrCancel((IStatus)(sta = AgentUIUtils.runPrecheckBundles(job)))) {
            return false;
        }
        if (!status.isOK()) {
            this.fixPage.getDetailPage().getObjectDescription(element);
            DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AvailableFixSection.this.fixPage.getPrimaryWizard().checkForAgentUpdate();
                }
            });
            return false;
        }
        return true;
    }

    private void addNewFixes(List newFixJobs, IProgressMonitor monitor) {
        Agent agent = AgentUI.getDefault().getAgent();
        List allFixes = agent.findAllFixes(true, monitor);
        List fixJobs = this.fixPage.getFixJobs();
        List selectedOfferingJobs = this.fixPage.getSelectedOfferingJobs();
        for (IFix fix : allFixes) {
            int i = 0;
            while (i < selectedOfferingJobs.size()) {
                AbstractJob offeringJob = (AbstractJob)selectedOfferingJobs.get(i);
                IOffering offering = offeringJob.getOffering();
                Profile profile = offeringJob.getProfile();
                if (FixUtil.isFixApplicable((IFix)fix, (IOffering)offering) && BitModeUtils.checkFixSupportedPlatforms((IFix)fix, (IOffering)offering)) {
                    AbstractJob fixJob = null;
                    fixJob = this.fixPage.createJob(fix, profile);
                    if (!AgentUIUtils.inExistingFixJobs((AgentJob)fixJob, fixJobs, this.fixPage.isMultipleProfileInstall())) {
                        newFixJobs.add(fixJob);
                        fixJobs.add(fixJob);
                    }
                }
                ++i;
            }
        }
        this.resetSupportCurrentPlatform();
        this.buildVersionTree(selectedOfferingJobs, newFixJobs);
    }

    private void resetSupportCurrentPlatform() {
        Collection versionNodes = this.roots.values();
        for (VersionNode vNode : versionNodes) {
            List fixNodes = vNode.getFixes();
            int i = 0;
            while (i < fixNodes.size()) {
                FixNode fNode = (FixNode)fixNodes.get(i);
                fNode.resetSupportCurrentPlatform();
                ++i;
            }
        }
    }

    private void searchForOtherFixes() {
        final ArrayList newFixes = new ArrayList();
        Agent agent = AgentUI.getDefault().getAgent();
        final IRepositoryGroup repositories = agent.getRepositoryGroup();
        final IStatus[] updateIMStatus = new IStatus[]{Status.OK_STATUS};
        final IStatus[] loadServiceRepStatus = new IStatus[]{Status.OK_STATUS};
        final Map[] repLocationMsgMap = new Map[]{new HashMap()};
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.getTreePart().getTreeViewer();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                HashSet installedProductOfferings;
                monitor.beginTask("", 3);
                SubProgressMonitor smonitor = new SubProgressMonitor(monitor, 1, 4);
                try {
                    if (!AvailableFixSection.this.isWizardMode || !Agent.getInstance().searchForAgentUpdate()) {
                        updateIMStatus[0] = Statuses.ST.createMultiStatus();
                    } else {
                        boolean mandatoryUpdate = false;
                        if (AvailableFixSection.this.fixPage.getPrimaryWizard().checkForAgentUpdate(updateIMStatus, mandatoryUpdate, (IProgressMonitor)smonitor)) {
                            return;
                        }
                    }
                }
                finally {
                    smonitor.done();
                }
                smonitor = new SubProgressMonitor(monitor, 1, 4);
                List selectedOfferings = AgentUIUtils.getSelectedProductOfferings(AvailableFixSection.this.fixPage.getSelectedOfferingJobs());
                ArrayList offeringsToSearchServiceRep = new ArrayList(selectedOfferings);
                if (!AvailableFixSection.this.isWizardMode && !(installedProductOfferings = AgentUIUtils.getInstalledProductOfferings()).isEmpty()) {
                    offeringsToSearchServiceRep.addAll(installedProductOfferings);
                }
                loadServiceRepStatus[0] = ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet((Map)repLocationMsgMap[0], (IRepositoryGroup)repositories, (IOffering[])offeringsToSearchServiceRep.toArray(new IOffering[offeringsToSearchServiceRep.size()]), (IProgressMonitor)smonitor);
                smonitor = new SubProgressMonitor(monitor, 1, 4);
                AvailableFixSection.this.addNewFixes(newFixes, (IProgressMonitor)smonitor);
                if (monitor.isCanceled()) {
                    ((AvailableFixSection)AvailableFixSection.this).searchForFixWasCanceled[0] = true;
                }
                monitor.done();
            }
        };
        try {
            int newFixCount;
            ISelection viewerSelection;
            int previousRootNodesSize = this.roots.size();
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, runnable);
            if (StatusUtil.isErrorOrCancel((IStatus)updateIMStatus[0])) {
                return;
            }
            if (previousRootNodesSize < this.roots.size()) {
                viewer.setInput((Object)this.roots.values().toArray());
                viewerSelection = viewer.getSelection();
                if (!viewerSelection.isEmpty()) {
                    this.fixPage.refreshDetailPage();
                }
                viewer.expandAll();
            } else {
                viewer.refresh();
                viewerSelection = viewer.getSelection();
                if (!viewerSelection.isEmpty()) {
                    this.fixPage.refreshDetailPage();
                }
                viewer.expandAll();
            }
            ScrollBar vScrollbar = viewer.getTree().getVerticalBar();
            if (vScrollbar != null && vScrollbar.isVisible()) {
                this.filterBoxPart.showFilterBox();
            }
            String message = com.ibm.cic.agent.core.sharedUI.Messages.AvailableFixSection_noFixFoundMsg;
            if (this.searchForFixWasCanceled[0]) {
                message = Messages.AvailableFixSection_noFixFoundBeforeCancel;
            }
            if ((newFixCount = newFixes.size()) > 0) {
                if (newFixCount > 1) {
                    message = !this.searchForFixWasCanceled[0] ? NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_fixesFound, (Object)String.valueOf(newFixCount)) : NLS.bind((String)Messages.AvailableOfferingSection_fixesFoundBeforeCancel, (Object)String.valueOf(newFixCount));
                } else if (newFixCount == 1) {
                    message = !this.searchForFixWasCanceled[0] ? NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_oneFixFound, (Object)String.valueOf(newFixCount)) : NLS.bind((String)Messages.AvailableOfferingSection_fixesFoundBeforeCancel, (Object)String.valueOf(newFixCount));
                }
                String repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap[0], (boolean)true);
                if (repStatusMessage.length() > 0) {
                    message = String.valueOf(message) + "\n\n";
                    message = String.valueOf(message) + repStatusMessage;
                }
                MessageDialog.openInformation((Shell)viewer.getTree().getShell(), (String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, (String)message);
                this.setRecommendedButtonsVisible(!this.recommendedNodes.isEmpty());
            } else if (loadServiceRepStatus[0].isOK()) {
                String repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap[0], (boolean)true);
                if (repStatusMessage.length() > 0) {
                    message = String.valueOf(message) + "\n\n";
                    message = String.valueOf(message) + repStatusMessage;
                }
                MessageDialog.openInformation((Shell)viewer.getTree().getShell(), (String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, (String)message);
            } else if (loadServiceRepStatus[0].isMultiStatus() && loadServiceRepStatus[0].getChildren() != null && loadServiceRepStatus[0].getChildren().length > 0) {
                IStatus[] children;
                message = String.valueOf(message) + "\n\n" + Messages.AvailableFixSection_noUpdateServiceRepMsg;
                String repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap[0], (boolean)true);
                if (repStatusMessage.length() > 0) {
                    message = String.valueOf(message) + "\n\n";
                    message = String.valueOf(message) + repStatusMessage;
                }
                CicMultiStatus displayStatus = Statuses.ST.createMultiStatus(message, new Object[0]);
                IStatus[] iStatusArray = children = loadServiceRepStatus[0].getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus element = iStatusArray[n2];
                    String msg = element.getMessage();
                    Status child = new Status(1, "com.ibm.cic.agent.ui", msg);
                    displayStatus.add((IStatus)child);
                    ++n2;
                }
                WrapDetailUIDErrorDialog dlg = new WrapDetailUIDErrorDialog(viewer.getTree().getShell(), com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, null, (IStatus)displayStatus, 1);
                dlg.open();
            } else {
                String repStatusMessage = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap[0], (boolean)true);
                if (repStatusMessage.length() > 0) {
                    message = String.valueOf(message) + "\n\n";
                    message = String.valueOf(message) + repStatusMessage;
                }
                MessageDialog.openInformation((Shell)viewer.getTree().getShell(), (String)com.ibm.cic.agent.core.sharedUI.Messages.AvailableOfferingSection_updateTitle_new, (String)message);
            }
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
    }

    @Override
    protected void checkLeafItems(CheckboxTreeViewer viewer, TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem[] children = items[i].getItems();
            if (children == null || children.length == 0) {
                Object data = items[i].getData();
                if (data instanceof FixNode) {
                    FixNode fixNode = (FixNode)data;
                    if (fixNode.isSelected() && !items[i].getChecked()) {
                        items[i].setChecked(true);
                        this.updateParents(viewer, fixNode.getParent(), true);
                    } else if (!fixNode.isSelected()) {
                        this.updateParents(viewer, fixNode.getParent(), false);
                    }
                }
            } else {
                this.checkLeafItems(viewer, children);
            }
            ++i;
        }
    }

    public boolean isShowAllChecked() {
        return !this.showRecommendedButton.getSelection();
    }

    protected static class FixTreeJobLabelProvider
    extends BaseJobNodeLabelProvider {
        public FixTreeJobLabelProvider(Display display) {
            super(display);
        }

        @Override
        public String getText(Object element) {
            if (element instanceof VersionNode) {
                IOffering offering = ((VersionNode)element).getOffering();
                return OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering, (boolean)false);
            }
            return super.getText(element);
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            FixNode fixNode;
            if (columnIndex == 3 && element instanceof FixNode && (fixNode = (FixNode)element).isUnavailable()) {
                return Messages.AvailableOfferingSection_notEntitled;
            }
            return super.getColumnText(element, columnIndex);
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof VersionNode) {
                IOffering offering = ((VersionNode)element).getOffering();
                return this.agentLabelProvider.getOfferingImage(offering);
            }
            return super.getImage(element);
        }

        @Override
        public Color getForeground(Object element, int columnIndex) {
            FixNode fixNode;
            VersionNode versionNode;
            if (element instanceof VersionNode ? (versionNode = (VersionNode)element).isUnavailable() : element instanceof FixNode && (fixNode = (FixNode)element).isUnavailable()) {
                return this.disabledColor;
            }
            return super.getForeground(element, columnIndex);
        }
    }

    private static class OfferingSorter
    extends ViewerSorter {
        private OfferingSorter() {
        }

        public int category(Object element) {
            if (element instanceof PackageNode) {
                return 1;
            }
            if (element instanceof VersionNode) {
                return 1;
            }
            if (element instanceof FixNode) {
                return 2;
            }
            return super.category(element);
        }

        public void sort(Viewer viewer, Object[] elements) {
            AgentUIUtils.sortByNameAndVersion(viewer, this, elements);
        }
    }

    private class RecommendedFilter
    extends ViewerFilter {
        private RecommendedFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (AvailableFixSection.this.showAll) {
                return true;
            }
            if (element instanceof FixNode) {
                FixNode node = (FixNode)element;
                return node.isRecommended();
            }
            return true;
        }
    }
}

