/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.views;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.ProfileOffering;
import com.ibm.cic.agent.core.sharedUI.ProfileOfferingFix;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.IAgentUIConstants;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.ViewInstalledOfferingsDialog;
import com.ibm.cic.agent.internal.ui.parts.TreeMasterPart;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.services.UiServices;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ViewInstalledOfferingsSection
extends TreeMasterPart
implements IAgentUIConstants {
    private final IFormContext context;
    private IDialogSettings dialogSettings;
    private TreeColumn offeringCol;
    private TreeColumn vendorCol;
    private TreeColumn licenseCol;
    private static final String P_OFFERING_COL = "offering";
    private static final String P_VENDOR_COL = "vendor";
    private static final String P_LICENSE_COL = "license";
    private static int offeringColInitWidth = 250;
    private static int vendorColInitWidth = 80;
    private static int licenseColInitWidth = 190;

    public ViewInstalledOfferingsSection(IFormContext context, Composite parent) {
        super(context, parent, 640, null, 512);
        this.context = context;
        this.configureViewer(this.getTreePart().getTreeViewer());
        this.getSection().setText(Messages.InstalledOfferingsDesc);
        this.getTreePart().getTreeViewer().setInput((Object)Agent.getInstance().getSortedProductProfiles(false));
        this.getTreePart().getTreeViewer().expandAll();
        Tree tree = this.getTreePart().getTreeViewer().getTree();
        if (tree.getItemCount() > 0) {
            TreeItem item = tree.getItem(0);
            tree.setTopItem(item);
        }
        this.makePreviewTasks();
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 65538, 2, toolkit);
        UiServices.getInstance().paintBordersFor(toolkit, container);
        section.setClient((Control)container);
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        int fullStyle = style;
        if (fullStyle == 0) {
            fullStyle = this.getToolkit().getBorderStyle() | 0x10000;
        }
        TreeViewer viewer = new TreeViewer(parent, fullStyle);
        this.getContext().getForm().getToolkit().adapt(viewer.getControl(), true, true);
        return viewer;
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.getContext().getForm().getToolkit();
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        if (this.context instanceof ViewInstalledOfferingsDialog) {
            this.dialogSettings = ((ViewInstalledOfferingsDialog)this.context).getLogSettings();
        } else {
            IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
            this.dialogSettings = settings.getSection(this.getClass().getName());
            if (this.dialogSettings == null) {
                this.dialogSettings = settings.addNewSection(this.getClass().getName());
            }
        }
        this.initInstallHistorySection();
        viewer.setContentProvider((IContentProvider)new InstalledOfferingsContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new InstalledOfferingsLabelProvider());
        this.createColumns(viewer);
        viewer.getTree().setHeaderVisible(true);
        viewer.getTree().setLinesVisible(false);
    }

    private void createColumns(TreeViewer viewer) {
        this.offeringCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.offeringCol.setText(Messages.InstalledOfferingsView_col1);
        this.offeringCol.setWidth(this.dialogSettings.getInt(P_OFFERING_COL));
        this.offeringCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ViewInstalledOfferingsSection.this.dialogSettings.put(ViewInstalledOfferingsSection.P_OFFERING_COL, ViewInstalledOfferingsSection.this.offeringCol.getWidth());
            }
        });
        this.vendorCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.vendorCol.setText(Messages.InstalledOfferingsView_col2);
        this.vendorCol.setWidth(this.dialogSettings.getInt(P_VENDOR_COL));
        this.vendorCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ViewInstalledOfferingsSection.this.dialogSettings.put(ViewInstalledOfferingsSection.P_VENDOR_COL, ViewInstalledOfferingsSection.this.vendorCol.getWidth());
            }
        });
        this.licenseCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.licenseCol.setText(Messages.InstalledOfferingsView_col3);
        this.licenseCol.setWidth(this.dialogSettings.getInt(P_LICENSE_COL));
        this.licenseCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ViewInstalledOfferingsSection.this.dialogSettings.put(ViewInstalledOfferingsSection.P_LICENSE_COL, ViewInstalledOfferingsSection.this.licenseCol.getWidth());
            }
        });
    }

    @Override
    public void primeSelection() {
        TreeViewer viewer = this.getTreePart().getTreeViewer();
        Tree installPkgTree = viewer.getTree();
        if (installPkgTree.getItemCount() > 0) {
            Object firstElement = installPkgTree.getItem(0).getData();
            viewer.setSelection((ISelection)new StructuredSelection(firstElement));
        }
    }

    void initInstallHistorySection() {
        try {
            this.dialogSettings.getInt(P_OFFERING_COL);
            this.dialogSettings.getInt(P_VENDOR_COL);
            this.dialogSettings.getInt(P_LICENSE_COL);
        }
        catch (NumberFormatException numberFormatException) {
            this.dialogSettings.put(P_OFFERING_COL, offeringColInitWidth);
            this.dialogSettings.put(P_VENDOR_COL, vendorColInitWidth);
            this.dialogSettings.put(P_LICENSE_COL, licenseColInitWidth);
        }
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getTreePart().getTreeViewer().getLabelProvider();
    }

    @Override
    public void showURL(String url) {
        AgentUI.getDefault().showURL(url);
    }

    private static class InstalledOfferingsContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private InstalledOfferingsContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Profile) {
                Profile profile = (Profile)parentElement;
                return ProfileOffering.getOfferingsFromProfile((Profile)profile);
            }
            if (parentElement instanceof ProfileOffering) {
                ProfileOffering profileOffering = (ProfileOffering)parentElement;
                return ProfileOfferingFix.getFixesFromProfileOffering((ProfileOffering)profileOffering);
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Profile) {
                Profile profile = (Profile)element;
                IOffering[] offerings = AgentUI.getDefault().getAgent().getInstalledOfferings(profile);
                return offerings.length > 0;
            }
            if (element instanceof ProfileOffering) {
                ProfileOffering profileOffering = (ProfileOffering)element;
                IFix[] fixes = AgentUI.getDefault().getAgent().getInstalledFixes(profileOffering.getProfile(), profileOffering.getOffering());
                return fixes.length > 0;
            }
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
        }
    }

    private static class InstalledOfferingsLabelProvider
    implements ITableLabelProvider {
        AgentUILabelProvider agentLabelProvider = AgentUI.getDefault().getLabelProvider();

        InstalledOfferingsLabelProvider() {
            this.agentLabelProvider.connect(this);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Profile) {
                    return this.agentLabelProvider.get(CommonImages.DESC_PROFILE_OBJ);
                }
                if (element instanceof ProfileOffering) {
                    IOffering offering = ((ProfileOffering)element).getOffering();
                    return this.agentLabelProvider.getOfferingImage(offering);
                }
                if (element instanceof IFix) {
                    return this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ);
                }
                if (element instanceof ProfileOfferingFix) {
                    return this.agentLabelProvider.get(CommonImages.DESC_FIX_OBJ);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getElementLabel(element);
            }
            if (element instanceof ProfileOffering) {
                IOffering offering = ((ProfileOffering)element).getOffering();
                switch (columnIndex) {
                    case 1: {
                        return offering.getProperties().getProperty("vendor.name", "");
                    }
                    case 2: {
                        return LicenseUtils.getRuntimeLicenseKinds((IOffering)offering);
                    }
                }
            }
            return null;
        }

        private String getElementLabel(Object element) {
            IFix fix;
            if (element instanceof Profile) {
                return ((Profile)element).getProfileId();
            }
            if (element instanceof ProfileOffering) {
                IOffering offering = ((ProfileOffering)element).getOffering();
                String offeringLabel = offering.getName();
                offeringLabel = String.valueOf(offeringLabel) + " ";
                Information info = offering.getInformation();
                offeringLabel = info != null && info.getVersion() != null ? String.valueOf(offeringLabel) + info.getVersion() : String.valueOf(offeringLabel) + offering.getVersion().toString();
                return offeringLabel;
            }
            if (element instanceof IFix) {
                IFix fix2 = (IFix)element;
                return this.getFixLabel(fix2);
            }
            if (element instanceof ProfileOfferingFix && (fix = ((ProfileOfferingFix)element).getFix()) != null) {
                return this.getFixLabel(fix);
            }
            return null;
        }

        private String getFixLabel(IFix fix) {
            String fixLabel = fix.getName();
            fixLabel = String.valueOf(fixLabel) + " ";
            Information info = fix.getInformation();
            fixLabel = info != null && info.getVersion() != null ? String.valueOf(fixLabel) + info.getVersion() : String.valueOf(fixLabel) + fix.getVersion().toString();
            return fixLabel;
        }

        public void dispose() {
            this.agentLabelProvider.disconnect(this);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

