/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.views;

import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.OpenLogDialog;
import com.ibm.cic.agent.internal.ui.views.IPreviewTaskProvider;
import com.ibm.cic.agent.internal.ui.views.LogSection;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.parser.EntryRecord;
import com.ibm.cic.common.logging.parser.MessageRecord;
import com.ibm.cic.common.logging.parser.ThrownRecord;
import com.ibm.cic.common.ui.internal.FormTextUtil;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LogDetailsPage
extends AbstractFormPart
implements IDetailsPage {
    private Label dateLabel;
    private Text dateText;
    private Label severityLabel;
    private Label severityImage;
    private Label severityText;
    private Label msgLabel;
    private FormText msgText;
    private Label exceptionLabel;
    private Text exceptionText;
    private final LogSection logSection;
    private IPreviewTaskProvider currentProvider;

    public LogDetailsPage(LogSection logSection) {
        this.logSection = logSection;
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        layout.bottomMargin = 0;
        layout.leftMargin = 2;
        layout.rightMargin = 5;
        layout.topMargin = 8;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 20;
        parent.setLayout((Layout)layout);
        toolkit.setBorderStyle(0);
        Section section = toolkit.createSection(parent, 512);
        section.setLayoutData((Object)new TableWrapData(256));
        section.marginHeight = 0;
        section.marginWidth = 5;
        section.setText(com.ibm.cic.agent.core.sharedUI.Messages.DetailsPage_title);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        layout = new TableWrapLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new TableWrapData(256));
        Color titleColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.dateLabel = toolkit.createLabel(container, Messages.LogViewDetails_dateLabel, 0);
        this.dateLabel.setForeground(titleColor);
        this.dateText = toolkit.createText(container, null, 8);
        this.severityLabel = toolkit.createLabel(container, Messages.LogViewDetails_severityLabel, 0);
        this.severityLabel.setForeground(titleColor);
        Composite group = toolkit.createComposite(container);
        TableWrapLayout innerLayout = new TableWrapLayout();
        innerLayout.numColumns = 2;
        innerLayout.leftMargin = 0;
        innerLayout.rightMargin = 0;
        innerLayout.topMargin = 0;
        innerLayout.bottomMargin = 0;
        group.setLayout((Layout)innerLayout);
        TableWrapData innerData = new TableWrapData();
        innerData.grabHorizontal = true;
        group.setLayoutData((Object)innerData);
        this.severityImage = toolkit.createLabel(group, null, 0);
        this.severityText = toolkit.createLabel(group, "", 0);
        this.msgLabel = toolkit.createLabel(container, Messages.LogViewDetails_msgLabel, 0);
        this.msgLabel.setForeground(titleColor);
        this.msgText = toolkit.createFormText(container, false);
        TableWrapData td = new TableWrapData(256);
        this.msgText.setLayoutData((Object)td);
        HyperlinkAdapter urlAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                OpenLogDialog.openSystemEditor(LogDetailsPage.this.msgText.getShell(), e.getHref().toString());
            }
        };
        this.msgText.setHyperlinkSettings((HyperlinkSettings)toolkit.getHyperlinkGroup());
        this.msgText.addHyperlinkListener((IHyperlinkListener)urlAction);
        this.exceptionLabel = toolkit.createLabel(container, Messages.LogViewDetails_exceptionLabel, 0);
        this.exceptionLabel.setForeground(titleColor);
        this.exceptionText = toolkit.createText(container, null, 74);
        td = new TableWrapData(256);
        this.exceptionText.setLayoutData((Object)td);
    }

    public void setSelection(IStructuredSelection selection) {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object object = ((StructuredSelection)selection).getFirstElement();
        this.currentProvider = (IPreviewTaskProvider)part;
        ITableLabelProvider tableLabelProvider = null;
        IBaseLabelProvider baseLabelProvider = this.currentProvider.getLabelProvider();
        if (!(baseLabelProvider instanceof ITableLabelProvider)) {
            return;
        }
        tableLabelProvider = (ITableLabelProvider)baseLabelProvider;
        EntryRecord entry = null;
        if (!(object instanceof EntryRecord)) {
            return;
        }
        entry = (EntryRecord)object;
        this.dateText.setText(tableLabelProvider.getColumnText((Object)entry, 3));
        this.severityImage.setImage(tableLabelProvider.getColumnImage((Object)entry, 0));
        this.severityText.setText(tableLabelProvider.getColumnText((Object)entry, 4));
        String message = SharedUIUtils.constructLogDescription((EntryRecord)entry);
        String href = null;
        MessageRecord messageRecord = entry.getMessageRecord();
        if (messageRecord != null) {
            href = messageRecord.getHref();
        }
        StringBuffer buf = new StringBuffer();
        boolean textContainsHtml = false;
        if (href != null && !StatusUtil.hasAnchor((String)message)) {
            textContainsHtml = true;
            buf.append("<form><p>");
            File resolvedFile = new File(this.logSection.getInput().getParentFile(), href);
            if (resolvedFile.exists()) {
                try {
                    href = resolvedFile.toURI().toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            buf.append("<a href=\"");
            buf.append(href);
            buf.append("\">");
            buf.append(message);
            buf.append("</a>");
            buf.append("</p></form>");
        } else if (StatusUtil.hasAnchor((String)message)) {
            textContainsHtml = true;
            buf.append("<form><p>");
            buf.append(FormTextUtil.escapeHTMLString((String)message));
            buf.append("</p></form>");
        } else {
            buf.append(message);
        }
        try {
            this.msgText.setText(buf.toString(), textContainsHtml, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.msgText.setText(String.valueOf(message) + (href == null ? "" : "[" + href + "]"), false, href != null);
        }
        String formattedStackTrace = SharedUIUtils.formatStackTrace((ThrownRecord)entry.getThrownRecord());
        this.exceptionText.setText(formattedStackTrace);
    }

    protected IPreviewTaskProvider getProvider() {
        return this.currentProvider;
    }
}

