/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.views;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.core.history.HistoryStore;
import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.agent.internal.core.history.IHistoryListener;
import com.ibm.cic.agent.internal.core.history.IOfferingInfo;
import com.ibm.cic.agent.internal.core.history.IProfileInfo;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUILabelProvider;
import com.ibm.cic.agent.internal.ui.IAgentUIConstants;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.dialogs.OpenLogDialog;
import com.ibm.cic.agent.internal.ui.dialogs.ViewInstallHistoryDialog;
import com.ibm.cic.agent.internal.ui.dialogs.ViewLogDialog;
import com.ibm.cic.agent.internal.ui.parts.TreeMasterPart;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.parts.IFormContext;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class InstallHistorySection
extends TreeMasterPart
implements IAgentUIConstants {
    private ViewerFilter historyFilter;
    private String filterProfileName;
    private List input;
    private final IFormContext context;
    private IDialogSettings dialogSettings;
    private File installHistoryFile;
    private TreeColumn profileCol;
    private TreeColumn activityCol;
    private TreeColumn dateCol;
    private TreeColumn statusCol;
    private TreeColumn offeringCol;
    private static int profileColInitWidth = 200;
    private static int activityColInitWidth = 80;
    private static int dateColInitWidth = 190;
    private static int statusColInitWidth = 70;
    private static int offeringColInitWidth = 200;
    public static final String P_ORDER_TYPE = "orderType";
    public static final String P_ORDER_VALUE = "orderValue";
    public static final String P_STATUS_COL = "statusCol";
    public static final String P_PROFILE_COL = "profileCol";
    public static final String P_ACTIVITY_COL = "activityCol";
    public static final String P_DATE_COL = "dateCol";
    public static final String P_OFFERING_COL = "offeringCol";
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private int PROFILE_ORDER = -1;
    private int ACTIVITY_ORDER = 1;
    private int STATUS_ORDER = 1;
    private int DATE_ORDER = -1;
    private static final int SORT_PROFILE = 0;
    private static final int SORT_ACTIVITY = 1;
    private static final int SORT_STATUS = 2;
    private static final int SORT_DATE = 3;

    public InstallHistorySection(IFormContext context, Composite parent) {
        super(context, parent, 640, new String[]{Messages.InstallHistoryView_showAllHistoryLabel, Messages.InstallHistoryView_viewLogLabel}, 256);
        this.context = context;
        this.configureViewer(this.getTreePart().getTreeViewer());
        AgentUILabelProvider labelProvider = AgentUI.getDefault().getLabelProvider();
        labelProvider.connect(this);
        this.getSection().setText(com.ibm.cic.agent.core.sharedUI.Messages.InstallHistoryView_title);
        if (this.filterProfileName == null) {
            this.getSection().setDescription("");
        } else {
            this.getSection().setDescription(NLS.bind((String)Messages.InstallHistoryView_des_for_profile, (Object)this.filterProfileName));
        }
        Image openInstallHistoryImage = labelProvider.get(CICImages.INSTALLHISTORY_OPEN_FILE);
        final ImageHyperlink openInstallHistoryLink = new ImageHyperlink((Composite)this.getSection(), 0);
        this.getToolkit().adapt((Composite)openInstallHistoryLink);
        openInstallHistoryLink.setImage(openInstallHistoryImage);
        openInstallHistoryLink.setToolTipText(Messages.InstallHistoryView_openHistoryFile_tooltip);
        openInstallHistoryLink.setBackground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        openInstallHistoryLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (InstallHistorySection.this.installHistoryFile != null) {
                    if (InstallHistorySection.this.installHistoryFile.exists()) {
                        OpenLogDialog.openSystemEditor(openInstallHistoryLink.getShell(), InstallHistorySection.this.installHistoryFile);
                    } else {
                        MessageDialog.openInformation((Shell)InstallHistorySection.this.getSection().getShell(), (String)Messages.InstallHistoryView_historyFileNotExist_title, (String)Messages.InstallHistoryView_historyFileNotExist);
                    }
                }
            }
        });
        this.getSection().setTextClient((Control)openInstallHistoryLink);
        if (this.input == null) {
            this.input = new ArrayList();
            Agent agent = AgentUI.getDefault().getAgent();
            HistoryStore historyStore = agent.getHistoryStore();
            Iterator it = historyStore.getAllProfileInfos();
            while (it.hasNext()) {
                IProfileInfo profileInfo = (IProfileInfo)it.next();
                Iterator activityIt = profileInfo.getHistory().getActivities();
                while (activityIt.hasNext()) {
                    this.input.add(activityIt.next());
                }
            }
            this.installHistoryFile = new File(historyStore.getAllHistoryFiles());
        }
        this.getTreePart().getTreeViewer().setInput((Object)this.input);
        this.initializeViewerSorter();
        this.makePreviewTasks();
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 65538, 2, toolkit);
        UiServices.getInstance().paintBordersFor(toolkit, container);
        section.setClient((Control)container);
    }

    public void setInput(List input) {
        this.input = input;
        this.getTreePart().getTreeViewer().setInput((Object)input);
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        int fullStyle = style;
        TreeViewer viewer = new TreeViewer(parent, fullStyle);
        this.getContext().getForm().getToolkit().adapt(viewer.getControl(), true, true);
        return viewer;
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.getContext().getForm().getToolkit();
    }

    public void dispose() {
        AgentUI.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    @Override
    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        if (this.context instanceof ViewInstallHistoryDialog) {
            this.dialogSettings = ((ViewInstallHistoryDialog)this.context).getLogSettings();
        } else {
            IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
            this.dialogSettings = settings.getSection(this.getClass().getName());
            if (this.dialogSettings == null) {
                this.dialogSettings = settings.addNewSection(this.getClass().getName());
            }
        }
        this.initInstallHistorySection();
        viewer.setContentProvider((IContentProvider)new InstallHistoryContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new InstallHistoryLabelProvider());
        this.createColumns(viewer);
        viewer.getTree().setHeaderVisible(true);
        viewer.getTree().setLinesVisible(true);
        this.getTreePart().setButtonVisible(0, this.filterProfileName != null);
        this.getTreePart().setButtonTooltip(0, Messages.InstallHistoryView_showAllHistoryBtn_tooltip);
        this.getTreePart().setButtonEnabled(1, viewer.getTree().getSelectionCount() > 0);
        this.getTreePart().setButtonTooltip(1, Messages.InstallHistoryView_showLogBtn_tooltip);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        if (this.getTreePart().getTreeViewer().getTree().getSelectionCount() > 0) {
            this.getTreePart().setButtonEnabled(1, true);
        } else {
            this.getTreePart().setButtonEnabled(1, false);
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.updateViewerFilter(null);
                break;
            }
            case 1: {
                this.viewLog();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void primeSelection() {
        TreeViewer viewer;
        Tree historyTree;
        if (this.input != null && this.input.size() > 0 && (historyTree = (viewer = this.getTreePart().getTreeViewer()).getTree()).getItemCount() > 0) {
            Object firstElement = historyTree.getItem(0).getData();
            viewer.setSelection((ISelection)new StructuredSelection(firstElement));
        }
    }

    private void viewLog() {
        IActivity selectedActivity = null;
        ISelection selection = this.getTreePart().getTreeViewer().getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selectedActivity = (IActivity)structuredSelection.getFirstElement();
        }
        if (selectedActivity == null) {
            return;
        }
        File logFile = selectedActivity.getLogFile();
        Shell shell = this.getContext().getShell();
        ViewLogDialog dlg = new ViewLogDialog(shell, logFile);
        dlg.open();
    }

    private void createColumns(final TreeViewer viewer) {
        this.dateCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.dateCol.setText(com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_dateCol);
        this.dateCol.setWidth(this.dialogSettings.getInt(P_DATE_COL));
        this.dateCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_DATE_COL, InstallHistorySection.this.dateCol.getWidth());
            }
        });
        this.dateCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallHistorySection installHistorySection = InstallHistorySection.this;
                installHistorySection.DATE_ORDER = installHistorySection.DATE_ORDER * -1;
                ViewerSorter sorter = InstallHistorySection.this.getViewerSorter(3);
                viewer.setSorter(sorter);
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ORDER_VALUE, InstallHistorySection.this.DATE_ORDER);
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ORDER_TYPE, 3);
                InstallHistorySection.this.setColumnSorting(InstallHistorySection.this.dateCol, InstallHistorySection.this.DATE_ORDER);
            }
        });
        this.activityCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.activityCol.setText(com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_activityCol);
        this.activityCol.setWidth(this.dialogSettings.getInt(P_ACTIVITY_COL));
        this.activityCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ACTIVITY_COL, InstallHistorySection.this.activityCol.getWidth());
            }
        });
        this.activityCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallHistorySection installHistorySection = InstallHistorySection.this;
                installHistorySection.ACTIVITY_ORDER = installHistorySection.ACTIVITY_ORDER * -1;
                ViewerSorter sorter = InstallHistorySection.this.getViewerSorter(1);
                viewer.setSorter(sorter);
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ORDER_VALUE, InstallHistorySection.this.ACTIVITY_ORDER);
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ORDER_TYPE, 1);
                InstallHistorySection.this.setColumnSorting(InstallHistorySection.this.activityCol, InstallHistorySection.this.ACTIVITY_ORDER);
            }
        });
        this.profileCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.profileCol.setText(com.ibm.cic.agent.core.sharedUI.Messages.General_Summary_PackageGroupName);
        this.profileCol.setWidth(this.dialogSettings.getInt(P_PROFILE_COL));
        this.profileCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_PROFILE_COL, InstallHistorySection.this.profileCol.getWidth());
            }
        });
        this.profileCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallHistorySection installHistorySection = InstallHistorySection.this;
                installHistorySection.PROFILE_ORDER = installHistorySection.PROFILE_ORDER * -1;
                ViewerSorter sorter = InstallHistorySection.this.getViewerSorter(0);
                viewer.setSorter(sorter);
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ORDER_VALUE, InstallHistorySection.this.PROFILE_ORDER);
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ORDER_TYPE, 0);
                InstallHistorySection.this.setColumnSorting(InstallHistorySection.this.profileCol, InstallHistorySection.this.PROFILE_ORDER);
            }
        });
        this.statusCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.statusCol.setText(com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_statusCol);
        this.statusCol.setWidth(this.dialogSettings.getInt(P_STATUS_COL));
        this.statusCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_STATUS_COL, InstallHistorySection.this.statusCol.getWidth());
            }
        });
        this.statusCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallHistorySection installHistorySection = InstallHistorySection.this;
                installHistorySection.STATUS_ORDER = installHistorySection.STATUS_ORDER * -1;
                ViewerSorter sorter = InstallHistorySection.this.getViewerSorter(2);
                viewer.setSorter(sorter);
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ORDER_VALUE, InstallHistorySection.this.STATUS_ORDER);
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_ORDER_TYPE, 2);
                InstallHistorySection.this.setColumnSorting(InstallHistorySection.this.statusCol, InstallHistorySection.this.STATUS_ORDER);
            }
        });
        this.offeringCol = new TreeColumn(viewer.getTree(), 0x800000);
        this.offeringCol.setText(com.ibm.cic.agent.core.sharedUI.Messages.InstallationHistoryView_offeringCol);
        this.offeringCol.setWidth(this.dialogSettings.getInt(P_OFFERING_COL));
        this.offeringCol.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InstallHistorySection.this.dialogSettings.put(InstallHistorySection.P_OFFERING_COL, InstallHistorySection.this.offeringCol.getWidth());
            }
        });
    }

    private void initializeViewerSorter() {
        int orderType = this.dialogSettings.getInt(P_ORDER_TYPE);
        ViewerSorter sorter = this.getViewerSorter(orderType);
        this.getTreePart().getTreeViewer().setSorter(sorter);
        if (orderType == 0) {
            this.setColumnSorting(this.profileCol, this.PROFILE_ORDER);
        } else if (orderType == 1) {
            this.setColumnSorting(this.activityCol, this.ACTIVITY_ORDER);
        } else if (orderType == 2) {
            this.setColumnSorting(this.statusCol, this.STATUS_ORDER);
        } else if (orderType == 3) {
            this.setColumnSorting(this.dateCol, this.DATE_ORDER);
        }
    }

    private void setColumnSorting(TreeColumn column, int order) {
        this.getTreePart().getTreeViewer().getTree().setSortColumn(column);
        this.getTreePart().getTreeViewer().getTree().setSortDirection(order == 1 ? 128 : 1024);
    }

    private ViewerSorter getViewerSorter(int sortType) {
        if (sortType == 0) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    IActivity activity1 = (IActivity)e1;
                    IActivity activity2 = (IActivity)e2;
                    return super.compare(viewer, (Object)activity1.getHistory().getProfileInfo().getProfileIdentity().getProfileId(), (Object)activity2.getHistory().getProfileInfo().getProfileIdentity().getProfileId()) * InstallHistorySection.this.PROFILE_ORDER;
                }
            };
        }
        if (sortType == 1) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    IActivity activity1 = (IActivity)e1;
                    IActivity activity2 = (IActivity)e2;
                    return super.compare(viewer, (Object)activity1.getActivityType(), (Object)activity2.getActivityType()) * InstallHistorySection.this.ACTIVITY_ORDER;
                }
            };
        }
        if (sortType == 2) {
            return new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    IActivity activity1 = (IActivity)e1;
                    IActivity activity2 = (IActivity)e2;
                    String statusString1 = SharedUIUtils.getLocalizedStatus((IActivity)activity1);
                    String statusString2 = SharedUIUtils.getLocalizedStatus((IActivity)activity2);
                    return super.compare(viewer, (Object)statusString1, (Object)statusString2) * InstallHistorySection.this.STATUS_ORDER;
                }
            };
        }
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IActivity activity1 = (IActivity)e1;
                IActivity activity2 = (IActivity)e2;
                return super.compare(viewer, (Object)activity1.getStartTime(), (Object)activity2.getStartTime()) * InstallHistorySection.this.DATE_ORDER;
            }
        };
    }

    void initInstallHistorySection() {
        this.readSettings();
        int type = this.dialogSettings.getInt(P_ORDER_TYPE);
        switch (type) {
            case 3: {
                this.DATE_ORDER = this.dialogSettings.getInt(P_ORDER_VALUE);
                this.PROFILE_ORDER = -1;
                this.ACTIVITY_ORDER = -1;
                this.STATUS_ORDER = -1;
                break;
            }
            case 0: {
                this.PROFILE_ORDER = this.dialogSettings.getInt(P_ORDER_VALUE);
                this.DATE_ORDER = -1;
                this.ACTIVITY_ORDER = -1;
                this.STATUS_ORDER = -1;
                break;
            }
            case 2: {
                this.STATUS_ORDER = this.dialogSettings.getInt(P_ORDER_VALUE);
                this.DATE_ORDER = -1;
                this.ACTIVITY_ORDER = -1;
                this.PROFILE_ORDER = -1;
                break;
            }
            case 1: {
                this.ACTIVITY_ORDER = this.dialogSettings.getInt(P_ORDER_VALUE);
                this.DATE_ORDER = -1;
                this.PROFILE_ORDER = -1;
                this.STATUS_ORDER = -1;
                break;
            }
            default: {
                this.PROFILE_ORDER = -1;
                this.DATE_ORDER = -1;
                this.ACTIVITY_ORDER = -1;
                this.STATUS_ORDER = -1;
            }
        }
    }

    private void readSettings() {
        try {
            this.dialogSettings.getInt(P_STATUS_COL);
            this.dialogSettings.getInt(P_PROFILE_COL);
            this.dialogSettings.getInt(P_ACTIVITY_COL);
            this.dialogSettings.getInt(P_DATE_COL);
            this.dialogSettings.getInt(P_OFFERING_COL);
            this.dialogSettings.getInt(P_ORDER_VALUE);
            this.dialogSettings.getInt(P_ORDER_TYPE);
        }
        catch (NumberFormatException numberFormatException) {
            this.dialogSettings.put(P_STATUS_COL, statusColInitWidth);
            this.dialogSettings.put(P_PROFILE_COL, profileColInitWidth);
            this.dialogSettings.put(P_ACTIVITY_COL, activityColInitWidth);
            this.dialogSettings.put(P_DATE_COL, dateColInitWidth);
            this.dialogSettings.put(P_OFFERING_COL, offeringColInitWidth);
            this.dialogSettings.put(P_ORDER_TYPE, this.DATE_ORDER);
            this.dialogSettings.put(P_ORDER_VALUE, -1);
        }
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return this.getTreePart().getTreeViewer().getLabelProvider();
    }

    @Override
    public void showURL(String url) {
        AgentUI.getDefault().showURL(url);
    }

    public void updateViewerFilter(String newProfileId) {
        this.filterProfileName = newProfileId;
        ViewerFilter oldHistoryFilter = this.historyFilter;
        if (oldHistoryFilter != null) {
            this.getTreePart().getTreeViewer().removeFilter(oldHistoryFilter);
            this.historyFilter = null;
        }
        if (newProfileId != null) {
            this.historyFilter = new InstallHistoryFilter(newProfileId);
            this.getTreePart().getTreeViewer().addFilter(this.historyFilter);
            this.getSection().setDescription(NLS.bind((String)Messages.InstallHistoryView_des_for_profile, (Object)this.filterProfileName));
            Control descControl = this.getSection().getDescriptionControl();
            if (descControl != null) {
                descControl.redraw();
            }
            this.getTreePart().setButtonVisible(0, true);
            this.getTreePart().setButtonEnabled(0, true);
            Agent agent = AgentUI.getDefault().getAgent();
            HistoryStore historyStore = agent.getHistoryStore();
            Iterator it = historyStore.getAllProfileInfos();
            while (it.hasNext()) {
                IProfileInfo profileInfo = (IProfileInfo)it.next();
                if (!profileInfo.getProfileIdentity().getProfileId().equals(newProfileId)) continue;
                this.installHistoryFile = new File(profileInfo.getHistory().getHistoryFilePath());
                break;
            }
        } else {
            this.getSection().setDescription("");
            Control descControl = this.getSection().getDescriptionControl();
            if (descControl != null) {
                descControl.redraw();
            }
            this.getTreePart().setButtonVisible(0, true);
            this.getTreePart().setButtonEnabled(0, false);
            Agent agent = AgentUI.getDefault().getAgent();
            HistoryStore historyStore = agent.getHistoryStore();
            this.installHistoryFile = new File(historyStore.getAllHistoryFiles());
        }
    }

    private class InstallHistoryContentProvider
    implements ITreeContentProvider,
    IHistoryListener {
        private TreeViewer viewer;

        private InstallHistoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
            Agent agent = AgentUI.getDefault().getAgent();
            HistoryStore historyStore = agent.getHistoryStore();
            historyStore.removeListener((IHistoryListener)this);
        }

        public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
            this.viewer = (TreeViewer)theViewer;
            if (oldInput == null && newInput != null) {
                Agent agent = AgentUI.getDefault().getAgent();
                HistoryStore historyStore = agent.getHistoryStore();
                historyStore.addListener((IHistoryListener)this);
            } else if (oldInput != null && newInput == null) {
                Agent agent = AgentUI.getDefault().getAgent();
                HistoryStore historyStore = agent.getHistoryStore();
                historyStore.removeListener((IHistoryListener)this);
            }
        }

        public void historyUpdated(IActivity[] newActivities) {
            IActivity[] finalActivities;
            IActivity[] iActivityArray = finalActivities = newActivities;
            int n = finalActivities.length;
            int n2 = 0;
            while (n2 < n) {
                IActivity finalActivity = iActivityArray[n2];
                InstallHistorySection.this.input.add(finalActivity);
                ++n2;
            }
            Control ctrl = this.viewer.getControl();
            if (ctrl != null && !ctrl.isDisposed()) {
                DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (InstallHistoryContentProvider.this.viewer != null) {
                            InstallHistoryContentProvider.this.viewer.refresh();
                        }
                    }
                });
            }
        }
    }

    private static class InstallHistoryFilter
    extends ViewerFilter {
        private final String profileId;

        InstallHistoryFilter(String profileId) {
            this.profileId = profileId;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IActivity) {
                IActivity activity = (IActivity)element;
                String id = activity.getHistory().getProfileInfo().getProfileIdentity().getProfileId();
                return this.profileId.equals(id);
            }
            return false;
        }
    }

    private static class InstallHistoryLabelProvider
    implements ITableLabelProvider {
        InstallHistoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IActivity) {
                IActivity activity = (IActivity)element;
                if (columnIndex == 0) {
                    return activity.getStartTime();
                }
                if (columnIndex == 1) {
                    return SharedUIUtils.ACTIVITY_TYPE[activity.getActivityType()];
                }
                if (columnIndex == 2) {
                    return activity.getHistory().getProfileInfo().getProfileIdentity().getProfileId();
                }
                if (columnIndex == 3) {
                    return SharedUIUtils.getLocalizedStatus((IActivity)activity);
                }
                if (columnIndex == 4) {
                    String offerings = "";
                    IOfferingInfo[] allOfferings = activity.getAllOfferingArray();
                    if (activity.getActivityType() == 3) {
                        if (allOfferings.length > 1) {
                            offerings = NLS.bind((String)Messages.InstallHistorySection_UpdateOffering, (Object)this.getOfferingDisplayName(allOfferings[0]), (Object)this.getOfferingDisplayName(allOfferings[1]));
                        }
                    } else if (allOfferings.length > 0) {
                        offerings = this.getOfferingDisplayName(allOfferings[0]);
                    }
                    return offerings;
                }
            }
            return null;
        }

        private String getOfferingDisplayName(IOfferingInfo offeringInfo) {
            StringBuffer offeringDisplayName = new StringBuffer();
            String offeringName = "";
            Information info = offeringInfo.getInformation();
            offeringName = info == null ? offeringInfo.getOfferingIdentity().getId() : (info.getName() == null || info.getName().length() == 0 ? offeringInfo.getOfferingIdentity().getId() : info.getName());
            offeringDisplayName.append(offeringName);
            offeringDisplayName.append(" ");
            if (offeringInfo.getLocalizedVersion() != null) {
                offeringDisplayName.append(offeringInfo.getLocalizedVersion());
            }
            return offeringDisplayName.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

