/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GetInitDataParser
extends XMLParser {
    private static final Logger logger = Logger.getLogger(GetInitDataParser.class);
    static final String RESPONSE = "response";
    static final String OPTION = "option";
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int NO_CONTENT_STATE = 1;
    private static final int INITIAL_STATE = 2;
    private static final int RESPONSE_STATE = 3;
    private static final int OPTION_STATE = 4;
    private static final String[] STATE_NAMES = new String[]{"IGNORED", "NO CONTENT", "INITIAL", "response", "option"};
    private Object rootObject;

    public GetInitDataParser(BundleContext context, String pluginId) {
        super(context, pluginId);
        this.stateStack = new XMLParser.StateStack(STATE_NAMES);
        this.status = Statuses.ST.createMultiStatus();
    }

    protected String getErrorMessage() {
        return Messages.GetInitDataParserError;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Object getRootObject() {
        return this.rootObject;
    }

    protected String processCharacters(String trimmedChars) {
        switch (this.stateStack.peekState()) {
            case 4: {
                this.setValue(trimmedChars);
                break;
            }
            default: {
                this.unexpectedCharacterData(trimmedChars);
            }
        }
        return trimmedChars;
    }

    public String toString() {
        return this.stateStack.toString();
    }

    public synchronized List parse(InputStream stream) throws IOException {
        try {
            this.getParser().parse(stream, (DefaultHandler)((Object)this));
            List list = (List)this.rootObject;
            return list;
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            stream.close();
        }
    }

    public void startDocument() {
        this.stateStack.clear();
        this.stateStack.push(2, null);
    }

    public void endDocument() {
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) {
        this.trace(name, attributes);
        switch (this.stateStack.peekState()) {
            case 0: {
                this.stateStack.push(0, (Object)("error: " + name));
                break;
            }
            case 2: {
                this.handleInitialState(name, attributes);
                break;
            }
            case 3: {
                this.handleResponseState(name, attributes);
                break;
            }
            default: {
                throw new XMLParser.BadStateError((XMLParser)this);
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.trace(name, null);
        this.finishCharacters();
        int state = this.stateStack.peekState();
        Object object = this.stateStack.peekObject();
        this.stateStack.pop();
        Object parentObject = this.stateStack.peekObject();
        switch (state) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                if (!(object instanceof List)) {
                    throw new XMLParser.BadStateError((XMLParser)this);
                }
                this.rootObject = object;
                break;
            }
            case 4: {
                if (!(object instanceof StringBuffer)) {
                    throw new XMLParser.BadStateError((XMLParser)this);
                }
                List list = (List)parentObject;
                list.add(((StringBuffer)object).toString());
                break;
            }
            default: {
                throw new XMLParser.BadStateError((XMLParser)this);
            }
        }
    }

    protected void setValue(String trimmedChars) {
        Object obj = this.stateStack.peekObject();
        if (obj instanceof StringBuffer) {
            StringBuffer buf = (StringBuffer)this.stateStack.peekObject();
            buf.append(trimmedChars);
        }
    }

    private void handleResponseState(String element, Attributes attributes) {
        if (!OPTION.equals(element)) {
            this.unexpectedElementError(element, attributes);
        } else {
            this.stateStack.push(4, (Object)new StringBuffer());
        }
    }

    private void handleInitialState(String element, Attributes attributes) {
        if (!RESPONSE.equals(element)) {
            this.unexpectedElementError(element, attributes);
        } else {
            this.stateStack.push(3, new LinkedList());
        }
    }
}

