/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.console.manager.InstalledOfferingsState;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.sharedUI.IContainsFix;
import com.ibm.cic.agent.core.sharedUI.IContainsOffering;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.factories.LauncherFactory;
import com.ibm.cic.agent.internal.ui.parts.TreeFilterBoxPart;
import com.ibm.cic.agent.internal.ui.utils.IProfileAndOfferings;
import com.ibm.cic.agent.internal.ui.utils.OfferingTreeNode;
import com.ibm.cic.agent.internal.ui.utils.ProfileJobNode;
import com.ibm.cic.agent.internal.ui.utils.ProfileTreeNode;
import com.ibm.cic.agent.internal.ui.wizards.WizardConstructionPage;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.sharedUI.CommonSharedUIUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.views.AbstractCicWizardView;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class AgentUIUtils {
    public static String getDisplayableVersion(IOfferingOrFix offeringOrFix) {
        String result = "";
        if (offeringOrFix == null) {
            return result;
        }
        Information info = offeringOrFix.getInformation();
        if (info == null) {
            return offeringOrFix.getVersion().toString();
        }
        result = info.getVersion();
        if (result == null) {
            return offeringOrFix.getVersion().toString();
        }
        return result;
    }

    public static String getOfferingOrFixLabel(IOfferingOrFix offeringOrFix) {
        boolean showInternalVersion = AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
        return OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix, (boolean)showInternalVersion);
    }

    public static String escapeSpecialChars(String value) {
        return CommonUIUtils.escapeSpecialChars((String)value);
    }

    public static String convertReturnChar(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        value = value.indexOf("\r\n") != -1 ? value.replaceAll("\r\n", "<br></br>") : value;
        value = value.indexOf("\r") != -1 ? value.replaceAll("\r", "<br></br>") : value;
        value = value.indexOf("\n") != -1 ? value.replaceAll("\n", "<br></br>") : value;
        return value;
    }

    public static String convertSpecialCharsForDescription(String value) {
        String desc = AgentUIUtils.escapeSpecialChars(value);
        return AgentUIUtils.convertReturnChar(desc);
    }

    public static boolean resolveSelectedJobs(List jobs) {
        return AgentUIUtils.prepareAndResolveSelectedJobs(jobs, true);
    }

    public static List getSelectedJobs(List jobs) {
        ArrayList<AbstractJob> selectedJobs = new ArrayList<AbstractJob>();
        if (jobs != null) {
            int i = 0;
            while (i < jobs.size()) {
                AbstractJob job = (AbstractJob)jobs.get(i);
                if (job.isSelected()) {
                    selectedJobs.add(job);
                }
                ++i;
            }
        }
        return selectedJobs;
    }

    public static List getSelectedOfferingsOrFixes(List jobs) {
        ArrayList<IOfferingOrFix> offeringsOrFixes = new ArrayList<IOfferingOrFix>();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            if (job.isSelected()) {
                offeringsOrFixes.add(job.getOfferingOrFix());
            }
            ++i;
        }
        return offeringsOrFixes;
    }

    public static List getSelectedOfferingOrFixIds(List jobs) {
        ArrayList<String> offeringOrFixIds = new ArrayList<String>();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            if (job.isSelected()) {
                offeringOrFixIds.add(job.getOfferingOrFix().getIdentity().getId());
            }
            ++i;
        }
        return offeringOrFixIds;
    }

    public static List getSelectedVisibleOfferingsOrFixes(List jobs) {
        ArrayList<IOfferingOrFix> offeringsOrFixes = new ArrayList<IOfferingOrFix>();
        int i = 0;
        while (i < jobs.size()) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            if (job.isSelected()) {
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                if (offeringOrFix instanceof IOffering) {
                    if (!LicenseUtils.isPEKOffering((IOffering)((IOffering)offeringOrFix))) {
                        offeringsOrFixes.add(offeringOrFix);
                    }
                } else {
                    offeringsOrFixes.add(offeringOrFix);
                }
            }
            ++i;
        }
        return offeringsOrFixes;
    }

    public static IOffering[] getSelectedProductOfferingArray(List jobs) {
        List return_value = AgentUIUtils.getSelectedProductOfferings(jobs);
        return return_value.toArray(new IOffering[return_value.size()]);
    }

    public static List getSelectedProductOfferings(List jobs) {
        ArrayList<IOffering> offeringList = new ArrayList<IOffering>();
        int i = 0;
        while (i < jobs.size()) {
            IOffering offering;
            AbstractJob job = (AbstractJob)jobs.get(i);
            if (job.isSelected() && (offering = job.getOffering()) != null && !LicenseUtils.isPEKOffering((IOffering)offering) && !Agent.getInstance().isAgentOffering((IOfferingOrFix)offering)) {
                offeringList.add(offering);
            }
            ++i;
        }
        return offeringList;
    }

    public static boolean prepareAndResolveSelectedJobs(List jobs) {
        return AgentUIUtils.prepareAndResolveSelectedJobs(jobs, false);
    }

    public static boolean prepareAndResolveSelectedJobs(List jobs, boolean skipPrepare) {
        List offeringsToPrepare = AgentUIUtils.getSelectedOfferingsOrFixes(jobs);
        return AgentUIUtils.prepareAndResolveOfferings(offeringsToPrepare, skipPrepare);
    }

    public static boolean prepareAndResolveOfferings(final List offeringsToPrepare, final boolean skipPrepare) {
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    Agent agent = AgentUI.getDefault().getAgent();
                    int[] weights = SharedUIUtils.getProgressWeightages((List)offeringsToPrepare);
                    int work = 0;
                    int[] nArray = weights;
                    int n = weights.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int weight = nArray[n2];
                        work += weight;
                        ++n2;
                    }
                    SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
                    Iterator iterator = offeringsToPrepare.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        IStatus status;
                        int ticks = weights[i++];
                        SubMonitor sm2 = sm.newChild(ticks, 0);
                        IOfferingOrFix offeringOrFix = (IOfferingOrFix)iterator.next();
                        if (offeringOrFix instanceof IOffering && !skipPrepare) {
                            sm2.setWorkRemaining(2);
                            status = agent.prepare(offeringOrFix, ExtensionCategory.ALL, (IProgressMonitor)sm2.newChild(1, 0));
                            if (!status.isOK()) {
                                if (status.matches(8)) {
                                    throw new OperationCanceledException(MultiStatusUtil.getFailureMessage((IStatus)status));
                                }
                                throw new RuntimeException(MultiStatusUtil.getFailureMessage((IStatus)status));
                            }
                        } else {
                            sm2.setWorkRemaining(1);
                        }
                        if ((status = agent.resolve(offeringOrFix, (IProgressMonitor)sm2.newChild(1, 0))) == Status.CANCEL_STATUS) {
                            OperationCanceledException e = new OperationCanceledException(Messages.FeatureSelectionPage_offeringResolveProcessWasCanceled);
                            throw e;
                        }
                        if (status.isOK()) continue;
                        RuntimeException e = new RuntimeException(MultiStatusUtil.getFailureMessage((IStatus)status));
                        throw e;
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static IOffering getNextLatestVersion(IOffering offering, Profile profile) {
        IOffering[] installed = AgentUI.getDefault().getAgent().getInstalledOfferings(profile, offering.getIdentity());
        if (installed.length < 2) {
            return null;
        }
        Arrays.sort(installed, new Comparator(){

            public int compare(Object o1, Object o2) {
                IOffering of1 = (IOffering)o1;
                IOffering of2 = (IOffering)o2;
                return of1.compareVersion((IContent)of2);
            }
        });
        return installed[installed.length - 2];
    }

    public static int calculateSpaceTableColumnWidth(Table table, String columnText) {
        return CommonUIUtils.calculateStringWidth((Control)table, (String)columnText, (int)5);
    }

    public static String getLicenseExpirationDateLabel(LicenseStatus licenseStatus) {
        String expdateStr = licenseStatus.getExpireDateString();
        boolean isTrial = licenseStatus.isLumTrial();
        if (!isTrial || expdateStr != null) {
            return expdateStr;
        }
        return licenseStatus.getLocalizedStatusString();
    }

    public static void updateHelpRefInsidePage(WizardConstructionPage page, String helpRef) {
        AbstractCicWizardView wizardView;
        page.setHelpRef(helpRef);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)page.getShell(), page.getHelpRef());
        IWizardContainer container = page.getWizard().getContainer();
        if (container instanceof AbstractCicWizardView && (wizardView = (AbstractCicWizardView)container).getCurrentPage() != null) {
            ((AbstractCicWizardView)container).fireCurrentPageChanged();
        }
    }

    public static HashSet getInstalledProductOfferings() {
        return InstalledOfferingsState.getInstalledProductOfferings();
    }

    public static boolean isFeatureGroupInstalled(IFeatureGroup group, Profile profile, IOffering offering) {
        List groups;
        Agent agent = AgentUI.getDefault().getAgent();
        Set installedFeatures = agent.getInstalledFeatures(profile, offering);
        List features = group.getFeatures();
        if (features != null && !features.isEmpty()) {
            int i = 0;
            while (i < features.size()) {
                IFeature feature = (IFeature)features.get(i);
                if (installedFeatures.contains(feature)) {
                    return true;
                }
                ++i;
            }
        }
        if ((groups = group.getGroups()) != null && !groups.isEmpty()) {
            int i = 0;
            while (i < groups.size()) {
                IFeatureGroup oneGroup = (IFeatureGroup)groups.get(i);
                if (AgentUIUtils.isFeatureGroupInstalled(oneGroup, profile, offering)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isFeatureInstalled(IFeature feature, Profile profile, IOffering offering) {
        Agent agent = AgentUI.getDefault().getAgent();
        Set installedFeatures = agent.getInstalledFeatures(profile, offering);
        return installedFeatures.contains(feature);
    }

    public static List getDiskInfoFromDiskSet(IArtifactSession session, IVolumeAccessByDisk diskRep, IVolumeAccessByDisk.IDiskSet diskSet, IVolumeAccessByDisk.IDiskSetDisks neededDisks) {
        ArrayList<String> return_value = new ArrayList<String>();
        try {
            int[] neededDiskNum = neededDisks.getDiskNumbers();
            if (neededDiskNum != null && neededDiskNum.length > 0) {
                String neededDiskString = DiskUtil.formatDiskNumbers((IVolumeAccessByDisk.IDiskSetDisks)neededDisks);
                return_value.add(neededDiskString);
                IVolumeAccessByDisk.IDiskSetDisks unavailable = DiskUtil.getUnavailableNeededDisks((IArtifactSession)session, (IVolumeAccessByDisk)diskRep, (IVolumeAccessByDisk.IDiskSetDisks)neededDisks, (IProgressMonitor)new NullProgressMonitor());
                String unavailableNum = DiskUtil.formatDiskNumbers((IVolumeAccessByDisk.IDiskSetDisks)unavailable);
                return_value.add(unavailableNum);
            }
        }
        catch (IOException e) {
            AgentUI.reportException(e, false);
        }
        catch (CoreException e) {
            AgentUI.reportException(e, false);
        }
        return return_value;
    }

    public static void checkForProductRestart(Shell shell, Profile profile) {
        if (AgentInput.getInstance().getMode() != 1) {
            return;
        }
        if (!CmdLine.CL.containsCommand("-restartPackage")) {
            return;
        }
        if (AgentRelaunch.getInstance().needsRelaunch()) {
            return;
        }
        if (profile == null || profile.isInstallLocationChangeable()) {
            return;
        }
        File workingDirectory = new File(profile.getInstallLocation());
        if (!workingDirectory.isDirectory()) {
            return;
        }
        LauncherFactory.Launcher[] launchers = AgentUIUtils.getLaunchers(profile);
        if (launchers.length < 1) {
            return;
        }
        LauncherFactory.Launcher launcher = AgentUIUtils.promptForLauncher(shell, launchers);
        if (launcher == null) {
            return;
        }
        launcher.setProfile(profile);
        IStatus status = launcher.launch();
        if (!status.isOK()) {
            AgentUI.reportStatus(status, true);
        }
    }

    private static LauncherFactory.Launcher[] getLaunchers(Profile profile) {
        IOffering[] offerings;
        ArrayList<LauncherFactory.Launcher> result = new ArrayList<LauncherFactory.Launcher>();
        IOffering[] iOfferingArray = offerings = Agent.getInstance().getInstalledOfferings(profile);
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            LauncherFactory.Launcher[] launchers;
            IOffering offering = iOfferingArray[n2];
            LauncherFactory.Launcher[] launcherArray = launchers = LauncherFactory.getInstance().findLaunchersFor(offering);
            int n3 = launchers.length;
            int n4 = 0;
            while (n4 < n3) {
                LauncherFactory.Launcher launcher = launcherArray[n4];
                if (!result.contains(launcher)) {
                    result.add(launcher);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new LauncherFactory.Launcher[result.size()]);
    }

    private static LauncherFactory.Launcher promptForLauncher(Shell shell, LauncherFactory.Launcher[] launchers) {
        if (launchers.length == 1) {
            LauncherFactory.Launcher launcher = launchers[0];
            boolean answeredYes = MessageDialog.openQuestion((Shell)shell, (String)Messages.AgentUIUtils_restartTitle, (String)NLS.bind((String)Messages.AgentUIUtils_restartMessage, (Object)launcher.getLabel()));
            return answeredYes ? launcher : null;
        }
        ListDialog d = new ListDialog(shell){

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, JFaceResources.getString((String)"yes"), true);
                this.createButton(parent, 1, JFaceResources.getString((String)"no"), false);
            }
        };
        d.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        d.setLabelProvider((ILabelProvider)new LabelProvider());
        d.setInput((Object)launchers);
        d.setTitle(Messages.AgentUIUtils_restartTitle);
        d.setMessage(Messages.AgentUIUtils_restartPackageMessage);
        d.setWidthInChars(80);
        d.setHeightInChars(5);
        d.setInitialSelections(new Object[]{launchers[0]});
        d.open();
        Object[] result = d.getResult();
        if (result == null) {
            return null;
        }
        LauncherFactory.Launcher launcher = (LauncherFactory.Launcher)result[0];
        return launcher;
    }

    public static boolean allFixJobs(List jobs) {
        boolean allFixes = true;
        int i = 0;
        while (i < jobs.size() && allFixes) {
            AbstractJob job = (AbstractJob)jobs.get(i);
            IOffering offering = job.getOffering();
            if (offering != null && !LicenseUtils.isPEKOffering((IOffering)offering)) {
                allFixes = false;
            }
            ++i;
        }
        return allFixes;
    }

    public static IFeatureBase[] getInstalledVisibleLicensedFeatureOrGroup(IOffering offering, Profile profile) {
        if (offering == null || profile == null) {
            return new IFeatureBase[0];
        }
        IFeatureBase[] licensedFeatureOrGroup = LicenseUtils.getLicensedFeatures((IOffering)offering);
        if (licensedFeatureOrGroup == null || licensedFeatureOrGroup.length == 0) {
            return new IFeatureBase[0];
        }
        ArrayList<Object> return_result = new ArrayList<Object>();
        Agent agent = AgentUI.getDefault().getAgent();
        HashSet<IFeatureBase> licensedFeatureOrGroupSet = new HashSet<IFeatureBase>(Arrays.asList(licensedFeatureOrGroup));
        Set installedFeatures = agent.getInstalledFeatures(profile, offering);
        for (IFeatureBase installedFeature : installedFeatures) {
            if (installedFeature.isVisible() && licensedFeatureOrGroupSet.contains(installedFeature)) {
                return_result.add(installedFeature);
            }
            IFeatureGroup parent = installedFeature.getParent();
            while (parent != null) {
                if (parent.isVisible() && licensedFeatureOrGroupSet.contains(parent) && !return_result.contains(parent)) {
                    return_result.add(parent);
                }
                parent = parent.getParent();
            }
        }
        return return_result.toArray(new IFeatureBase[return_result.size()]);
    }

    public static boolean sameJobs(List list1, List list2) {
        if (list1.isEmpty() && list2.isEmpty()) {
            return true;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        Map profileToJobMap1 = SpaceInfoUtils.createProfileJobsMap((List)list1);
        Map profileToJobMap2 = SpaceInfoUtils.createProfileJobsMap((List)list2);
        if (profileToJobMap1.size() != profileToJobMap2.size()) {
            return false;
        }
        Set entrySet = profileToJobMap1.entrySet();
        for (Map.Entry entry : entrySet) {
            Profile profile = (Profile)entry.getKey();
            List jobList1 = (List)entry.getValue();
            List jobList2 = (List)profileToJobMap2.get(profile);
            if (jobList2 == null) {
                return false;
            }
            if (AgentUIUtils.hasSameOfferings(jobList1, jobList2)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSameOfferings(List jobs1, List jobs2) {
        if (jobs1.isEmpty() && jobs2.isEmpty()) {
            return true;
        }
        if (jobs1.size() != jobs2.size()) {
            return false;
        }
        ArrayList<IOfferingOrFix> copyList11 = new ArrayList<IOfferingOrFix>();
        ArrayList<IOfferingOrFix> copyList12 = new ArrayList<IOfferingOrFix>();
        ArrayList<IOfferingOrFix> copyList21 = new ArrayList<IOfferingOrFix>();
        ArrayList<IOfferingOrFix> copyList22 = new ArrayList<IOfferingOrFix>();
        int i = 0;
        while (i < jobs1.size()) {
            AbstractJob job = (AbstractJob)jobs1.get(i);
            IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            if (offeringOrFix != null) {
                copyList11.add(offeringOrFix);
                copyList12.add(offeringOrFix);
            }
            if ((offeringOrFix = (job = (AbstractJob)jobs2.get(i)).getOfferingOrFix()) != null) {
                copyList21.add(offeringOrFix);
                copyList22.add(offeringOrFix);
            }
            ++i;
        }
        boolean removed1 = copyList11.removeAll(copyList21);
        boolean removed2 = copyList22.removeAll(copyList12);
        return removed1 && copyList11.isEmpty() && removed2 && copyList22.isEmpty();
    }

    public static IStatus runPrecheckBundles(AgentJob job) {
        return AgentUIUtils.runPrecheckBundles(job, true);
    }

    public static IStatus runPrecheckBundles(AgentJob job, boolean prepareBundles) {
        if (job == null) {
            throw new IllegalArgumentException("job cannot be null");
        }
        if (job.getOfferingOrFix() != null && OfferingProperty.getPrecheckBundlesProperty((IOfferingOrFix)job.getOfferingOrFix()).length() > 0) {
            final IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
            final Agent agent = AgentUI.getDefault().getAgent();
            final IStatus[] sta = new IStatus[]{Status.OK_STATUS};
            try {
                if (offeringOrFix != null) {
                    final ISelectionExpression.ISelectedByBundle[] bundles = agent.getPrecheckBundles(offeringOrFix);
                    if (bundles.length > 0 && prepareBundles) {
                        CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                sta[0] = agent.prepareAgentBundles(offeringOrFix, bundles, monitor);
                            }
                        });
                    }
                    if (StatusUtil.isErrorOrCancel((IStatus)sta[0])) {
                        return sta[0];
                    }
                    return AgentUI.getDefault().getAgent().evaluateOfferingBundles((ISelectionExpression[])bundles, job, false);
                }
            }
            catch (InvocationTargetException e) {
                AgentUI.reportException(e);
            }
            catch (InterruptedException e) {
                AgentUI.reportException(e);
            }
            return sta[0];
        }
        return Status.OK_STATUS;
    }

    public static IStatus runPrecheckBundles(List agentJobs, boolean prepareBundles) {
        if (agentJobs == null) {
            throw new IllegalArgumentException("agentJobs cannot be null");
        }
        return AgentUIUtils.runPrecheckBundles(agentJobs.toArray(new AbstractJob[agentJobs.size()]), prepareBundles);
    }

    public static IStatus runPrecheckBundles(final AbstractJob[] agentJobs, boolean prepareBundles) {
        if (agentJobs == null) {
            throw new IllegalArgumentException("agentJobs cannot be null");
        }
        final IStatus[] sta = new IStatus[1];
        if (prepareBundles && agentJobs.length > 0) {
            final Agent agent = AgentUI.getDefault().getAgent();
            try {
                CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, agentJobs.length);
                        try {
                            AbstractJob[] abstractJobArray = agentJobs;
                            int n = agentJobs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                AbstractJob agentJob = abstractJobArray[n2];
                                IOfferingOrFix offeringOrFix = agentJob.getOfferingOrFix();
                                if (offeringOrFix != null) {
                                    ISelectionExpression.ISelectedByBundle[] bundles = agent.getPrecheckBundles(offeringOrFix);
                                    if (bundles.length > 0) {
                                        sta[0] = agent.prepareAgentBundles(offeringOrFix, bundles, pm.next());
                                        if (StatusUtil.isErrorOrCancel((IStatus)sta[0])) {
                                            break;
                                        }
                                    } else {
                                        pm.next().done();
                                    }
                                } else {
                                    pm.next().done();
                                }
                                ++n2;
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                AgentUI.reportException(e);
            }
            catch (InterruptedException e) {
                AgentUI.reportException(e);
            }
        }
        if (sta[0] == null || !StatusUtil.isErrorOrCancel((IStatus)sta[0])) {
            AbstractJob[] abstractJobArray = agentJobs;
            int n = agentJobs.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractJob agentJob = abstractJobArray[n2];
                IStatus status = AgentUIUtils.runPrecheckBundles((AgentJob)agentJob, false);
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    return status;
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus runPrecheckBundlesWithMonitor(List jobList, boolean prepareBundles, IProgressMonitor monitor) {
        if (jobList != null) {
            return AgentUIUtils.runPrecheckBundlesWithMonitor(jobList.toArray(new AbstractJob[jobList.size()]), prepareBundles, monitor);
        }
        return Status.OK_STATUS;
    }

    public static IStatus runPrecheckBundlesWithMonitor(AbstractJob[] agentJobs, boolean prepareBundles, IProgressMonitor monitor) {
        if (agentJobs == null) {
            throw new IllegalArgumentException("agentJobs cannot be null");
        }
        IStatus[] sta = new IStatus[1];
        if (prepareBundles && agentJobs.length > 0) {
            Agent agent = AgentUI.getDefault().getAgent();
            SplitProgressMonitor pm = new SplitProgressMonitor(monitor, agentJobs.length);
            try {
                AbstractJob[] abstractJobArray = agentJobs;
                int n = agentJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractJob agentJob = abstractJobArray[n2];
                    IOfferingOrFix offeringOrFix = agentJob.getOfferingOrFix();
                    if (offeringOrFix != null) {
                        ISelectionExpression.ISelectedByBundle[] bundles = agent.getPrecheckBundles(offeringOrFix);
                        if (bundles.length > 0) {
                            sta[0] = agent.prepareAgentBundles(offeringOrFix, bundles, pm.next());
                            if (StatusUtil.isErrorOrCancel((IStatus)sta[0])) {
                                break;
                            }
                        } else {
                            pm.next().done();
                        }
                    } else {
                        pm.next().done();
                    }
                    ++n2;
                }
            }
            finally {
                pm.done();
            }
        }
        if (sta[0] == null || !StatusUtil.isErrorOrCancel((IStatus)sta[0])) {
            AbstractJob[] abstractJobArray = agentJobs;
            int n = agentJobs.length;
            int n3 = 0;
            while (n3 < n) {
                AbstractJob agentJob = abstractJobArray[n3];
                IStatus status = AgentUIUtils.runPrecheckBundles((AgentJob)agentJob, false);
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    return status;
                }
                ++n3;
            }
        }
        return Status.OK_STATUS;
    }

    public static void reportRepositoryConnectionMsg(Shell shell, IStatus connectionStatus, Map repLocationMsgMap) {
        String repStatusMsg = CommonSharedUIUtils.constructRepositoryMessages((Map)repLocationMsgMap, (boolean)true);
        if (repStatusMsg.length() > 0) {
            if (!connectionStatus.isOK()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(com.ibm.cic.common.core.sharedUI.Messages.TestConnectionResultDlg_notConnected);
                buffer.append("\n\n");
                buffer.append(connectionStatus.getMessage());
                buffer.append("\n\n");
                buffer.append(repStatusMsg);
                MessageDialog.openError((Shell)shell, (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, (String)buffer.toString());
            } else if (CommonSharedUIUtils.repositoryMessageContainWarning((Map)repLocationMsgMap)) {
                MessageDialog.openWarning((Shell)shell, (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepWarning, (String)repStatusMsg);
            } else {
                MessageDialog.openInformation((Shell)shell, (String)com.ibm.cic.common.core.sharedUI.Messages.AddRepositoryDialog_RepInfo, (String)repStatusMsg);
            }
        }
    }

    public static boolean containUseIMManageLicenseOffering() {
        Profile[] profiles = Agent.getInstance().getVisibleProfiles();
        int i = 0;
        while (i < profiles.length) {
            if (!profiles[i].isAgentProfile() && !profiles[i].isLicenseProfile()) {
                IOffering[] offerings;
                IOffering[] iOfferingArray = offerings = Agent.getInstance().getInstalledOfferings(profiles[i]);
                int n = offerings.length;
                int n2 = 0;
                while (n2 < n) {
                    IOffering offering = iOfferingArray[n2];
                    if (OfferingProperty.configureLicenseWithIM((IOffering)offering)) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return false;
    }

    public static List getDeselectedJobs(List previousSelectedJobs, List currentSelectedJobs) {
        if (currentSelectedJobs == null || currentSelectedJobs.isEmpty()) {
            return previousSelectedJobs;
        }
        ArrayList<AgentJob> return_result = new ArrayList<AgentJob>();
        if (previousSelectedJobs != null && previousSelectedJobs.size() > 0) {
            int i = 0;
            while (i < previousSelectedJobs.size()) {
                AgentJob previousJob = (AgentJob)previousSelectedJobs.get(i);
                boolean found = false;
                int j = 0;
                while (j < currentSelectedJobs.size()) {
                    AgentJob currentJob = (AgentJob)currentSelectedJobs.get(j);
                    if (previousJob.getProfile().equals(currentJob.getProfile()) && previousJob.getOfferingOrFix().equals(currentJob.getOfferingOrFix())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return_result.add(previousJob);
                }
                ++i;
            }
        }
        return return_result;
    }

    public static boolean hasFixJob(List jobs) {
        int i = 0;
        while (i < jobs.size()) {
            AgentJob job = (AgentJob)jobs.get(i);
            IFix fix = job.getFix();
            if (fix != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List createProfileJobTreeView(List selectedJobs) {
        ArrayList profileJobNodeList = new ArrayList();
        HashMap<Profile, ProfileJobNode> profileToNodeMap = new HashMap<Profile, ProfileJobNode>();
        int i = 0;
        while (i < selectedJobs.size()) {
            AbstractJob job = (AbstractJob)selectedJobs.get(i);
            Profile profile = job.getProfile();
            if (!profile.getProfileKind().equals("license")) {
                ProfileJobNode node = (ProfileJobNode)profileToNodeMap.get(profile);
                if (node == null) {
                    node = new ProfileJobNode(profile);
                    profileToNodeMap.put(profile, node);
                }
                node.getChildren().add(job);
            }
            ++i;
        }
        profileJobNodeList.addAll(profileToNodeMap.values());
        return profileJobNodeList;
    }

    public static boolean offeringBeUpdated(IOffering offering, List updateOfferingJobs) {
        if (updateOfferingJobs != null && !updateOfferingJobs.isEmpty()) {
            int i = 0;
            while (i < updateOfferingJobs.size()) {
                AbstractJob job = (AbstractJob)updateOfferingJobs.get(i);
                IOffering update = job.getOffering();
                if (update != null && offering.getIdentity().equals(update.getIdentity())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static IStatus loadAgentDependencyBundles(AgentJob[] jobs, boolean preliminaryProfile, IProgressMonitor monitor) {
        if (jobs == null || jobs.length == 0) {
            return Status.OK_STATUS;
        }
        CicMultiStatus returnStatus = Statuses.ST.createMultiStatus();
        Profile profile = null;
        if (!preliminaryProfile) {
            profile = jobs[0].getProfile();
        }
        IOfferingOrFix[] pkgs = null;
        if (!preliminaryProfile) {
            boolean adjustJobs = false;
            pkgs = AgentUtil.getResultingOfferingsAndFixes((IProfile)profile, (AgentJob[])jobs, (boolean)adjustJobs);
        } else {
            pkgs = AgentUIUtils.getOfferingOrFixFromJobs(jobs);
        }
        SplitProgressMonitor subMonitor = new SplitProgressMonitor(monitor, pkgs.length);
        IOfferingOrFix[] iOfferingOrFixArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix pkg = iOfferingOrFixArray[n2];
            OfferingUtil.IBundleIdAndClassName[] bundles = OfferingUtil.getDependenciesBundles((IOfferingOrFix)pkg);
            String[] bundleIds = OfferingUtil.getUniqueBundleIds((OfferingUtil.IBundleIdAndClassName[])bundles);
            IStatus loadStatus = Agent.getInstance().prepareAgentBundles(pkg, bundleIds, Agent.DEPENDENCY_HANDLER_SELECTOR_IDS, subMonitor.next());
            if (StatusUtil.isErrorOrCancel((IStatus)loadStatus)) {
                return loadStatus;
            }
            returnStatus.add(loadStatus);
            ++n2;
        }
        return returnStatus;
    }

    public static IStatus unloadAgentDependencyBundles(AgentJob[] jobs, IProgressMonitor monitor) {
        CicMultiStatus returnStatus = Statuses.ST.createMultiStatus();
        IOfferingOrFix[] pkgs = AgentUIUtils.getOfferingOrFixFromJobs(jobs);
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, pkgs.length);
        IOfferingOrFix[] iOfferingOrFixArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix pkg = iOfferingOrFixArray[n2];
            OfferingUtil.IBundleIdAndClassName[] bundles = OfferingUtil.getDependenciesBundles((IOfferingOrFix)pkg);
            String[] bundleIds = OfferingUtil.getUniqueBundleIds((OfferingUtil.IBundleIdAndClassName[])bundles);
            IStatus unloadStatus = Agent.getInstance().unloadAgentBundles(pkg, bundleIds, Agent.DEPENDENCY_HANDLER_SELECTOR_IDS, pm.next());
            if (StatusUtil.isErrorOrCancel((IStatus)unloadStatus)) {
                return unloadStatus;
            }
            returnStatus.add(unloadStatus);
            ++n2;
        }
        return returnStatus;
    }

    private static IOfferingOrFix[] getOfferingOrFixFromJobs(AgentJob[] jobs) {
        if (jobs != null) {
            ArrayList<IOfferingOrFix> returnList = new ArrayList<IOfferingOrFix>(jobs.length);
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                IOfferingOrFix offeringOrFix = job.getOfferingOrFix();
                if (offeringOrFix != null) {
                    returnList.add(offeringOrFix);
                }
                ++n2;
            }
            return returnList.toArray(new IOfferingOrFix[returnList.size()]);
        }
        return new IOfferingOrFix[0];
    }

    public static boolean isFixInstalled(IFix fix, Profile profile) {
        IFix[] installedFixes = Agent.getInstance().getInstalledFixes(profile);
        if (installedFixes != null && installedFixes.length > 0) {
            IFix[] iFixArray = installedFixes;
            int n = installedFixes.length;
            int n2 = 0;
            while (n2 < n) {
                IFix installedFix = iFixArray[n2];
                if (installedFix.equals(fix)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Map generateProfileJobFeatureTree(List selectedJobs) {
        HashMap<Profile, ProfileTreeNode> returnResult = new HashMap<Profile, ProfileTreeNode>();
        int i = 0;
        while (i < selectedJobs.size()) {
            AbstractJob job = (AbstractJob)selectedJobs.get(i);
            Profile profile = job.getProfile();
            if (!profile.getProfileKind().equals("license")) {
                IOfferingOrFix offeringOrFix;
                ProfileTreeNode profileNode = (ProfileTreeNode)returnResult.get(profile);
                if (profileNode == null) {
                    profileNode = new ProfileTreeNode(profile);
                    returnResult.put(profile, profileNode);
                }
                if ((offeringOrFix = job.getOfferingOrFix()) instanceof IOffering) {
                    profileNode.addChild(job);
                } else {
                    AgentUIUtils.generateFixTreeNode(job, profileNode, selectedJobs);
                }
            }
            ++i;
        }
        return returnResult;
    }

    private static void generateFixTreeNode(AbstractJob fixJob, ProfileTreeNode profileNode, List selectedJobs) {
        Profile profile = fixJob.getProfile();
        IFix fix = fixJob.getFix();
        int i = 0;
        while (i < selectedJobs.size()) {
            IOffering offering;
            AbstractJob job = (AbstractJob)selectedJobs.get(i);
            if (job.getProfile().equals(profile) && (offering = job.getOffering()) != null && FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) {
                OfferingTreeNode offeringNode = profileNode.addChild(job);
                offeringNode.addFix(fixJob);
            }
            ++i;
        }
        IOffering[] installedOfferings = Agent.getInstance().getInstalledOfferings(profile);
        int i2 = 0;
        while (i2 < installedOfferings.length) {
            if (!AgentUIUtils.offeringBeUpdated(installedOfferings[i2], selectedJobs) && FixUtil.isFixApplicable((IFix)fix, (IOffering)installedOfferings[i2])) {
                OfferingTreeNode offeringNode = profileNode.addChild(installedOfferings[i2]);
                offeringNode.addFix(fixJob);
            }
            ++i2;
        }
    }

    public static boolean supportMultipleProfileInstall(IOffering[] offerings) {
        int i = 0;
        while (i < offerings.length) {
            if (!OfferingProperty.supportMultipleProfileInstall((IOffering)offerings[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean supportMultipleProfileInstall(AgentJob[] productJobs) {
        AgentJob[] agentJobArray = productJobs;
        int n = productJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob productJob = agentJobArray[n2];
            IOffering offering = productJob.getOffering();
            if (offering == null || !OfferingProperty.supportMultipleProfileInstall((IOffering)offering)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean inExistingFixJobs(AgentJob fixJob, List processedFixJobs, boolean checkProfile) {
        if (processedFixJobs.isEmpty()) {
            return false;
        }
        for (AgentJob existingFixJob : processedFixJobs) {
            if (!fixJob.getFix().equals(existingFixJob.getFix())) continue;
            if (checkProfile) {
                if (!fixJob.getProfile().equals(existingFixJob.getProfile())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static void sortByNameAndVersion(Viewer viewer, ViewerSorter sorter, Object[] elements) {
        AgentUIUtils.sortByNameAndVersion(viewer, sorter, elements, false);
    }

    public static void sortByNameAndVersion(final Viewer viewer, final ViewerSorter sorter, Object[] elements, boolean uninstall) {
        if (elements.length >= 2) {
            if (elements[0] instanceof AgentJob) {
                AgentUIUtils.sortJobs(elements, uninstall);
            } else if (elements[0] instanceof IContainsOffering || elements[0] instanceof IContainsFix) {
                AgentUIUtils.sortPackagesAndOthers(elements);
            } else if (elements[0] instanceof IProfileAndOfferings) {
                AgentUIUtils.sortProfiles(elements, uninstall);
            } else {
                Arrays.sort(elements, new Comparator(){

                    public int compare(Object a, Object b) {
                        return sorter.compare(viewer, a, b);
                    }
                });
            }
        }
    }

    private static void sortJobs(Object[] elements, boolean uninstall) {
        AgentJob[] jobs = new AgentJob[elements.length];
        System.arraycopy(elements, 0, jobs, 0, elements.length);
        SortUtil.sortByProfileNameAndVersion((AgentJob[])jobs, (boolean)uninstall);
        System.arraycopy(jobs, 0, elements, 0, elements.length);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void sortPackagesAndOthers(Object[] elements) {
        pkgToElement = new HashMap<IOffering, Object>();
        sorter = new SortUtil.PackageSorter();
        others = new ArrayList<Object>(elements.length);
        var7_4 = elements;
        var6_5 = elements.length;
        var5_7 = 0;
        while (var5_7 < var6_5) {
            block6: {
                element = var7_4[var5_7];
                if (!(element instanceof IContainsOffering)) break block6;
                pkg = ((IContainsOffering)element).getOffering();
                ** GOTO lbl18
            }
            if (!(element instanceof IContainsFix)) {
                others.add(element);
            } else {
                pkg = ((IContainsFix)element).getFix();
lbl18:
                // 2 sources

                sorter.add((IOfferingOrFix)pkg);
                pkgToElement.put(pkg, element);
            }
            ++var5_7;
        }
        i = 0;
        for (IOfferingOrFix offering : sorter.getSortedPkgs()) {
            elements[i++] = pkgToElement.get(offering);
        }
        for (E other : others) {
            elements[i++] = other;
        }
        if (!AgentUIUtils.$assertionsDisabled && i != elements.length) {
            throw new AssertionError();
        }
    }

    private static void sortProfiles(Object[] elements, boolean uninstall) {
        HashMap<Profile, IProfileAndOfferings> profileToElement = new HashMap<Profile, IProfileAndOfferings>();
        SortUtil.ProfileSorter sorter = new SortUtil.ProfileSorter();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IProfileAndOfferings p = (IProfileAndOfferings)element;
            Profile profile = p.getProfile();
            profileToElement.put(profile, p);
            for (IOffering offering : p.getOfferings()) {
                sorter.add(profile, (IOfferingOrFix)offering);
            }
            ++n2;
        }
        int i = 0;
        for (Profile profile : sorter.getSortedProfiles(uninstall)) {
            elements[i++] = profileToElement.get(profile);
        }
    }

    public static boolean delayFeatureValidation(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null && OfferingProperty.isDelayFeatureValidation((IOffering)offering)) {
                return true;
            }
            ++n2;
        }
        Collection groupedJobs = AgentUtil.groupByProfile((AgentJob[])jobs, (boolean)false);
        for (AgentJob[] jobsInOneGroup : groupedJobs) {
            IOffering[] installedOfferings;
            Profile profileInGroup = jobsInOneGroup[0].getProfile();
            if (profileInGroup.isShadow()) continue;
            IOffering[] iOfferingArray = installedOfferings = Agent.getInstance().getInstalledOfferings(profileInGroup);
            int n3 = installedOfferings.length;
            int n4 = 0;
            while (n4 < n3) {
                IOffering installedOffering = iOfferingArray[n4];
                if (OfferingProperty.isDelayFeatureValidation((IOffering)installedOffering)) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    public static void reflowForControl(Control c) {
        for (Composite parent = c.getParent(); parent != null; parent = parent.getParent()) {
            parent.layout();
            if (!(parent instanceof ScrolledForm)) continue;
            ((ScrolledForm)parent).reflow(true);
            break;
        }
    }

    public static void showOrHideFilterBoxAsync(final TreeViewer viewer, final TreeFilterBoxPart filterBox) {
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScrollBar vScrollBar = viewer.getTree().getVerticalBar();
                if (vScrollBar != null) {
                    boolean showFilterBox = vScrollBar.isVisible();
                    filterBox.resetFilterBoxState(showFilterBox);
                }
            }
        });
    }
}

