/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.preferences;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.downloads.FormatUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class FilesForRollbackPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Agent.IPurgeableFiles purgeableFile = null;
    private Label sizeLabel;
    private Button cleanUpButton;
    private Composite innerComp;
    private BooleanFieldEditor preserveArtifacts;

    public FilesForRollbackPage() {
        super(1);
        this.setPreferenceStore(AgentUI.getDefault().getAgentPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (!SharedUIUtils.isPreferenceEditable((ICicPreferenceConstants.PreferenceTag)ICicPreferenceConstants.PRESERVE_DOWNLOADED_ARTIFACTS) || Agent.getInstance().isPortable()) {
            this.preserveArtifacts.setEnabled(false, this.innerComp);
            Button restoreDefaultButton = this.getDefaultsButton();
            if (restoreDefaultButton != null) {
                restoreDefaultButton.setEnabled(false);
            }
        }
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cic.agent.ui.DownloadCachePage");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Font font = parent.getFont();
        Group preserveArtifactsGroup = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 8;
        preserveArtifactsGroup.setLayout((Layout)gridLayout);
        preserveArtifactsGroup.setLayoutData((Object)new GridData(768));
        Label preserveArtifactsLabel = new Label((Composite)preserveArtifactsGroup, 64);
        preserveArtifactsLabel.setFont(font);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        preserveArtifactsLabel.setLayoutData((Object)gridData);
        preserveArtifactsLabel.setText(com.ibm.cic.agent.core.sharedUI.Messages.DownloadCachePreferencePage_PreserveCache_Label);
        this.innerComp = new Composite((Composite)preserveArtifactsGroup, 0);
        this.innerComp.setLayout((Layout)new GridLayout());
        this.preserveArtifacts = new PreserveArtifactsBooleanEditor(ICicPreferenceConstants.PRESERVE_DOWNLOADED_ARTIFACTS.key(), Messages.DownloadCachePreferencePage_PreserveCache_Button, this.innerComp);
        this.addField((FieldEditor)this.preserveArtifacts);
        Group cleanUpGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        cleanUpGroup.setLayout((Layout)layout);
        cleanUpGroup.setLayoutData((Object)new GridData(768));
        Label cleanUpLabel = new Label((Composite)cleanUpGroup, 64);
        cleanUpLabel.setFont(font);
        GridData data = new GridData(768);
        data.widthHint = 250;
        cleanUpLabel.setLayoutData((Object)data);
        cleanUpLabel.setText(com.ibm.cic.agent.core.sharedUI.Messages.DownloadCachePreferencePage_CleanUp_Label);
        this.sizeLabel = new Label((Composite)cleanUpGroup, 0);
        this.sizeLabel.setFont(font);
        this.sizeLabel.setLayoutData((Object)new GridData(768));
        this.cleanUpButton = new Button((Composite)cleanUpGroup, 0);
        this.cleanUpButton.setFont(font);
        this.cleanUpButton.setText(Messages.DownloadCachePreferencePage_CleanUp_Button);
        final IStatus[] purgeStatus = new IStatus[]{Status.OK_STATUS};
        try {
            AgentUI.getDefault().run(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        FilesForRollbackPage.this.purgeableFile = AgentUI.getDefault().getAgent().determinePurgeableFiles(monitor);
                    }
                    catch (CoreException e) {
                        purgeStatus[0] = e.getStatus();
                    }
                }
            });
        }
        catch (InvocationTargetException exp) {
            AgentUI.reportException(exp);
        }
        catch (InterruptedException exp) {
            AgentUI.reportException(exp);
        }
        this.determinePurgeableFiles(purgeStatus[0]);
        this.cleanUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IStatus[] determineStatus = new IStatus[1];
                try {
                    AgentUI.getDefault().run(true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            determineStatus[0] = FilesForRollbackPage.this.purgeableFile.purgeFiles(monitor);
                        }
                    });
                    FilesForRollbackPage.this.determinePurgeableFiles(determineStatus[0]);
                }
                catch (InvocationTargetException exp) {
                    AgentUI.reportException(exp);
                }
                catch (InterruptedException exp) {
                    AgentUI.reportException(exp);
                }
            }
        });
    }

    private void determinePurgeableFiles(IStatus status) {
        long size = -1L;
        if (status != null && status.isOK() && this.purgeableFile != null) {
            size = this.purgeableFile.getTotalSize();
        }
        String sizeString = com.ibm.cic.agent.core.sharedUI.Messages.DownloadCachePreferencePage_CleanUp_CurrentStatus_Unknown;
        if (status != null && status.isOK() && this.purgeableFile != null && size >= 0L) {
            sizeString = FormatUtil.formatBytes((long)size);
        }
        this.sizeLabel.setText(NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.DownloadCachePreferencePage_CleanUp_CurrentStatus, (Object)sizeString));
        this.sizeLabel.redraw();
        if (size > 0L) {
            this.cleanUpButton.setEnabled(true);
        } else {
            this.cleanUpButton.setEnabled(false);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private static class PreserveArtifactsBooleanEditor
    extends BooleanFieldEditor {
        public PreserveArtifactsBooleanEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void doLoad() {
            if (Agent.getInstance().isPortable()) {
                this.getPreferenceStore().setValue(this.getPreferenceName(), false);
            }
            super.doLoad();
        }

        protected void doLoadDefault() {
            if (Agent.getInstance().isPortable()) {
                this.getPreferenceStore().setDefault(this.getPreferenceName(), false);
            }
            super.doLoadDefault();
        }
    }
}

