/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.lum.enroll;

import com.ibm.LUMClient.LicenseTransaction;
import com.ibm.LUMClient.LumClient;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.Logger;
import com.ibm.cic.licensing.lum.enroll.LicData;
import com.ibm.cic.licensing.lum.enroll.LicReader;
import com.ibm.cic.licensing.lum.enroll.LicWriter;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class LicEnroller {
    public static final int ENROLL_SUCCESS = 0;
    public static final int ENROLL_FAILED = -1;
    public static final int TRIAL_EXPIRED = 0;
    public static final String DAT_FILE_EXTENSION = ".dat";

    public static int enroll(String ecfpath, String nodelockFilePath) {
        LicData licdata = LicReader.getLicData(ecfpath);
        String vendorID = licdata.getVendorID();
        int option = 1;
        int licenseType = 1;
        int productID = Integer.parseInt(licdata.getProductId());
        String productVersion = licdata.getProductVersion();
        long status = 0L;
        byte[] advancedOptions = new byte[132];
        boolean multiUseCheck = false;
        LumClient client = LumClient.getLumClient();
        status = client.setOption(vendorID, option, nodelockFilePath);
        if (status != 0L) {
            Logger.logNtrace((int)Logger.ERROR, (String)"Error while setting client option");
            return -1;
        }
        LicenseTransaction Lic = client.initSession(vendorID);
        status = Lic.getServerStatus();
        if (status != 0L) {
            Logger.logNtrace((int)Logger.ERROR, (String)"Error while initializing License Use Management");
            return -1;
        }
        Lic = client.requestLicense(licenseType, productID, productVersion, 1, 0, multiUseCheck, "", "", advancedOptions, "", "", "");
        status = Lic.getServerStatus();
        if (status != 0L) {
            if (licdata.isTryAndBuy()) {
                File ecffile = new File(ecfpath);
                String ecfcopypath = String.valueOf(ecffile.getParent()) + File.separator + "ecfcopy.lic";
                File ecfcopyfile = new File(ecfcopypath);
                LicEnroller.copy(ecffile, ecfcopyfile);
                Calendar rightNow = Calendar.getInstance();
                long startDate = rightNow.getTime().getTime() / 1000L;
                if (status == 486604803L) {
                    if (Lic.getAttrMask() == '\u0001') {
                        Logger.logNtrace((int)Logger.ERROR, (String)("The trial license was not re-enrolled since it had expired: " + licdata.getProductName()));
                        return 0;
                    }
                    try {
                        LicWriter.append(nodelockFilePath, licdata.toCommentLine());
                        client.setUseOpenTargetTryAndBuy(true);
                        status = client.addTryBuy(productID, productVersion, ecfcopypath, startDate);
                    }
                    catch (SecurityException se) {
                        Logger.logNtrace((String)se.getMessage(), (Exception)se);
                        return -1;
                    }
                    catch (IllegalArgumentException ill) {
                        Logger.logNtrace((String)ill.getMessage(), (Exception)ill);
                        return -1;
                    }
                }
                try {
                    LicWriter.append(nodelockFilePath, licdata.toCommentLine());
                    client.setUseOpenTargetTryAndBuy(true);
                    status = client.addTryBuy(productID, productVersion, ecfcopypath, startDate);
                }
                catch (SecurityException se) {
                    Logger.logNtrace((String)se.getMessage(), (Exception)se);
                    return -1;
                }
                catch (IllegalArgumentException ill) {
                    Logger.logNtrace((String)ill.getMessage(), (Exception)ill);
                    return -1;
                }
                if (status != 0L) {
                    Logger.logNtrace((int)Logger.ERROR, (String)("Error in adding the Try and Buy license." + client.getErrMsg(status)));
                    return -1;
                }
            } else {
                LicWriter.topInsert(nodelockFilePath, licdata);
            }
        } else if (Lic.getAttrMask() == '\u0001') {
            if (!licdata.isTryAndBuy()) {
                LicWriter.topInsert(nodelockFilePath, licdata);
            }
        } else {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("mm/dd/yyyy");
                Date newLicExpDate = dateFormat.parse(licdata.getExpirationTS());
                Date oldLicExpDate = new Date(Lic.getExpirationDate() * 1000L);
                if (oldLicExpDate.before(newLicExpDate) && !licdata.isTryAndBuy()) {
                    LicWriter.topInsert(nodelockFilePath, licdata);
                }
            }
            catch (ParseException e) {
                Logger.logNtrace((String)"Date parsing error", (Exception)e);
            }
        }
        Lic = client.requestLicense(licenseType, productID, productVersion, 1, 0, multiUseCheck, "", "", advancedOptions, "", "", "");
        status = Lic.getServerStatus();
        return (int)status;
    }

    public static void recordLicenseDataLocation(File isdplic, File licenseDataDir) {
        block2: {
            try {
                LicUserUtils.storeProperties((String)isdplic.getAbsolutePath(), (String)"cic.appDataLocation", (String)licenseDataDir.getCanonicalPath());
            }
            catch (Exception e) {
                if (!Logger.isTracing((boolean)Logger.DEBUG_EXCEPTIONS)) break block2;
                e.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean write(File file, boolean append, String content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 98->101)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean copy(File src, File dest) {
        try {
            int c;
            FileReader in = new FileReader(src);
            FileWriter out = new FileWriter(dest);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            return true;
        }
        catch (Exception e) {
            if (Logger.isTracing((boolean)Logger.DEBUG_EXCEPTIONS)) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static String getDatFileName(String licfilepath) {
        int dotlicindex = licfilepath.lastIndexOf(".lic");
        if (dotlicindex < 0) {
            dotlicindex = licfilepath.lastIndexOf(".lic".toUpperCase(Locale.ENGLISH));
        }
        String datfilepath = String.valueOf(licfilepath.substring(0, dotlicindex)) + DAT_FILE_EXTENSION;
        return datfilepath;
    }

    public static void renameLicToDatFile(String licfilepath) {
        String datfilepath = LicEnroller.getDatFileName(licfilepath);
        File licfile = new File(licfilepath);
        File datfile = new File(datfilepath);
        if (licfile.exists() && datfile.exists()) {
            datfile.delete();
        }
        if (licfile.exists()) {
            licfile.renameTo(datfile);
        }
    }

    public static void copyLicToDatFile(String licfilepath) {
        File licfile = new File(licfilepath);
        File datfile = new File(LicEnroller.getDatFileName(licfilepath));
        LicEnroller.copy(licfile, datfile);
    }
}

