/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.verbs.Device;
import com.ibm.net.rdma.jverbs.verbs.DeviceAttribute;
import com.ibm.net.rdma.jverbs.verbs.DeviceGlobalId;
import com.ibm.net.rdma.jverbs.verbs.DeviceList;
import com.ibm.net.rdma.jverbs.verbs.PortAttribute;
import com.ibm.net.rdma.jverbs.verbs.PortIndex;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class NativeVerbsContext
extends VerbsContext {
    DeviceAttribute devAttr = null;
    Map<Integer, PortAttribute> portAttrMap = new HashMap<Integer, PortAttribute>();
    Map<PortIndex, DeviceGlobalId> gidMap = new HashMap<PortIndex, DeviceGlobalId>();

    public NativeVerbsContext(int n, Device device) throws IOException {
        super(n, device);
    }

    public NativeVerbsContext(int n) throws IOException {
        super(n);
        Device device = null;
        DeviceList deviceList = DeviceList.getDeviceList();
        for (int i = 0; i < deviceList.getNdevices() && (device = deviceList.getDevice(i)).getContext().getFD() != n; ++i) {
        }
        this.setDevice(device);
    }

    @Override
    public DeviceAttribute queryDevice() throws IOException {
        int n;
        if (this.devAttr == null && ((n = this.queryDevice0(this.getFD())) < 0 || this.devAttr == null)) {
            throw new IOException("Query device failed");
        }
        return this.devAttr;
    }

    @Override
    public PortAttribute queryPort(int n) throws IOException {
        int n2;
        if (this.portAttrMap.get(n) == null && ((n2 = this.queryPort0(this.getFD(), n)) < 0 || this.portAttrMap.get(n) == null)) {
            throw new IOException("Query port failed");
        }
        return this.portAttrMap.get(n);
    }

    @Override
    public DeviceGlobalId queryGid(int n, int n2) throws IOException {
        PortIndex portIndex = new PortIndex(n, n2);
        if (this.gidMap.get(portIndex) == null) {
            byte[] byArray = this.queryGid0(this.getFD(), n, n2);
            if (byArray == null) {
                throw new IOException("Query gid failed");
            }
            DeviceGlobalId deviceGlobalId = new DeviceGlobalId(byArray);
            this.gidMap.put(portIndex, deviceGlobalId);
        }
        return this.gidMap.get(portIndex);
    }

    void setIbvDeviceAttr(String string, long l, long l2, long l3, long l4, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, int n27, int n28, int n29, int n30, int n31, int n32, short s, short s2, int n33) {
        this.devAttr = new DeviceAttribute(string, l, l2, l3, l4, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, n21, n22, n23, n24, n25, n26, n27, n28, n29, n30, n31, n32, s, s2, DeviceAttribute.AtomicLimit.values()[n33]);
    }

    void setIbvPortAttr(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11) {
        PortAttribute portAttribute = new PortAttribute(PortAttribute.PortState.values()[n2], PortAttribute.Mtu.values()[n3], PortAttribute.Mtu.values()[n4], n5, n6, n7, n8, n9, n10, n11, n12, s, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11);
        this.portAttrMap.put(n, portAttribute);
    }

    native int queryDevice0(int var1);

    native int queryPort0(int var1, int var2);

    native byte[] queryGid0(int var1, int var2, int var3);
}

