/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.cm;

import com.ibm.net.rdma.jverbs.NativeSizeConstants;
import com.ibm.net.rdma.jverbs.cm.ConnectionEvent;
import com.ibm.net.rdma.jverbs.cm.ConnectionId;
import com.ibm.net.rdma.jverbs.cm.ConnectionParameter;
import com.ibm.net.rdma.jverbs.cm.EventChannel;
import com.ibm.net.rdma.jverbs.cm.NativeConnectionEvent;
import com.ibm.net.rdma.jverbs.cm.NativeConnectionId;
import com.ibm.net.rdma.jverbs.cm.NativeConnectionParameter;
import com.ibm.net.rdma.jverbs.cm.NativeEventChannel;
import com.ibm.net.rdma.jverbs.cm.NetUtils;
import com.ibm.net.rdma.jverbs.cm.PortSpace;
import com.ibm.net.rdma.jverbs.cm.RdmaCM;
import com.ibm.net.rdma.jverbs.cm.SockAddrIn;
import com.ibm.net.rdma.jverbs.common.MemoryBuffer;
import com.ibm.net.rdma.jverbs.common.MemoryBufferPool;
import com.ibm.net.rdma.jverbs.verbs.CompletionQueue;
import com.ibm.net.rdma.jverbs.verbs.ProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.QueuePairInitAttribute;
import com.ibm.net.rdma.jverbs.verbs.QueuePairLimit;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.reflect.misc.ConstructorUtil;

class NativeRdmaCM
extends RdmaCM {
    private static final String RDMA_NATIVE_QUEUE_PAIR_IMPL_CLASS = "com.ibm.net.rdma.jverbs.verbs.NativeQueuePair";
    private MemoryBufferPool memAlloc = MemoryBufferPool.getInstance();

    @Override
    public void cleanup() {
        this.memAlloc.cleanupBuffers();
    }

    @Override
    public EventChannel createEventChannel() throws IOException {
        int n = this.createEventChannel0();
        if (n >= 0) {
            return new NativeEventChannel(n);
        }
        throw new IOException("Event channel creation failed");
    }

    @Override
    public ConnectionId createConnectionId(EventChannel eventChannel, PortSpace portSpace) throws IllegalArgumentException, IOException {
        int n = -1;
        if (eventChannel != null) {
            n = eventChannel.getFD();
        }
        if (portSpace != PortSpace.RDMA_PS_TCP) {
            throw new IllegalArgumentException("Unsupported RDMA port space ");
        }
        long l = this.createId0(n, (short)portSpace.getValue());
        NativeConnectionId nativeConnectionId = null;
        if (l < 0L) {
            throw new IOException("Connection Id creation failed");
        }
        nativeConnectionId = new NativeConnectionId(eventChannel, portSpace, l, this);
        ((NativeEventChannel)eventChannel).addCmId(l, nativeConnectionId);
        return nativeConnectionId;
    }

    @Override
    public QueuePair createQueuePair(ConnectionId connectionId, ProtectionDomain protectionDomain, QueuePairInitAttribute queuePairInitAttribute) throws IllegalArgumentException, IOException {
        long l = -1L;
        if (connectionId == null || (l = ((NativeConnectionId)connectionId).getNatid()) == -1L) {
            throw new IllegalArgumentException("Connection Id is invalid");
        }
        int n = -1;
        if (protectionDomain == null || (n = protectionDomain.getHandle()) == -1) {
            throw new IllegalArgumentException("Protection Domain is invalid");
        }
        if (queuePairInitAttribute == null) {
            throw new IllegalArgumentException("QueuePair Init Attribute is invalid");
        }
        if (connectionId.getQueuePair() != null) {
            throw new IOException("Cannot create qp, already associated");
        }
        CompletionQueue completionQueue = queuePairInitAttribute.getSendCompletionQueue();
        CompletionQueue completionQueue2 = queuePairInitAttribute.getReceiveCompletionQueue();
        int n2 = -1;
        int n3 = -1;
        if (completionQueue == null || (n2 = completionQueue.getHandle()) == -1) {
            throw new IllegalArgumentException("QueuePair Init Attribute has invalid Send Completion Queue");
        }
        if (completionQueue2 == null || (n3 = completionQueue2.getHandle()) == -1) {
            throw new IllegalArgumentException("QueuePair Init Attribute has invalid Receive Completion Queue");
        }
        MemoryBuffer memoryBuffer = this.memAlloc.allocate(4 * NativeSizeConstants.INT_SIZE, MemoryBufferPool.MemType.DIRECT);
        long l2 = memoryBuffer.getAddress();
        QueuePairLimit queuePairLimit = queuePairInitAttribute.getCap();
        int n4 = this.createQp0(l, n, n2, n3, queuePairLimit.getMaxSendSge(), queuePairLimit.getMaxReceiveSge(), queuePairLimit.getMaxSendWorkRequest(), queuePairLimit.getMaxReceiveWorkRequest(), queuePairInitAttribute.getQueuePairType().getValue(), l2, l2 + (long)NativeSizeConstants.INT_SIZE, l2 + (long)(2 * NativeSizeConstants.INT_SIZE), l2 + (long)(3 * NativeSizeConstants.INT_SIZE));
        QueuePairLimit queuePairLimit2 = new QueuePairLimit(memoryBuffer.getInt(), memoryBuffer.getInt(), memoryBuffer.getInt(), memoryBuffer.getInt());
        memoryBuffer.cache();
        QueuePair queuePair = null;
        if (n4 >= 0) {
            Class[] classArray = new Class[]{VerbsContext.class, ProtectionDomain.class, Integer.TYPE, QueuePair.Type.class, CompletionQueue.class, CompletionQueue.class, QueuePairLimit.class};
            Object[] objectArray = new Object[]{connectionId.getVerbsContext(), protectionDomain, new Integer(n4), queuePairInitAttribute.getQueuePairType(), completionQueue, completionQueue2, queuePairLimit2};
            queuePair = (QueuePair)this.invokeConstructor(RDMA_NATIVE_QUEUE_PAIR_IMPL_CLASS, classArray, objectArray);
        }
        if (queuePair == null) {
            throw new IOException("QueuePair creation failed");
        }
        ((NativeConnectionId)connectionId).setQueuePair(queuePair);
        return queuePair;
    }

    private Object invokeConstructor(String string, final Class[] classArray, Object[] objectArray) {
        final Class[] classArray2 = new Class[]{};
        Object[] objectArray2 = new Object[]{};
        try {
            final Class<?> clazz = Class.forName(string);
            Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Constructor<?> constructor = ConstructorUtil.getConstructor(clazz, classArray == null ? classArray2 : classArray);
                    constructor.setAccessible(true);
                    return constructor;
                }
            });
            return constructor.newInstance(objectArray == null ? objectArray2 : objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void bindAddress(ConnectionId connectionId, SocketAddress socketAddress) throws IllegalArgumentException, IOException {
        long l = -1L;
        if (connectionId == null || (l = ((NativeConnectionId)connectionId).getNatid()) == -1L) {
            throw new IllegalArgumentException("Connection Id is invalid");
        }
        if (socketAddress == null) {
            throw new IllegalArgumentException("Socket Address should be specified");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        int n = this.bindAddr0(l, (short)2, NetUtils.getIntIPFromInetAddress(inetSocketAddress.getAddress()), inetSocketAddress.getPort());
        if (n < 0) {
            throw new IOException("Binding socket address failed");
        }
    }

    @Override
    public void listen(ConnectionId connectionId, int n) throws IOException {
        int n2;
        long l = -1L;
        if (connectionId == null || (l = ((NativeConnectionId)connectionId).getNatid()) == -1L) {
            throw new IllegalArgumentException("Connection Id is invalid");
        }
        if (n <= 0) {
            n = 50;
        }
        if ((n2 = this.listen0(l, n)) < 0) {
            throw new IOException("Listen action failed");
        }
    }

    @Override
    public void resolveAddress(ConnectionId connectionId, SocketAddress socketAddress, SocketAddress socketAddress2, int n) throws IllegalArgumentException, IOException {
        long l = -1L;
        if (connectionId == null || (l = ((NativeConnectionId)connectionId).getNatid()) == -1L) {
            throw new IllegalArgumentException("Connection Id is invalid");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Timeout parameter value can not be less than 0");
        }
        if (socketAddress2 == null) {
            throw new IllegalArgumentException("Destination address should be specified");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress2;
        int n2 = this.resolveAddr0(l, 0L, (short)2, NetUtils.getIntIPFromInetAddress(inetSocketAddress.getAddress()), inetSocketAddress.getPort(), n);
        if (n2 < 0) {
            throw new IOException("Resolve address action failed");
        }
    }

    @Override
    public void resolveRoute(ConnectionId connectionId, int n) throws IllegalArgumentException, IOException {
        long l = -1L;
        if (connectionId == null || (l = ((NativeConnectionId)connectionId).getNatid()) == -1L) {
            throw new IllegalArgumentException("Connection Id is invalid");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Timeout parameter value can not be less than 0");
        }
        int n2 = this.resolveRoute0(l, n);
        if (n2 < 0) {
            throw new IOException("Resolve route action failed");
        }
    }

    @Override
    public ConnectionEvent getConnectionEvent(EventChannel eventChannel, int n) throws IllegalArgumentException, IOException {
        int n2 = eventChannel.getFD();
        NativeEventChannel nativeEventChannel = (NativeEventChannel)eventChannel;
        NativeConnectionEvent nativeConnectionEvent = null;
        MemoryBuffer memoryBuffer = this.memAlloc.allocate(NativeSizeConstants.INT_SIZE + 2 * NativeSizeConstants.VOID_POINTER_SIZE, MemoryBufferPool.MemType.DIRECT);
        long l = this.getCmEvent0(n2, memoryBuffer.getAddress(), memoryBuffer.getAddress() + (long)NativeSizeConstants.INT_SIZE, memoryBuffer.getAddress() + (long)NativeSizeConstants.INT_SIZE + (long)NativeSizeConstants.VOID_POINTER_SIZE, n);
        if (l != -1L) {
            long l2;
            long l3;
            int n3 = memoryBuffer.getInt();
            ConnectionEvent.EventType eventType = ConnectionEvent.EventType.values()[n3];
            if (NativeSizeConstants.INT_SIZE == NativeSizeConstants.VOID_POINTER_SIZE) {
                l3 = (long)memoryBuffer.getInt() & 0xFFFFFFFFL;
                l2 = (long)memoryBuffer.getInt() & 0xFFFFFFFFL;
            } else {
                l3 = memoryBuffer.getLong();
                l2 = memoryBuffer.getLong();
            }
            NativeConnectionId nativeConnectionId = null;
            NativeConnectionId nativeConnectionId2 = nativeEventChannel.getCmId(l3);
            if (eventType == ConnectionEvent.EventType.RDMA_CM_EVENT_CONNECT_REQUEST) {
                nativeConnectionId = new NativeConnectionId(nativeConnectionId2.getEventChannel(), nativeConnectionId2.getPortSpace(), l2, this);
                nativeConnectionId.setVerbs(nativeConnectionId2.getVerbsContext());
                nativeEventChannel.addCmId(nativeConnectionId.getNatid(), nativeConnectionId);
            } else {
                nativeConnectionId = nativeEventChannel.getCmId(l2);
            }
            nativeConnectionEvent = new NativeConnectionEvent(eventType, nativeConnectionId2, nativeConnectionId, l);
        }
        memoryBuffer.cache();
        return nativeConnectionEvent;
    }

    @Override
    public void connect(ConnectionId connectionId, ConnectionParameter connectionParameter) throws IllegalArgumentException, IOException {
        long l = -1L;
        if (connectionId == null || (l = ((NativeConnectionId)connectionId).getNatid()) == -1L) {
            throw new IllegalArgumentException("Connection Id is invalid");
        }
        if (connectionParameter == null) {
            throw new IllegalArgumentException("Invalid connParam");
        }
        NativeConnectionParameter nativeConnectionParameter = new NativeConnectionParameter(connectionParameter);
        MemoryBuffer memoryBuffer = this.memAlloc.allocate(NativeSizeConstants.CONN_PARAM_SIZE, MemoryBufferPool.MemType.DIRECT);
        nativeConnectionParameter.writeBack(memoryBuffer.getBuffer());
        int n = this.connect0(l, memoryBuffer.getAddress());
        memoryBuffer.cache();
        if (n < 0) {
            throw new IOException("Connect action failed");
        }
    }

    @Override
    public void accept(ConnectionId connectionId, ConnectionParameter connectionParameter) throws IllegalArgumentException, IOException {
        long l = -1L;
        if (connectionId == null || (l = ((NativeConnectionId)connectionId).getNatid()) == -1L) {
            throw new IllegalArgumentException("Connection Id is invalid");
        }
        if (connectionParameter == null) {
            throw new IllegalArgumentException("Invalid connParam");
        }
        NativeConnectionParameter nativeConnectionParameter = new NativeConnectionParameter(connectionParameter);
        MemoryBuffer memoryBuffer = this.memAlloc.allocate(NativeSizeConstants.CONN_PARAM_SIZE, MemoryBufferPool.MemType.DIRECT);
        nativeConnectionParameter.writeBack(memoryBuffer.getBuffer());
        int n = this.accept0(l, memoryBuffer.getAddress());
        memoryBuffer.cache();
        if (n < 0) {
            throw new IOException("Accept action failed");
        }
    }

    @Override
    public void ackConnectionEvent(ConnectionEvent connectionEvent) throws IllegalArgumentException, IOException {
        long l = -1L;
        if (connectionEvent == null || (l = ((NativeConnectionEvent)connectionEvent).getNativeId()) == -1L) {
            throw new IllegalArgumentException("Connection Id is invalid");
        }
        int n = this.ackCmEvent0(l);
        if (n < 0) {
            throw new IOException("Acknowledge cm event action failed");
        }
    }

    @Override
    public void disconnect(ConnectionId connectionId) throws IOException {
        long l = ((NativeConnectionId)connectionId).getNatid();
        int n = this.disconnect0(l);
        if (n < 0) {
            throw new IOException("Disconnect action failed");
        }
    }

    @Override
    public void destroyEventChannel(EventChannel eventChannel) throws IOException {
        int n = this.destroyEventChannel0(eventChannel.getFD());
        if (n < 0) {
            throw new IOException("Destroy event channel action failed");
        }
        ((NativeEventChannel)eventChannel).clearCmIds();
    }

    @Override
    public void destroyConnectionId(ConnectionId connectionId) throws IllegalArgumentException, IOException {
        long l = -1L;
        if (connectionId == null || (l = ((NativeConnectionId)connectionId).getNatid()) == -1L) {
            throw new IOException("Connection Id is not valid");
        }
        int n = this.destroyCmId0(l);
        if (n < 0) {
            throw new IOException("Destroy Connection Id action failed");
        }
        EventChannel eventChannel = connectionId.getEventChannel();
        if (eventChannel != null) {
            ((NativeEventChannel)eventChannel).removeCmId(l);
        }
    }

    @Override
    public void destroyQueuePair(ConnectionId connectionId) throws IOException {
        long l = ((NativeConnectionId)connectionId).getNatid();
        if (((NativeConnectionId)connectionId).getQueuePair() == null) {
            throw new IOException("QueuePair is not associated with this Id");
        }
        int n = this.destroyQp0(l);
        if (n < 0) {
            throw new IOException("Destroy QueuePair action failed");
        }
        ((NativeConnectionId)connectionId).setQueuePair(null);
    }

    @Override
    public SocketAddress getSourceAddress(ConnectionId connectionId) throws IOException {
        long l = ((NativeConnectionId)connectionId).getNatid();
        SockAddrIn sockAddrIn = new SockAddrIn();
        MemoryBuffer memoryBuffer = this.memAlloc.allocate(10, MemoryBufferPool.MemType.DIRECT);
        int n = this.getSrcAddr0(l, memoryBuffer.getAddress());
        InetSocketAddress inetSocketAddress = null;
        if (n == 0) {
            memoryBuffer.clear();
            sockAddrIn.update(memoryBuffer.getBuffer());
            InetAddress inetAddress = NetUtils.getInetAddressFromIntIP(sockAddrIn.getSin_addr());
            inetSocketAddress = new InetSocketAddress(inetAddress, sockAddrIn.getSin_port());
            memoryBuffer.cache();
            return inetSocketAddress;
        }
        memoryBuffer.cache();
        throw new IOException("Get source address action failed");
    }

    @Override
    public SocketAddress getDestinationAddress(ConnectionId connectionId) throws IOException {
        long l = ((NativeConnectionId)connectionId).getNatid();
        SockAddrIn sockAddrIn = new SockAddrIn();
        MemoryBuffer memoryBuffer = this.memAlloc.allocate(10, MemoryBufferPool.MemType.DIRECT);
        int n = this.getDstAddr0(l, memoryBuffer.getAddress());
        InetSocketAddress inetSocketAddress = null;
        if (n == 0) {
            memoryBuffer.clear();
            sockAddrIn.update(memoryBuffer.getBuffer());
            InetAddress inetAddress = NetUtils.getInetAddressFromIntIP(sockAddrIn.getSin_addr());
            inetSocketAddress = new InetSocketAddress(inetAddress, sockAddrIn.getSin_port());
            memoryBuffer.cache();
            return inetSocketAddress;
        }
        memoryBuffer.cache();
        throw new IOException("Get destination address action failed");
    }

    @Override
    public int getSourcePort(ConnectionId connectionId) throws IOException {
        long l = ((NativeConnectionId)connectionId).getNatid();
        int n = this.getSrcPort0(l);
        if (n < 0) {
            throw new IOException("Get source port action failed");
        }
        return n;
    }

    @Override
    public int getDestinationPort(ConnectionId connectionId) throws IOException {
        long l = ((NativeConnectionId)connectionId).getNatid();
        int n = this.getDstPort0(l);
        if (n < 0) {
            throw new IOException("Getting destination port action failed");
        }
        return n;
    }

    @Override
    public void destroyEndpoint(ConnectionId connectionId) throws IOException {
        long l = ((NativeConnectionId)connectionId).getNatid();
        int n = this.destroyEp0(l);
        if (n < 0) {
            throw new IOException("Destroy end point action failed");
        }
        EventChannel eventChannel = connectionId.getEventChannel();
        if (eventChannel != null) {
            ((NativeEventChannel)eventChannel).removeCmId(l);
        }
        ((NativeConnectionId)connectionId).setQueuePair(null);
    }

    native int createEventChannel0();

    native long createId0(int var1, short var2);

    native int createQp0(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13, long var15, long var17);

    native int bindAddr0(long var1, short var3, int var4, int var5);

    native int listen0(long var1, int var3);

    native int resolveAddr0(long var1, long var3, short var5, int var6, int var7, int var8);

    native int resolveRoute0(long var1, int var3);

    native long getCmEvent0(int var1, long var2, long var4, long var6, int var8);

    native int connect0(long var1, long var3);

    native int accept0(long var1, long var3);

    native int ackCmEvent0(long var1);

    native int disconnect0(long var1);

    native int destroyEventChannel0(int var1);

    native int destroyCmId0(long var1);

    native int destroyQp0(long var1);

    native int getSrcAddr0(long var1, long var3);

    native int getDstAddr0(long var1, long var3);

    native int getSrcPort0(long var1);

    native int getDstPort0(long var1);

    native int destroyEp0(long var1);

    native int getContext0(long var1);
}

