/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.cm;

import com.ibm.net.rdma.jverbs.cm.ConnectionId;
import com.ibm.net.rdma.jverbs.cm.EventChannel;
import com.ibm.net.rdma.jverbs.cm.NativeRdmaCM;
import com.ibm.net.rdma.jverbs.cm.PortSpace;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.reflect.misc.ConstructorUtil;

class NativeConnectionId
extends ConnectionId {
    private long natid = -1L;
    private NativeRdmaCM cmImpl = null;
    private static final String RDMA_NATIVE_VERBS_CONTEXT_IMPL_CLASS = "com.ibm.net.rdma.jverbs.verbs.NativeVerbsContext";

    public NativeConnectionId(EventChannel eventChannel, PortSpace portSpace, long l, NativeRdmaCM nativeRdmaCM) throws IOException {
        super(eventChannel, portSpace);
        this.natid = l;
        this.cmImpl = nativeRdmaCM;
    }

    long getNatid() {
        return this.natid;
    }

    @Override
    public VerbsContext getVerbsContext() throws IOException {
        if (this.verbs == null) {
            int n = this.cmImpl.getContext0(this.natid);
            VerbsContext verbsContext = null;
            if (n >= 0) {
                Class[] classArray = new Class[]{Integer.TYPE};
                Object[] objectArray = new Object[]{new Integer(n)};
                verbsContext = (VerbsContext)this.invokeConstructor(RDMA_NATIVE_VERBS_CONTEXT_IMPL_CLASS, classArray, objectArray);
            }
            if (verbsContext == null) {
                throw new IOException("Get verbs context action failed");
            }
            this.setVerbs(verbsContext);
        }
        return this.verbs;
    }

    @Override
    protected void setQueuePair(QueuePair queuePair) {
        super.setQueuePair(queuePair);
    }

    protected void setVerbs(VerbsContext verbsContext) {
        super.setVerbsContext(verbsContext);
    }

    private Object invokeConstructor(String string, final Class[] classArray, Object[] objectArray) {
        final Class[] classArray2 = new Class[]{};
        Object[] objectArray2 = new Object[]{};
        try {
            final Class<?> clazz = Class.forName(string);
            Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Constructor<?> constructor = ConstructorUtil.getConstructor(clazz, classArray == null ? classArray2 : classArray);
                    constructor.setAccessible(true);
                    return constructor;
                }
            });
            return constructor.newInstance(objectArray == null ? objectArray2 : objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

