/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CPSuri;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.Qualifier;
import com.ibm.security.x509.UserNotice;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class PolicyQualifierInfo
implements Cloneable {
    private Qualifier qualifier;
    private ObjectIdentifier oid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.PolicyQualifierInfo";
    private volatile int cachedHashVal = 0;

    public PolicyQualifierInfo(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PolicyQualifierInfo", (Object)der);
        }
        DerInputStream derin = new DerInputStream(der);
        DerValue encoding = derin.getDerValue();
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "PolicyQualifierInfo");
        }
    }

    public PolicyQualifierInfo(Qualifier qualifier) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PolicyQualifierInfo", qualifier);
        }
        if (qualifier == null) {
            if (debug != null) {
                debug.text(16384L, className, "PolicyQualifierInfo", "qualifier not specified.");
            }
            throw new IllegalArgumentException("qualifier not specified.");
        }
        this.qualifier = qualifier;
        this.oid = qualifier.getObjectIdentifier();
        if (debug != null) {
            debug.exit(16384L, className, "PolicyQualifierInfo");
        }
    }

    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putOID(this.oid);
        if (this.qualifier instanceof CPSuri) {
            ((CPSuri)this.qualifier).encode(bytes);
        } else {
            ((UserNotice)this.qualifier).encode(bytes);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", this.oid);
        }
        return this.oid;
    }

    public Qualifier getQualifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getQualifier");
            debug.exit(16384L, (Object)className, "getQualifier", this.qualifier);
        }
        return this.qualifier;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            PolicyQualifierInfo result = new PolicyQualifierInfo(derout.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", result);
            }
            return result;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String out = "";
        HexDumpEncoder hd = new HexDumpEncoder();
        out = out + "PolicyQualifierInfo: [\r\n";
        if (this.qualifier != null) {
            out = out + this.qualifier.toString();
        }
        out = out + "]\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(other instanceof PolicyQualifierInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((PolicyQualifierInfo)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PolicyQualifierInfo parsing error, not a SEQUENCE");
            }
            throw new IOException("PolicyQualifierInfo parsing error, not a SEQUENCE");
        }
        this.oid = encoding.getData().getOID();
        DerValue der = encoding.getData().getDerValue();
        byte[] encodedValue = der.toByteArray();
        this.qualifier = this.oid.equals(PKIXExtensions.CPSuri_Id) ? new CPSuri(encodedValue) : (this.oid.equals(PKIXExtensions.UserNotice_Id) ? new UserNotice(encodedValue) : null);
        if (encoding.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PolicyQualifierInfo parsing error - data overrun, bytes = " + encoding.getData().available());
            }
            throw new IOException("PolicyQualifierInfo parsing error - data overrun, bytes = " + encoding.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }
}

