/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

public final class DeltaCRLIndicatorExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.DeltaCRLIndicator";
    public static final String NAME = "DeltaCRLIndicator";
    public static final String NUMBER = "value";
    private BigInteger deltaCRLNumber;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.DeltaCRLIndicatorExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.deltaCRLNumber == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream os = new DerOutputStream();
        os.putInteger(this.deltaCRLNumber);
        this.extensionValue = os.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public DeltaCRLIndicatorExtension(int deltaCRLNum) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DeltaCRLIndicatorExtension", new Integer(deltaCRLNum));
        }
        this.deltaCRLNumber = BigInteger.valueOf(deltaCRLNum);
        this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "DeltaCRLIndicatorExtension");
        }
    }

    public DeltaCRLIndicatorExtension(BigInteger deltaCRLNum) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DeltaCRLIndicatorExtension", deltaCRLNum);
        }
        this.deltaCRLNumber = deltaCRLNum;
        this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
        this.critical = true;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "DeltaCRLIndicatorExtension");
        }
    }

    public DeltaCRLIndicatorExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "DeltaCRLIndicatorExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.deltaCRLNumber = val.getInteger();
        if (debug != null) {
            debug.exit(16384L, className, "DeltaCRLIndicatorExtension");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (!(obj instanceof BigInteger)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute must be of type BigInteger.");
                }
                throw new IOException("Attribute must be of type BigInteger.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:DeltaCRLNumber.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:DeltaCRLNumber.");
        }
        this.deltaCRLNumber = (BigInteger)obj;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(NUMBER)) {
            if (this.deltaCRLNumber == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.deltaCRLNumber);
            }
            return this.deltaCRLNumber;
        }
        if (debug != null) {
            debug.text(16384L, className, "get_2", "Attribute name not recognized by CertAttrSet:DeltaCRLIndicator.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:DeltaCRLIndicator.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (!name.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:DeltaCRLIndicator.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:DeltaCRLIndicator.");
        }
        this.deltaCRLNumber = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = super.toString() + "Delta CRL Indicator: " + (this.deltaCRLNumber == null ? "" : this.deltaCRLNumber.toString()) + "\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.DeltaCRLIndicator_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

