/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;

public class parseCerts {
    public static void main(String[] argv) throws Throwable {
        if (argv.length < 1) {
            System.out.println("usage: parseCerts CertFile [CertFile CertFile ...]");
            System.exit(1);
        }
        for (int i = 0; i < argv.length; ++i) {
            Certificate cert = null;
            try {
                FileInputStream fis = new FileInputStream(argv[i]);
                cert = new X509CertImpl(fis);
                fis.close();
                System.out.println(cert);
                parseCerts.verifyCert(cert);
                continue;
            }
            catch (CertificateException ce) {
                Content content;
                SignedData sd;
                Certificate[] certs;
                ce.printStackTrace();
                ContentInfo ci = new ContentInfo(argv[i], false);
                if (!ci.isSignedData()) {
                    System.out.println("Not pkcs#7 signed data");
                    System.exit(1);
                }
                if ((certs = (sd = (SignedData)(content = ci.getContent())).getCertificates()) != null || certs.length != 0) {
                    for (int c = 0; c < certs.length; ++c) {
                        cert = certs[c];
                        System.out.println(cert);
                        parseCerts.verifyCert(cert);
                    }
                    continue;
                }
                System.out.println("No certificates in object");
            }
        }
    }

    static void verifyCert(Certificate inCert) throws Exception {
        X509CertImpl cert = (X509CertImpl)inCert;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException e) {
            System.out.println("Warning: Certificate expired!");
            System.out.println(e.getMessage());
        }
        PublicKey pubKey = cert.getPublicKey();
        if (cert.getSubjectDN().equals(cert.getIssuerDN())) {
            System.out.println("It is self signed, verifying signature ...");
            try {
                cert.verify(pubKey);
                System.out.println("The signature is verified.");
            }
            catch (Exception e) {
                System.out.println("\tThe signature can't be verified.");
                e.printStackTrace();
            }
        }
    }
}

