@echo off
SETLOCAL
REM ########################################################################
REM #
REM #       Licensed Materials - Property of IBM
REM #
REM #       5724-S44
REM #
REM #       (C) Copyright IBM Corp. 2015. All Rights Reserved
REM #
REM #       US Government Users Restricted Rights - Use, duplication
REM #       or disclosure restricted by GSA ADP Schedule Contract
REM #       with IBM Corp.
REM #
REM #       Netcool/OMNIbus Probe for Generic Log File (GLF) Java
REM #
REM #######################################################################
REM Group name under which to install this probe (TODO)
REM /GROUP <GroupName>

REM Initialize variables
SET jvmUsed=
SET OMNI_JVM_DIR=
SET GLFJavaTemp="Glfloc_%RANDOM%-%RANDOM%.tmp"
REM deleting Temp files as a precaution
if exist "%GLFJavaTemp%" (
	del %GLFJavaTemp%
)

REM *** remove spaces from OMNIHOME variable or they screw things up
call :get_new_omnihome "%OMNIHOME%"
call :get_jvm_dll "%OMNIBUS_JVM_DLL%"

if exist "%OMNIHOME%\probes\win32\nco_p_glf_java.jar" (
set CLASS_DIR=%NEWOMNIHOME%\probes\win32\
)

REM *** For Windows service which required declare JVM dll path
REM *** If user defined their own JVM DLL for use %OMNIBUS_JVM_DLL%
REM ***  
REM *** Define the following variables in System variables
REM ***  %OMNIHOME%                  (Optional; if this variable is used in probe's props file)

if exist "%NEWOMNIBUS_JVM_DLL%" (
set OMNI_JVM_DIR=%NEWOMNIBUS_JVM_DLL%
) else (
	REM *** By default use J9VM DLL from netcool omnibus
	REM *** Find the j9vm\jvm.dll file in the $NCHOME/platform directory
	REM echo glf java probe temp file %GLFJavaTemp% used to find default jvm dll path
	dir %NEWOMNIHOME%\..\platform /s /b | find "j9vm\jvm.dll" >> %GLFJavaTemp%
	set /p OMNI_JVM_DIR= < %GLFJavaTemp%
	del %GLFJavaTemp%
)

SET GLFJavaTemp1="GLFJavaTemploc1_%RANDOM%.tmp"
SET GLFJavaTemp2="GLFJavaTemploc2_%RANDOM%.tmp"
SET JAVA_USED=

REM deleting Temp files as a precaution
if exist "%GLFJavaTemp1%" (
        del %GLFJavaTemp1%
)

if exist "%GLFJavaTemp2%" (
        del %GLFJavaTemp2%
)

REM - This algo will only work if all the jre dirs are at the same level
REM   ex C:\IBM\Tivoli\Netcool\platform\win32\jre_1.5.6\jre\bin\java.exe
REM      C:\IBM\Tivoli\Netcool\platform\win32\jre_1.6.1\jre\bin\java.exe
REM      C:\IBM\Tivoli\Netcool\platform\win32\jre_1.9.0\jre\bin\java.exe
REM      C:\IBM\Tivoli\Netcool\platform\win32\jre_1.5.4\jre\bin\java.exe
REM
REM - Always use the latest java.exe from C:\IBM\Tivoli\Netcool\platform\win32
REM - "Find" java in Omnibus Installation does the following:
REM   It sortes by default in ascending order if multiple java paths are located and written to a
REM   temp file. This temp file is than sorted in reverse order so that the latest java path is on
REM   top. Only the 1st line is assigned to variable "javaUsed"

dir %NEWOMNIHOME%\..\platform /s /b | find "java.exe" >> %GLFJavaTemp1%
sort /R %GLFJavaTemp1% /O %GLFJavaTemp2%
set /p JAVA_USED= < %GLFJavaTemp2%
del %GLFJavaTemp1% %GLFJavaTemp2%


set LD_LIBRARY_PATH=%OMNIHOME%\..\platform\win32\lib

set JARS_DIR=%OMNIHOME%\java\jars

REM Set CAMEL_CLASSPATH and DSLSTREAM_CLASSPATH as specified for dsl framework
call %OMNIHOME%\probes\java\dsl\dsl_framework.bat

set PROBE_CLASSPATH=%CLASS_DIR%\nco_p_glf_java.jar;%CAMEL_CLASSPATH%;%DSLSTREAM_CLASSPATH%
set CP_CLASSPATH=%CLASS_DIR%\JSON4J_Apache.jar
set FW_CLASSPATH=%CLASS_DIR%\framework.jar
set PS_CLASSPATH=%CLASS_DIR%\ProbeServices.jar
set NS_CLASSPATH=%CLASS_DIR%\NSHeadServices.jar
set TS_CLASSPATH=%CLASS_DIR%\TestServices.jar

set START_PRMS=
set UNQUOTED=
set STARTUP=--Startup=auto
set DEPENDS=
set SVCUSER=
set SVCPASS=
set OPTION=
set INSTANCE=NCONcoPGlfJavaProbe

:loopargs
if "%1" EQU "" (
    goto endofargs
)
REM Installs the probe as a service.  Sets probesrv.exe using install
if /i "%1" EQU "/INSTALL" (
	set OPTION=//IS//
	shift
	goto loopargs
)
REM Sets the instance to the passed value
if /i "%1" EQU "/INSTANCE" (
	set INSTANCE=%2
	shift
	shift
	goto loopargs
)
REM Removes the service.  Runs probesrv.exe using delete
if /i "%1" EQU "/REMOVE" (
	set OPTION=//DS//
	shift
	goto loopargs
)
REM Start the probe service manually.  Sets --Startup=manual
if /i "%1" EQU "/NOAUTO" (
	set STARTUP=--Startup=manual
	shift
	goto loopargs
)
REM Depend on another service.  Sets ++DependsOn <Service>
if /i "%1" EQU "/DEPEND" (
	set DEPENDS=%DEPENDS% ++DependsOn=%2
	shift
	shift
	goto loopargs
)
REM The account under which the probe will be run.  Sets --ServiceUser <ServiceUser>
if /i "%1" EQU "/ACCOUNT" (
	set SVCUSER=--ServiceUser=%2
	shift
	shift
	goto loopargs
)
REM The password pertaining to the /ACCOUNT name.  Sets --ServicePassword <password>
if /i "%1" EQU "/PASSWORD" (
	set SVCPASS=--ServicePassword=%2
	shift
	shift
	goto loopargs
)
REM The commandline options to specify for the probe
if /i "%1" EQU "/CMDLINE" (
	for /F "tokens=*" %%v in (%2) do (
	for %%a in (%%v) do (call :append_params %%a)
	)
    shift
	shift
    goto loopargs
)
REM The number of attempts to connect to the object server.  Sets -retrycount <value> (should use -retrycount)
if /i "%1" EQU "/BACKOFF" (
	set ARGS="-retrycount " %2
	shift
	shift
	goto loopargs
)
:endofargs

REM *** Below JVM options can be set with IBM JRE only
if /i "%OPTION%" EQU "" (
%JAVA_USED% -Xms64m -Xmx64m -Xmn56m -Xdisableexcessivegc -DOMNIHOME=%NEWOMNIHOME% ^
-cp %PROBE_CLASSPATH%;%CP_CLASSPATH%;%FW_CLASSPATH%;%PS_CLASSPATH%;%NS_CLASSPATH%;%TS_CLASSPATH% ^
com.ibm.tivoli.netcool.omnibus.oidk.Probe %*
) else (
%JAVA_USED% -DOMNIHOME=%NEWOMNIHOME% ^
-cp %PROBE_CLASSPATH%;%CP_CLASSPATH%;%FW_CLASSPATH%;%PS_CLASSPATH%;%NS_CLASSPATH%;%TS_CLASSPATH% ^
com.ibm.tivoli.netcool.omnibus.oidk.Probe %OPTION%%INSTANCE% --DisplayName=%INSTANCE% ^
--Install=%NEWOMNIHOME%\probes\win32\probesrv.exe %STARTUP% %SVCUSER% %SVCPASS% %DEPENDS% ^
++JvmOptions=-Xms64m;-Xmx64m;-Xmn56m;-Xdisableexcessivegc;-DOMNIHONE=%NEWOMNIHOME% ^
--Classpath=%PROBE_CLASSPATH%;%CP_CLASSPATH%;%FW_CLASSPATH%;%PS_CLASSPATH%;%NS_CLASSPATH%;%TS_CLASSPATH% ^
--Jvm=%OMNI_JVM_DIR% ^
--StartMode=jvm ^
--StartClass=com.ibm.tivoli.netcool.omnibus.oidk.Probe ^
--StartMethod=startProbe ^
%START_PRMS% ^
--StopMode=jvm ^
--StopClass=com.ibm.tivoli.netcool.omnibus.oidk.Probe ^
--StopMethod=stopProbe
)
set START_PRMS=
set UNQUOTED=
goto :eof

:append_params
set "START_PRMS=%START_PRMS% ++StartParams=%~1"
goto :EOF

REM *** convert OMNIHOME into 8.3 notation
:get_new_omnihome
set NEWOMNIHOME=%~fs1
goto :EOF   

REM *** convert OMNIBUS_JVM_DLL into 8.3 notation
:get_jvm_dll
set NEWOMNIBUS_JVM_DLL=%~fs1
goto :EOF   
	