------------------------------------------------------------------------------
--
--      Licensed Materials - Property of IBM
--
--      5724O4800
--
--      (C) Copyright IBM Corp. 2017. All Rights Reserved
--
--      US Government Users Restricted Rights - Use, duplication
--      or disclosure restricted by GSA ADP Schedule Contract
--      with IBM Corp.
--
--	Netcool/OMNIbus 8.1.0 - July 2018  Build: 5.50.78
--
--	RELATED EVENT GROUPING
--
--	This SQL file removes the fields and triggers used by scope-based event grouping
--
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- DROP TRIGGERS
------------------------------------------------------------------------------

DROP TRIGGER correlation_process_existing_parents;
go

DROP PROCEDURE correlation_process_superparents;
go

DROP PROCEDURE correlation_process_scopeidparents;
go

DROP PROCEDURE correlation_scopeid_customtext;
go

DROP PROCEDURE correlation_scopeid_impactcause;
go

DROP PROCEDURE correlation_process_sitenameparents;
go

DROP PROCEDURE correlation_sitename_customtext;
go

DROP PROCEDURE correlation_sitename_impactcause;
go

DROP PROCEDURE correlation_clear_expired_parents;
go

DROP PROCEDURE correlation_dismantle_small_groups;
go

DROP TRIGGER correlation_delete_row;
go

DROP TRIGGER correlation_deduplication;
go

DROP TRIGGER correlation_update;
go

DROP TRIGGER correlation_new_row;
go

DROP TRIGGER GROUP correlation_triggers;
go

------------------------------------------------------------------------------
-- DROP INDEXES ON PARENT TABLES
------------------------------------------------------------------------------

DROP INDEX SiteNameIdentifierIdx;
go

DROP INDEX ScopeIDIdentifierIdx;
go

------------------------------------------------------------------------------
-- DROP TABLE TO STORE POLICIES CREATED BY THE UI
------------------------------------------------------------------------------

DELETE FROM master.correlation_scope_based_policies;
go

DROP TABLE master.correlation_scope_based_policies;
go

------------------------------------------------------------------------------
-- DROP TABLE TO STORE PRIORITY CHILD EVENT DETAILS
------------------------------------------------------------------------------

DELETE FROM master.correlation_priority_children;
go

DROP TABLE master.correlation_priority_children;
go

------------------------------------------------------------------------------
-- DROP TABLE TO STORE ScopeAlias MEMBERS
------------------------------------------------------------------------------

DELETE FROM master.correlation_scopealias_members;
go

DROP TABLE master.correlation_scopealias_members;
go

------------------------------------------------------------------------------
-- DROP TABLE TO STORE ScopeIDs
------------------------------------------------------------------------------

DELETE FROM master.correlation_scopeid;
go

DROP TABLE master.correlation_scopeid;
go

------------------------------------------------------------------------------
-- DROP TABLE TO STORE SiteNames
------------------------------------------------------------------------------

DELETE FROM master.correlation_sitename;
go

DROP TABLE master.correlation_sitename;
go

------------------------------------------------------------------------------
-- DELETE Properties
------------------------------------------------------------------------------

DELETE FROM master.properties where Name in (
	'SEGVersion', 
	'SEGQuietPeriod',
	'SEGPropagateTTNumber',
	'SEGPropagateAcknowledged',
	'SEGPropagateOwnerUID',
	'SEGPropagateOwnerGID',
	'SEGUseNodeForScopeIDParent',
	'SEGUseNodeForSiteNameParent',
	'SEGNoSiteNameParentIfSiteNameBlank',
	'SEGUseScopeIDPrefix',
	'SEGScopeIDPrefix',
	'SEGUseScopeIDLabel',
	'SEGUseScopeIDImpactCause',
	'SEGScopeIDSitesAffectedLabel',
	'SEGUseScopeIDCustomText',
	'SEGPropagateTextToScopeIDParentCause',
	'SEGPropagateTextToScopeIDParentImpact',
	'SEGPropagateTextToScopeIDParentFirst',
	'SEGPropagateTextToScopeIDParentLast',
	'SEGUseScopeIDSitesAffected',
	'SEGScopeIDSummaryActiveFirst',
	'SEGUseScopeIDNumActiveAlarms',
	'SEGUseSiteNamePrefix',
	'SEGSiteNamePrefix',
	'SEGUseSiteNameLabel',
	'SEGUseSiteNameImpactCause',
	'SEGUseSiteNameCustomText',
	'SEGPropagateTextToSiteNameParentCause',
	'SEGPropagateTextToSiteNameParentImpact',
	'SEGPropagateTextToSiteNameParentFirst',
	'SEGPropagateTextToSiteNameParentLast',
	'SEGSiteNameSummaryActiveFirst',
	'SEGUseSiteNameNumActiveAlarms',
	'SEGJournalUID',
	'SEGJournalToSiteNameParent',
	'SEGJournalToScopeIDParent',
	'SEGJournalToSuperParent',
	'SEGJournalMaxEventsPerEntry',
	'SEGJournalServerNameServerSerial',
	'SEGJournalNode',
	'SEGJournalSummary',
	'SEGJournalAlertKey',
	'SEGJournalCustomText',
	'SEGMaxSiteNameJournals',
	'SEGMaxScopeIDJournals',
	'SEGMaxSuperParentJournals',
	'SEGMinimumChildren',
	'SEGMinimumScopeIDTTL',
	'SEGClearTTNumber');
go

------------------------------------------------------------------------------
-- DROP INDEXES ON alerts.status TABLE
------------------------------------------------------------------------------

DROP INDEX AlertGroupIdx;
go

DROP INDEX ParentIdentifierIdx;
go

DROP INDEX ScopeIDIdx;
go

DROP INDEX SiteNameIdx;
go

------------------------------------------------------------------------------
-- DROP NEW FIELDS IN AGGREGATION OBJECTSERVER
------------------------------------------------------------------------------

ALTER TABLE alerts.status DROP COLUMN NormalisedAlarmName;
go

ALTER TABLE alerts.status DROP COLUMN NormalisedAlarmGroup;
go

ALTER TABLE alerts.status DROP COLUMN NormalisedAlarmCode;
go

ALTER TABLE alerts.status DROP COLUMN ScopeID;
go

ALTER TABLE alerts.status DROP COLUMN SiteName;
go

ALTER TABLE alerts.status DROP COLUMN CauseWeight;
go

ALTER TABLE alerts.status DROP COLUMN ImpactWeight;
go

-- THE FOLLOWING TWO FIELDS NOT USED EXCLUSIVELY BY SCOPE EVENT GROUPING

-- ALTER TABLE alerts.status DROP COLUMN ParentIdentifier;
-- go

-- ALTER TABLE alerts.status DROP COLUMN TTNumber;
-- go

ALTER TABLE alerts.status DROP COLUMN QuietPeriod;
go

ALTER TABLE alerts.status DROP COLUMN CustomText;
go

ALTER TABLE alerts.status DROP COLUMN JournalSent;
go


